package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.SWT;
import java.lang.System;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import java.lang.Math__;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class TableTreeItem extends Item {
  internal var tableItem: TableItem;
  internal var parent: TableTree;
  internal var parentItem: TableTreeItem;
  internal var items: JavaArray = TableTree.EMPTY_ITEMS;
  internal var texts: JavaArray = TableTree.EMPTY_TEXTS;
  internal var images: JavaArray = TableTree.EMPTY_IMAGES;
  internal var background: Color;
  internal var foreground: Color;
  internal var font: Font;
  internal var expanded: Boolean;
  internal var checked: Boolean;
  internal var grayed: Boolean;
  public function TableTreeItem__Lorg_eclipse_swt_custom_TableTree_2I(parent: TableTree, style: int): Object {
    return this;
  }
  public function TableTreeItem__Lorg_eclipse_swt_custom_TableTree_2II(parent: TableTree, style: int, index: int): Object {
    return this;
  }
  public function TableTreeItem__Lorg_eclipse_swt_custom_TableTreeItem_2I(parent: TableTreeItem, style: int): Object {
    return this;
  }
  public function TableTreeItem__Lorg_eclipse_swt_custom_TableTreeItem_2II(parent: TableTreeItem, style: int, index: int): Object {
    return this;
  }
  public function TableTreeItem__Lorg_eclipse_swt_custom_TableTree_2Lorg_eclipse_swt_custom_TableTreeItem_2II(parent: TableTree, parentItem: TableTreeItem, style: int, index: int): Object {
    this.parent = parent;
    this.parentItem = parentItem;
    if (parentItem === null) {
      var tableIndex: int = parent.addItem__Lorg_eclipse_swt_custom_TableTreeItem_2I(this, index);
      tableItem = new TableItem(new Arguments(org.eclipse.swt.widgets.TableItem.TableItem__Lorg_eclipse_swt_widgets_Table_2II, [parent.getTable__(), style, tableIndex]));
      tableItem.setData__Ljava_lang_String_2Ljava_lang_Object_2("TableTreeItemID", this);
      this.addCheck__();
      if (parent.sizeImage === null) {
        var itemHeight: int = parent.getItemHeight__();
        parent.sizeImage = new Image(new Arguments(org.eclipse.swt.graphics.Image.Image__Lorg_eclipse_swt_graphics_Device_2II, [parent.getDisplay__(), itemHeight, itemHeight]));
        var gc: GC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [parent.sizeImage]));
        gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(parent.getBackground__());
        gc.fillRectangle__IIII(0, 0, itemHeight, itemHeight);
        gc.dispose__();
        tableItem.setImage__ILorg_eclipse_swt_graphics_Image_2(0, parent.sizeImage);
      }
    } else {
      parentItem.addItem__Lorg_eclipse_swt_custom_TableTreeItem_2I(this, index);
    }
    return this;
  }
  public function addCheck__(): void {
    var table: Table = parent.getTable__();
    if ((table.getStyle__() & 32) == 0)
      return;
    tableItem.setChecked__Z(checked);
    tableItem.setGrayed__Z(grayed);
  }
  public function addItem__Lorg_eclipse_swt_custom_TableTreeItem_2I(item: TableTreeItem, index: int): void {
    if (item === null)
      SWT.error__I(4);
    if (index < 0 || index > items.length)
      SWT.error__I(5);
    if (items.length == 0 && index == 0) {
      if (tableItem !== null) {
        var image_1: Image = expanded ? parent.getMinusImage__() : parent.getPlusImage__();
        tableItem.setImage__ILorg_eclipse_swt_graphics_Image_2(0, image_1);
      }
    }
    var newItems: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/TableTreeItem;").lengths(items.length + 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, 0, newItems, 0, index);
    newItems[index] = item;
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, index, newItems, index + 1, items.length - index);
    items = newItems;
    if (expanded)
      item.setVisible__Z(true);
    return;
  }
  public function getBackground__(): Color {
    this.checkWidget__();
    return (background === null) ? parent.getBackground__() : background;
  }
  public function getBounds__I(index: int): Rectangle {
    this.checkWidget__();
    if (tableItem !== null) {
      return tableItem.getBounds__I(index);
    } else {
      return new Rectangle(0, 0, 0, 0);
    }
    return null;
  }
  public function getChecked__(): Boolean {
    this.checkWidget__();
    if (tableItem === null)
      return checked;
    return tableItem.getChecked__();
  }
  public function getGrayed__(): Boolean {
    this.checkWidget__();
    if (tableItem === null)
      return grayed;
    return tableItem.getGrayed__();
  }
  public function getExpanded__(): Boolean {
    return expanded;
  }
  public function getFont__(): Font {
    this.checkWidget__();
    return (font === null) ? parent.getFont__() : font;
  }
  public function getForeground__(): Color {
    this.checkWidget__();
    return (foreground === null) ? parent.getForeground__() : foreground;
  }
  public override function getImage__(): Image {
    this.checkWidget__();
    return this.getImage__I(0);
  }
  public function getImage__I(index: int): Image {
    if (0 < index && index < images.length)
      return images[index];
    return null;
  }
  public function getIndent__(): int {
    if (parentItem === null)
      return 0;
    return parentItem.getIndent__() + 1;
  }
  public function getItem__I(index: int): TableTreeItem {
    this.checkWidget__();
    var count: int = items.length;
    if (!(0 <= index && index < count))
      SWT.error__I(6);
    return items[index];
  }
  public function getItemCount__(): int {
    return items.length;
  }
  public function getItems__(): JavaArray {
    var newItems: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/TableTreeItem;").lengths(items.length);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, 0, newItems, 0, items.length);
    return newItems;
  }
  public function getItem__Lorg_eclipse_swt_widgets_TableItem_2(tableItem_1: TableItem): TableTreeItem {
    if (tableItem_1 === null)
      return null;
    if (this.tableItem === tableItem_1)
      return this;
    for (var i: int = 0; i < items.length; i++) {
      var item: TableTreeItem = items[i].getItem__Lorg_eclipse_swt_widgets_TableItem_2(tableItem_1);
      if (item !== null)
        return item;
    }
    return null;
  }
  public function getParent__(): TableTree {
    return parent;
  }
  public function getParentItem__(): TableTreeItem {
    return parentItem;
  }
  public override function getText__(): String {
    this.checkWidget__();
    return this.getText__I(0);
  }
  public function getText__I(index: int): String {
    if (0 <= index && index < texts.length)
      return texts[index];
    return null;
  }
  public function getVisible__(): Boolean {
    return tableItem !== null;
  }
  public function indexOf__Lorg_eclipse_swt_custom_TableTreeItem_2(item: TableTreeItem): int {
    for (var i: int = 0; i < items.length; i++) {
      if (items[i] === item)
        return i;
    }
    return -1;
  }
  public function expandAll__Z(notify: Boolean): void {
    if (items.length == 0)
      return;
    if (!expanded) {
      this.setExpanded__Z(true);
      if (notify) {
        var event: Event = new Event();
        event.item = this;
        parent.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(17, event);
      }
    }
    for (var i: int = 0; i < items.length; i++) {
      items[i].expandAll__Z(notify);
    }
    return;
  }
  public function expandedIndexOf__Lorg_eclipse_swt_custom_TableTreeItem_2(item: TableTreeItem): int {
    var index: int = 0;
    for (var i: int = 0; i < items.length; i++) {
      if (items[i] === item)
        return index;
      if (items[i].expanded)
        index += items[i].visibleChildrenCount__();
      index++;
    }
    return -1;
  }
  public function visibleChildrenCount__(): int {
    var count: int = 0;
    for (var i: int = 0; i < items.length; i++) {
      if (items[i].getVisible__()) {
        count += 1 + items[i].visibleChildrenCount__();
      }
    }
    return count;
  }
  public override function dispose__(): void {
    if (this.isDisposed__())
      return;
    for (var i: int = items.length - 1; i >= 0; i--) {
      items[i].dispose__();
    }
    super.dispose__();
    if (!parent.inDispose) {
      if (parentItem !== null) {
        parentItem.removeItem__Lorg_eclipse_swt_custom_TableTreeItem_2(this);
      } else {
        parent.removeItem__Lorg_eclipse_swt_custom_TableTreeItem_2(this);
      }
      if (tableItem !== null)
        tableItem.dispose__();
    }
    items = null;
    parentItem = null;
    parent = null;
    images = null;
    texts = null;
    tableItem = null;
    foreground = null;
    background = null;
    font = null;
    return;
  }
  public function removeItem__Lorg_eclipse_swt_custom_TableTreeItem_2(item: TableTreeItem): void {
    var index: int = 0;
    while (index < items.length && items[index] !== item)
      index++;
    if (index == items.length)
      return;
    var newItems: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/TableTreeItem;").lengths(items.length - 1);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, 0, newItems, 0, index);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, index + 1, newItems, index, items.length - index - 1);
    items = newItems;
    if (items.length == 0) {
      if (tableItem !== null)
        tableItem.setImage__ILorg_eclipse_swt_graphics_Image_2(0, null);
    }
    return;
  }
  public function setBackground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    this.checkWidget__();
    if (color !== null && color.isDisposed__()) {
      SWT.error__I(5);
    }
    if (tableItem !== null) {
      tableItem.setBackground__Lorg_eclipse_swt_graphics_Color_2(color);
    }
    background = color;
    return;
  }
  public function setChecked__Z(checked_1: Boolean): void {
    this.checkWidget__();
    var table: Table = parent.getTable__();
    if ((table.getStyle__() & 32) == 0)
      return;
    if (tableItem !== null) {
      tableItem.setChecked__Z(checked_1);
    }
    this.checked = checked_1;
    return;
  }
  public function setGrayed__Z(grayed_1: Boolean): void {
    this.checkWidget__();
    var table: Table = parent.getTable__();
    if ((table.getStyle__() & 32) == 0)
      return;
    if (tableItem !== null) {
      tableItem.setGrayed__Z(grayed_1);
    }
    this.grayed = grayed_1;
    return;
  }
  public function setExpanded__Z(expanded_1: Boolean): void {
    this.checkWidget__();
    if (items.length == 0)
      return;
    if (this.expanded == expanded_1)
      return;
    this.expanded = expanded_1;
    if (tableItem === null)
      return;
    parent.setRedraw__Z(false);
    for (var i: int = 0; i < items.length; i++) {
      items[i].setVisible__Z(expanded_1);
    }
    var image_1: Image = expanded_1 ? parent.getMinusImage__() : parent.getPlusImage__();
    tableItem.setImage__ILorg_eclipse_swt_graphics_Image_2(0, image_1);
    parent.setRedraw__Z(true);
    return;
  }
  public function setFont__Lorg_eclipse_swt_graphics_Font_2(font_1: Font): void {
    this.checkWidget__();
    if (font_1 !== null && font_1.isDisposed__()) {
      SWT.error__I(5);
    }
    if (tableItem !== null) {
      tableItem.setFont__Lorg_eclipse_swt_graphics_Font_2(font_1);
    }
    this.font = font_1;
    return;
  }
  public function setForeground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    this.checkWidget__();
    if (color !== null && color.isDisposed__()) {
      SWT.error__I(5);
    }
    if (tableItem !== null) {
      tableItem.setForeground__Lorg_eclipse_swt_graphics_Color_2(color);
    }
    foreground = color;
    return;
  }
  public function setImage__ILorg_eclipse_swt_graphics_Image_2(index: int, image_1: Image): void {
    this.checkWidget__();
    var columnCount: int = Math__.max__II(parent.getTable__().getColumnCount__(), 1);
    if (index <= 0 || index >= columnCount)
      return;
    if (images.length < columnCount) {
      var newImages: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/Image;").lengths(columnCount);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(images, 0, newImages, 0, images.length);
      images = newImages;
    }
    images[index] = image_1;
    if (tableItem !== null)
      tableItem.setImage__ILorg_eclipse_swt_graphics_Image_2(index, image_1);
    return;
  }
  public override function setImage__Lorg_eclipse_swt_graphics_Image_2(image_1: Image): void {
    this.setImage__ILorg_eclipse_swt_graphics_Image_2(0, image_1);
    return;
  }
  public function setText__ILjava_lang_String_2(index: int, text_1: String): void {
    this.checkWidget__();
    if (text_1 === null)
      SWT.error__I(4);
    var columnCount: int = Math__.max__II(parent.getTable__().getColumnCount__(), 1);
    if (index < 0 || index >= columnCount)
      return;
    if (texts.length < columnCount) {
      var newTexts: JavaArray = new JavaArray("[Ljava/lang/String;").lengths(columnCount);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(texts, 0, newTexts, 0, texts.length);
      texts = newTexts;
    }
    texts[index] = text_1;
    if (tableItem !== null)
      tableItem.setText__ILjava_lang_String_2(index, text_1);
    return;
  }
  public override function setText__Ljava_lang_String_2(string: String): void {
    this.setText__ILjava_lang_String_2(0, string);
    return;
  }
  public function setVisible__Z(show: Boolean): void {
    if (parentItem === null)
      return;
    if (this.getVisible__() == show)
      return;
    if (show) {
      if (!parentItem.getVisible__())
        return;
      var table: Table = parent.getTable__();
      var parentIndex: int = table.indexOf__Lorg_eclipse_swt_widgets_TableItem_2(parentItem.tableItem);
      var index: int = parentItem.expandedIndexOf__Lorg_eclipse_swt_custom_TableTreeItem_2(this) + parentIndex + 1;
      if (index < 0)
        return;
      tableItem = new TableItem(new Arguments(org.eclipse.swt.widgets.TableItem.TableItem__Lorg_eclipse_swt_widgets_Table_2II, [table, this.getStyle__(), index]));
      tableItem.setData__Ljava_lang_String_2Ljava_lang_Object_2("TableTreeItemID", this);
      tableItem.setImageIndent__I(this.getIndent__());
      if (background !== null)
        tableItem.setBackground__Lorg_eclipse_swt_graphics_Color_2(background);
      if (foreground !== null)
        tableItem.setForeground__Lorg_eclipse_swt_graphics_Color_2(foreground);
      if (font !== null)
        tableItem.setFont__Lorg_eclipse_swt_graphics_Font_2(font);
      this.addCheck__();
      var columnCount: int = Math__.max__II(table.getColumnCount__(), 1);
      for (var i: int = 0; i < columnCount; i++) {
        if (i < texts.length && texts[i] !== null)
          this.setText__ILjava_lang_String_2(i, texts[i]);
        if (i < images.length && images[i] !== null)
          this.setImage__ILorg_eclipse_swt_graphics_Image_2(i, images[i]);
      }
      if (items.length != 0) {
        if (expanded) {
          tableItem.setImage__ILorg_eclipse_swt_graphics_Image_2(0, parent.getMinusImage__());
          for (var i_1: int = 0, length: int = items.length; i_1 < length; i_1++) {
            items[i_1].setVisible__Z(true);
          }
        } else {
          tableItem.setImage__ILorg_eclipse_swt_graphics_Image_2(0, parent.getPlusImage__());
        }
      }
    } else {
      for (var i_2: int = 0, length_1: int = items.length; i_2 < length_1; i_2++) {
        items[i_2].setVisible__Z(false);
      }
      tableItem.dispose__();
      tableItem = null;
    }
    return;
  }
  public function TableTreeItem(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 2 && vargs[0] is TableTree && vargs[1] is int) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 3 && vargs[0] is TableTree && vargs[1] is int && vargs[2] is int) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 2 && vargs[0] is TableTreeItem && vargs[1] is int) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 3 && vargs[0] is TableTreeItem && vargs[1] is int && vargs[2] is int) {
        args = vargs;
        id = 3;
      } else if (vargs.length == 4 && vargs[0] is TableTree && vargs[1] is TableTreeItem && vargs[2] is int && vargs[3] is int) {
        args = vargs;
        id = 4;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1]];
        args1 = [args0[0], args0[1], args0[0].getItemCount__()];
        args4 = [args1[0], null, args1[1], args1[2]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args4[0], args4[2]]);
        break;
      case 1:
        var args1: Array = [args[0], args[1], args[2]];
        args4 = [args1[0], null, args1[1], args1[2]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args4[0], args4[2]]);
        break;
      case 2:
        var args2: Array = [args[0], args[1]];
        args3 = [args2[0], args2[1], args2[0].getItemCount__()];
        args4 = [args3[0].getParent__(), args3[0], args3[1], args3[2]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args4[0], args4[2]]);
        break;
      case 3:
        var args3: Array = [args[0], args[1], args[2]];
        args4 = [args3[0].getParent__(), args3[0], args3[1], args3[2]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args4[0], args4[2]]);
        break;
      case 4:
        var args4: Array = [args[0], args[1], args[2], args[3]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args4[0], args4[2]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        TableTreeItem__Lorg_eclipse_swt_custom_TableTree_2Lorg_eclipse_swt_custom_TableTreeItem_2II(args4[0], args4[1], args4[2], args4[3]);
        TableTreeItem__Lorg_eclipse_swt_custom_TableTree_2II(args1[0], args1[1], args1[2]);
        TableTreeItem__Lorg_eclipse_swt_custom_TableTree_2I(args0[0], args0[1]);
        break;
      case 1:
        TableTreeItem__Lorg_eclipse_swt_custom_TableTree_2Lorg_eclipse_swt_custom_TableTreeItem_2II(args4[0], args4[1], args4[2], args4[3]);
        TableTreeItem__Lorg_eclipse_swt_custom_TableTree_2II(args1[0], args1[1], args1[2]);
        break;
      case 2:
        TableTreeItem__Lorg_eclipse_swt_custom_TableTree_2Lorg_eclipse_swt_custom_TableTreeItem_2II(args4[0], args4[1], args4[2], args4[3]);
        TableTreeItem__Lorg_eclipse_swt_custom_TableTreeItem_2II(args3[0], args3[1], args3[2]);
        TableTreeItem__Lorg_eclipse_swt_custom_TableTreeItem_2I(args2[0], args2[1]);
        break;
      case 3:
        TableTreeItem__Lorg_eclipse_swt_custom_TableTree_2Lorg_eclipse_swt_custom_TableTreeItem_2II(args4[0], args4[1], args4[2], args4[3]);
        TableTreeItem__Lorg_eclipse_swt_custom_TableTreeItem_2II(args3[0], args3[1], args3[2]);
        break;
      case 4:
        TableTreeItem__Lorg_eclipse_swt_custom_TableTree_2Lorg_eclipse_swt_custom_TableTreeItem_2II(args4[0], args4[1], args4[2], args4[3]);
        break;
    }
  }
  public static const TableTreeItem__Lorg_eclipse_swt_custom_TableTree_2I : int = 0;
  public static const TableTreeItem__Lorg_eclipse_swt_custom_TableTree_2II : int = 1;
  public static const TableTreeItem__Lorg_eclipse_swt_custom_TableTreeItem_2I : int = 2;
  public static const TableTreeItem__Lorg_eclipse_swt_custom_TableTreeItem_2II : int = 3;
  public static const TableTreeItem__Lorg_eclipse_swt_custom_TableTree_2Lorg_eclipse_swt_custom_TableTreeItem_2II : int = 4;
}
}
