package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.TreeListener;
import java.lang.Runnable;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Math__;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Control;
dynamic public class TreeEditor extends ControlEditor {
  internal var tree: Tree;
  internal var item: TreeItem;
  internal var column: int = 0;
  internal var columnListener: ControlListener;
  internal var treeListener: TreeListener;
  internal var timer: Runnable;
  public static const TIMEOUT: int = 1500;
  public function TreeEditor(tree: Tree) {
    super(tree);
    this.tree = tree;
    columnListener = new org.eclipse.swt.custom.TreeEditor$1(this);
    timer = new org.eclipse.swt.custom.TreeEditor$2(this);
    treeListener = new TreeEditor$3(this);
    tree.addTreeListener__Lorg_eclipse_swt_events_TreeListener_2(treeListener);
    grabVertical = true;
    return;
  }
  public override function computeBounds__(): Rectangle {
    if (item === null || column == -1 || item.isDisposed__())
      return new Rectangle(0, 0, 0, 0);
    var cell: Rectangle = item.getBounds__I(column);
    var rect: Rectangle = item.getImageBounds__I(column);
    cell.x = rect.x + rect.width;
    cell.width -= rect.width;
    var area: Rectangle = tree.getClientArea__();
    if (cell.x < area.x + area.width) {
      if (cell.x + cell.width > area.x + area.width) {
        cell.width = area.x + area.width - cell.x;
      }
    }
    var editorRect: Rectangle = new Rectangle(cell.x, cell.y, minimumWidth, minimumHeight);
    if (grabHorizontal) {
      if (tree.getColumnCount__() == 0) {
        cell.width = area.x + area.width - cell.x;
      }
      editorRect.width = Math__.max__II(cell.width, minimumWidth);
    }
    if (grabVertical) {
      editorRect.height = Math__.max__II(cell.height, minimumHeight);
    }
    if (horizontalAlignment == 131072) {
      editorRect.x += cell.width - editorRect.width;
    } else if (horizontalAlignment == 16384) {
    } else {
      editorRect.x += int((cell.width - editorRect.width) / 2);
    }
    editorRect.x = Math__.max__II(cell.x, editorRect.x);
    if (verticalAlignment == 1024) {
      editorRect.y += cell.height - editorRect.height;
    } else if (verticalAlignment == 128) {
    } else {
      editorRect.y += int((cell.height - editorRect.height) / 2);
    }
    return editorRect;
  }
  public override function dispose__(): void {
    if (tree !== null && !tree.isDisposed__()) {
      if (this.column > -1 && this.column < tree.getColumnCount__()) {
        var treeColumn: TreeColumn = tree.getColumn__I(this.column);
        treeColumn.removeControlListener__Lorg_eclipse_swt_events_ControlListener_2(columnListener);
      }
      if (treeListener !== null)
        tree.removeTreeListener__Lorg_eclipse_swt_events_TreeListener_2(treeListener);
    }
    columnListener = null;
    treeListener = null;
    tree = null;
    item = null;
    column = 0;
    timer = null;
    super.dispose__();
    return;
  }
  public function getColumn__(): int {
    return column;
  }
  public function getItem__(): TreeItem {
    return item;
  }
  public function resize__(): void {
    this.layout__();
    if (tree !== null) {
      var display: Display = tree.getDisplay__();
      display.timerExec__ILjava_lang_Runnable_2(-1, timer);
      display.timerExec__ILjava_lang_Runnable_2(1500, timer);
    }
    return;
  }
  public function setColumn__I(column_1: int): void {
    var columnCount: int = tree.getColumnCount__();
    if (columnCount == 0) {
      this.column = (column_1 == 0) ? 0 : -1;
      this.resize__();
      return;
    }
    if (this.column > -1 && this.column < columnCount) {
      var treeColumn: TreeColumn = tree.getColumn__I(this.column);
      treeColumn.removeControlListener__Lorg_eclipse_swt_events_ControlListener_2(columnListener);
      this.column = -1;
    }
    if (column_1 < 0 || column_1 >= tree.getColumnCount__())
      return;
    this.column = column_1;
    var treeColumn_1: TreeColumn = tree.getColumn__I(this.column);
    treeColumn_1.addControlListener__Lorg_eclipse_swt_events_ControlListener_2(columnListener);
    this.resize__();
  }
  public function setItem__Lorg_eclipse_swt_widgets_TreeItem_2(item_1: TreeItem): void {
    this.item = item_1;
    this.resize__();
  }
  public function setEditor__Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_widgets_TreeItem_2I(editor_1: Control, item_1: TreeItem, column_1: int): void {
    this.setItem__Lorg_eclipse_swt_widgets_TreeItem_2(item_1);
    this.setColumn__I(column_1);
    this.setEditor__Lorg_eclipse_swt_widgets_Control_2(editor_1);
  }
  public override function setEditor__Lorg_eclipse_swt_widgets_Control_2(editor_1: Control): void {
    super.setEditor__Lorg_eclipse_swt_widgets_Control_2(editor_1);
    this.resize__();
  }
  public function setEditor__Lorg_eclipse_swt_widgets_Control_2Lorg_eclipse_swt_widgets_TreeItem_2(editor_1: Control, item_1: TreeItem): void {
    this.setItem__Lorg_eclipse_swt_widgets_TreeItem_2(item_1);
    this.setEditor__Lorg_eclipse_swt_widgets_Control_2(editor_1);
  }
  public override function layout__(): void {
    if (tree === null || tree.isDisposed__())
      return;
    if (item === null || item.isDisposed__())
      return;
    var columnCount: int = tree.getColumnCount__();
    if (columnCount == 0 && column != 0)
      return;
    if (columnCount > 0 && (column < 0 || column >= columnCount))
      return;
    super.layout__();
  }
}
}
