package org.eclipse.swt.custom {
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Layout;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ViewForm extends Composite {
  public var marginWidth: int = 0;
  public var marginHeight: int = 0;
  public var horizontalSpacing: int = 1;
  public var verticalSpacing: int = 1;
  public static var borderInsideRGB: RGB = new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [132, 130, 132]));
  public static var borderMiddleRGB: RGB = new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [143, 141, 138]));
  public static var borderOutsideRGB: RGB = new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [171, 168, 165]));
  internal var topLeft: Control;
  internal var topCenter: Control;
  internal var topRight: Control;
  internal var content: Control;
  internal var separateTopCenter: Boolean = false;
  internal var showBorder: Boolean = false;
  internal var separator: int = -1;
  internal var borderTop: int = 0;
  internal var borderBottom: int = 0;
  internal var borderLeft: int = 0;
  internal var borderRight: int = 0;
  internal var highlight: int = 0;
  internal var oldSize: Point;
  internal var selectionBackground: Color;
  internal var listener: Listener;
  public static const OFFSCREEN: int = -200;
  public static const BORDER1_COLOR: int = 18;
  public static const SELECTION_BACKGROUND: int = 25;
  public function ViewForm(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [parent, ViewForm.checkStyle__I(style)]));
    super.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new ViewFormLayout());
    this.setBorderVisible__Z((style & 2048) != 0);
    listener = new org.eclipse.swt.custom.ViewForm$1(this);
    var events: JavaArray = new JavaArray("[I").values(12, 9, 11);
    for (var i: int = 0; i < events.length; i++) {
      this.addListener__ILorg_eclipse_swt_widgets_Listener_2(events[i], listener);
    }
    return;
  }
  public static function checkStyle__I(style: int): int {
    var mask: int = 8388608 | 33554432 | 67108864;
    return style & mask | 1048576;
  }
  public override function computeTrim__IIII(x_1: int, y_1: int, width_1: int, height_1: int): Rectangle {
    this.checkWidget__();
    var trimX: int = x_1 - borderLeft - highlight;
    var trimY: int = y_1 - borderTop - highlight;
    var trimWidth: int = width_1 + borderLeft + borderRight + 2 * highlight;
    var trimHeight: int = height_1 + borderTop + borderBottom + 2 * highlight;
    return new Rectangle(trimX, trimY, trimWidth, trimHeight);
  }
  public override function getClientArea__(): Rectangle {
    this.checkWidget__();
    var clientArea: Rectangle = super.getClientArea__();
    clientArea.x += borderLeft;
    clientArea.y += borderTop;
    clientArea.width -= borderLeft + borderRight;
    clientArea.height -= borderTop + borderBottom;
    return clientArea;
  }
  public function getContent__(): Control {
    return content;
  }
  public function getTopCenter__(): Control {
    return topCenter;
  }
  public function getTopLeft__(): Control {
    return topLeft;
  }
  public function getTopRight__(): Control {
    return topRight;
  }
  public function onDispose__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    this.removeListener__ILorg_eclipse_swt_widgets_Listener_2(12, listener);
    this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(12, event);
    event.type = 0;
    topLeft = null;
    topCenter = null;
    topRight = null;
    content = null;
    oldSize = null;
    selectionBackground = null;
  }
  public function onPaint__Lorg_eclipse_swt_graphics_GC_2(gc: GC): void {
    var gcForeground: Color = gc.getForeground__();
    var size: Point = this.getSize__();
    var border: Color = this.getDisplay__().getSystemColor__I(18);
    if (showBorder) {
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(border);
      gc.drawRectangle__IIII(0, 0, size.x - 1, size.y - 1);
      if (highlight > 0) {
        var x1: int = 1;
        var y1: int = 1;
        var x2: int = size.x - 1;
        var y2: int = size.y - 1;
        var shape: JavaArray = new JavaArray("[I").values(x1, y1, x2, y1, x2, y2, x1, y2, x1, y1 + highlight, x1 + highlight, y1 + highlight, x1 + highlight, y2 - highlight, x2 - highlight, y2 - highlight, x2 - highlight, y1 + highlight, x1, y1 + highlight);
        var highlightColor: Color = this.getDisplay__().getSystemColor__I(26);
        gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(highlightColor);
        gc.fillPolygon___3I(shape);
      }
    }
    if (separator > -1) {
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(border);
      gc.drawLine__IIII(borderLeft + highlight, separator, size.x - borderLeft - borderRight - highlight, separator);
    }
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(gcForeground);
    return;
  }
  public function onResize__(): void {
    var size: Point = this.getSize__();
    if (oldSize === null || oldSize.x == 0 || oldSize.y == 0) {
      this.redraw__();
    } else {
      var width_1: int = 0;
      if (oldSize.x < size.x) {
        width_1 = size.x - oldSize.x + borderRight + highlight;
      } else if (oldSize.x > size.x) {
        width_1 = borderRight + highlight;
      }
      this.redraw__IIIIZ(size.x - width_1, 0, width_1, size.y, false);
      var height_1: int = 0;
      if (oldSize.y < size.y) {
        height_1 = size.y - oldSize.y + borderBottom + highlight;
      }
      if (oldSize.y > size.y) {
        height_1 = borderBottom + highlight;
      }
      this.redraw__IIIIZ(0, size.y - height_1, size.x, height_1, false);
    }
    oldSize = size;
    return;
  }
  public function setContent__Lorg_eclipse_swt_widgets_Control_2(content_1: Control): void {
    this.checkWidget__();
    if (content_1 !== null && content_1.getParent__() !== this) {
      SWT.error__I(5);
    }
    if (this.content !== null && !this.content.isDisposed__()) {
      this.content.setBounds__IIII(-200, -200, 0, 0);
    }
    this.content = content_1;
    this.layout__Z(false);
    return;
  }
  public override function setLayout__Lorg_eclipse_swt_widgets_Layout_2(layout_1: Layout): void {
    this.checkWidget__();
    return;
  }
  public function setSelectionBackground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    this.checkWidget__();
    if (selectionBackground === color)
      return;
    if (color === null)
      color = this.getDisplay__().getSystemColor__I(25);
    selectionBackground = color;
    this.redraw__();
  }
  public function setTopCenter__Lorg_eclipse_swt_widgets_Control_2(topCenter_1: Control): void {
    this.checkWidget__();
    if (topCenter_1 !== null && topCenter_1.getParent__() !== this) {
      SWT.error__I(5);
    }
    if (this.topCenter !== null && !this.topCenter.isDisposed__()) {
      var size: Point = this.topCenter.getSize__();
      this.topCenter.setLocation__II(-200 - size.x, -200 - size.y);
    }
    this.topCenter = topCenter_1;
    this.layout__Z(false);
    return;
  }
  public function setTopLeft__Lorg_eclipse_swt_widgets_Control_2(c: Control): void {
    this.checkWidget__();
    if (c !== null && c.getParent__() !== this) {
      SWT.error__I(5);
    }
    if (this.topLeft !== null && !this.topLeft.isDisposed__()) {
      var size: Point = this.topLeft.getSize__();
      this.topLeft.setLocation__II(-200 - size.x, -200 - size.y);
    }
    this.topLeft = c;
    this.layout__Z(false);
    return;
  }
  public function setTopRight__Lorg_eclipse_swt_widgets_Control_2(c: Control): void {
    this.checkWidget__();
    if (c !== null && c.getParent__() !== this) {
      SWT.error__I(5);
    }
    if (this.topRight !== null && !this.topRight.isDisposed__()) {
      var size: Point = this.topRight.getSize__();
      this.topRight.setLocation__II(-200 - size.x, -200 - size.y);
    }
    this.topRight = c;
    this.layout__Z(false);
    return;
  }
  public function setBorderVisible__Z(show: Boolean): void {
    this.checkWidget__();
    if (showBorder == show)
      return;
    showBorder = show;
    if (showBorder) {
      borderLeft = borderTop = borderRight = borderBottom = 1;
      if ((this.getStyle__() & 8388608) == 0)
        highlight = 2;
    } else {
      borderBottom = borderTop = borderLeft = borderRight = 0;
      highlight = 0;
    }
    this.layout__Z(false);
    this.redraw__();
    return;
  }
  public function setTopCenterSeparate__Z(show: Boolean): void {
    this.checkWidget__();
    separateTopCenter = show;
    this.layout__Z(false);
    return;
  }
}
}
