package org.eclipse.swt.custom {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.SWT;
import java.lang.Math__;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.graphics.Rectangle;
dynamic public class ViewFormLayout extends Layout {
  public override function computeSize__Lorg_eclipse_swt_widgets_Composite_2IIZ(composite: Composite, wHint: int, hHint: int, flushCache: Boolean): Point {
    var form: ViewForm = ViewForm(composite);
    var left: Control = form.topLeft;
    var center: Control = form.topCenter;
    var right: Control = form.topRight;
    var content: Control = form.content;
    var leftSize: Point = new Point(0, 0);
    if (left !== null) {
      leftSize = this.computeChildSize__Lorg_eclipse_swt_widgets_Control_2IIZ(left, -1, -1, flushCache);
    }
    var centerSize: Point = new Point(0, 0);
    if (center !== null) {
      centerSize = this.computeChildSize__Lorg_eclipse_swt_widgets_Control_2IIZ(center, -1, -1, flushCache);
    }
    var rightSize: Point = new Point(0, 0);
    if (right !== null) {
      rightSize = this.computeChildSize__Lorg_eclipse_swt_widgets_Control_2IIZ(right, -1, -1, flushCache);
    }
    var size: Point = new Point(0, 0);
    if (form.separateTopCenter || (wHint != -1 && leftSize.x + centerSize.x + rightSize.x > wHint)) {
      size.x = leftSize.x + rightSize.x;
      if (leftSize.x > 0 && rightSize.x > 0)
        size.x += form.horizontalSpacing;
      size.x = Math__.max__II(centerSize.x, size.x);
      size.y = Math__.max__II(leftSize.y, rightSize.y);
      if (center !== null) {
        size.y += centerSize.y;
        if (left !== null || right !== null)
          size.y += form.verticalSpacing;
      }
    } else {
      size.x = leftSize.x + centerSize.x + rightSize.x;
      var count: int = -1;
      if (leftSize.x > 0)
        count++;
      if (centerSize.x > 0)
        count++;
      if (rightSize.x > 0)
        count++;
      if (count > 0)
        size.x += count * form.horizontalSpacing;
      size.y = Math__.max__II(leftSize.y, Math__.max__II(centerSize.y, rightSize.y));
    }
    if (content !== null) {
      if (left !== null || right !== null || center !== null)
        size.y += 1;
      var contentSize: Point = new Point(0, 0);
      contentSize = this.computeChildSize__Lorg_eclipse_swt_widgets_Control_2IIZ(content, -1, -1, flushCache);
      size.x = Math__.max__II(size.x, contentSize.x);
      size.y += contentSize.y;
      if (size.y > contentSize.y)
        size.y += form.verticalSpacing;
    }
    size.x += 2 * form.marginWidth;
    size.y += 2 * form.marginHeight;
    if (wHint != -1)
      size.x = wHint;
    if (hHint != -1)
      size.y = hHint;
    return size;
  }
  public function computeChildSize__Lorg_eclipse_swt_widgets_Control_2IIZ(control: Control, wHint: int, hHint: int, flushCache: Boolean): Point {
    var data: Object = control.getLayoutData__();
    if (data === null || !(data is CLayoutData)) {
      data = new CLayoutData();
      control.setLayoutData__Ljava_lang_Object_2(data);
    }
    return (CLayoutData(data)).computeSize__Lorg_eclipse_swt_widgets_Control_2IIZ(control, wHint, hHint, flushCache);
  }
  public function computeTrim__Lorg_eclipse_swt_widgets_Control_2(c: Control): int {
    if (c is Scrollable) {
      var rect: Rectangle = (Scrollable(c)).computeTrim__IIII(0, 0, 0, 0);
      return rect.width;
    }
    return c.getBorderWidth__() * 2;
  }
  public override function flushCache__Lorg_eclipse_swt_widgets_Control_2(control: Control): Boolean {
    var data: Object = control.getLayoutData__();
    if (data !== null && data is CLayoutData)
      (CLayoutData(data)).flushCache__();
    return true;
  }
  public override function layout__Lorg_eclipse_swt_widgets_Composite_2Z(composite: Composite, flushCache: Boolean): void {
    var form: ViewForm = ViewForm(composite);
    var left: Control = form.topLeft;
    var center: Control = form.topCenter;
    var right: Control = form.topRight;
    var content: Control = form.content;
    var rect: Rectangle = composite.getClientArea__();
    var leftSize: Point = new Point(0, 0);
    if (left !== null && !left.isDisposed__()) {
      leftSize = this.computeChildSize__Lorg_eclipse_swt_widgets_Control_2IIZ(left, -1, -1, flushCache);
    }
    var centerSize: Point = new Point(0, 0);
    if (center !== null && !center.isDisposed__()) {
      centerSize = this.computeChildSize__Lorg_eclipse_swt_widgets_Control_2IIZ(center, -1, -1, flushCache);
    }
    var rightSize: Point = new Point(0, 0);
    if (right !== null && !right.isDisposed__()) {
      rightSize = this.computeChildSize__Lorg_eclipse_swt_widgets_Control_2IIZ(right, -1, -1, flushCache);
    }
    var minTopWidth: int = leftSize.x + centerSize.x + rightSize.x + 2 * form.marginWidth + 2 * form.highlight;
    var count: int = -1;
    if (leftSize.x > 0)
      count++;
    if (centerSize.x > 0)
      count++;
    if (rightSize.x > 0)
      count++;
    if (count > 0)
      minTopWidth += count * form.horizontalSpacing;
    var x: int = rect.x + rect.width - form.marginWidth - form.highlight;
    var y: int = rect.y + form.marginHeight + form.highlight;
    var top: Boolean = false;
    if (form.separateTopCenter || minTopWidth > rect.width) {
      var topHeight: int = Math__.max__II(rightSize.y, leftSize.y);
      if (right !== null && !right.isDisposed__()) {
        top = true;
        x -= rightSize.x;
        right.setBounds__IIII(x, y, rightSize.x, topHeight);
        x -= form.horizontalSpacing;
      }
      if (left !== null && !left.isDisposed__()) {
        top = true;
        var trim: int = this.computeTrim__Lorg_eclipse_swt_widgets_Control_2(left);
        var leftW: int = x - rect.x - form.marginWidth - form.highlight - trim;
        leftSize = this.computeChildSize__Lorg_eclipse_swt_widgets_Control_2IIZ(left, leftW, -1, false);
        left.setBounds__IIII(rect.x + form.marginWidth + form.highlight, y, leftSize.x, topHeight);
      }
      if (top)
        y += topHeight + form.verticalSpacing;
      if (center !== null && !center.isDisposed__()) {
        top = true;
        var trim_1: int = this.computeTrim__Lorg_eclipse_swt_widgets_Control_2(center);
        var w: int = rect.width - 2 * form.marginWidth - 2 * form.highlight - trim_1;
        centerSize = this.computeChildSize__Lorg_eclipse_swt_widgets_Control_2IIZ(center, w, -1, false);
        center.setBounds__IIII(rect.x + rect.width - form.marginWidth - form.highlight - centerSize.x, y, centerSize.x, centerSize.y);
        y += centerSize.y + form.verticalSpacing;
      }
    } else {
      var topHeight_1: int = Math__.max__II(rightSize.y, Math__.max__II(centerSize.y, leftSize.y));
      if (right !== null && !right.isDisposed__()) {
        top = true;
        x -= rightSize.x;
        right.setBounds__IIII(x, y, rightSize.x, topHeight_1);
        x -= form.horizontalSpacing;
      }
      if (center !== null && !center.isDisposed__()) {
        top = true;
        x -= centerSize.x;
        center.setBounds__IIII(x, y, centerSize.x, topHeight_1);
        x -= form.horizontalSpacing;
      }
      if (left !== null && !left.isDisposed__()) {
        top = true;
        var trim_2: Rectangle = left is Composite ? (Composite(left)).computeTrim__IIII(0, 0, 0, 0) : new Rectangle(0, 0, 0, 0);
        var w_1: int = x - rect.x - form.marginWidth - form.highlight - trim_2.width;
        var h: int = topHeight_1 - trim_2.height;
        leftSize = this.computeChildSize__Lorg_eclipse_swt_widgets_Control_2IIZ(left, w_1, h, false);
        left.setBounds__IIII(rect.x + form.marginWidth + form.highlight, y, leftSize.x, topHeight_1);
      }
      if (top)
        y += topHeight_1 + form.verticalSpacing;
    }
    var oldSeperator: int = form.separator;
    form.separator = -1;
    if (content !== null && !content.isDisposed__()) {
      if (left !== null || right !== null || center !== null) {
        form.separator = y;
        y++;
      }
      content.setBounds__IIII(rect.x + form.marginWidth + form.highlight, y, rect.width - 2 * form.marginWidth - 2 * form.highlight, rect.y + rect.height - y - form.marginHeight - form.highlight);
    }
    if (oldSeperator != -1 && form.separator != -1) {
      var t: int = Math__.min__II(form.separator, oldSeperator);
      var b: int = Math__.max__II(form.separator, oldSeperator);
      form.redraw__IIIIZ(form.borderLeft, t, form.getSize__().x - form.borderLeft - form.borderRight, b - t, false);
    }
    return;
  }
}
}
