package org.eclipse.swt.dnd {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Display;
import java.lang.Thread;
import org.eclipse.swt.SWT;
import java.lang.Class__;
import java.lang.JavaArray;
dynamic public class Clipboard {
  private var display: Display;
  public function Clipboard(display: Display) {
    this.checkSubclass__();
    if (display === null) {
      display = Display.getCurrent__();
      if (display === null) {
        display = Display.getDefault__();
      }
    }
    if (display.getThread__() !== Thread.currentThread__()) {
      DND.error__I(22);
    }
    this.display = display;
    return;
  }
  public function checkSubclass__(): void {
    var name: String = Object(this).getClass__().getName__();
    var validName: String = Class__.forName__Ljava_lang_String_2("org.eclipse.swt.dnd.Clipboard").getName__();
    if (!Object(validName).equals__Ljava_lang_Object_2(name)) {
      DND.error__I(43);
    }
    return;
  }
  public function checkWidget__(): void {
    var display_1: Display = this.display;
    if (display_1 === null)
      DND.error__I(24);
    if (display_1.getThread__() !== Thread.currentThread__())
      DND.error__I(22);
    if (display_1.isDisposed__())
      DND.error__I(24);
    return;
  }
  public function dispose__(): void {
    if (this.isDisposed__())
      return;
    if (display.getThread__() !== Thread.currentThread__())
      DND.error__I(22);
    display = null;
  }
  public function getContents__Lorg_eclipse_swt_dnd_Transfer_2(transfer: Transfer): Object {
    return this.getContents__Lorg_eclipse_swt_dnd_Transfer_2I(transfer, 1);
  }
  public function getContents__Lorg_eclipse_swt_dnd_Transfer_2I(transfer: Transfer, clipboards: int): Object {
    this.checkWidget__();
    if (transfer === null)
      DND.error__I(4);
    if (!(transfer is TextTransfer))
      return null;
    return display.getData__Ljava_lang_String_2("TextTransfer");
  }
  public function isDisposed__(): Boolean {
    return (display === null);
  }
  public function setContents___3Ljava_lang_Object_2_3Lorg_eclipse_swt_dnd_Transfer_2(data: JavaArray, dataTypes: JavaArray): void {
    this.setContents___3Ljava_lang_Object_2_3Lorg_eclipse_swt_dnd_Transfer_2I(data, dataTypes, 1);
  }
  public function setContents___3Ljava_lang_Object_2_3Lorg_eclipse_swt_dnd_Transfer_2I(data: JavaArray, dataTypes: JavaArray, clipboards: int): void {
    this.checkWidget__();
    if (data === null || dataTypes === null || data.length != dataTypes.length) {
      DND.error__I(5);
    }
    for (var i: int = 0; i < dataTypes.length; i++) {
      if (dataTypes[i] is TextTransfer && data[i] is String) {
        display.setData__Ljava_lang_String_2Ljava_lang_Object_2("TextTransfer", data[i]);
        return;
      }
    }
    return;
  }
  public function getAvailableTypes__(): JavaArray {
    this.checkWidget__();
    return new JavaArray("[Lorg/eclipse/swt/dnd/TransferData;").lengths(0);
  }
  public function getAvailableTypeNames__(): JavaArray {
    this.checkWidget__();
    return new JavaArray("[Ljava/lang/String;").lengths(0);
  }
}
}
