package org.eclipse.swt.dnd {
import org.eclipse.swt.*;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.SWT;
import java.lang.Arguments;
dynamic public class DND {
  public static const CLIPBOARD: int = 1 << 0;
  public static const SELECTION_CLIPBOARD: int = 1 << 1;
  public static const DROP_NONE: int = 0;
  public static const DROP_COPY: int = 1 << 0;
  public static const DROP_MOVE: int = 1 << 1;
  public static const DROP_LINK: int = 1 << 2;
  public static const DROP_TARGET_MOVE: int = 1 << 3;
  public static const DROP_DEFAULT: int = 1 << 4;
  public static const DragEnd: int = 2000;
  public static const DragSetData: int = 2001;
  public static const DragEnter: int = 2002;
  public static const DragLeave: int = 2003;
  public static const DragOver: int = 2004;
  public static const DragOperationChanged: int = 2005;
  public static const Drop: int = 2006;
  public static const DropAccept: int = 2007;
  public static const DragStart: int = 2008;
  public static const FEEDBACK_NONE: int = 0;
  public static const FEEDBACK_SELECT: int = 1;
  public static const FEEDBACK_INSERT_BEFORE: int = 2;
  public static const FEEDBACK_INSERT_AFTER: int = 4;
  public static const FEEDBACK_SCROLL: int = 8;
  public static const FEEDBACK_EXPAND: int = 16;
  public static const ERROR_CANNOT_INIT_DRAG: int = 2000;
  public static const ERROR_CANNOT_INIT_DROP: int = 2001;
  public static const ERROR_CANNOT_SET_CLIPBOARD: int = 2002;
  public static const ERROR_INVALID_DATA: int = 2003;
  public static const DROP_TARGET_KEY: String = "DropTarget";
  public static const DRAG_SOURCE_KEY: String = "DragSource";
  public static const INIT_DRAG_MESSAGE: String = "Cannot initialize Drag";
  public static const INIT_DROP_MESSAGE: String = "Cannot initialize Drop";
  public static const CANNOT_SET_CLIPBOARD_MESSAGE: String = "Cannot set data in clipboard";
  public static const INVALID_DATA_MESSAGE: String = "Data does not have correct format for type";
  public static function error__I(code: int): void {
    error__II(code, 0);
    return;
  }
  public static function error__II(code: int, hresult: int): void {
    switch (code) {
      case 2000 :
        {
          var msg: String = "Cannot initialize Drag";
          if (hresult != 0)
            msg += " result = " + hresult;
          throw new SWTError(new Arguments(org.eclipse.swt.SWTError.SWTError__ILjava_lang_String_2, [code, msg]));
        }
      case 2001 :
        {
          var msg_1: String = "Cannot initialize Drop";
          if (hresult != 0)
            msg_1 += " result = " + hresult;
          throw new SWTError(new Arguments(org.eclipse.swt.SWTError.SWTError__ILjava_lang_String_2, [code, msg_1]));
        }
      case 2002 :
        {
          var msg_2: String = "Cannot set data in clipboard";
          if (hresult != 0)
            msg_2 += " result = " + hresult;
          throw new SWTError(new Arguments(org.eclipse.swt.SWTError.SWTError__ILjava_lang_String_2, [code, msg_2]));
        }
      case 2003 :
        {
          var msg_3: String = "Data does not have correct format for type";
          if (hresult != 0)
            msg_3 += " result = " + hresult;
          throw new SWTException(new Arguments(org.eclipse.swt.SWTException.SWTException__ILjava_lang_String_2, [code, msg_3]));
        }
    }
    SWT.error__I(code);
    return;
  }
}
}
