package org.eclipse.swt.dnd {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Table;
import java.lang.System;
import java.lang.Arguments;
import java.lang.Class__;
import java.lang.JavaArray;
dynamic public class DragSource extends Widget {
  private var control: Control;
  private var controlListener: Listener;
  private var transferAgents: JavaArray = new JavaArray("[Lorg/eclipse/swt/dnd/Transfer;").lengths(0);
  private var dragEffect: DragSourceEffect;
  public static const DEFAULT_DRAG_SOURCE_EFFECT: String = "DEFAULT_DRAG_SOURCE_EFFECT";
  public function DragSource(control: Control, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Widget.Widget__Lorg_eclipse_swt_widgets_Widget_2I, [control, DragSource.checkStyle__I(style)]));
    this.control = control;
    if (control.getData__Ljava_lang_String_2("DragSource") !== null)
      DND.error__I(2000);
    control.setData__Ljava_lang_String_2Ljava_lang_Object_2("DragSource", this);
    controlListener = new org.eclipse.swt.dnd.DragSource$1(this);
    control.addListener__ILorg_eclipse_swt_widgets_Listener_2(12, controlListener);
    control.addListener__ILorg_eclipse_swt_widgets_Listener_2(29, controlListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(12, new org.eclipse.swt.dnd.DragSource$2(this));
    var effect: Object = control.getData__Ljava_lang_String_2("DEFAULT_DRAG_SOURCE_EFFECT");
    if (effect is DragSourceEffect) {
      dragEffect = DragSourceEffect(effect);
    } else if (control is Tree) {
      dragEffect = new TreeDragSourceEffect(Tree(control));
    } else if (control is Table) {
      dragEffect = new TableDragSourceEffect(Table(control));
    }
    return;
  }
  public function addDragListener__Lorg_eclipse_swt_dnd_DragSourceListener_2(listener: DragSourceListener): void {
    if (listener === null)
      DND.error__I(4);
    var typedListener: DNDListener = new DNDListener(listener);
    typedListener.dndWidget = this;
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(2008, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(2001, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(2000, typedListener);
    return;
  }
  public static function checkStyle__I(style: int): int {
    if (style == 0)
      return 2;
    return style;
  }
  public override function checkSubclass__(): void {
    var name: String = Object(this).getClass__().getName__();
    var validName: String = Class__.forName__Ljava_lang_String_2("org.eclipse.swt.dnd.DragSource").getName__();
    if (!Object(validName).equals__Ljava_lang_Object_2(name)) {
      DND.error__I(43);
    }
    return;
  }
  public function getControl__(): Control {
    return control;
  }
  public function getDragListeners__(): JavaArray {
    var listeners: JavaArray = this.getListeners__I(2008);
    var length: int = listeners.length;
    var dragListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/dnd/DragSourceListener;").lengths(length);
    var count: int = 0;
    for (var i: int = 0; i < length; i++) {
      var listener: Listener = listeners[i];
      if (listener is DNDListener) {
        dragListeners[count] = DragSourceListener((DNDListener(listener)).getEventListener__());
        count++;
      }
    }
    if (count == length)
      return dragListeners;
    var result: JavaArray = new JavaArray("[Lorg/eclipse/swt/dnd/DragSourceListener;").lengths(count);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(dragListeners, 0, result, 0, count);
    return result;
  }
  public function getDragSourceEffect__(): DragSourceEffect {
    return dragEffect;
  }
  public function getTransfer__(): JavaArray {
    return transferAgents;
  }
  private function onDispose__(): void {
    if (control === null)
      return;
    if (controlListener !== null) {
      control.removeListener__ILorg_eclipse_swt_widgets_Listener_2(12, controlListener);
      control.removeListener__ILorg_eclipse_swt_widgets_Listener_2(29, controlListener);
    }
    controlListener = null;
    control.setData__Ljava_lang_String_2Ljava_lang_Object_2("DragSource", null);
    control = null;
    transferAgents = null;
    return;
  }
  public function removeDragListener__Lorg_eclipse_swt_dnd_DragSourceListener_2(listener: DragSourceListener): void {
    if (listener === null)
      DND.error__I(4);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(2008, listener);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(2001, listener);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(2000, listener);
    return;
  }
  public function setDragSourceEffect__Lorg_eclipse_swt_dnd_DragSourceEffect_2(effect: DragSourceEffect): void {
    dragEffect = effect;
    return;
  }
  public function setTransfer___3Lorg_eclipse_swt_dnd_Transfer_2(transferAgents_1: JavaArray): void {
    this.transferAgents = transferAgents_1;
    return;
  }
  public static function access$0(arg0: DragSource): void {
    arg0.onDispose__();
  }
}
}
