package org.eclipse.swt.dnd {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import java.lang.System;
import java.lang.Arguments;
import java.lang.Class__;
import java.lang.JavaArray;
dynamic public class DropTarget extends Widget {
  internal var control: Control;
  internal var controlListener: Listener;
  internal var transferAgents: JavaArray = new JavaArray("[Lorg/eclipse/swt/dnd/Transfer;").lengths(0);
  internal var dropEffect: DropTargetEffect;
  public static const DEFAULT_DROP_TARGET_EFFECT: String = "DEFAULT_DROP_TARGET_EFFECT";
  public function DropTarget(control: Control, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Widget.Widget__Lorg_eclipse_swt_widgets_Widget_2I, [control, DropTarget.checkStyle__I(style)]));
    this.control = control;
    if (control.getData__Ljava_lang_String_2("DropTarget") !== null)
      DND.error__I(2001);
    control.setData__Ljava_lang_String_2Ljava_lang_Object_2("DropTarget", this);
    controlListener = new org.eclipse.swt.dnd.DropTarget$1(this);
    control.addListener__ILorg_eclipse_swt_widgets_Listener_2(12, controlListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(12, new org.eclipse.swt.dnd.DropTarget$2(this));
    var effect: Object = control.getData__Ljava_lang_String_2("DEFAULT_DROP_TARGET_EFFECT");
    if (effect is DropTargetEffect) {
      dropEffect = DropTargetEffect(effect);
    } else if (control is Table) {
      dropEffect = new TableDropTargetEffect(Table(control));
    } else if (control is Tree) {
      dropEffect = new TreeDropTargetEffect(Tree(control));
    }
    return;
  }
  public function addDropListener__Lorg_eclipse_swt_dnd_DropTargetListener_2(listener: DropTargetListener): void {
    if (listener === null)
      DND.error__I(4);
    var typedListener: DNDListener = new DNDListener(listener);
    typedListener.dndWidget = this;
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(2002, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(2003, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(2004, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(2005, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(2006, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(2007, typedListener);
    return;
  }
  public static function checkStyle__I(style: int): int {
    if (style == 0)
      return 2;
    return style;
  }
  public override function checkSubclass__(): void {
    var name: String = Object(this).getClass__().getName__();
    var validName: String = Class__.forName__Ljava_lang_String_2("org.eclipse.swt.dnd.DropTarget").getName__();
    if (!Object(validName).equals__Ljava_lang_Object_2(name)) {
      DND.error__I(43);
    }
    return;
  }
  public function getControl__(): Control {
    return control;
  }
  public function getDropListeners__(): JavaArray {
    var listeners: JavaArray = this.getListeners__I(2002);
    var length: int = listeners.length;
    var dropListeners: JavaArray = new JavaArray("[Lorg/eclipse/swt/dnd/DropTargetListener;").lengths(length);
    var count: int = 0;
    for (var i: int = 0; i < length; i++) {
      var listener: Listener = listeners[i];
      if (listener is DNDListener) {
        dropListeners[count] = DropTargetListener((DNDListener(listener)).getEventListener__());
        count++;
      }
    }
    if (count == length)
      return dropListeners;
    var result: JavaArray = new JavaArray("[Lorg/eclipse/swt/dnd/DropTargetListener;").lengths(count);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(dropListeners, 0, result, 0, count);
    return result;
  }
  public function getDropTargetEffect__(): DropTargetEffect {
    return dropEffect;
  }
  public function getTransfer__(): JavaArray {
    return transferAgents;
  }
  public function onDispose__(): void {
    if (control === null)
      return;
    if (controlListener !== null)
      control.removeListener__ILorg_eclipse_swt_widgets_Listener_2(12, controlListener);
    controlListener = null;
    control.setData__Ljava_lang_String_2Ljava_lang_Object_2("DropTarget", null);
    transferAgents = null;
    control = null;
  }
  public function removeDropListener__Lorg_eclipse_swt_dnd_DropTargetListener_2(listener: DropTargetListener): void {
    if (listener === null)
      DND.error__I(4);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(2002, listener);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(2003, listener);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(2004, listener);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(2005, listener);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(2006, listener);
    this.removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(2007, listener);
  }
  public function setDropTargetEffect__Lorg_eclipse_swt_dnd_DropTargetEffect_2(effect: DropTargetEffect): void {
    dropEffect = effect;
  }
  public function setTransfer___3Lorg_eclipse_swt_dnd_Transfer_2(transferAgents_1: JavaArray): void {
    if (transferAgents_1 === null)
      DND.error__I(4);
    this.transferAgents = transferAgents_1;
  }
}
}
