package org.eclipse.swt.dnd {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.TreeItem;
dynamic public class DropTargetEffect extends DropTargetAdapter {
  internal var control: Control;
  public function DropTargetEffect(control: Control) {
    if (control === null)
      SWT.error__I(4);
    this.control = control;
    return;
  }
  public function getControl__(): Control {
    return control;
  }
  public function getItem__II(x: int, y: int): Widget {
    if (control is Table) {
      return this.getItem__Lorg_eclipse_swt_widgets_Table_2II(Table(control), x, y);
    }
    if (control is Tree) {
      return this.getItem__Lorg_eclipse_swt_widgets_Tree_2II(Tree(control), x, y);
    }
    return null;
  }
  public function getItem__Lorg_eclipse_swt_widgets_Table_2II(table: Table, x: int, y: int): Widget {
    var coordinates: Point = new Point(x, y);
    coordinates = table.toControl__Lorg_eclipse_swt_graphics_Point_2(coordinates);
    var item: TableItem = table.getItem__Lorg_eclipse_swt_graphics_Point_2(coordinates);
    if (item !== null)
      return item;
    var area: Rectangle = table.getClientArea__();
    var tableBottom: int = area.y + area.height;
    var itemCount: int = table.getItemCount__();
    for (var i: int = table.getTopIndex__(); i < itemCount; i++) {
      item = table.getItem__I(i);
      var rect: Rectangle = item.getBounds__();
      rect.x = area.x;
      rect.width = area.width;
      if (rect.contains__Lorg_eclipse_swt_graphics_Point_2(coordinates))
        return item;
      if (rect.y > tableBottom)
        break;
    }
    return null;
  }
  public function getItem__Lorg_eclipse_swt_widgets_Tree_2II(tree: Tree, x: int, y: int): Widget {
    var point: Point = new Point(x, y);
    point = tree.toControl__Lorg_eclipse_swt_graphics_Point_2(point);
    var item: TreeItem = tree.getItem__Lorg_eclipse_swt_graphics_Point_2(point);
    if (item === null) {
      var area: Rectangle = tree.getClientArea__();
      if (area.contains__Lorg_eclipse_swt_graphics_Point_2(point)) {
        var treeBottom: int = area.y + area.height;
        item = tree.getTopItem__();
        while (item !== null) {
          var rect: Rectangle = item.getBounds__();
          var itemBottom: int = rect.y + rect.height;
          if (rect.y <= point.y && point.y < itemBottom)
            return item;
          if (itemBottom > treeBottom)
            break;
          item = this.nextItem__Lorg_eclipse_swt_widgets_Tree_2Lorg_eclipse_swt_widgets_TreeItem_2(tree, item);
        }
        return null;
      }
    }
    return item;
  }
  public function nextItem__Lorg_eclipse_swt_widgets_Tree_2Lorg_eclipse_swt_widgets_TreeItem_2(tree: Tree, item: TreeItem): TreeItem {
    if (item === null)
      return null;
    if (item.getExpanded__() && item.getItemCount__() > 0)
      return item.getItem__I(0);
    var childItem: TreeItem = item;
    var parentItem: TreeItem = childItem.getParentItem__();
    var index: int = parentItem === null ? tree.indexOf__Lorg_eclipse_swt_widgets_TreeItem_2(childItem) : parentItem.indexOf__Lorg_eclipse_swt_widgets_TreeItem_2(childItem);
    var count: int = parentItem === null ? tree.getItemCount__() : parentItem.getItemCount__();
    while (true) {
      if (index + 1 < count)
        return parentItem === null ? tree.getItem__I(index + 1) : parentItem.getItem__I(index + 1);
      if (parentItem === null)
        return null;
      childItem = parentItem;
      parentItem = childItem.getParentItem__();
      index = parentItem === null ? tree.indexOf__Lorg_eclipse_swt_widgets_TreeItem_2(childItem) : parentItem.indexOf__Lorg_eclipse_swt_widgets_TreeItem_2(childItem);
      count = parentItem === null ? tree.getItemCount__() : parentItem.getItemCount__();
    }
    return null;
  }
  public function previousItem__Lorg_eclipse_swt_widgets_Tree_2Lorg_eclipse_swt_widgets_TreeItem_2(tree: Tree, item: TreeItem): TreeItem {
    if (item === null)
      return null;
    var childItem: TreeItem = item;
    var parentItem: TreeItem = childItem.getParentItem__();
    var index: int = parentItem === null ? tree.indexOf__Lorg_eclipse_swt_widgets_TreeItem_2(childItem) : parentItem.indexOf__Lorg_eclipse_swt_widgets_TreeItem_2(childItem);
    if (index == 0)
      return parentItem;
    var nextItem: TreeItem = parentItem === null ? tree.getItem__I(index - 1) : parentItem.getItem__I(index - 1);
    var count: int = nextItem.getItemCount__();
    while (count > 0 && nextItem.getExpanded__()) {
      nextItem = nextItem.getItem__I(count - 1);
      count = nextItem.getItemCount__();
    }
    return nextItem;
  }
}
}
