package org.eclipse.swt.dnd {
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Widget;
import java.lang.StringBuffer;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class DropTargetEvent extends TypedEvent {
  public var x: int;
  public var y: int;
  public var detail: int;
  public var operations: int;
  public var feedback: int;
  public var item: Widget;
  public var currentDataType: TransferData;
  public var dataTypes: JavaArray;
  public static const serialVersionUID: Number = 3256727264573338678;
  public function DropTargetEvent(e: DNDEvent) {
    super(new Arguments(org.eclipse.swt.events.TypedEvent.TypedEvent__Lorg_eclipse_swt_widgets_Event_2, [e]));
    this.data = e.data;
    this.x = e.x;
    this.y = e.y;
    this.detail = e.detail;
    this.currentDataType = e.dataType;
    this.dataTypes = e.dataTypes;
    this.operations = e.operations;
    this.feedback = e.feedback;
    this.item = e.item;
    return;
  }
  public function updateEvent__Lorg_eclipse_swt_dnd_DNDEvent_2(e: DNDEvent): void {
    e.widget = this.widget;
    e.time = this.time;
    e.data = this.data;
    e.x = this.x;
    e.y = this.y;
    e.detail = this.detail;
    e.dataType = this.currentDataType;
    e.dataTypes = this.dataTypes;
    e.operations = this.operations;
    e.feedback = this.feedback;
    e.item = this.item;
    return;
  }
  public override function toString__(): String {
    var string: String = super.toString__();
    var sb: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__, []));
    sb.append__Ljava_lang_String_2(Object(string).substring__II(0, Object(string).length__() - 1));
    sb.append__Ljava_lang_String_2(" x=");
    sb.append__I(x);
    sb.append__Ljava_lang_String_2(" y=");
    sb.append__I(y);
    sb.append__Ljava_lang_String_2(" item=");
    sb.append__Ljava_lang_Object_2(item);
    sb.append__Ljava_lang_String_2(" operations=");
    sb.append__I(operations);
    sb.append__Ljava_lang_String_2(" operation=");
    sb.append__I(detail);
    sb.append__Ljava_lang_String_2(" feedback=");
    sb.append__I(feedback);
    sb.append__Ljava_lang_String_2(" dataTypes={ ");
    if (dataTypes !== null) {
      for (var i: int = 0; i < dataTypes.length; i++) {
        sb.append__I(dataTypes[i].type);
        sb.append__C(32);
      }
    }
    sb.append__C(125);
    sb.append__Ljava_lang_String_2(" currentDataType=");
    sb.append__I(currentDataType !== null ? currentDataType.type : 48);
    sb.append__C(125);
    return sb.toString__();
  }
}
}
