package org.eclipse.swt.graphics {
import org.eclipse.swt.*;
import org.eclipse.swt.SWT;
import java.lang.Arguments;
dynamic public class Color extends Resource {
  public var handle: int;
  public function Color__Lorg_eclipse_swt_graphics_Device_2(device: Device): Object {
    return this;
  }
  public function Color__Lorg_eclipse_swt_graphics_Device_2III(device: Device, red: int, green: int, blue: int): Object {
    this.init__III(red, green, blue);
    this.init__();
    return this;
  }
  public function Color__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_RGB_2(device: Device, rgb: RGB): Object {
    this.init__III(rgb.red, rgb.green, rgb.blue);
    this.init__();
    return this;
  }
  public override function destroy__(): void {
    handle = -1;
    return;
  }
  public function equals__Ljava_lang_Object_2(object: Object): Boolean {
    if (object === this)
      return true;
    if (!(object is Color))
      return false;
    var color: Color = Color(object);
    return device === color.device && (handle & 0xFFFFFF) == (color.handle & 0xFFFFFF);
  }
  public function getBlue__(): int {
    if (this.isDisposed__())
      SWT.error__I(44);
    return handle & 0xFF;
  }
  public function getGreen__(): int {
    if (this.isDisposed__())
      SWT.error__I(44);
    return (handle & 0xFF00) >> 8;
  }
  public function getRed__(): int {
    if (this.isDisposed__())
      SWT.error__I(44);
    return (handle & 0xFF0000) >> 16;
  }
  public function getRGB__(): RGB {
    if (this.isDisposed__())
      SWT.error__I(44);
    return new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [(handle & 0xFF0000) >> 16, (handle & 0xFF00) >> 8, handle & 0xFF]));
  }
  public function hashCode__(): int {
    if (this.isDisposed__())
      return 0;
    return handle;
  }
  public function init__III(red: int, green: int, blue: int): void {
    if (red > 255 || red < 0 || green > 255 || green < 0 || blue > 255 || blue < 0) {
      SWT.error__I(5);
    }
    handle = ((red & 0xFF) << 16) | ((green & 0xFF) << 8) | (blue & 0xFF);
    return;
  }
  public override function isDisposed__(): Boolean {
    return handle == -1;
  }
  public function toString__(): String {
    if (this.isDisposed__())
      return "Color {*DISPOSED*}";
    return "Color {" + this.getRed__() + ", " + this.getGreen__() + ", " + this.getBlue__() + "}";
  }
  public static function flex_new__Lorg_eclipse_swt_graphics_Device_2I(device: Device, rgb: int): Color {
    var color: Color = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2, [device]));
    color.handle = rgb;
    return color;
  }
  public function Color(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is Device) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 4 && vargs[0] is Device && vargs[1] is int && vargs[2] is int && vargs[3] is int) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 2 && vargs[0] is Device && vargs[1] is RGB) {
        args = vargs;
        id = 2;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args0[0]]);
        break;
      case 1:
        var args1: Array = [args[0], args[1], args[2], args[3]];
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args1[0]]);
        break;
      case 2:
        var args2: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args2[0]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        Color__Lorg_eclipse_swt_graphics_Device_2(args0[0]);
        break;
      case 1:
        Color__Lorg_eclipse_swt_graphics_Device_2III(args1[0], args1[1], args1[2], args1[3]);
        break;
      case 2:
        Color__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_RGB_2(args2[0], args2[1]);
        break;
    }
  }
  public static const Color__Lorg_eclipse_swt_graphics_Device_2 : int = 0;
  public static const Color__Lorg_eclipse_swt_graphics_Device_2III : int = 1;
  public static const Color__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_RGB_2 : int = 2;
}
}
