package org.eclipse.swt.graphics {
import org.eclipse.swt.SWT;
import flash.display.BitmapData;
import flash.utils.ByteArray;
import flash.geom.Rectangle;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Cursor extends Resource {
  public var object: Class;
  public var bitmap: BitmapData;
  public var hotspotX: int;
  public var hotspotY: int;
  public var wait: Boolean;
  public static const HAND_X: int = 5;
  public static const HAND_Y: int = 0;
  public static const HAND_WIDTH: int = 32;
  public static const HAND_HEIGHT: int = 16;
  public static var HAND_SOURCE: JavaArray = new JavaArray("[B").values(int(0xf9), int(0xff), int(0xff), int(0xff), int(0xf0), int(0xff), int(0xff), int(0xff), int(0xf0), int(0xff), int(0xff), int(0xff), int(0xf0), int(0xff), int(0xff), int(0xff), int(0xf0), int(0x3f), int(0xff), int(0xff), int(0xf0), int(0x07), int(0xff), int(0xff), int(0xf0), int(0x03), int(0xff), int(0xff), int(0xf0), int(0x00), int(0xff), int(0xff), int(0x10), int(0x00), int(0x7f), int(0xff), int(0x00), int(0x00), int(0x7f), int(0xff), int(0x80), int(0x00), int(0x7f), int(0xff), int(0xc0), int(0x00), int(0x7f), int(0xff), int(0xe0), int(0x00), int(0x7f), int(0xff), int(0xf0), int(0x00), int(0x7f), int(0xff), int(0xf8), int(0x00), int(0xff), int(0xff), int(0xfc), int(0x01), int(0xff), int(0xff));
  public static var HAND_MASK: JavaArray = new JavaArray("[B").values(int(0x00), int(0x00), int(0x00), int(0x00), int(0x06), int(0x00), int(0x00), int(0x00), int(0x06), int(0x00), int(0x00), int(0x00), int(0x06), int(0x00), int(0x00), int(0x00), int(0x06), int(0x00), int(0x00), int(0x00), int(0x06), int(0xc0), int(0x00), int(0x00), int(0x06), int(0xd8), int(0x00), int(0x00), int(0x06), int(0xd8), int(0x00), int(0x00), int(0x07), int(0xdb), int(0x00), int(0x00), int(0x67), int(0xfb), int(0x00), int(0x00), int(0x3f), int(0xff), int(0x00), int(0x00), int(0x1f), int(0xff), int(0x00), int(0x00), int(0x0f), int(0xff), int(0x00), int(0x00), int(0x07), int(0xff), int(0x00), int(0x00), int(0x03), int(0xfe), int(0x00), int(0x00), int(0x00), int(0x00), int(0x00), int(0x00));
  public static const IBEAM_X: int = 3;
  public static const IBEAM_Y: int = 8;
  public static const IBEAM_WIDTH: int = 32;
  public static const IBEAM_HEIGHT: int = 16;
  public static var IBEAM_SOURCE: JavaArray = new JavaArray("[B").values(int(0x11), int(0xff), int(0xff), int(0xff), int(0xef), int(0xff), int(0xff), int(0xff), int(0xef), int(0xff), int(0xff), int(0xff), int(0xef), int(0xff), int(0xff), int(0xff), int(0xef), int(0xff), int(0xff), int(0xff), int(0xef), int(0xff), int(0xff), int(0xff), int(0xef), int(0xff), int(0xff), int(0xff), int(0xef), int(0xff), int(0xff), int(0xff), int(0xef), int(0xff), int(0xff), int(0xff), int(0xef), int(0xff), int(0xff), int(0xff), int(0xef), int(0xff), int(0xff), int(0xff), int(0xef), int(0xff), int(0xff), int(0xff), int(0xef), int(0xff), int(0xff), int(0xff), int(0xef), int(0xff), int(0xff), int(0xff), int(0xef), int(0xff), int(0xff), int(0xff), int(0x11), int(0xff), int(0xff), int(0xff));
  public static const SIZEE_X: int = 10;
  public static const SIZEE_Y: int = 10;
  public static const SIZEE_WIDTH: int = 32;
  public static const SIZEE_HEIGHT: int = 20;
  public static var SIZEE_SOURCE: JavaArray = new JavaArray("[B").values(int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xef), int(0xfe), int(0xff), int(0xff), int(0xcf), int(0xfe), int(0x7f), int(0xff), int(0x8f), int(0xfe), int(0x3f), int(0xff), int(0x00), int(0x00), int(0x1f), int(0xff), int(0x8f), int(0xfe), int(0x3f), int(0xff), int(0xcf), int(0xfe), int(0x7f), int(0xff), int(0xef), int(0xfe), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff));
  public static const SIZES_X: int = 10;
  public static const SIZES_Y: int = 10;
  public static const SIZES_WIDTH: int = 32;
  public static const SIZES_HEIGHT: int = 20;
  public static var SIZES_SOURCE: JavaArray = new JavaArray("[B").values(int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0x1f), int(0xff), int(0xff), int(0xfe), int(0x0f), int(0xff), int(0xff), int(0xfc), int(0x07), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xfc), int(0x07), int(0xff), int(0xff), int(0xfe), int(0x0f), int(0xff), int(0xff), int(0xff), int(0x1f), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff));
  public static const SIZEALL_X: int = 10;
  public static const SIZEALL_Y: int = 10;
  public static const SIZEALL_WIDTH: int = 32;
  public static const SIZEALL_HEIGHT: int = 20;
  public static var SIZEALL_SOURCE: JavaArray = new JavaArray("[B").values(int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0x1f), int(0xff), int(0xff), int(0xfe), int(0x0f), int(0xff), int(0xff), int(0xfc), int(0x07), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xef), int(0xbe), int(0xff), int(0xff), int(0xcf), int(0xbe), int(0x7f), int(0xff), int(0x8f), int(0xbe), int(0x3f), int(0xff), int(0x00), int(0x00), int(0x1f), int(0xff), int(0x8f), int(0xbe), int(0x3f), int(0xff), int(0xcf), int(0xbe), int(0x7f), int(0xff), int(0xef), int(0xbe), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xfc), int(0x07), int(0xff), int(0xff), int(0xfe), int(0x0f), int(0xff), int(0xff), int(0xff), int(0x1f), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff));
  public static const SIZENW_X: int = 7;
  public static const SIZENW_Y: int = 7;
  public static const SIZENW_WIDTH: int = 32;
  public static const SIZENW_HEIGHT: int = 16;
  public static var SIZENW_SOURCE: JavaArray = new JavaArray("[B").values(int(0x07), int(0xff), int(0xff), int(0xff), int(0x0f), int(0xff), int(0xff), int(0xff), int(0x1f), int(0xff), int(0xff), int(0xff), int(0x2f), int(0xff), int(0xff), int(0xff), int(0x77), int(0xff), int(0xff), int(0xff), int(0xfb), int(0xff), int(0xff), int(0xff), int(0xfd), int(0xff), int(0xff), int(0xff), int(0xfe), int(0xff), int(0xff), int(0xff), int(0xff), int(0x77), int(0xff), int(0xff), int(0xff), int(0xa7), int(0xff), int(0xff), int(0xff), int(0xc7), int(0xff), int(0xff), int(0xff), int(0x87), int(0xff), int(0xff), int(0xff), int(0x07), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff));
  public static const SIZENE_X: int = 7;
  public static const SIZENE_Y: int = 7;
  public static const SIZENE_WIDTH: int = 32;
  public static const SIZENE_HEIGHT: int = 16;
  public static var SIZENE_SOURCE: JavaArray = new JavaArray("[B").values(int(0xff), int(0x07), int(0xff), int(0xff), int(0xff), int(0x87), int(0xff), int(0xff), int(0xff), int(0xc7), int(0xff), int(0xff), int(0xff), int(0xa7), int(0xff), int(0xff), int(0xff), int(0x77), int(0xff), int(0xff), int(0xfe), int(0xff), int(0xff), int(0xff), int(0xfd), int(0xff), int(0xff), int(0xff), int(0xfb), int(0xff), int(0xff), int(0xff), int(0x77), int(0xff), int(0xff), int(0xff), int(0x2f), int(0xff), int(0xff), int(0xff), int(0x1f), int(0xff), int(0xff), int(0xff), int(0x0f), int(0xff), int(0xff), int(0xff), int(0x07), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff));
  public static const CROSS_X: int = 10;
  public static const CROSS_Y: int = 10;
  public static const CROSS_WIDTH: int = 32;
  public static const CROSS_HEIGHT: int = 20;
  public static var CROSS_SOURCE: JavaArray = new JavaArray("[B").values(int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0x00), int(0x00), int(0x1f), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xbf), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff), int(0xff));
  public function Cursor__Lorg_eclipse_swt_graphics_Device_2I(device: Device, style: int): Object {
    var width: int = 0;
    var height: int = 0;
    var hotspotX: int = 0;
    var hotspotY: int = 0;
    var source: JavaArray = null;
    var mask: JavaArray = null;
    switch (style) {
      case 21 :
        source = HAND_SOURCE;
        mask = HAND_MASK;
        hotspotX = 5;
        hotspotY = 0;
        width = 32;
        height = 16;
        break;
      case 0 :
        break;
      case 1 :
        wait = true;
        break;
      case 2 :
        source = CROSS_SOURCE;
        hotspotX = 10;
        hotspotY = 10;
        width = 32;
        height = 20;
        break;
      case 3 :
        break;
      case 4 :
        break;
      case 5 :
      case 6 :
      case 8 :
        source = SIZEALL_SOURCE;
        hotspotX = 10;
        hotspotY = 10;
        width = 32;
        height = 20;
        break;
      case 7 :
      case 10 :
      case 11 :
        source = SIZES_SOURCE;
        hotspotX = 10;
        hotspotY = 10;
        width = 32;
        height = 20;
        break;
      case 9 :
      case 12 :
      case 13 :
        source = SIZEE_SOURCE;
        hotspotX = 10;
        hotspotY = 10;
        width = 32;
        height = 20;
        break;
      case 14 :
      case 15 :
        source = SIZENE_SOURCE;
        hotspotX = 7;
        hotspotY = 7;
        width = 32;
        height = 16;
        break;
      case 16 :
      case 17 :
        source = SIZENW_SOURCE;
        hotspotX = 7;
        hotspotY = 7;
        width = 32;
        height = 16;
        break;
      case 18 :
        break;
      case 19 :
        source = IBEAM_SOURCE;
        hotspotX = 3;
        hotspotY = 8;
        width = 32;
        height = 16;
        break;
      case 20 :
        break;
      default :
        SWT.error__I(5);
    }
    if (source !== null) {
      var data: JavaArray = new JavaArray("[B").lengths(width * height * 4);
      for (var y: int = 0; y < height; y++) {
        var offset: int = y * width * 4;
        for (var x: int = 0; x < width; x++) {
          var index: int = (y * 4) + (x >> 3);
          var masking: int = 1 << (7 - (x & 0x7));
          var pixel: int = ((source[index] & 0xFF) & masking) == 0 ? 0 : 1;
          var maskPixel: int = mask === null || ((mask[index] & 0xFF) & masking) == 0 ? 0 : 1;
          if (pixel == 0 && maskPixel == 0) {
            data[offset] = int(0xFF);
          } else if (pixel == 0 && maskPixel == 1) {
            data[offset] = data[offset + 1] = data[offset + 2] = data[offset + 3] = int(0xFF);
          } else if (pixel == 1 && maskPixel == 0) {
          } else {
          }
          offset += 4;
        }
      }
      this.hotspotX = hotspotX;
      this.hotspotY = hotspotY;
      this.createBitmap___3BII(data, width, height);
    }
    this.init__();
    return this;
  }
  public function Cursor__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_ImageData_2Lorg_eclipse_swt_graphics_ImageData_2II(device: Device, source: ImageData, mask: ImageData, hotspotX: int, hotspotY: int): Object {
    if (source === null)
      SWT.error__I(4);
    if (mask === null) {
      if (source.getTransparencyType__() != 2) {
        SWT.error__I(4);
      }
      mask = source.getTransparencyMask__();
    }
    if (mask.width != source.width || mask.height != source.height) {
      SWT.error__I(5);
    }
    if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
      SWT.error__I(5);
    }
    var data: JavaArray = new JavaArray("[B").lengths(source.width * source.height * 4);
    for (var y: int = 0; y < source.height; y++) {
      var offset: int = y * source.width * 4;
      for (var x: int = 0; x < source.width; x++) {
        var pixel: int = source.getPixel__II(x, y);
        var maskPixel: int = mask.getPixel__II(x, y);
        if (pixel == 0 && maskPixel == 0) {
          data[offset] = int(0xFF);
        } else if (pixel == 0 && maskPixel == 1) {
          data[offset] = data[offset + 1] = data[offset + 2] = data[offset + 3] = int(0xFF);
        } else if (pixel == 1 && maskPixel == 0) {
        } else {
        }
        offset += 4;
      }
    }
    this.hotspotX = hotspotX;
    this.hotspotY = hotspotY;
    this.createBitmap___3BII(data, source.width, source.height);
    this.init__();
    return this;
  }
  public function Cursor__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_ImageData_2II(device: Device, source: ImageData, hotspotX: int, hotspotY: int): Object {
    if (source === null)
      SWT.error__I(4);
    if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
      SWT.error__I(5);
    }
    if (source === null)
      SWT.error__I(4);
    this.hotspotX = hotspotX;
    this.hotspotY = hotspotY;
    var palette: PaletteData = source.palette;
    if (!(((source.depth == 1 || source.depth == 2 || source.depth == 4 || source.depth == 8) && !palette.isDirect) || ((source.depth == 8) || (source.depth == 16 || source.depth == 24 || source.depth == 32) && palette.isDirect)))
      SWT.error__I(38);
    var width: int = source.width;
    var height: int = source.height;
    var buffer: JavaArray = new JavaArray("[B").lengths(width * 4 * height);
    if (palette.isDirect) {
      ImageData.blit__I_3BIIIIIIIIIII_3BIII_3BIIIIIIIIIIZZ(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder__(), 0, 0, width, height, palette.redMask, palette.greenMask, palette.blueMask, 255, null, 0, 0, 0, buffer, 32, width * 4, 1, 0, 0, width, height, 0xFF0000, 0xFF00, 0xFF, false, false);
    } else {
      var rgbs: JavaArray = palette.getRGBs__();
      var length: int = rgbs.length;
      var srcReds: JavaArray = new JavaArray("[B").lengths(length);
      var srcGreens: JavaArray = new JavaArray("[B").lengths(length);
      var srcBlues: JavaArray = new JavaArray("[B").lengths(length);
      for (var i: int = 0; i < rgbs.length; i++) {
        var rgb: RGB = rgbs[i];
        if (rgb === null)
          continue;
        srcReds[i] = int(rgb.red);
        srcGreens[i] = int(rgb.green);
        srcBlues[i] = int(rgb.blue);
      }
      ImageData.blit__I_3BIIIIIII_3B_3B_3BI_3BIII_3BIIIIIIIIIIZZ(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder__(), 0, 0, width, height, srcReds, srcGreens, srcBlues, 255, null, 0, 0, 0, buffer, 32, width * 4, 1, 0, 0, width, height, 0xFF0000, 0xFF00, 0xFF, false, false);
    }
    var transparency: int = source.getTransparencyType__();
    if (transparency == 2 || source.transparentPixel != -1) {
      var maskImage: ImageData = source.getTransparencyMask__();
      var maskData: JavaArray = maskImage.data;
      var maskBpl: int = maskImage.bytesPerLine;
      var offset: int = 0;
      var maskOffset: int = 0;
      for (var y: int = 0; y < height; y++) {
        for (var x: int = 0; x < width; x++) {
          buffer[offset] = ((maskData[maskOffset + (x >> 3)]) & (1 << (7 - (x & 0x7)))) != 0 ? int(0xff) : 0;
          offset += 4;
        }
        maskOffset += maskBpl;
      }
    } else {
      if (source.alpha != -1) {
        var a: int = int(source.alpha);
        for (var dataIndex: int = 0; dataIndex < buffer.length; dataIndex += 4) {
          buffer[dataIndex] = a;
        }
      } else if (source.alphaData !== null) {
        var offset_1: int = 0;
        var alphaOffset: int = 0;
        for (var y_1: int = 0; y_1 < height; y_1++) {
          for (var x_1: int = 0; x_1 < width; x_1++) {
            buffer[offset_1] = source.alphaData[alphaOffset];
            offset_1 += 4;
            alphaOffset += 1;
          }
        }
      } else {
        for (var dataIndex_1: int = 0; dataIndex_1 < buffer.length; dataIndex_1 += 4) {
          buffer[dataIndex_1] = int(0xff);
        }
      }
    }
    this.createBitmap___3BII(buffer, width, height);
    this.init__();
    return this;
  }
  public function createBitmap___3BII(buffer: JavaArray, width: int, height: int): void {
    var object_1: BitmapData = new BitmapData(width, height, true, 0xFFFFFFFF);
    if (object_1 === null)
      SWT.error__I(2);
    bitmap = object_1;
    var rect: flash.geom.Rectangle = new flash.geom.Rectangle(0, 0, width, height);
    object_1.setPixels(rect, this.getArray___3B(buffer));
    return;
  }
  public override function destroy__(): void {
    object = null;
    bitmap = null;
    return;
  }
  public function equals__Ljava_lang_Object_2(object_1: Object): Boolean {
    if (object_1 === this)
      return true;
    if (!(object_1 is Cursor))
      return false;
    var cursor: Cursor = Cursor(object_1);
    return device === cursor.device && object_1 === cursor.object;
  }
  public function getArray___3B(array: JavaArray): ByteArray {
    return ByteArray(array.array);
  }
  public function hashCode__(): int {
    return Object(Object.prototype).hashCode__.call(this);
  }
  public override function isDisposed__(): Boolean {
    return device === null;
  }
  public function toString__(): String {
    if (this.isDisposed__())
      return "Cursor {*DISPOSED*}";
    return "Cursor {" + 1 + "}";
  }
  public function Cursor(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 2 && vargs[0] is Device && vargs[1] is int) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 5 && vargs[0] is Device && vargs[1] is ImageData && vargs[2] is ImageData && vargs[3] is int && vargs[4] is int) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 4 && vargs[0] is Device && vargs[1] is ImageData && vargs[2] is int && vargs[3] is int) {
        args = vargs;
        id = 2;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args0[0]]);
        break;
      case 1:
        var args1: Array = [args[0], args[1], args[2], args[3], args[4]];
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args1[0]]);
        break;
      case 2:
        var args2: Array = [args[0], args[1], args[2], args[3]];
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args2[0]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        Cursor__Lorg_eclipse_swt_graphics_Device_2I(args0[0], args0[1]);
        break;
      case 1:
        Cursor__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_ImageData_2Lorg_eclipse_swt_graphics_ImageData_2II(args1[0], args1[1], args1[2], args1[3], args1[4]);
        break;
      case 2:
        Cursor__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_ImageData_2II(args2[0], args2[1], args2[2], args2[3]);
        break;
    }
  }
  public static const Cursor__Lorg_eclipse_swt_graphics_Device_2I : int = 0;
  public static const Cursor__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_ImageData_2Lorg_eclipse_swt_graphics_ImageData_2II : int = 1;
  public static const Cursor__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_ImageData_2II : int = 2;
}
}
