package org.eclipse.swt.graphics {
import org.eclipse.swt.*;
import flash.system.Capabilities;
import java.lang.Runnable;
import java.lang.Class__;
import java.lang.Throwable;
import java.lang.Error__;
import org.eclipse.swt.SWT;
import flash.text.Font;
import java.lang.System;
import java.lang.Arguments;
import java.lang.Class__;
import java.lang.JavaArray;
dynamic public class Device implements Drawable {
  public static var DEBUG: Boolean;
  internal var debug: Boolean = DEBUG;
  internal var tracking: Boolean = DEBUG;
  internal var errors: JavaArray;
  internal var objects: JavaArray;
  internal var trackingLock: Object;
  internal var disposed: Boolean;
  internal var systemFont: org.eclipse.swt.graphics.Font;
  public static var CurrentDevice: Device;
  public static var DeviceFinder: Runnable;

  __clinit();

  static private function __clinit(): void {
    {
      try {
        Class__.forName__Ljava_lang_String_2("org.eclipse.swt.widgets.Display");
      } catch (e : Throwable) {
      }
    }
  }
  public static function getDevice__(): Device {
    if (DeviceFinder !== null)
      DeviceFinder.run__();
    var device: Device = CurrentDevice;
    CurrentDevice = null;
    return device;
  }
  public function Device__(): Object {
    return this;
  }
  public function Device__Lorg_eclipse_swt_graphics_DeviceData_2(data: DeviceData): Object {
    {
      if (data !== null) {
        debug = data.debug;
        tracking = data.tracking;
      }
      this.create__Lorg_eclipse_swt_graphics_DeviceData_2(data);
      this.init__();
      if (tracking) {
        errors = new JavaArray("[Ljava/lang/Error;").lengths(128);
        objects = new JavaArray("[Ljava/lang/Object;").lengths(128);
        trackingLock = new Object();
      }
      systemFont = org.eclipse.swt.graphics.Font.flex_new__Lorg_eclipse_swt_graphics_Device_2Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2F(this, "_sans", "normal", "normal", int(12 * 96 / 72));
    }
    return this;
  }
  public function arrayGet__LArray_2I(array: Array, index: int): Object {
    return array[index];
  }
  public function checkDevice__(): void {
    if (disposed)
      SWT.error__I(45);
    return;
  }
  public function create__Lorg_eclipse_swt_graphics_DeviceData_2(data: DeviceData): void {
  }
  public function destroy__(): void {
  }
  public function dispose__(): void {
    {
      if (this.isDisposed__())
        return;
      this.checkDevice__();
      this.release__();
      this.destroy__();
      disposed = true;
      if (tracking) {
        {
          objects = null;
          errors = null;
          trackingLock = null;
        }
      }
    }
    return;
  }
  public function dispose_Object__Ljava_lang_Object_2(object: Object): void {
    {
      for (var i: int = 0; i < objects.length; i++) {
        if (objects[i] === object) {
          objects[i] = null;
          errors[i] = null;
          return;
        }
      }
    }
    return;
  }
  public function getBounds__(): Rectangle {
    this.checkDevice__();
    return new Rectangle(0, 0, int(Capabilities.screenResolutionX), int(Capabilities.screenResolutionY));
  }
  public function getDeviceData__(): DeviceData {
    this.checkDevice__();
    var data: DeviceData = new DeviceData();
    data.debug = debug;
    data.tracking = tracking;
    if (tracking) {
      {
        var count: int = 0;
        var length: int = objects.length;
        for (var i: int = 0; i < length; i++) {
          if (objects[i] !== null)
            count++;
        }
        var index: int = 0;
        data.objects = new JavaArray("[Ljava/lang/Object;").lengths(count);
        data.errors = new JavaArray("[Ljava/lang/Error;").lengths(count);
        for (var i_1: int = 0; i_1 < length; i_1++) {
          if (objects[i_1] !== null) {
            data.objects[index] = objects[i_1];
            data.errors[index] = errors[i_1];
            index++;
          }
        }
      }
    } else {
      data.objects = new JavaArray("[Ljava/lang/Object;").lengths(0);
      data.errors = new JavaArray("[Ljava/lang/Error;").lengths(0);
    }
    return data;
  }
  public function getClientArea__(): Rectangle {
    return this.getBounds__();
  }
  public function getDepth__(): int {
    this.checkDevice__();
    return 0;
  }
  public function getDPI__(): Point {
    this.checkDevice__();
    return new Point(int(Capabilities.screenDPI), int(Capabilities.screenDPI));
  }
  public function getFontList__Ljava_lang_String_2Z(faceName: String, scalable: Boolean): JavaArray {
    this.checkDevice__();
    var fonts: Array = flash.text.Font.enumerateFonts(true);
    var fontData: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/FontData;").lengths(fonts.length);
    for (var i: int = 0; i < fontData.length; i++) {
      fontData[i] = new FontData(new Arguments(org.eclipse.swt.graphics.FontData.FontData__Ljava_lang_String_2II, [(flash.text.Font(this.arrayGet__LArray_2I(fonts, i))).fontName, 10, 0]));
    }
    return fontData;
  }
  public function getSystemColor__I(id: int): Color {
    this.checkDevice__();
    var rgb: int = 0x000000;
    switch (id) {
      case 1 :
        rgb = 0xFFFFFF;
        break;
      case 2 :
        rgb = 0x000000;
        break;
      case 3 :
        rgb = 0xFF0000;
        break;
      case 4 :
        rgb = 0x800000;
        break;
      case 5 :
        rgb = 0x00FF00;
        break;
      case 6 :
        rgb = 0x008000;
        break;
      case 7 :
        rgb = 0xFFFF00;
        break;
      case 8 :
        rgb = 0x808000;
        break;
      case 9 :
        rgb = 0x0000FF;
        break;
      case 10 :
        rgb = 0x000080;
        break;
      case 11 :
        rgb = 0xFF00FF;
        break;
      case 12 :
        rgb = 0x800080;
        break;
      case 13 :
        rgb = 0xFF00FF;
        break;
      case 14 :
        rgb = 0x800080;
        break;
      case 15 :
        rgb = 0xC0C0C0;
        break;
      case 16 :
        rgb = 0x808080;
        break;
    }
    return Color.flex_new__Lorg_eclipse_swt_graphics_Device_2I(this, rgb);
  }
  public function getSystemFont__(): org.eclipse.swt.graphics.Font {
    this.checkDevice__();
    return systemFont;
  }
  public function getWarnings__(): Boolean {
    this.checkDevice__();
    return false;
  }
  public function init__(): void {
  }
  public function internal_new_GC__Lorg_eclipse_swt_graphics_GCData_2(data: GCData): int { // abstract
    return 0;
  }
  public function internal_dispose_GC__ILorg_eclipse_swt_graphics_GCData_2(hDC: int, data: GCData): void { } // abstract
  public function isDisposed__(): Boolean {
    {
      return disposed;
    }
    return false;
  }
  public function loadFont__Ljava_lang_String_2(path: String): Boolean {
    this.checkDevice__();
    return false;
  }
  public function new_Object__Ljava_lang_Object_2(object: Object): void {
    {
      for (var i: int = 0; i < objects.length; i++) {
        if (objects[i] === null) {
          objects[i] = object;
          errors[i] = new Error__(new Arguments(java.lang.Error__.Error____, []));
          return;
        }
      }
      var newObjects: JavaArray = new JavaArray("[Ljava/lang/Object;").lengths(objects.length + 128);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(objects, 0, newObjects, 0, objects.length);
      newObjects[objects.length] = object;
      objects = newObjects;
      var newErrors: JavaArray = new JavaArray("[Ljava/lang/Error;").lengths(errors.length + 128);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(errors, 0, newErrors, 0, errors.length);
      newErrors[errors.length] = new Error__(new Arguments(java.lang.Error__.Error____, []));
      errors = newErrors;
    }
    return;
  }
  public function release__(): void {
  }
  public function setWarnings__Z(warnings: Boolean): void {
    this.checkDevice__();
    return;
  }
  public function Device(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is DeviceData) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        args1 = [null];
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Device__Lorg_eclipse_swt_graphics_DeviceData_2(args1[0]);
        Device__();
        break;
      case 1:
        Device__Lorg_eclipse_swt_graphics_DeviceData_2(args1[0]);
        break;
    }
  }
  public static const Device__ : int = 0;
  public static const Device__Lorg_eclipse_swt_graphics_DeviceData_2 : int = 1;
}
}
