package org.eclipse.swt.graphics {
import org.eclipse.swt.*;
import org.eclipse.swt.SWT;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Font extends Resource {
  public var fontFamily: String;
  public var fontStyle: String;
  public var fontWeight: String;
  public var fontSize: Number = 0;
  public function Font__Lorg_eclipse_swt_graphics_Device_2(device: Device): Object {
    return this;
  }
  public function Font__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_FontData_2(device: Device, fd: FontData): Object {
    this.init__Lorg_eclipse_swt_graphics_FontData_2(fd);
    this.init__();
    return this;
  }
  public function Font__Lorg_eclipse_swt_graphics_Device_2_3Lorg_eclipse_swt_graphics_FontData_2(device: Device, fds: JavaArray): Object {
    if (fds === null)
      SWT.error__I(4);
    if (fds.length == 0)
      SWT.error__I(5);
    for (var i: int = 0; i < fds.length; i++) {
      if (fds[i] === null)
        SWT.error__I(5);
    }
    this.init__Lorg_eclipse_swt_graphics_FontData_2(fds[0]);
    this.init__();
    return this;
  }
  public function Font__Lorg_eclipse_swt_graphics_Device_2Ljava_lang_String_2II(device: Device, name: String, height: int, style: int): Object {
    if (name === null)
      SWT.error__I(4);
    this.init__Lorg_eclipse_swt_graphics_FontData_2(new FontData(new Arguments(org.eclipse.swt.graphics.FontData.FontData__Ljava_lang_String_2II, [name, height, style])));
    this.init__();
    return this;
  }
  public override function destroy__(): void {
    fontFamily = fontStyle = fontWeight = null;
    fontSize = 0;
    return;
  }
  public function equals__Ljava_lang_Object_2(object: Object): Boolean {
    if (object === this)
      return true;
    if (!(object is Font))
      return false;
    if (this.isDisposed__())
      return false;
    var font: Font = Font(object);
    return device === font.device && Object(fontFamily).equals__Ljava_lang_Object_2(font.fontFamily) && Object(fontStyle).equals__Ljava_lang_Object_2(font.fontStyle) && Object(fontWeight).equals__Ljava_lang_Object_2(font.fontWeight) && fontSize == font.fontSize;
  }
  public function getFontData__(): JavaArray {
    if (this.isDisposed__())
      SWT.error__I(44);
    var data: FontData = new FontData(new Arguments(org.eclipse.swt.graphics.FontData.FontData__, []));
    data.name = fontFamily;
    data.height = fontSize * 72 / 96;
    if (Object(fontStyle).equals__Ljava_lang_Object_2("italic"))
      data.style |= 2;
    if (Object(fontWeight).equals__Ljava_lang_Object_2("bold"))
      data.style |= 1;
    return new JavaArray("[Lorg/eclipse/swt/graphics/FontData;").values(data);
  }
  public function hashCode__(): int {
    if (this.isDisposed__())
      return 0;
    return Object(fontFamily).hashCode__() ^ Object(fontStyle).hashCode__() ^ Object(fontWeight).hashCode__();
  }
  public function init__Lorg_eclipse_swt_graphics_FontData_2(fd: FontData): void {
    if (fd === null)
      SWT.error__I(4);
    this.fontFamily = fd.name;
    if ((fd.style & 2) != 0) {
      this.fontStyle = "italic";
    } else {
      this.fontStyle = "normal";
    }
    if ((fd.style & 1) != 0) {
      this.fontWeight = "bold";
    } else {
      this.fontWeight = "normal";
    }
    this.fontSize = fd.height * 96 / 72;
    return;
  }
  public override function isDisposed__(): Boolean {
    return fontFamily === null;
  }
  public function toString__(): String {
    if (this.isDisposed__())
      return "Font {*DISPOSED*}";
    return "Font {" + fontFamily + "," + fontStyle + "," + fontWeight + "," + fontSize + "}";
  }
  public static function flex_new__Lorg_eclipse_swt_graphics_Device_2Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2F(device: Device, fontFamily: String, fontStyle: String, fontWeight: String, height: Number): Font {
    var font: Font = new Font(new Arguments(org.eclipse.swt.graphics.Font.Font__Lorg_eclipse_swt_graphics_Device_2, [device]));
    font.fontFamily = fontFamily;
    font.fontStyle = fontStyle;
    font.fontWeight = fontWeight;
    font.fontSize = height;
    return font;
  }
  public function Font(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is Device) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Device && vargs[1] is FontData) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 2 && vargs[0] is Device && vargs[1] is JavaArray) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 4 && vargs[0] is Device && vargs[1] is String && vargs[2] is int && vargs[3] is int) {
        args = vargs;
        id = 3;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args0[0]]);
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args1[0]]);
        break;
      case 2:
        var args2: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args2[0]]);
        break;
      case 3:
        var args3: Array = [args[0], args[1], args[2], args[3]];
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args3[0]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        Font__Lorg_eclipse_swt_graphics_Device_2(args0[0]);
        break;
      case 1:
        Font__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_FontData_2(args1[0], args1[1]);
        break;
      case 2:
        Font__Lorg_eclipse_swt_graphics_Device_2_3Lorg_eclipse_swt_graphics_FontData_2(args2[0], args2[1]);
        break;
      case 3:
        Font__Lorg_eclipse_swt_graphics_Device_2Ljava_lang_String_2II(args3[0], args3[1], args3[2], args3[3]);
        break;
    }
  }
  public static const Font__Lorg_eclipse_swt_graphics_Device_2 : int = 0;
  public static const Font__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_FontData_2 : int = 1;
  public static const Font__Lorg_eclipse_swt_graphics_Device_2_3Lorg_eclipse_swt_graphics_FontData_2 : int = 2;
  public static const Font__Lorg_eclipse_swt_graphics_Device_2Ljava_lang_String_2II : int = 3;
}
}
