package org.eclipse.swt.graphics {
import org.eclipse.swt.*;
import org.eclipse.swt.SWT;
import java.lang.Integer;
import java.lang.NumberFormatException;
import java.lang.Float;
import java.lang.StringBuffer;
import java.lang.Arguments;
dynamic public class FontData {
  public var name: String;
  public var height: Number = 0;
  public var style: int;
  internal var lang: String;
  internal var country: String;
  internal var variant: String;
  public function FontData__(): Object {
    return this;
  }
  public function FontData__Ljava_lang_String_2(string: String): Object {
    if (string === null)
      SWT.error__I(4);
    var start: int = 0;
    var end: int = Object(string).indexOf__I(124);
    if (end == -1)
      SWT.error__I(5);
    var version1: String = Object(string).substring__II(start, end);
    try {
      if (Integer.parseInt__Ljava_lang_String_2(version1) != 1)
        SWT.error__I(5);
    } catch (e : NumberFormatException) {
      SWT.error__I(5);
    }
    start = end + 1;
    end = Object(string).indexOf__II(124, start);
    if (end == -1)
      SWT.error__I(5);
    var name: String = Object(string).substring__II(start, end);
    start = end + 1;
    end = Object(string).indexOf__II(124, start);
    if (end == -1)
      SWT.error__I(5);
    var height: Number = 0;
    try {
      height = Float.parseFloat__Ljava_lang_String_2(Object(string).substring__II(start, end));
    } catch (e_1 : NumberFormatException) {
      SWT.error__I(5);
    }
    start = end + 1;
    end = Object(string).indexOf__II(124, start);
    if (end == -1)
      SWT.error__I(5);
    var style: int = 0;
    try {
      style = Integer.parseInt__Ljava_lang_String_2(Object(string).substring__II(start, end));
    } catch (e_2 : NumberFormatException) {
      SWT.error__I(5);
    }
    start = end + 1;
    end = Object(string).indexOf__II(124, start);
    this.setName__Ljava_lang_String_2(name);
    this.setHeight__F(height);
    this.setStyle__I(style);
    if (end == -1)
      return this;
    var platform: String = Object(string).substring__II(start, end);
    start = end + 1;
    end = Object(string).indexOf__II(124, start);
    if (end == -1)
      return this;
    var version2: String = Object(string).substring__II(start, end);
    if (Object(platform).equals__Ljava_lang_Object_2("FLEX") && Object(version2).equals__Ljava_lang_Object_2("1")) {
      return this;
    }
    return this;
  }
  public function FontData__Ljava_lang_String_2FI(name: String, height: Number, style: int): Object {
    this.setName__Ljava_lang_String_2(name);
    this.setHeight__F(height);
    this.setStyle__I(style);
    return this;
  }
  public function FontData__Ljava_lang_String_2II(name: String, height: int, style: int): Object {
    this.setName__Ljava_lang_String_2(name);
    this.setHeight__I(height);
    this.setStyle__I(style);
    return this;
  }
  public function equals__Ljava_lang_Object_2(object: Object): Boolean {
    if (object === this)
      return true;
    if (!(object is FontData))
      return false;
    var data: FontData = FontData(object);
    return Object(name).equals__Ljava_lang_Object_2(data.name) && height == data.height && style == data.style;
  }
  public function getHeight__(): int {
    return int((0.5 + height));
  }
  public function getHeightF__(): Number {
    return height;
  }
  public function getLocale__(): String {
    var buffer: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__, []));
    var sep: uint = 95;
    if (lang !== null) {
      buffer.append__Ljava_lang_String_2(lang);
      buffer.append__C(sep);
    }
    if (country !== null) {
      buffer.append__Ljava_lang_String_2(country);
      buffer.append__C(sep);
    }
    if (variant !== null) {
      buffer.append__Ljava_lang_String_2(variant);
    }
    var result: String = buffer.toString__();
    var length: int = Object(result).length__();
    if (length > 0) {
      if (Object(result).charAt__I(length - 1) == sep) {
        result = Object(result).substring__II(0, length - 1);
      }
    }
    return result;
  }
  public function getName__(): String {
    return name;
  }
  public function getStyle__(): int {
    return style;
  }
  public function hashCode__(): int {
    return Object(name).hashCode__() ^ this.getHeight__() ^ style;
  }
  public function setHeight__I(height_1: int): void {
    if (height_1 < 0)
      SWT.error__I(5);
    this.height = height_1;
  }
  public function setHeight__F(height_1: Number): void {
    if (height_1 < 0)
      SWT.error__I(5);
    this.height = height_1;
  }
  public function setLocale__Ljava_lang_String_2(locale: String): void {
    lang = country = variant = null;
    if (locale !== null) {
      var sep: uint = 95;
      var length: int = Object(locale).length__();
      var firstSep: int;
      var secondSep: int;
      firstSep = Object(locale).indexOf__I(sep);
      if (firstSep == -1) {
        firstSep = secondSep = length;
      } else {
        secondSep = Object(locale).indexOf__II(sep, firstSep + 1);
        if (secondSep == -1)
          secondSep = length;
      }
      if (firstSep > 0)
        lang = Object(locale).substring__II(0, firstSep);
      if (secondSep > firstSep + 1)
        country = Object(locale).substring__II(firstSep + 1, secondSep);
      if (length > secondSep + 1)
        variant = Object(locale).substring__I(secondSep + 1);
    }
    return;
  }
  public function setName__Ljava_lang_String_2(name_1: String): void {
    if (name_1 === null)
      SWT.error__I(4);
    this.name = name_1;
    return;
  }
  public function setStyle__I(style_1: int): void {
    this.style = style_1;
    return;
  }
  public function toString__(): String {
    var buffer: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__, []));
    buffer.append__Ljava_lang_String_2("1|");
    buffer.append__Ljava_lang_String_2(this.getName__());
    buffer.append__Ljava_lang_String_2("|");
    buffer.append__F(this.getHeightF__());
    buffer.append__Ljava_lang_String_2("|");
    buffer.append__I(this.getStyle__());
    buffer.append__Ljava_lang_String_2("|");
    buffer.append__Ljava_lang_String_2("FLEX|1|");
    return buffer.toString__();
  }
  public function FontData(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is String) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 3 && vargs[0] is String && vargs[1] is Number && vargs[2] is int) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 3 && vargs[0] is String && vargs[1] is int && vargs[2] is int) {
        args = vargs;
        id = 3;
      }
    }
    switch (id) {
      case 0:
        args3 = ["", 12, 0];
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
      case 2:
        var args2: Array = [args[0], args[1], args[2]];
        break;
      case 3:
        var args3: Array = [args[0], args[1], args[2]];
        break;
    }
    super();
    switch (id) {
      case 0:
        FontData__Ljava_lang_String_2II(args3[0], args3[1], args3[2]);
        FontData__();
        break;
      case 1:
        FontData__Ljava_lang_String_2(args1[0]);
        break;
      case 2:
        FontData__Ljava_lang_String_2FI(args2[0], args2[1], args2[2]);
        break;
      case 3:
        FontData__Ljava_lang_String_2II(args3[0], args3[1], args3[2]);
        break;
    }
  }
  public static const FontData__ : int = 0;
  public static const FontData__Ljava_lang_String_2 : int = 1;
  public static const FontData__Ljava_lang_String_2FI : int = 2;
  public static const FontData__Ljava_lang_String_2II : int = 3;
}
}
