package org.eclipse.swt.graphics {
import flash.display.*;
import flash.geom.Matrix;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.TextFieldAutoSize;
import flash.text.TextLineMetrics;
import org.eclipse.swt.*;
import org.eclipse.swt.SWT;
import flash.display.Shape;
import flash.display.Graphics;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import flash.display.CapsStyle;
import flash.display.JointStyle;
import flash.display.Bitmap;
import flash.geom.Point;
import flash.geom.Rectangle;
import java.lang.Math__;
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class GC extends Resource {
  internal var drawable: Drawable;
  internal var data: GCData;
  public static const DRAW: int = 1;
  public static const FILL: int = 2;
  public function GC__(): Object {
    return this;
  }
  public function GC__Lorg_eclipse_swt_graphics_Drawable_2(drawable: Drawable): Object {
    return this;
  }
  public function GC__Lorg_eclipse_swt_graphics_Drawable_2I(drawable: Drawable, style: int): Object {
    if (drawable === null)
      SWT.error__I(4);
    var data: GCData = new GCData();
    data.style = GC.checkStyle__I(style);
    var id: int = drawable.internal_new_GC__Lorg_eclipse_swt_graphics_GCData_2(data);
    var device: Device = data.device;
    if (device === null)
      device = Device.getDevice__();
    if (device === null)
      SWT.error__I(4);
    this.device = data.device = device;
    this.init__Lorg_eclipse_swt_graphics_Drawable_2Lorg_eclipse_swt_graphics_GCData_2I(drawable, data, id);
    return this;
  }
  public static function checkStyle__I(style: int): int {
    if ((style & 33554432) != 0)
      style &= ~67108864;
    return style & (33554432 | 67108864);
  }
  public function newTextField__ILjava_lang_String_2I(operation: int, string: String, flags: int): TextField {
    var text: TextField = new TextField();
    text.text = string;
    text.autoSize = TextFieldAutoSize.LEFT;
    text.selectable = false;
    text.mouseEnabled = false;
    var format: TextFormat = new TextFormat();
    switch (operation) {
      case 1 :
        if (data.matrix !== null)
          text.transform.matrix = data.matrix;
        if (data.clip !== null)
          text.mask = data.clip;
        if ((flags & 1) == 0) {
          text.background = true;
          text.backgroundColor = data.background.handle;
        }
        text.textColor = data.foreground.handle;
        format.color = new Number(data.foreground.handle);
        break;
    }
    var font: Font = data.font;
    format.font = font.fontFamily;
    format.size = new Number(font.fontSize);
    if (Object(font.fontStyle).equals__Ljava_lang_Object_2("italic"))
      format.italic = font.fontStyle;
    if (Object(font.fontWeight).equals__Ljava_lang_Object_2("bold"))
      format.bold = font.fontWeight;
    text.defaultTextFormat = format;
    if (Object(string).length__() > 0) {
      text.setTextFormat(format, 0, Object(string).length__());
    }
    return text;
  }
  public function newShape__I(operation: int): Shape {
    var shape: Shape = new Shape();
    var graphics: Graphics = shape.graphics;
    if (data.matrix !== null)
      shape.transform.matrix = data.matrix;
    if (data.clip !== null)
      shape.mask = data.clip;
    switch (operation) {
      case 2 :
        var pattern: Pattern = data.backgroundPattern;
        if (pattern !== null) {
          var image: Image = pattern.image;
          if (image !== null) {
            graphics.beginBitmapFill(image.object, null, true, false);
          } else {
            var colors: Array = new Array();
            colors.push(pattern.color1.handle);
            colors.push(pattern.color2.handle);
            var alphas: Array = new Array();
            alphas.push(pattern.alpha1 / 255.0);
            alphas.push(pattern.alpha2 / 255.0);
            var ratios: Array = new Array();
            ratios.push(0);
            ratios.push(255);
            var matrix: Matrix = new Matrix(1, 0, 0, 1, 0, 0);
            var width: Number = pattern.x2 - pattern.x1;
            var height: Number = pattern.y2 - pattern.y1;
            var rotation: Number = height == 0 ? 0 : width / height;
            matrix.createGradientBox(width, height, rotation, pattern.x1, pattern.y1);
            graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
          }
        } else {
          graphics.beginFill(data.background.handle, data.alpha / 255.0);
        }
        break;
      case 1 :
        var caps: String = CapsStyle.NONE;
        switch (data.lineCap) {
          case 2 :
            caps = CapsStyle.ROUND;
            break;
          case 3 :
            caps = CapsStyle.SQUARE;
            break;
        }
        var joints: String = JointStyle.MITER;
        switch (data.lineJoin) {
          case 2 :
            joints = JointStyle.ROUND;
            break;
          case 3 :
            joints = JointStyle.BEVEL;
            break;
        }
        graphics.lineStyle(data.lineWidth, data.foreground.handle, data.alpha / 255.0, false, "normal", caps, joints, data.lineMiterLimit);
        break;
    }
    data.sprite.addChild(shape);
    return shape;
  }
  public function copyArea__Lorg_eclipse_swt_graphics_Image_2II(image: Image, x: int, y: int): void {
  }
  public function copyArea__IIIIII(srcX: int, srcY: int, width: int, height: int, destX: int, destY: int): void {
  }
  public function copyArea__IIIIIIZ(srcX: int, srcY: int, width: int, height: int, destX: int, destY: int, paint: Boolean): void {
  }
  public override function destroy__(): void {
    var image: Image = data.image;
    if (image !== null) {
      image.memGC = null;
    }
    if (drawable !== null)
      drawable.internal_dispose_GC__ILorg_eclipse_swt_graphics_GCData_2(1, data);
    drawable = null;
    data.image = null;
    data.device = null;
    data.foreground = null;
    data.foregroundPattern = null;
    data.background = null;
    data.backgroundPattern = null;
    data.font = null;
    data.lineDashes = null;
    data = null;
    return;
  }
  public function drawArc__IIIIII(x: int, y: int, width: int, height: int, startAngle: int, arcAngle: int): void {
  }
  public function drawFocus__IIII(x: int, y: int, width: int, height: int): void {
  }
  public function drawImage__Lorg_eclipse_swt_graphics_Image_2II(image: Image, x: int, y: int): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (image === null)
      SWT.error__I(4);
    if (image.isDisposed__())
      SWT.error__I(5);
    this.drawImage__Lorg_eclipse_swt_graphics_Image_2IIIIIIIIZ(image, 0, 0, -1, -1, x, y, -1, -1, true);
    return;
  }
  public function drawImage__Lorg_eclipse_swt_graphics_Image_2IIIIIIII(image: Image, srcX: int, srcY: int, srcWidth: int, srcHeight: int, destX: int, destY: int, destWidth: int, destHeight: int): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0)
      return;
    if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
      SWT.error__I(5);
    }
    if (image === null)
      SWT.error__I(4);
    if (image.isDisposed__())
      SWT.error__I(5);
    this.drawImage__Lorg_eclipse_swt_graphics_Image_2IIIIIIIIZ(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false);
    return;
  }
  public function drawImage__Lorg_eclipse_swt_graphics_Image_2IIIIIIIIZ(image: Image, srcX: int, srcY: int, srcWidth: int, srcHeight: int, destX: int, destY: int, destWidth: int, destHeight: int, simple: Boolean): void {
    var imgWidth: int = image.object.width;
    var imgHeight: int = image.object.height;
    if (simple) {
      srcWidth = destWidth = imgWidth;
      srcHeight = destHeight = imgHeight;
    } else {
      simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
      if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
        SWT.error__I(5);
      }
    }
    var bitmap: Bitmap = new Bitmap(image.object);
    if (data.matrix !== null) {
      bitmap.transform.matrix = Matrix(data.matrix.clone());
      var point: flash.geom.Point = new flash.geom.Point(destX, destY);
      point = data.matrix.transformPoint(point);
      bitmap.x = point.x;
      bitmap.y = point.y;
    } else {
      bitmap.x = destX;
      bitmap.y = destY;
    }
    if (data.clip !== null)
      bitmap.mask = data.clip;
    bitmap.scrollRect = new flash.geom.Rectangle(srcX, srcY, srcWidth, srcHeight);
    if (srcWidth != destWidth)
      bitmap.scaleX *= destWidth / Number(srcWidth);
    if (srcHeight != destHeight)
      bitmap.scaleY *= destHeight / Number(srcHeight);
    data.sprite.addChild(bitmap);
    return;
  }
  public function drawLine__IIII(x1: int, y1: int, x2: int, y2: int): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    var shape: Shape = this.newShape__I(1);
    var graphics: Graphics = shape.graphics;
    graphics.moveTo(x1, y1);
    graphics.lineTo(x2, y2);
    return;
  }
  public function drawOval__IIII(x: int, y: int, width: int, height: int): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    var shape: Shape = this.newShape__I(1);
    var graphics: Graphics = shape.graphics;
    graphics.drawEllipse(x, y, width, height);
    return;
  }
  public function drawPath__Lorg_eclipse_swt_graphics_Path_2(path: Path): void {
  }
  public function drawPoint__II(x: int, y: int): void {
  }
  public function drawPolygon___3I(pointArray: JavaArray): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (pointArray === null)
      SWT.error__I(44);
    var shape: Shape = this.newShape__I(1);
    var graphics: Graphics = shape.graphics;
    graphics.moveTo(pointArray[0], pointArray[1]);
    for (var i: int = 2; i < pointArray.length; i += 2) {
      graphics.lineTo(pointArray[i], pointArray[i + 1]);
    }
    graphics.lineTo(pointArray[0], pointArray[1]);
    return;
  }
  public function drawPolyline___3I(pointArray: JavaArray): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (pointArray === null)
      SWT.error__I(44);
    var shape: Shape = this.newShape__I(1);
    var graphics: Graphics = shape.graphics;
    graphics.moveTo(pointArray[0], pointArray[1]);
    for (var i: int = 2; i < pointArray.length; i += 2) {
      graphics.lineTo(pointArray[i], pointArray[i + 1]);
    }
    return;
  }
  public function drawRectangle__IIII(x: int, y: int, width: int, height: int): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    var shape: Shape = this.newShape__I(1);
    var graphics: Graphics = shape.graphics;
    graphics.drawRect(x, y, width, height);
    return;
  }
  public function drawRectangle__Lorg_eclipse_swt_graphics_Rectangle_2(rect: org.eclipse.swt.graphics.Rectangle): void {
    if (rect === null)
      SWT.error__I(4);
    this.drawRectangle__IIII(rect.x, rect.y, rect.width, rect.height);
    return;
  }
  public function drawRoundRectangle__IIIIII(x: int, y: int, width: int, height: int, arcWidth: int, arcHeight: int): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    var shape: Shape = this.newShape__I(1);
    var graphics: Graphics = shape.graphics;
    graphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    return;
  }
  public function drawString__Ljava_lang_String_2II(string: String, x: int, y: int): void {
    this.drawString__Ljava_lang_String_2IIZ(string, x, y, false);
    return;
  }
  public function drawString__Ljava_lang_String_2IIZ(string: String, x: int, y: int, isTransparent: Boolean): void {
    this.drawText__Ljava_lang_String_2III(string, x, y, isTransparent ? 1 : 0);
    return;
  }
  public function drawText__Ljava_lang_String_2II(string: String, x: int, y: int): void {
    this.drawText__Ljava_lang_String_2III(string, x, y, 2 | 4);
    return;
  }
  public function drawText__Ljava_lang_String_2IIZ(string: String, x: int, y: int, isTransparent: Boolean): void {
    var flags: int = 2 | 4;
    if (isTransparent)
      flags |= 1;
    this.drawText__Ljava_lang_String_2III(string, x, y, flags);
    return;
  }
  public function drawText__Ljava_lang_String_2III(string: String, x: int, y: int, flags: int): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (string === null)
      SWT.error__I(4);
    if (Object(string).length__() == 0)
      return;
    var text: TextField = this.newTextField__ILjava_lang_String_2I(1, string, flags);
    if (data.matrix !== null) {
      var point: flash.geom.Point = new flash.geom.Point(x, y);
      point = data.matrix.transformPoint(point);
      text.x = point.x;
      text.y = point.y;
    } else {
      text.x = x;
      text.y = y;
    }
    data.sprite.addChild(text);
    return;
  }
  public function equals__Ljava_lang_Object_2(object: Object): Boolean {
    if (object === this)
      return true;
    if (!(object is GC))
      return false;
    var gc: GC = GC(object);
    return device === gc.device && drawable === gc.drawable;
  }
  public function fillArc__IIIIII(x: int, y: int, width: int, height: int, startAngle: int, arcAngle: int): void {
  }
  public function fillGradientRectangle__IIIIZ(x: int, y: int, width: int, height: int, vertical: Boolean): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    var shape: Shape = this.newShape__I(0);
    var graphics: Graphics = shape.graphics;
    var colors: Array = new Array();
    colors.push(data.foreground.handle);
    colors.push(data.background.handle);
    var alphas: Array = new Array();
    alphas.push(data.alpha / 255.0);
    alphas.push(data.alpha / 255.0);
    var ratios: Array = new Array();
    ratios.push(0);
    ratios.push(255);
    var matrix: Matrix = new Matrix(1, 0, 0, 1, 0, 0);
    matrix.createGradientBox(width, height, vertical ? 3.141592653589793 / 2.0 : 0, x, y);
    graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
    graphics.drawRect(x, y, width, height);
    graphics.endFill();
  }
  public function fillOval__IIII(x: int, y: int, width: int, height: int): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    var shape: Shape = this.newShape__I(2);
    var graphics: Graphics = shape.graphics;
    graphics.drawEllipse(x, y, width, height);
    graphics.endFill();
  }
  public function fillPath__Lorg_eclipse_swt_graphics_Path_2(path: Path): void {
  }
  public function fillPolygon___3I(pointArray: JavaArray): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (pointArray === null)
      SWT.error__I(44);
    var shape: Shape = this.newShape__I(2);
    var graphics: Graphics = shape.graphics;
    graphics.moveTo(pointArray[0], pointArray[1]);
    for (var i: int = 2; i < pointArray.length; i += 2) {
      graphics.lineTo(pointArray[i], pointArray[i + 1]);
    }
    graphics.lineTo(pointArray[0], pointArray[1]);
    graphics.endFill();
    return;
  }
  public function fillRectangle__IIII(x: int, y: int, width: int, height: int): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    var shape: Shape = this.newShape__I(2);
    var graphics: Graphics = shape.graphics;
    graphics.drawRect(x, y, width, height);
    graphics.endFill();
    return;
  }
  public function fillRectangle__Lorg_eclipse_swt_graphics_Rectangle_2(rect: org.eclipse.swt.graphics.Rectangle): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (rect === null)
      SWT.error__I(4);
    this.fillRectangle__IIII(rect.x, rect.y, rect.width, rect.height);
    return;
  }
  public function fillRoundRectangle__IIIIII(x: int, y: int, width: int, height: int, arcWidth: int, arcHeight: int): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    var shape: Shape = this.newShape__I(2);
    var graphics: Graphics = shape.graphics;
    graphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    graphics.endFill();
    return;
  }
  public static function flex_new__Lorg_eclipse_swt_graphics_Drawable_2Lorg_eclipse_swt_graphics_GCData_2(drawable: Drawable, data: GCData): GC {
    var gc: GC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__, []));
    var hDC: int = drawable.internal_new_GC__Lorg_eclipse_swt_graphics_GCData_2(data);
    gc.device = data.device;
    gc.init__Lorg_eclipse_swt_graphics_Drawable_2Lorg_eclipse_swt_graphics_GCData_2I(drawable, data, hDC);
    return gc;
  }
  public function getAdvanceWidth__C(ch: uint): int {
    if (this.isDisposed__())
      SWT.error__I(44);
    return this.stringExtent__Ljava_lang_String_2(Object(String).valueOf__C(ch)).x;
  }
  public function getAdvanced__(): Boolean {
    if (this.isDisposed__())
      SWT.error__I(44);
    return true;
  }
  public function getAlpha__(): int {
    if (this.isDisposed__())
      SWT.error__I(44);
    return data.alpha;
  }
  public function getAntialias__(): int {
    if (this.isDisposed__())
      SWT.error__I(44);
    return data.antialias;
  }
  public function getBackground__(): Color {
    if (this.isDisposed__())
      SWT.error__I(44);
    return data.background;
  }
  public function getBackgroundPattern__(): Pattern {
    if (this.isDisposed__())
      SWT.error__I(44);
    return data.backgroundPattern;
  }
  public function getCharWidth__C(ch: uint): int {
    if (this.isDisposed__())
      SWT.error__I(44);
    return this.stringExtent__Ljava_lang_String_2(Object(String).valueOf__C(ch)).x;
  }
  public function getClipping__(): org.eclipse.swt.graphics.Rectangle {
    if (this.isDisposed__())
      SWT.error__I(44);
    var rect: org.eclipse.swt.graphics.Rectangle = new org.eclipse.swt.graphics.Rectangle(0, 0, 0, 0);
    var image: Image = data.image;
    if (image !== null) {
      rect.width = image.object.width;
      rect.height = image.object.height;
    } else {
      rect.width = int(data.sprite.parent.width);
      rect.height = int(data.sprite.parent.height);
      var paint: flash.geom.Rectangle = data.paintRect;
      if (paint !== null) {
        rect.intersect__Lorg_eclipse_swt_graphics_Rectangle_2(new org.eclipse.swt.graphics.Rectangle(int(paint.x), int(paint.y), int(paint.width), int(paint.height)));
      }
    }
    return rect;
  }
  public function getClipping__Lorg_eclipse_swt_graphics_Region_2(region: Region): void {
    if (this.isDisposed__())
      SWT.error__I(44);
  }
  public function getFillRule__(): int {
    if (this.isDisposed__())
      SWT.error__I(44);
    return data.fillRule;
  }
  public function getFont__(): Font {
    if (this.isDisposed__())
      SWT.error__I(44);
    return data.font;
  }
  public function getFontMetrics__(): FontMetrics {
    if (this.isDisposed__())
      SWT.error__I(44);
    var str: String = "0123456789abcdefghijklmnopqrstuvxwz";
    var text: TextField = this.newTextField__ILjava_lang_String_2I(0, str, 0);
    var mt: TextLineMetrics = text.getLineMetrics(0);
    return FontMetrics.internal_new__IIII(int(mt.ascent), int(mt.descent), int(mt.height), int(int(mt.width) / Object(str).length__()));
  }
  public function getForeground__(): Color {
    if (this.isDisposed__())
      SWT.error__I(44);
    return data.foreground;
  }
  public function getForegroundPattern__(): Pattern {
    if (this.isDisposed__())
      SWT.error__I(44);
    return data.foregroundPattern;
  }
  public function getGCData__(): GCData {
    if (this.isDisposed__())
      SWT.error__I(44);
    return data;
  }
  public function getInterpolation__(): int {
    if (this.isDisposed__())
      SWT.error__I(44);
    return 0;
  }
  public function getLineAttributes__(): LineAttributes {
    if (this.isDisposed__())
      SWT.error__I(44);
    var dashes: JavaArray = null;
    if (data.lineDashes !== null) {
      dashes = new JavaArray("[F").lengths(data.lineDashes.length);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(data.lineDashes, 0, dashes, 0, dashes.length);
    }
    return new LineAttributes(new Arguments(org.eclipse.swt.graphics.LineAttributes.LineAttributes__FIII_3FFF, [data.lineWidth, data.lineCap, data.lineJoin, data.lineStyle, dashes, data.lineDashesOffset, data.lineMiterLimit]));
  }
  public function getLineCap__(): int {
    if (this.isDisposed__())
      SWT.error__I(44);
    return data.lineCap;
  }
  public function getLineDash__(): JavaArray {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (data.lineDashes === null)
      return null;
    var lineDashes: JavaArray = new JavaArray("[I").lengths(data.lineDashes.length);
    for (var i: int = 0; i < lineDashes.length; i++) {
      lineDashes[i] = int(data.lineDashes[i]);
    }
    return lineDashes;
  }
  public function getLineJoin__(): int {
    if (this.isDisposed__())
      SWT.error__I(44);
    return data.lineJoin;
  }
  public function getLineStyle__(): int {
    if (this.isDisposed__())
      SWT.error__I(44);
    return data.lineStyle;
  }
  public function getLineWidth__(): int {
    if (this.isDisposed__())
      SWT.error__I(44);
    return int(data.lineWidth);
  }
  public function getStyle__(): int {
    if (this.isDisposed__())
      SWT.error__I(44);
    return data.style;
  }
  public function getTextAntialias__(): int {
    if (this.isDisposed__())
      SWT.error__I(44);
    return data.textAntialias;
  }
  public function getTransform__Lorg_eclipse_swt_graphics_Transform_2(transform: Transform): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (transform === null)
      SWT.error__I(4);
    if (transform.isDisposed__())
      SWT.error__I(5);
    var matrix: Matrix = data.matrix;
    if (matrix !== null) {
      transform.setElements__FFFFFF(Number(matrix.a), Number(matrix.b), Number(matrix.c), Number(matrix.d), Number(matrix.tx), Number(matrix.ty));
    } else {
      transform.setElements__FFFFFF(1, 0, 0, 1, 0, 0);
    }
    return;
  }
  public function getXORMode__(): Boolean {
    if (this.isDisposed__())
      SWT.error__I(44);
    return data.xorMode;
  }
  public function hashCode__(): int {
    return Object(Object.prototype).hashCode__.call(this);
  }
  public function init__Lorg_eclipse_swt_graphics_Drawable_2Lorg_eclipse_swt_graphics_GCData_2I(drawable_1: Drawable, data_1: GCData, id: int): void {
    var image: Image = data_1.image;
    if (image !== null)
      image.memGC = this;
    this.drawable = drawable_1;
    this.data = data_1;
  }
  public function isClipped__(): Boolean {
    if (this.isDisposed__())
      SWT.error__I(44);
    return data.clip !== null;
  }
  public override function isDisposed__(): Boolean {
    return device === null;
  }
  public function setAdvanced__Z(advanced: Boolean): void {
  }
  public function setAntialias__I(antialias: int): void {
    if (this.isDisposed__())
      SWT.error__I(44);
  }
  public function setAlpha__I(alpha: int): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    data.alpha = alpha & 0xFF;
  }
  public function setBackground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (color === null)
      SWT.error__I(4);
    if (color.isDisposed__())
      SWT.error__I(5);
    data.background = color;
    data.backgroundPattern = null;
  }
  public function setBackgroundPattern__Lorg_eclipse_swt_graphics_Pattern_2(pattern: Pattern): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (pattern !== null && pattern.isDisposed__())
      SWT.error__I(5);
    if (data.backgroundPattern === pattern)
      return;
    data.backgroundPattern = pattern;
  }
  public function setClipping__IIII(x: int, y: int, width: int, height: int): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    var shape: Shape = new Shape();
    if (data.matrix !== null) {
      shape.transform.matrix = Matrix(data.matrix.clone());
    }
    var graphics: Graphics = shape.graphics;
    graphics.beginFill(0xFFFFFF, 1);
    graphics.drawRect(x, y, width, height);
    data.sprite.addChild(shape);
    data.clip = shape;
    return;
  }
  public function setClipping__Lorg_eclipse_swt_graphics_Path_2(path: Path): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    return;
  }
  public function setClipping__Lorg_eclipse_swt_graphics_Rectangle_2(rect: org.eclipse.swt.graphics.Rectangle): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (rect === null) {
      data.clip = null;
    } else {
      this.setClipping__IIII(rect.x, rect.y, rect.width, rect.height);
    }
    return;
  }
  public function setClipping__Lorg_eclipse_swt_graphics_Region_2(region: Region): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (region === null) {
      data.clip = null;
    } else {
      data.clip = region.object;
    }
    return;
  }
  public function setFillRule__I(rule: int): void {
  }
  public function setFont__Lorg_eclipse_swt_graphics_Font_2(font: Font): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (font === null)
      font = data.device.systemFont;
    if (font.isDisposed__())
      SWT.error__I(5);
    data.font = font;
    return;
  }
  public function setForeground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (color === null)
      SWT.error__I(4);
    if (color.isDisposed__())
      SWT.error__I(5);
    data.foreground = color;
    data.foregroundPattern = null;
    return;
  }
  public function setForegroundPattern__Lorg_eclipse_swt_graphics_Pattern_2(pattern: Pattern): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (pattern !== null && pattern.isDisposed__())
      SWT.error__I(5);
    if (data.foregroundPattern === pattern)
      return;
    data.foregroundPattern = pattern;
  }
  public function setInterpolation__I(interpolation: int): void {
    if (this.isDisposed__())
      SWT.error__I(44);
  }
  public function setLineAttributes__Lorg_eclipse_swt_graphics_LineAttributes_2(attributes: LineAttributes): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (attributes === null)
      SWT.error__I(4);
    var lineWidth: Number = attributes.width;
    var lineStyle: int = attributes.style;
    if (lineStyle != data.lineStyle) {
      switch (lineStyle) {
        case 1 :
        case 2 :
        case 3 :
        case 4 :
        case 5 :
          break;
        case 6 :
          if (attributes.dash === null)
            lineStyle = 1;
          break;
        default :
          SWT.error__I(5);
      }
    }
    var join: int = attributes.join;
    if (join != data.lineJoin) {
      switch (join) {
        case 2 :
        case 1 :
        case 3 :
          break;
        default :
          SWT.error__I(5);
      }
    }
    var cap: int = attributes.join;
    if (cap != data.lineCap) {
      switch (cap) {
        case 1 :
        case 2 :
        case 3 :
          break;
        default :
          SWT.error__I(5);
      }
    }
    var dashes: JavaArray = attributes.dash;
    var lineDashes: JavaArray = data.lineDashes;
    if (dashes !== null && dashes.length > 0) {
      var changed: Boolean = lineDashes === null || lineDashes.length != dashes.length;
      for (var i: int = 0; i < dashes.length; i++) {
        var dash: Number = dashes[i];
        if (dash <= 0)
          SWT.error__I(5);
        if (!changed && lineDashes[i] != dash)
          changed = true;
      }
      if (changed) {
        var newDashes: JavaArray = new JavaArray("[F").lengths(dashes.length);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(dashes, 0, newDashes, 0, dashes.length);
        dashes = newDashes;
      } else {
        dashes = lineDashes;
      }
    } else {
      if (!(lineDashes !== null && lineDashes.length > 0)) {
        dashes = lineDashes;
      }
    }
    var dashOffset: Number = attributes.dashOffset;
    var miterLimit: Number = attributes.miterLimit;
    data.lineWidth = lineWidth;
    data.lineStyle = lineStyle;
    data.lineCap = cap;
    data.lineJoin = join;
    data.lineDashes = dashes;
    data.lineDashesOffset = dashOffset;
    data.lineMiterLimit = miterLimit;
    return;
  }
  public function setLineCap__I(cap: int): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (data.lineCap == cap)
      return;
    switch (cap) {
      case 2 :
      case 1 :
      case 3 :
        break;
      default :
        SWT.error__I(5);
    }
    data.lineCap = cap;
  }
  public function setLineDash___3I(dashes: JavaArray): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    var lineDashes: JavaArray = data.lineDashes;
    if (dashes !== null && dashes.length > 0) {
      var changed: Boolean = data.lineStyle != 6 || lineDashes === null || lineDashes.length != dashes.length;
      for (var i: int = 0; i < dashes.length; i++) {
        var dash: int = dashes[i];
        if (dash <= 0)
          SWT.error__I(5);
        if (!changed && lineDashes[i] != dash)
          changed = true;
      }
      if (!changed)
        return;
      data.lineDashes = new JavaArray("[F").lengths(dashes.length);
      for (var i_1: int = 0; i_1 < dashes.length; i_1++) {
        data.lineDashes[i_1] = dashes[i_1];
      }
      data.lineStyle = 6;
    } else {
      if (data.lineStyle == 1 && (lineDashes === null || lineDashes.length == 0))
        return;
      data.lineDashes = null;
      data.lineStyle = 1;
    }
    return;
  }
  public function setLineJoin__I(join: int): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (data.lineJoin == join)
      return;
    switch (join) {
      case 1 :
      case 2 :
      case 3 :
        break;
      default :
        SWT.error__I(5);
    }
    data.lineJoin = join;
  }
  public function setLineStyle__I(lineStyle: int): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (data.lineStyle == lineStyle)
      return;
    switch (lineStyle) {
      case 1 :
      case 2 :
      case 3 :
      case 4 :
      case 5 :
        break;
      case 6 :
        if (data.lineDashes === null)
          lineStyle = 1;
        break;
      default :
        SWT.error__I(5);
    }
    data.lineStyle = lineStyle;
  }
  public function setLineWidth__I(lineWidth: int): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (data.lineWidth == lineWidth)
      return;
    data.lineWidth = lineWidth;
  }
  public function setTextAntialias__I(antialias: int): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    data.textAntialias = antialias;
  }
  public function setTransform__Lorg_eclipse_swt_graphics_Transform_2(transform: Transform): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (transform !== null && transform.isDisposed__())
      SWT.error__I(5);
    if (transform === null) {
      data.matrix = null;
    } else {
      data.matrix = Matrix(transform.object.clone());
    }
    return;
  }
  public function setXORMode__Z(xor: Boolean): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    data.xorMode = xor;
    return;
  }
  public function stringExtent__Ljava_lang_String_2(string: String): org.eclipse.swt.graphics.Point {
    return this.textExtent__Ljava_lang_String_2I(string, 0);
  }
  public function textExtent__Ljava_lang_String_2(string: String): org.eclipse.swt.graphics.Point {
    return this.textExtent__Ljava_lang_String_2I(string, 2 | 4);
  }
  public function textExtent__Ljava_lang_String_2I(string: String, flags: int): org.eclipse.swt.graphics.Point {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (string === null)
      SWT.error__I(4);
    var text: TextField = this.newTextField__ILjava_lang_String_2I(0, string, flags);
    return new org.eclipse.swt.graphics.Point(int(text.width), int(text.height));
  }
  public function toString__(): String {
    if (this.isDisposed__())
      return "GC {*DISPOSED*}";
    return "GC {" + data.sprite + "}";
  }
  public function GC(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Drawable) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 2 && vargs[0] is Drawable && vargs[1] is int) {
        args = vargs;
        id = 2;
      }
    }
    switch (id) {
      case 0:
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__, []);
        break;
      case 1:
        var args1: Array = [args[0]];
        args2 = [args1[0], 0];
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__, []);
        break;
      case 2:
        var args2: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__, []);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        GC__();
        break;
      case 1:
        GC__Lorg_eclipse_swt_graphics_Drawable_2I(args2[0], args2[1]);
        GC__Lorg_eclipse_swt_graphics_Drawable_2(args1[0]);
        break;
      case 2:
        GC__Lorg_eclipse_swt_graphics_Drawable_2I(args2[0], args2[1]);
        break;
    }
  }
  public static const GC__ : int = 0;
  public static const GC__Lorg_eclipse_swt_graphics_Drawable_2 : int = 1;
  public static const GC__Lorg_eclipse_swt_graphics_Drawable_2I : int = 2;
}
}
