package org.eclipse.swt.graphics {
import org.eclipse.swt.*;
import org.eclipse.swt.SWT;
dynamic public class GlyphMetrics {
  public var ascent: int;
  public var descent: int;
  public var width: int;
  public function GlyphMetrics(ascent: int, descent: int, width: int) {
    if (ascent < 0 || descent < 0 || width < 0) {
      SWT.error__I(5);
    }
    this.ascent = ascent;
    this.descent = descent;
    this.width = width;
    return;
  }
  public function equals__Ljava_lang_Object_2(object: Object): Boolean {
    if (object === this)
      return true;
    if (!(object is GlyphMetrics))
      return false;
    var metrics: GlyphMetrics = GlyphMetrics(object);
    return metrics.ascent == ascent && metrics.descent == descent && metrics.width == width;
  }
  public function hashCode__(): int {
    return ascent ^ descent ^ width;
  }
  public function toString__(): String {
    return "GlyphMetrics {" + ascent + ", " + descent + ", " + width + "}";
  }
}
}
