package org.eclipse.swt.graphics {
import org.eclipse.swt.*;
import java.io.*;
import flash.display.BitmapData;
import flash.display.LoaderInfo;
import flash.system.LoaderContext;
import flash.utils.*;
import flash.display.*;
import flash.net.*;
import flash.events.*;
import flash.geom.Rectangle;
import org.eclipse.swt.internal.image.*;
import flash.events.EventDispatcher;
import org.eclipse.swt.internal.image.WinICOFileFormat;
import org.eclipse.swt.internal.image.GIFFileFormat;
import org.eclipse.swt.internal.image.WinBMPFileFormat;
import org.eclipse.swt.internal.image.TIFFFileFormat;
import org.eclipse.swt.internal.image.JPEGFileFormat;
import org.eclipse.swt.internal.image.PNGFileFormat;
import org.eclipse.swt.internal.image.OS2BMPFileFormat;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.SWT;
import java.io.InputStream;
import flash.utils.ByteArray;
import java.lang.System;
import flash.display.Sprite;
import flash.net.URLStream;
import flash.net.URLRequest;
import flash.display.Loader;
import flash.events.Event;
import flash.events.IOErrorEvent;
import java.io.ByteArrayInputStream;
import flash.display.Bitmap;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Image extends Resource implements Drawable {
  public var type: int;
  internal var transparentPixel: int = -1;
  internal var alphaData: JavaArray;
  internal var alpha: int = -1;
  internal var memGC: GC;
  public var object: BitmapData;
  public var listener: EventDispatcher;
  public static var format1: WinICOFileFormat;
  public static var format2: GIFFileFormat;
  public static var format3: WinBMPFileFormat;
  public static var format4: TIFFFileFormat;
  public static var format5: JPEGFileFormat;
  public static var format6: PNGFileFormat;
  public static var format7: OS2BMPFileFormat;
  public var l: Listener;
  public function Image__Lorg_eclipse_swt_graphics_Device_2(device: Device): Object {
    return this;
  }
  public function Image__Lorg_eclipse_swt_graphics_Device_2II(device: Device, width: int, height: int): Object {
    this.init__II(width, height);
    this.init__();
    return this;
  }
  public function Image__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_Image_2I(device: Device, srcImage: Image, flag: int): Object {
    this.init__();
    return this;
  }
  public function Image__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_Rectangle_2(device: Device, bounds: org.eclipse.swt.graphics.Rectangle): Object {
    if (bounds === null)
      SWT.error__I(4);
    this.init__II(bounds.width, bounds.height);
    this.init__();
    return this;
  }
  public function Image__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_ImageData_2(device: Device, data: ImageData): Object {
    this.init__Lorg_eclipse_swt_graphics_ImageData_2(data);
    this.init__();
    return this;
  }
  public function Image__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_ImageData_2Lorg_eclipse_swt_graphics_ImageData_2(device: Device, source: ImageData, mask: ImageData): Object {
    if (source === null)
      SWT.error__I(4);
    if (mask === null)
      SWT.error__I(4);
    if (source.width != mask.width || source.height != mask.height) {
      SWT.error__I(5);
    }
    mask = ImageData.convertMask__Lorg_eclipse_swt_graphics_ImageData_2(mask);
    var image: ImageData = new ImageData(new Arguments(org.eclipse.swt.graphics.ImageData.ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2I_3B, [source.width, source.height, source.depth, source.palette, source.scanlinePad, source.data]));
    image.maskPad = mask.scanlinePad;
    image.maskData = mask.data;
    this.init__Lorg_eclipse_swt_graphics_ImageData_2(image);
    this.init__();
    return this;
  }
  public function Image__Lorg_eclipse_swt_graphics_Device_2Ljava_io_InputStream_2(device: Device, stream: InputStream): Object {
    this.init__Lorg_eclipse_swt_graphics_ImageData_2(new ImageData(new Arguments(org.eclipse.swt.graphics.ImageData.ImageData__Ljava_io_InputStream_2, [stream])));
    this.init__();
    return this;
  }
  public function Image__Lorg_eclipse_swt_graphics_Device_2Ljava_lang_String_2(device: Device, filename: String): Object {
    if (filename === null)
      SWT.error__I(4);
    {
      this.init__Ljava_lang_String_2(filename);
    }
    this.init__();
    return this;
  }
  public override function destroy__(): void {
    object = null;
    listener = null;
    return;
  }
  public function equals__Ljava_lang_Object_2(object_1: Object): Boolean {
    if (object_1 === this)
      return true;
    if (!(object_1 is Font))
      return false;
    var image: Image = Image(object_1);
    return device === image.device && object_1 === image.object;
  }
  public function getArray___3B(array: JavaArray): ByteArray {
    return ByteArray(array.array);
  }
  public function getBackground__(): Color {
    if (this.isDisposed__())
      SWT.error__I(44);
    return null;
  }
  public function getBounds__(): org.eclipse.swt.graphics.Rectangle {
    if (this.isDisposed__())
      SWT.error__I(44);
    return new org.eclipse.swt.graphics.Rectangle(0, 0, object.width, object.height);
  }
  public function getImageData__(): ImageData {
    if (this.isDisposed__())
      SWT.error__I(44);
    var width: int = object.width;
    var height: int = object.height;
    var bpr: int = width * 4;
    var rect: flash.geom.Rectangle = new flash.geom.Rectangle();
    rect.width = width;
    rect.height = height;
    var array: ByteArray = object.getPixels(rect);
    var srcData: JavaArray = this.newArray__Lflash_utils_ByteArray_2(array);
    var palette: PaletteData = new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData__III, [0xFF0000, 0xFF00, 0xFF]));
    var data: ImageData = new ImageData(new Arguments(org.eclipse.swt.graphics.ImageData.ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2, [width, height, 32, palette]));
    data.data = srcData;
    data.bytesPerLine = bpr;
    data.transparentPixel = transparentPixel;
    if (transparentPixel == -1 && type == 1) {
      var maskPad: int = 2;
      var maskBpl: int = int(((int((width + 7) / 8)) + (maskPad - 1)) / maskPad) * maskPad;
      var maskData: JavaArray = new JavaArray("[B").lengths(height * maskBpl);
      var offset: int = 0;
      var maskOffset: int = 0;
      for (var y: int = 0; y < height; y++) {
        for (var x: int = 0; x < width; x++) {
          if (srcData[offset] != 0) {
            maskData[maskOffset + (x >> 3)] |= (1 << (7 - (x & 0x7)));
          } else {
            maskData[maskOffset + (x >> 3)] &= ~(1 << (7 - (x & 0x7)));
          }
          offset += 4;
        }
        maskOffset += maskBpl;
      }
      data.maskData = maskData;
      data.maskPad = maskPad;
    }
    for (var i: int = 0; i < srcData.length; i += 4) {
      srcData[i] = 0;
    }
    data.alpha = alpha;
    if (alpha == -1 && alphaData !== null) {
      data.alphaData = new JavaArray("[B").lengths(alphaData.length);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(alphaData, 0, data.alphaData, 0, alphaData.length);
    }
    return data;
  }
  public function hashCode__(): int {
    if (this.isDisposed__())
      return 0;
    return Object(Object.prototype).hashCode__.call(this);
  }
  public function internal_new_GC__Lorg_eclipse_swt_graphics_GCData_2(data: GCData): int {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (type != 0 || memGC !== null) {
      SWT.error__I(5);
    }
    if (data !== null) {
      data.sprite = new Sprite();
      var mask: int = 33554432 | 67108864;
      if ((data.style & mask) == 0) {
        data.style |= 33554432;
      }
      data.device = device;
      data.background = device.getSystemColor__I(1);
      data.foreground = device.getSystemColor__I(2);
      data.font = device.systemFont;
      data.image = this;
      return 1;
    }
    return 0;
  }
  public function internal_dispose_GC__ILorg_eclipse_swt_graphics_GCData_2(hDC: int, data: GCData): void {
    if (data === null)
      return;
    object.draw(data.sprite);
  }
  public function init__Ljava_lang_String_2(filename: String): void {
    var file: String = Object(filename).toLowerCase__();
    if (Object(file).endsWith__Ljava_lang_String_2(".bmp") || Object(file).endsWith__Ljava_lang_String_2(".ico") || Object(file).endsWith__Ljava_lang_String_2(".tiff") || Object(file).endsWith__Ljava_lang_String_2(".tif")) {
      var stream: URLStream = new URLStream();
      stream.load(new URLRequest(filename));
      listener = stream;
    } else {
      var loader: Loader = new Loader();
      var context: LoaderContext = new LoaderContext();
      context.checkPolicyFile = true;
      loader.load(new URLRequest(filename), context);
      listener = loader.contentLoaderInfo;
    }
    listener.addEventListener(Event.COMPLETE, this.completeHandlerFunction__());
    listener.addEventListener(IOErrorEvent.IO_ERROR, this.ioErrorHandlerFunction__());
    return;
  }
  public function completeHandler__Lflash_events_Event_2(event: Event): void {
    if (event.target is URLStream) {
      var b: ByteArray = new ByteArray();
      var stream: URLStream = URLStream(event.target);
      stream.readBytes(b, 0, stream.bytesAvailable);
      this.init__Lorg_eclipse_swt_graphics_ImageData_2(new ImageData(new Arguments(org.eclipse.swt.graphics.ImageData.ImageData__Ljava_io_InputStream_2, [new ByteArrayInputStream(new Arguments(java.io.ByteArrayInputStream.ByteArrayInputStream___3B, [this.newArray__Lflash_utils_ByteArray_2(b)]))])));
    } else {
      object = (Bitmap((LoaderInfo(event.target)).content)).bitmapData;
    }
    if (l !== null)
      l.handleEvent__Lorg_eclipse_swt_widgets_Event_2(null);
    return;
  }
  public function completeHandlerFunction__(): Function {
    return completeHandler__Lflash_events_Event_2;
  }
  public function ioErrorHandler__Lflash_events_IOErrorEvent_2(event: IOErrorEvent): void {
    System.out.println__Ljava_lang_String_2(event.text);
    return;
  }
  public function ioErrorHandlerFunction__(): Function {
    return ioErrorHandler__Lflash_events_IOErrorEvent_2;
  }
  public function newArray__Lflash_utils_ByteArray_2(b: ByteArray): JavaArray {
    var array:JavaArray = new JavaArray("[B");
    array.array = b;
    return array;
  }
  public function init__II(width: int, height: int): void {
    if (width <= 0 || height <= 0) {
      SWT.error__I(5);
    }
    this.type = 0;
    object = new BitmapData(width, height, false, 0xFFFFFFFF);
    if (object === null)
      SWT.error__I(2);
    return;
  }
  public function init__Lorg_eclipse_swt_graphics_ImageData_2(image: ImageData): void {
    if (image === null)
      SWT.error__I(4);
    var palette: PaletteData = image.palette;
    if (!(((image.depth == 1 || image.depth == 2 || image.depth == 4 || image.depth == 8) && !palette.isDirect) || ((image.depth == 8) || (image.depth == 16 || image.depth == 24 || image.depth == 32) && palette.isDirect)))
      SWT.error__I(38);
    var width: int = image.width;
    var height: int = image.height;
    var buffer: JavaArray = new JavaArray("[B").lengths(width * 4 * height);
    if (palette.isDirect) {
      ImageData.blit__I_3BIIIIIIIIIII_3BIII_3BIIIIIIIIIIZZ(1, image.data, image.depth, image.bytesPerLine, image.getByteOrder__(), 0, 0, width, height, palette.redMask, palette.greenMask, palette.blueMask, 255, null, 0, 0, 0, buffer, 32, width * 4, 1, 0, 0, width, height, 0xFF0000, 0xFF00, 0xFF, false, false);
    } else {
      var rgbs: JavaArray = palette.getRGBs__();
      var length: int = rgbs.length;
      var srcReds: JavaArray = new JavaArray("[B").lengths(length);
      var srcGreens: JavaArray = new JavaArray("[B").lengths(length);
      var srcBlues: JavaArray = new JavaArray("[B").lengths(length);
      for (var i: int = 0; i < rgbs.length; i++) {
        var rgb: RGB = rgbs[i];
        if (rgb === null)
          continue;
        srcReds[i] = int(rgb.red);
        srcGreens[i] = int(rgb.green);
        srcBlues[i] = int(rgb.blue);
      }
      ImageData.blit__I_3BIIIIIII_3B_3B_3BI_3BIII_3BIIIIIIIIIIZZ(1, image.data, image.depth, image.bytesPerLine, image.getByteOrder__(), 0, 0, width, height, srcReds, srcGreens, srcBlues, 255, null, 0, 0, 0, buffer, 32, width * 4, 1, 0, 0, width, height, 0xFF0000, 0xFF00, 0xFF, false, false);
    }
    var transparency: int = image.getTransparencyType__();
    if (transparency == 2 || image.transparentPixel != -1) {
      this.type = image.transparentPixel != -1 ? 0 : 1;
      if (image.transparentPixel != -1) {
        var transRed: int = 0;
        var transGreen: int = 0;
        var transBlue: int = 0;
        if (palette.isDirect) {
          var rgb_1: RGB = palette.getRGB__I(image.transparentPixel);
          transRed = rgb_1.red;
          transGreen = rgb_1.green;
          transBlue = rgb_1.blue;
        } else {
          var rgbs_1: JavaArray = palette.getRGBs__();
          if (image.transparentPixel < rgbs_1.length) {
            var rgb_2: RGB = rgbs_1[image.transparentPixel];
            transRed = rgb_2.red;
            transGreen = rgb_2.green;
            transBlue = rgb_2.blue;
          }
        }
        transparentPixel = transRed << 16 | transGreen << 8 | transBlue;
      }
      var maskImage: ImageData = image.getTransparencyMask__();
      var maskData: JavaArray = maskImage.data;
      var maskBpl: int = maskImage.bytesPerLine;
      var offset: int = 0;
      var maskOffset: int = 0;
      for (var y: int = 0; y < height; y++) {
        for (var x: int = 0; x < width; x++) {
          buffer[offset] = ((maskData[maskOffset + (x >> 3)]) & (1 << (7 - (x & 0x7)))) != 0 ? int(0xff) : 0;
          offset += 4;
        }
        maskOffset += maskBpl;
      }
    } else {
      this.type = 0;
      if (image.alpha != -1) {
        this.alpha = image.alpha;
        var a: int = int(this.alpha);
        for (var dataIndex: int = 0; dataIndex < buffer.length; dataIndex += 4) {
          buffer[dataIndex] = a;
        }
      } else if (image.alphaData !== null) {
        this.alphaData = new JavaArray("[B").lengths(image.alphaData.length);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(image.alphaData, 0, this.alphaData, 0, alphaData.length);
        var offset_1: int = 0;
        var alphaOffset: int = 0;
        for (var y_1: int = 0; y_1 < height; y_1++) {
          for (var x_1: int = 0; x_1 < width; x_1++) {
            buffer[offset_1] = alphaData[alphaOffset];
            offset_1 += 4;
            alphaOffset += 1;
          }
        }
      } else {
        for (var dataIndex_1: int = 0; dataIndex_1 < buffer.length; dataIndex_1 += 4) {
          buffer[dataIndex_1] = int(0xff);
        }
      }
    }
    object = new BitmapData(width, height, true, 0xFFFFFFFF);
    if (object === null)
      SWT.error__I(2);
    var rect: flash.geom.Rectangle = new flash.geom.Rectangle(0, 0, width, height);
    object.setPixels(rect, this.getArray___3B(buffer));
    return;
  }
  public override function isDisposed__(): Boolean {
    return device === null;
  }
  public function setBackground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    if (this.isDisposed__())
      SWT.error__I(44);
  }
  public function toString__(): String {
    if (this.isDisposed__())
      return "Image {*DISPOSED*}";
    return "Image {" + 1 + "}";
  }
  public static function flex_new__Lorg_eclipse_swt_graphics_Device_2Lflash_display_BitmapData_2(device: Device, object: BitmapData): Image {
    var image: Image = new Image(new Arguments(org.eclipse.swt.graphics.Image.Image__Lorg_eclipse_swt_graphics_Device_2, [device]));
    image.object = object;
    return image;
  }
  public function Image(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is Device) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 3 && vargs[0] is Device && vargs[1] is int && vargs[2] is int) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 3 && vargs[0] is Device && vargs[1] is Image && vargs[2] is int) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 2 && vargs[0] is Device && vargs[1] is org.eclipse.swt.graphics.Rectangle) {
        args = vargs;
        id = 3;
      } else if (vargs.length == 2 && vargs[0] is Device && vargs[1] is ImageData) {
        args = vargs;
        id = 4;
      } else if (vargs.length == 3 && vargs[0] is Device && vargs[1] is ImageData && vargs[2] is ImageData) {
        args = vargs;
        id = 5;
      } else if (vargs.length == 2 && vargs[0] is Device && vargs[1] is InputStream) {
        args = vargs;
        id = 6;
      } else if (vargs.length == 2 && vargs[0] is Device && vargs[1] is String) {
        args = vargs;
        id = 7;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args0[0]]);
        break;
      case 1:
        var args1: Array = [args[0], args[1], args[2]];
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args1[0]]);
        break;
      case 2:
        var args2: Array = [args[0], args[1], args[2]];
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args2[0]]);
        break;
      case 3:
        var args3: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args3[0]]);
        break;
      case 4:
        var args4: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args4[0]]);
        break;
      case 5:
        var args5: Array = [args[0], args[1], args[2]];
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args5[0]]);
        break;
      case 6:
        var args6: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args6[0]]);
        break;
      case 7:
        var args7: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args7[0]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        Image__Lorg_eclipse_swt_graphics_Device_2(args0[0]);
        break;
      case 1:
        Image__Lorg_eclipse_swt_graphics_Device_2II(args1[0], args1[1], args1[2]);
        break;
      case 2:
        Image__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_Image_2I(args2[0], args2[1], args2[2]);
        break;
      case 3:
        Image__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_Rectangle_2(args3[0], args3[1]);
        break;
      case 4:
        Image__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_ImageData_2(args4[0], args4[1]);
        break;
      case 5:
        Image__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_ImageData_2Lorg_eclipse_swt_graphics_ImageData_2(args5[0], args5[1], args5[2]);
        break;
      case 6:
        Image__Lorg_eclipse_swt_graphics_Device_2Ljava_io_InputStream_2(args6[0], args6[1]);
        break;
      case 7:
        Image__Lorg_eclipse_swt_graphics_Device_2Ljava_lang_String_2(args7[0], args7[1]);
        break;
    }
  }
  public static const Image__Lorg_eclipse_swt_graphics_Device_2 : int = 0;
  public static const Image__Lorg_eclipse_swt_graphics_Device_2II : int = 1;
  public static const Image__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_Image_2I : int = 2;
  public static const Image__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_Rectangle_2 : int = 3;
  public static const Image__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_ImageData_2 : int = 4;
  public static const Image__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_ImageData_2Lorg_eclipse_swt_graphics_ImageData_2 : int = 5;
  public static const Image__Lorg_eclipse_swt_graphics_Device_2Ljava_io_InputStream_2 : int = 6;
  public static const Image__Lorg_eclipse_swt_graphics_Device_2Ljava_lang_String_2 : int = 7;
}
}
