package org.eclipse.swt.graphics {
import java.io.*;
import org.eclipse.swt.*;
import org.eclipse.swt.internal.CloneableCompatibility;
import org.eclipse.swt.SWT;
import java.io.InputStream;
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ImageData implements CloneableCompatibility {
  public var width: int;
  public var height: int;
  public var depth: int;
  public var scanlinePad: int;
  public var bytesPerLine: int;
  public var data: JavaArray;
  public var palette: PaletteData;
  public var transparentPixel: int;
  public var maskData: JavaArray;
  public var maskPad: int;
  public var alphaData: JavaArray;
  public var alpha: int;
  public var type: int;
  public var x: int;
  public var y: int;
  public var disposalMethod: int;
  public var delayTime: int;
  public static var ANY_TO_EIGHT: JavaArray = new JavaArray("[[B").lengths(9);
  public static var ONE_TO_ONE_MAPPING: JavaArray = ANY_TO_EIGHT[8];
  public static var DITHER_MATRIX: JavaArray = new JavaArray("[[I").values(new JavaArray("[I").values(0xfc0000, 0x7c0000, 0xdc0000, 0x5c0000, 0xf40000, 0x740000, 0xd40000, 0x540000), new JavaArray("[I").values(0x3c0000, 0xbc0000, 0x1c0000, 0x9c0000, 0x340000, 0xb40000, 0x140000, 0x940000), new JavaArray("[I").values(0xcc0000, 0x4c0000, 0xec0000, 0x6c0000, 0xc40000, 0x440000, 0xe40000, 0x640000), new JavaArray("[I").values(0x0c0000, 0x8c0000, 0x2c0000, 0xac0000, 0x040000, 0x840000, 0x240000, 0xa40000), new JavaArray("[I").values(0xf00000, 0x700000, 0xd00000, 0x500000, 0xf80000, 0x780000, 0xd80000, 0x580000), new JavaArray("[I").values(0x300000, 0xb00000, 0x100000, 0x900000, 0x380000, 0xb80000, 0x180000, 0x980000), new JavaArray("[I").values(0xc00000, 0x400000, 0xe00000, 0x600000, 0xc80000, 0x480000, 0xe80000, 0x680000), new JavaArray("[I").values(0x000000, 0x800000, 0x200000, 0xa00000, 0x080000, 0x880000, 0x280000, 0xa80000));
  public static const BLIT_SRC: int = 1;
  public static const BLIT_ALPHA: int = 2;
  public static const BLIT_DITHER: int = 4;
  public static const ALPHA_OPAQUE: int = 255;
  public static const ALPHA_TRANSPARENT: int = 0;
  public static const ALPHA_CHANNEL_SEPARATE: int = -1;
  public static const ALPHA_CHANNEL_SOURCE: int = -2;
  public static const ALPHA_MASK_UNPACKED: int = -3;
  public static const ALPHA_MASK_PACKED: int = -4;
  public static const ALPHA_MASK_INDEX: int = -5;
  public static const ALPHA_MASK_RGB: int = -6;
  public static const LSB_FIRST: int = 0;
  public static const MSB_FIRST: int = 1;
  public static const TYPE_GENERIC_8: int = 0;
  public static const TYPE_GENERIC_16_MSB: int = 1;
  public static const TYPE_GENERIC_16_LSB: int = 2;
  public static const TYPE_GENERIC_24: int = 3;
  public static const TYPE_GENERIC_32_MSB: int = 4;
  public static const TYPE_GENERIC_32_LSB: int = 5;
  public static const TYPE_INDEX_8: int = 6;
  public static const TYPE_INDEX_4: int = 7;
  public static const TYPE_INDEX_2: int = 8;
  public static const TYPE_INDEX_1_MSB: int = 9;
  public static const TYPE_INDEX_1_LSB: int = 10;

  __clinit();

  static private function __clinit(): void {
    {
      for (var b: int = 0; b < 9; ++b) {
        var data: JavaArray = ANY_TO_EIGHT[b] = new JavaArray("[B").lengths(1 << b);
        if (b == 0)
          continue;
        var inc: int = 0;
        for (var bit: int = 0x10000; (bit >>= b) != 0;)
          inc |= bit;
        for (var v: int = 0, p: int = 0; v < 0x10000; v += inc)
          data[p++] = int((v >> 8));
      }
    }
  }
  public function ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2(width: int, height: int, depth: int, palette: PaletteData): Object {
    return this;
  }
  public function ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2I_3B(width: int, height: int, depth: int, palette: PaletteData, scanlinePad: int, data: JavaArray): Object {
    return this;
  }
  public function ImageData__Ljava_io_InputStream_2(stream: InputStream): Object {
    var data: JavaArray = ImageDataLoader.load__Ljava_io_InputStream_2(stream);
    if (data.length < 1)
      SWT.error__I(40);
    var i: ImageData = data[0];
    this.setAllFields__IIIII_3BLorg_eclipse_swt_graphics_PaletteData_2I_3BI_3BIIIIII(i.width, i.height, i.depth, i.scanlinePad, i.bytesPerLine, i.data, i.palette, i.transparentPixel, i.maskData, i.maskPad, i.alphaData, i.alpha, i.type, i.x, i.y, i.disposalMethod, i.delayTime);
    return this;
  }
  public function ImageData__Ljava_lang_String_2(filename: String): Object {
    var data: JavaArray = ImageDataLoader.load__Ljava_lang_String_2(filename);
    if (data.length < 1)
      SWT.error__I(40);
    var i: ImageData = data[0];
    this.setAllFields__IIIII_3BLorg_eclipse_swt_graphics_PaletteData_2I_3BI_3BIIIIII(i.width, i.height, i.depth, i.scanlinePad, i.bytesPerLine, i.data, i.palette, i.transparentPixel, i.maskData, i.maskPad, i.alphaData, i.alpha, i.type, i.x, i.y, i.disposalMethod, i.delayTime);
    return this;
  }
  public function ImageData__(): Object {
    return this;
  }
  public function ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2I_3BI_3B_3BIIIIIII(width: int, height: int, depth: int, palette: PaletteData, scanlinePad: int, data: JavaArray, maskPad: int, maskData: JavaArray, alphaData: JavaArray, alpha: int, transparentPixel: int, type: int, x: int, y: int, disposalMethod: int, delayTime: int): Object {
    if (palette === null)
      SWT.error__I(4);
    if (!(depth == 1 || depth == 2 || depth == 4 || depth == 8 || depth == 16 || depth == 24 || depth == 32)) {
      SWT.error__I(5);
    }
    if (width <= 0 || height <= 0) {
      SWT.error__I(5);
    }
    if (scanlinePad == 0)
      SWT.error__I(7);
    var bytesPerLine: int = int(((int((width * depth + 7) / 8)) + (scanlinePad - 1)) / scanlinePad) * scanlinePad;
    var minBytesPerLine: int = type == 5 ? (int(((int((width + 7) / 8)) + 3) / 4)) * 4 : bytesPerLine;
    if (data !== null && data.length < minBytesPerLine * height) {
      SWT.error__I(5);
    }
    this.setAllFields__IIIII_3BLorg_eclipse_swt_graphics_PaletteData_2I_3BI_3BIIIIII(width, height, depth, scanlinePad, bytesPerLine, data !== null ? data : new JavaArray("[B").lengths(bytesPerLine * height), palette, transparentPixel, maskData, maskPad, alphaData, alpha, type, x, y, disposalMethod, delayTime);
    return this;
  }
  public function setAllFields__IIIII_3BLorg_eclipse_swt_graphics_PaletteData_2I_3BI_3BIIIIII(width_1: int, height_1: int, depth_1: int, scanlinePad_1: int, bytesPerLine_1: int, data_1: JavaArray, palette_1: PaletteData, transparentPixel_1: int, maskData_1: JavaArray, maskPad_1: int, alphaData_1: JavaArray, alpha_1: int, type_1: int, x_1: int, y_1: int, disposalMethod_1: int, delayTime_1: int): void {
    this.width = width_1;
    this.height = height_1;
    this.depth = depth_1;
    this.scanlinePad = scanlinePad_1;
    this.bytesPerLine = bytesPerLine_1;
    this.data = data_1;
    this.palette = palette_1;
    this.transparentPixel = transparentPixel_1;
    this.maskData = maskData_1;
    this.maskPad = maskPad_1;
    this.alphaData = alphaData_1;
    this.alpha = alpha_1;
    this.type = type_1;
    this.x = x_1;
    this.y = y_1;
    this.disposalMethod = disposalMethod_1;
    this.delayTime = delayTime_1;
    return;
  }
  public static function internal_new__IIILorg_eclipse_swt_graphics_PaletteData_2I_3BI_3B_3BIIIIIII(width: int, height: int, depth: int, palette: PaletteData, scanlinePad: int, data: JavaArray, maskPad: int, maskData: JavaArray, alphaData: JavaArray, alpha: int, transparentPixel: int, type: int, x: int, y: int, disposalMethod: int, delayTime: int): ImageData {
    return new ImageData(new Arguments(org.eclipse.swt.graphics.ImageData.ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2I_3BI_3B_3BIIIIIII, [width, height, depth, palette, scanlinePad, data, maskPad, maskData, alphaData, alpha, transparentPixel, type, x, y, disposalMethod, delayTime]));
  }
  public function colorMaskImage__I(pixel: int): ImageData {
    var mask: ImageData = new ImageData(new Arguments(org.eclipse.swt.graphics.ImageData.ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2I_3BI_3B_3BIIIIIII, [width, height, 1, ImageData.bwPalette__(), 2, null, 0, null, null, -1, -1, -1, 0, 0, 0, 0]));
    var row: JavaArray = new JavaArray("[I").lengths(width);
    for (var y_1: int = 0; y_1 < height; y_1++) {
      this.getPixels__III_3II(0, y_1, width, row, 0);
      for (var i: int = 0; i < width; i++) {
        if (pixel != -1 && row[i] == pixel) {
          row[i] = 0;
        } else {
          row[i] = 1;
        }
      }
      mask.setPixels__III_3II(0, y_1, width, row, 0);
    }
    return mask;
  }
  public static function checkData___3B(data: JavaArray): JavaArray {
    if (data === null)
      SWT.error__I(4);
    return data;
  }
  public function clone__(): Object {
    var cloneData: JavaArray = new JavaArray("[B").lengths(data.length);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(data, 0, cloneData, 0, data.length);
    var cloneMaskData: JavaArray = null;
    if (maskData !== null) {
      cloneMaskData = new JavaArray("[B").lengths(maskData.length);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(maskData, 0, cloneMaskData, 0, maskData.length);
    }
    var cloneAlphaData: JavaArray = null;
    if (alphaData !== null) {
      cloneAlphaData = new JavaArray("[B").lengths(alphaData.length);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(alphaData, 0, cloneAlphaData, 0, alphaData.length);
    }
    return new ImageData(new Arguments(org.eclipse.swt.graphics.ImageData.ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2I_3BI_3B_3BIIIIIII, [width, height, depth, palette, scanlinePad, cloneData, maskPad, cloneMaskData, cloneAlphaData, alpha, transparentPixel, type, x, y, disposalMethod, delayTime]));
  }
  public function getAlpha__II(x_1: int, y_1: int): int {
    if (x_1 >= width || y_1 >= height || x_1 < 0 || y_1 < 0)
      SWT.error__I(5);
    if (alphaData === null)
      return 255;
    return alphaData[y_1 * width + x_1] & 0xFF;
  }
  public function getAlphas__III_3BI(x_1: int, y_1: int, getWidth: int, alphas: JavaArray, startIndex: int): void {
    if (alphas === null)
      SWT.error__I(4);
    if (getWidth < 0 || x_1 >= width || y_1 >= height || x_1 < 0 || y_1 < 0)
      SWT.error__I(5);
    if (getWidth == 0)
      return;
    if (alphaData === null) {
      var endIndex: int = startIndex + getWidth;
      for (var i: int = startIndex; i < endIndex; i++) {
        alphas[i] = int(255);
      }
      return;
    }
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(alphaData, y_1 * width + x_1, alphas, startIndex, getWidth);
    return;
  }
  public function getPixel__II(x_1: int, y_1: int): int {
    if (x_1 >= width || y_1 >= height || x_1 < 0 || y_1 < 0)
      SWT.error__I(5);
    var index: int;
    var theByte: int;
    var mask: int;
    switch (depth) {
      case 32 :
        index = (y_1 * bytesPerLine) + (x_1 * 4);
        return ((data[index] & 0xFF) << 24) + ((data[index + 1] & 0xFF) << 16) + ((data[index + 2] & 0xFF) << 8) + (data[index + 3] & 0xFF);
      case 24 :
        index = (y_1 * bytesPerLine) + (x_1 * 3);
        return ((data[index] & 0xFF) << 16) + ((data[index + 1] & 0xFF) << 8) + (data[index + 2] & 0xFF);
      case 16 :
        index = (y_1 * bytesPerLine) + (x_1 * 2);
        return ((data[index + 1] & 0xFF) << 8) + (data[index] & 0xFF);
      case 8 :
        index = (y_1 * bytesPerLine) + x_1;
        return data[index] & 0xFF;
      case 4 :
        index = (y_1 * bytesPerLine) + (x_1 >> 1);
        theByte = data[index] & 0xFF;
        if ((x_1 & 0x1) == 0) {
          return theByte >> 4;
        } else {
          return theByte & 0x0F;
        }
      case 2 :
        index = (y_1 * bytesPerLine) + (x_1 >> 2);
        theByte = data[index] & 0xFF;
        var offset: int = 3 - (x_1 % 4);
        mask = 3 << (offset * 2);
        return (theByte & mask) >> (offset * 2);
      case 1 :
        index = (y_1 * bytesPerLine) + (x_1 >> 3);
        theByte = data[index] & 0xFF;
        mask = 1 << (7 - (x_1 & 0x7));
        if ((theByte & mask) == 0) {
          return 0;
        } else {
          return 1;
        }
    }
    SWT.error__I(38);
    return 0;
  }
  public function getPixels__III_3BI(x_1: int, y_1: int, getWidth: int, pixels: JavaArray, startIndex: int): void {
    if (pixels === null)
      SWT.error__I(4);
    if (getWidth < 0 || x_1 >= width || y_1 >= height || x_1 < 0 || y_1 < 0)
      SWT.error__I(5);
    if (getWidth == 0)
      return;
    var index: int;
    var theByte: int;
    var mask: int = 0;
    var n: int = getWidth;
    var i: int = startIndex;
    var srcX: int = x_1;
    var srcY: int = y_1;
    switch (depth) {
      case 8 :
        index = (y_1 * bytesPerLine) + x_1;
        for (var j: int = 0; j < getWidth; j++) {
          pixels[i] = data[index];
          i++;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            srcX = 0;
          } else {
            index++;
          }
        }
        return;
      case 4 :
        index = (y_1 * bytesPerLine) + (x_1 >> 1);
        if ((x_1 & 0x1) == 1) {
          theByte = data[index] & 0xFF;
          pixels[i] = int((theByte & 0x0F));
          i++;
          n--;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            srcX = 0;
          } else {
            index++;
          }
        }
        while (n > 1) {
          theByte = data[index] & 0xFF;
          pixels[i] = int((theByte >> 4));
          i++;
          n--;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            srcX = 0;
          } else {
            pixels[i] = int((theByte & 0x0F));
            i++;
            n--;
            srcX++;
            if (srcX >= width) {
              srcY++;
              index = srcY * bytesPerLine;
              srcX = 0;
            } else {
              index++;
            }
          }
        }
        if (n > 0) {
          theByte = data[index] & 0xFF;
          pixels[i] = int((theByte >> 4));
        }
        return;
      case 2 :
        index = (y_1 * bytesPerLine) + (x_1 >> 2);
        theByte = data[index] & 0xFF;
        var offset: int;
        while (n > 0) {
          offset = 3 - (srcX % 4);
          mask = 3 << (offset * 2);
          pixels[i] = int(((theByte & mask) >> (offset * 2)));
          i++;
          n--;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            if (n > 0)
              theByte = data[index] & 0xFF;
            srcX = 0;
          } else {
            if (offset == 0) {
              index++;
              theByte = data[index] & 0xFF;
            }
          }
        }
        return;
      case 1 :
        index = (y_1 * bytesPerLine) + (x_1 >> 3);
        theByte = data[index] & 0xFF;
        while (n > 0) {
          mask = 1 << (7 - (srcX & 0x7));
          if ((theByte & mask) == 0) {
            pixels[i] = 0;
          } else {
            pixels[i] = 1;
          }
          i++;
          n--;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            if (n > 0)
              theByte = data[index] & 0xFF;
            srcX = 0;
          } else {
            if (mask == 1) {
              index++;
              if (n > 0)
                theByte = data[index] & 0xFF;
            }
          }
        }
        return;
    }
    SWT.error__I(38);
  }
  public function getPixels__III_3II(x_1: int, y_1: int, getWidth: int, pixels: JavaArray, startIndex: int): void {
    if (pixels === null)
      SWT.error__I(4);
    if (getWidth < 0 || x_1 >= width || y_1 >= height || x_1 < 0 || y_1 < 0)
      SWT.error__I(5);
    if (getWidth == 0)
      return;
    var index: int;
    var theByte: int;
    var mask: int;
    var n: int = getWidth;
    var i: int = startIndex;
    var srcX: int = x_1;
    var srcY: int = y_1;
    switch (depth) {
      case 32 :
        index = (y_1 * bytesPerLine) + (x_1 * 4);
        i = startIndex;
        for (var j: int = 0; j < getWidth; j++) {
          pixels[i] = ((data[index] & 0xFF) << 24) | ((data[index + 1] & 0xFF) << 16) | ((data[index + 2] & 0xFF) << 8) | (data[index + 3] & 0xFF);
          i++;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            srcX = 0;
          } else {
            index += 4;
          }
        }
        return;
      case 24 :
        index = (y_1 * bytesPerLine) + (x_1 * 3);
        for (var j_1: int = 0; j_1 < getWidth; j_1++) {
          pixels[i] = ((data[index] & 0xFF) << 16) | ((data[index + 1] & 0xFF) << 8) | (data[index + 2] & 0xFF);
          i++;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            srcX = 0;
          } else {
            index += 3;
          }
        }
        return;
      case 16 :
        index = (y_1 * bytesPerLine) + (x_1 * 2);
        for (var j_2: int = 0; j_2 < getWidth; j_2++) {
          pixels[i] = ((data[index + 1] & 0xFF) << 8) + (data[index] & 0xFF);
          i++;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            srcX = 0;
          } else {
            index += 2;
          }
        }
        return;
      case 8 :
        index = (y_1 * bytesPerLine) + x_1;
        for (var j_3: int = 0; j_3 < getWidth; j_3++) {
          pixels[i] = data[index] & 0xFF;
          i++;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            srcX = 0;
          } else {
            index++;
          }
        }
        return;
      case 4 :
        index = (y_1 * bytesPerLine) + (x_1 >> 1);
        if ((x_1 & 0x1) == 1) {
          theByte = data[index] & 0xFF;
          pixels[i] = theByte & 0x0F;
          i++;
          n--;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            srcX = 0;
          } else {
            index++;
          }
        }
        while (n > 1) {
          theByte = data[index] & 0xFF;
          pixels[i] = theByte >> 4;
          i++;
          n--;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            srcX = 0;
          } else {
            pixels[i] = theByte & 0x0F;
            i++;
            n--;
            srcX++;
            if (srcX >= width) {
              srcY++;
              index = srcY * bytesPerLine;
              srcX = 0;
            } else {
              index++;
            }
          }
        }
        if (n > 0) {
          theByte = data[index] & 0xFF;
          pixels[i] = theByte >> 4;
        }
        return;
      case 2 :
        index = (y_1 * bytesPerLine) + (x_1 >> 2);
        theByte = data[index] & 0xFF;
        var offset: int;
        while (n > 0) {
          offset = 3 - (srcX % 4);
          mask = 3 << (offset * 2);
          pixels[i] = int(((theByte & mask) >> (offset * 2)));
          i++;
          n--;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            if (n > 0)
              theByte = data[index] & 0xFF;
            srcX = 0;
          } else {
            if (offset == 0) {
              index++;
              theByte = data[index] & 0xFF;
            }
          }
        }
        return;
      case 1 :
        index = (y_1 * bytesPerLine) + (x_1 >> 3);
        theByte = data[index] & 0xFF;
        while (n > 0) {
          mask = 1 << (7 - (srcX & 0x7));
          if ((theByte & mask) == 0) {
            pixels[i] = 0;
          } else {
            pixels[i] = 1;
          }
          i++;
          n--;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            if (n > 0)
              theByte = data[index] & 0xFF;
            srcX = 0;
          } else {
            if (mask == 1) {
              index++;
              if (n > 0)
                theByte = data[index] & 0xFF;
            }
          }
        }
        return;
    }
    SWT.error__I(38);
  }
  public function getRGBs__(): JavaArray {
    return palette.getRGBs__();
  }
  public function getTransparencyMask__(): ImageData {
    if (this.getTransparencyType__() == 2) {
      return new ImageData(new Arguments(org.eclipse.swt.graphics.ImageData.ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2I_3B, [width, height, 1, ImageData.bwPalette__(), maskPad, maskData]));
    } else {
      return this.colorMaskImage__I(transparentPixel);
    }
    return null;
  }
  public function getTransparencyType__(): int {
    if (maskData !== null)
      return 2;
    if (transparentPixel != -1)
      return 4;
    if (alphaData !== null)
      return 1;
    return 0;
  }
  public function getByteOrder__(): int {
    return depth != 16 ? 1 : 0;
  }
  public function scaledTo__II(width_1: int, height_1: int): ImageData {
    var flipX: Boolean = (width_1 < 0);
    if (flipX)
      width_1 = -width_1;
    var flipY: Boolean = (height_1 < 0);
    if (flipY)
      height_1 = -height_1;
    var dest: ImageData = new ImageData(new Arguments(org.eclipse.swt.graphics.ImageData.ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2I_3BI_3B_3BIIIIIII, [width_1, height_1, depth, palette, scanlinePad, null, 0, null, null, -1, transparentPixel, type, x, y, disposalMethod, delayTime]));
    if (palette.isDirect)
      ImageData.blit__I_3BIIIIIIIIIII_3BIII_3BIIIIIIIIIIZZ(1, this.data, this.depth, this.bytesPerLine, this.getByteOrder__(), 0, 0, this.width, this.height, 0, 0, 0, 255, null, 0, 0, 0, dest.data, dest.depth, dest.bytesPerLine, dest.getByteOrder__(), 0, 0, dest.width, dest.height, 0, 0, 0, flipX, flipY);
    else
      ImageData.blit__I_3BIIIIIII_3B_3B_3BI_3BIII_3BIIIIIII_3B_3B_3BZZ(1, this.data, this.depth, this.bytesPerLine, this.getByteOrder__(), 0, 0, this.width, this.height, null, null, null, 255, null, 0, 0, 0, dest.data, dest.depth, dest.bytesPerLine, dest.getByteOrder__(), 0, 0, dest.width, dest.height, null, null, null, flipX, flipY);
    if (maskData !== null) {
      dest.maskPad = this.maskPad;
      var destBpl: int = int((dest.width + 7) / 8);
      destBpl = int((destBpl + (dest.maskPad - 1)) / dest.maskPad) * dest.maskPad;
      dest.maskData = new JavaArray("[B").lengths(destBpl * dest.height);
      var srcBpl: int = int((this.width + 7) / 8);
      srcBpl = int((srcBpl + (this.maskPad - 1)) / this.maskPad) * this.maskPad;
      ImageData.blit__I_3BIIIIIII_3B_3B_3BI_3BIII_3BIIIIIII_3B_3B_3BZZ(1, this.maskData, 1, srcBpl, 1, 0, 0, this.width, this.height, null, null, null, 255, null, 0, 0, 0, dest.maskData, 1, destBpl, 1, 0, 0, dest.width, dest.height, null, null, null, flipX, flipY);
    } else if (alpha != -1) {
      dest.alpha = this.alpha;
    } else if (alphaData !== null) {
      dest.alphaData = new JavaArray("[B").lengths(dest.width * dest.height);
      ImageData.blit__I_3BIIIIIII_3B_3B_3BI_3BIII_3BIIIIIII_3B_3B_3BZZ(1, this.alphaData, 8, this.width, 1, 0, 0, this.width, this.height, null, null, null, 255, null, 0, 0, 0, dest.alphaData, 8, dest.width, 1, 0, 0, dest.width, dest.height, null, null, null, flipX, flipY);
    }
    return dest;
  }
  public function setAlpha__III(x_1: int, y_1: int, alpha_1: int): void {
    if (x_1 >= width || y_1 >= height || x_1 < 0 || y_1 < 0 || alpha_1 < 0 || alpha_1 > 255)
      SWT.error__I(5);
    if (alphaData === null)
      alphaData = new JavaArray("[B").lengths(width * height);
    alphaData[y_1 * width + x_1] = int(alpha_1);
  }
  public function setAlphas__III_3BI(x_1: int, y_1: int, putWidth: int, alphas: JavaArray, startIndex: int): void {
    if (alphas === null)
      SWT.error__I(4);
    if (putWidth < 0 || x_1 >= width || y_1 >= height || x_1 < 0 || y_1 < 0)
      SWT.error__I(5);
    if (putWidth == 0)
      return;
    if (alphaData === null)
      alphaData = new JavaArray("[B").lengths(width * height);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(alphas, startIndex, alphaData, y_1 * width + x_1, putWidth);
  }
  public function setPixel__III(x_1: int, y_1: int, pixelValue: int): void {
    if (x_1 >= width || y_1 >= height || x_1 < 0 || y_1 < 0)
      SWT.error__I(5);
    var index: int;
    var theByte: int;
    var mask: int;
    switch (depth) {
      case 32 :
        index = (y_1 * bytesPerLine) + (x_1 * 4);
        data[index] = int(((pixelValue >> 24) & 0xFF));
        data[index + 1] = int(((pixelValue >> 16) & 0xFF));
        data[index + 2] = int(((pixelValue >> 8) & 0xFF));
        data[index + 3] = int((pixelValue & 0xFF));
        return;
      case 24 :
        index = (y_1 * bytesPerLine) + (x_1 * 3);
        data[index] = int(((pixelValue >> 16) & 0xFF));
        data[index + 1] = int(((pixelValue >> 8) & 0xFF));
        data[index + 2] = int((pixelValue & 0xFF));
        return;
      case 16 :
        index = (y_1 * bytesPerLine) + (x_1 * 2);
        data[index + 1] = int(((pixelValue >> 8) & 0xFF));
        data[index] = int((pixelValue & 0xFF));
        return;
      case 8 :
        index = (y_1 * bytesPerLine) + x_1;
        data[index] = int((pixelValue & 0xFF));
        return;
      case 4 :
        index = (y_1 * bytesPerLine) + (x_1 >> 1);
        if ((x_1 & 0x1) == 0) {
          data[index] = int(((data[index] & 0x0F) | ((pixelValue & 0x0F) << 4)));
        } else {
          data[index] = int(((data[index] & 0xF0) | (pixelValue & 0x0F)));
        }
        return;
      case 2 :
        index = (y_1 * bytesPerLine) + (x_1 >> 2);
        theByte = data[index];
        var offset: int = 3 - (x_1 % 4);
        mask = 0xFF ^ (3 << (offset * 2));
        data[index] = int(((data[index] & mask) | (pixelValue << (offset * 2))));
        return;
      case 1 :
        index = (y_1 * bytesPerLine) + (x_1 >> 3);
        theByte = data[index];
        mask = 1 << (7 - (x_1 & 0x7));
        if ((pixelValue & 0x1) == 1) {
          data[index] = int((theByte | mask));
        } else {
          data[index] = int((theByte & (mask ^ -1)));
        }
        return;
    }
    SWT.error__I(38);
  }
  public function setPixels__III_3BI(x_1: int, y_1: int, putWidth: int, pixels: JavaArray, startIndex: int): void {
    if (pixels === null)
      SWT.error__I(4);
    if (putWidth < 0 || x_1 >= width || y_1 >= height || x_1 < 0 || y_1 < 0)
      SWT.error__I(5);
    if (putWidth == 0)
      return;
    var index: int;
    var theByte: int;
    var mask: int;
    var n: int = putWidth;
    var i: int = startIndex;
    var srcX: int = x_1;
    var srcY: int = y_1;
    switch (depth) {
      case 8 :
        index = (y_1 * bytesPerLine) + x_1;
        for (var j: int = 0; j < putWidth; j++) {
          data[index] = int((pixels[i] & 0xFF));
          i++;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            srcX = 0;
          } else {
            index++;
          }
        }
        return;
      case 4 :
        index = (y_1 * bytesPerLine) + (x_1 >> 1);
        var high: Boolean = (x_1 & 0x1) == 0;
        while (n > 0) {
          theByte = pixels[i] & 0x0F;
          if (high) {
            data[index] = int(((data[index] & 0x0F) | (theByte << 4)));
          } else {
            data[index] = int(((data[index] & 0xF0) | theByte));
          }
          i++;
          n--;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            high = true;
            srcX = 0;
          } else {
            if (!high)
              index++;
            high = !high;
          }
        }
        return;
      case 2 :
        var masks: JavaArray = new JavaArray("[B").values(int(0xFC), int(0xF3), int(0xCF), int(0x3F));
        index = (y_1 * bytesPerLine) + (x_1 >> 2);
        var offset: int = 3 - (x_1 % 4);
        while (n > 0) {
          theByte = pixels[i] & 0x3;
          data[index] = int(((data[index] & masks[offset]) | (theByte << (offset * 2))));
          i++;
          n--;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            offset = 0;
            srcX = 0;
          } else {
            if (offset == 0) {
              index++;
              offset = 3;
            } else {
              offset--;
            }
          }
        }
        return;
      case 1 :
        index = (y_1 * bytesPerLine) + (x_1 >> 3);
        while (n > 0) {
          mask = 1 << (7 - (srcX & 0x7));
          if ((pixels[i] & 0x1) == 1) {
            data[index] = int(((data[index] & 0xFF) | mask));
          } else {
            data[index] = int(((data[index] & 0xFF) & (mask ^ -1)));
          }
          i++;
          n--;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            srcX = 0;
          } else {
            if (mask == 1) {
              index++;
            }
          }
        }
        return;
    }
    SWT.error__I(38);
  }
  public function setPixels__III_3II(x_1: int, y_1: int, putWidth: int, pixels: JavaArray, startIndex: int): void {
    if (pixels === null)
      SWT.error__I(4);
    if (putWidth < 0 || x_1 >= width || y_1 >= height || x_1 < 0 || y_1 < 0)
      SWT.error__I(5);
    if (putWidth == 0)
      return;
    var index: int;
    var theByte: int;
    var mask: int;
    var n: int = putWidth;
    var i: int = startIndex;
    var pixel: int;
    var srcX: int = x_1;
    var srcY: int = y_1;
    switch (depth) {
      case 32 :
        index = (y_1 * bytesPerLine) + (x_1 * 4);
        for (var j: int = 0; j < putWidth; j++) {
          pixel = pixels[i];
          data[index] = int(((pixel >> 24) & 0xFF));
          data[index + 1] = int(((pixel >> 16) & 0xFF));
          data[index + 2] = int(((pixel >> 8) & 0xFF));
          data[index + 3] = int((pixel & 0xFF));
          i++;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            srcX = 0;
          } else {
            index += 4;
          }
        }
        return;
      case 24 :
        index = (y_1 * bytesPerLine) + (x_1 * 3);
        for (var j_1: int = 0; j_1 < putWidth; j_1++) {
          pixel = pixels[i];
          data[index] = int(((pixel >> 16) & 0xFF));
          data[index + 1] = int(((pixel >> 8) & 0xFF));
          data[index + 2] = int((pixel & 0xFF));
          i++;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            srcX = 0;
          } else {
            index += 3;
          }
        }
        return;
      case 16 :
        index = (y_1 * bytesPerLine) + (x_1 * 2);
        for (var j_2: int = 0; j_2 < putWidth; j_2++) {
          pixel = pixels[i];
          data[index] = int((pixel & 0xFF));
          data[index + 1] = int(((pixel >> 8) & 0xFF));
          i++;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            srcX = 0;
          } else {
            index += 2;
          }
        }
        return;
      case 8 :
        index = (y_1 * bytesPerLine) + x_1;
        for (var j_3: int = 0; j_3 < putWidth; j_3++) {
          data[index] = int((pixels[i] & 0xFF));
          i++;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            srcX = 0;
          } else {
            index++;
          }
        }
        return;
      case 4 :
        index = (y_1 * bytesPerLine) + (x_1 >> 1);
        var high: Boolean = (x_1 & 0x1) == 0;
        while (n > 0) {
          theByte = pixels[i] & 0x0F;
          if (high) {
            data[index] = int(((data[index] & 0x0F) | (theByte << 4)));
          } else {
            data[index] = int(((data[index] & 0xF0) | theByte));
          }
          i++;
          n--;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            high = true;
            srcX = 0;
          } else {
            if (!high)
              index++;
            high = !high;
          }
        }
        return;
      case 2 :
        var masks: JavaArray = new JavaArray("[B").values(int(0xFC), int(0xF3), int(0xCF), int(0x3F));
        index = (y_1 * bytesPerLine) + (x_1 >> 2);
        var offset: int = 3 - (x_1 % 4);
        while (n > 0) {
          theByte = pixels[i] & 0x3;
          data[index] = int(((data[index] & masks[offset]) | (theByte << (offset * 2))));
          i++;
          n--;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            offset = 3;
            srcX = 0;
          } else {
            if (offset == 0) {
              index++;
              offset = 3;
            } else {
              offset--;
            }
          }
        }
        return;
      case 1 :
        index = (y_1 * bytesPerLine) + (x_1 >> 3);
        while (n > 0) {
          mask = 1 << (7 - (srcX & 0x7));
          if ((pixels[i] & 0x1) == 1) {
            data[index] = int(((data[index] & 0xFF) | mask));
          } else {
            data[index] = int(((data[index] & 0xFF) & (mask ^ -1)));
          }
          i++;
          n--;
          srcX++;
          if (srcX >= width) {
            srcY++;
            index = srcY * bytesPerLine;
            srcX = 0;
          } else {
            if (mask == 1) {
              index++;
            }
          }
        }
        return;
    }
    SWT.error__I(38);
  }
  public static function bwPalette__(): PaletteData {
    return new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData___3Lorg_eclipse_swt_graphics_RGB_2, [new JavaArray("[Lorg/eclipse/swt/graphics/RGB;").values(new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [0, 0, 0])), new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [255, 255, 255])))]));
  }
  public static function getMSBOffset__I(mask: int): int {
    for (var i: int = 31; i >= 0; i--) {
      if (((mask >> i) & 0x1) != 0)
        return i + 1;
    }
    return 0;
  }
  public static function closestMatch__IBBBIII_3B_3B_3B(depth: int, red: int, green: int, blue: int, redMask: int, greenMask: int, blueMask: int, reds: JavaArray, greens: JavaArray, blues: JavaArray): int {
    if (depth > 8) {
      var rshift: int = 32 - getMSBOffset__I(redMask);
      var gshift: int = 32 - getMSBOffset__I(greenMask);
      var bshift: int = 32 - getMSBOffset__I(blueMask);
      return (((red << 24) >>> rshift) & redMask) | (((green << 24) >>> gshift) & greenMask) | (((blue << 24) >>> bshift) & blueMask);
    }
    var r: int;
    var g: int;
    var b: int;
    var minDistance: int = 0x7fffffff;
    var nearestPixel: int = 0;
    var n: int = reds.length;
    for (var j: int = 0; j < n; j++) {
      r = (reds[j] & 0xFF) - (red & 0xFF);
      g = (greens[j] & 0xFF) - (green & 0xFF);
      b = (blues[j] & 0xFF) - (blue & 0xFF);
      var distance: int = r * r + g * g + b * b;
      if (distance < minDistance) {
        nearestPixel = j;
        if (distance == 0)
          break;
        minDistance = distance;
      }
    }
    return nearestPixel;
  }
  public static function convertMask__Lorg_eclipse_swt_graphics_ImageData_2(mask: ImageData): ImageData {
    if (mask.depth == 1)
      return mask;
    var palette: PaletteData = new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData___3Lorg_eclipse_swt_graphics_RGB_2, [new JavaArray("[Lorg/eclipse/swt/graphics/RGB;").values(new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [0, 0, 0])), new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [255, 255, 255])))]));
    var newMask: ImageData = new ImageData(new Arguments(org.eclipse.swt.graphics.ImageData.ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2, [mask.width, mask.height, 1, palette]));
    var blackIndex: int = 0;
    var rgbs: JavaArray = mask.getRGBs__();
    if (rgbs !== null) {
      while (blackIndex < rgbs.length) {
        if (rgbs[blackIndex].equals__Ljava_lang_Object_2(palette.colors[0]))
          break;
        blackIndex++;
      }
    }
    var pixels: JavaArray = new JavaArray("[I").lengths(mask.width);
    for (var y: int = 0; y < mask.height; y++) {
      mask.getPixels__III_3II(0, y, mask.width, pixels, 0);
      for (var i: int = 0; i < pixels.length; i++) {
        if (pixels[i] == blackIndex) {
          pixels[i] = 0;
        } else {
          pixels[i] = 1;
        }
      }
      newMask.setPixels__III_3II(0, y, mask.width, pixels, 0);
    }
    return newMask;
  }
  public static function convertPad___3BIIIII(data: JavaArray, width: int, height: int, depth: int, pad: int, newPad: int): JavaArray {
    if (pad == newPad)
      return data;
    var stride: int = int((width * depth + 7) / 8);
    var bpl: int = int((stride + (pad - 1)) / pad) * pad;
    var newBpl: int = int((stride + (newPad - 1)) / newPad) * newPad;
    var newData: JavaArray = new JavaArray("[B").lengths(height * newBpl);
    var srcIndex: int = 0;
    var destIndex: int = 0;
    for (var y: int = 0; y < height; y++) {
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(data, srcIndex, newData, destIndex, stride);
      srcIndex += bpl;
      destIndex += newBpl;
    }
    return newData;
  }
  public static function blit__I_3BIIIIIIIIIII_3BIII_3BIIIIIIIIIIZZ(op: int, srcData: JavaArray, srcDepth: int, srcStride: int, srcOrder: int, srcX: int, srcY: int, srcWidth: int, srcHeight: int, srcRedMask: int, srcGreenMask: int, srcBlueMask: int, alphaMode: int, alphaData: JavaArray, alphaStride: int, alphaX: int, alphaY: int, destData: JavaArray, destDepth: int, destStride: int, destOrder: int, destX: int, destY: int, destWidth: int, destHeight: int, destRedMask: int, destGreenMask: int, destBlueMask: int, flipX: Boolean, flipY: Boolean): void {
    if ((destWidth <= 0) || (destHeight <= 0) || (alphaMode == 0))
      return;
    var srcAlphaMask: int = 0;
    var destAlphaMask: int = 0;
    var dwm1: int = destWidth - 1;
    var sfxi: int = (dwm1 != 0) ? int((((Number(srcWidth) << 16) - 1) / dwm1)) : 0;
    var dhm1: int = destHeight - 1;
    var sfyi: int = (dhm1 != 0) ? int((((Number(srcHeight) << 16) - 1) / dhm1)) : 0;
    var sbpp: int;
    var stype: int;
    switch (srcDepth) {
      case 8 :
        sbpp = 1;
        stype = 0;
        break;
      case 16 :
        sbpp = 2;
        stype = (srcOrder == 1) ? 1 : 2;
        break;
      case 24 :
        sbpp = 3;
        stype = 3;
        break;
      case 32 :
        sbpp = 4;
        stype = (srcOrder == 1) ? 4 : 5;
        break;
      default :
        return;
    }
    var spr: int = srcY * srcStride + srcX * sbpp;
    var dbpp: int;
    var dtype: int;
    switch (destDepth) {
      case 8 :
        dbpp = 1;
        dtype = 0;
        break;
      case 16 :
        dbpp = 2;
        dtype = (destOrder == 1) ? 1 : 2;
        break;
      case 24 :
        dbpp = 3;
        dtype = 3;
        break;
      case 32 :
        dbpp = 4;
        dtype = (destOrder == 1) ? 4 : 5;
        break;
      default :
        return;
    }
    var dpr: int = ((flipY) ? destY + dhm1 : destY) * destStride + ((flipX) ? destX + dwm1 : destX) * dbpp;
    var dprxi: int = (flipX) ? -dbpp : dbpp;
    var dpryi: int = (flipY) ? -destStride : destStride;
    var apr: int;
    if ((op & 2) != 0) {
      switch (alphaMode) {
        case -3 :
        case -1 :
          if (alphaData === null)
            alphaMode = 0x10000;
          apr = alphaY * alphaStride + alphaX;
          break;
        case -4 :
          if (alphaData === null)
            alphaMode = 0x10000;
          alphaStride <<= 3;
          apr = alphaY * alphaStride + alphaX;
          break;
        case -5 :
          return;
        case -6 :
          if (alphaData === null)
            alphaMode = 0x10000;
          apr = 0;
          break;
        default :
          alphaMode = int((alphaMode << 16) / 255);
          case -2 :
          apr = 0;
          break;
      }
    } else {
      alphaMode = 0x10000;
      apr = 0;
    }
    var dp: int = dpr;
    var sp: int = spr;
    if ((alphaMode == 0x10000) && (stype == dtype) && (srcRedMask == destRedMask) && (srcGreenMask == destGreenMask) && (srcBlueMask == destBlueMask) && (0 == 0)) {
      switch (sbpp) {
        case 1 :
          for (var dy: int = destHeight, sfy: int = sfyi; dy > 0; --dy, sp = spr += (sfy >>> 16) * srcStride, sfy = (sfy & 0xffff) + sfyi, dp = dpr += dpryi) {
            for (var dx: int = destWidth, sfx: int = sfxi; dx > 0; --dx, dp += dprxi, sfx = (sfx & 0xffff) + sfxi) {
              destData[dp] = srcData[sp];
              sp += (sfx >>> 16);
            }
          }
          break;
        case 2 :
          for (var dy_1: int = destHeight, sfy_1: int = sfyi; dy_1 > 0; --dy_1, sp = spr += (sfy_1 >>> 16) * srcStride, sfy_1 = (sfy_1 & 0xffff) + sfyi, dp = dpr += dpryi) {
            for (var dx_1: int = destWidth, sfx_1: int = sfxi; dx_1 > 0; --dx_1, dp += dprxi, sfx_1 = (sfx_1 & 0xffff) + sfxi) {
              destData[dp] = srcData[sp];
              destData[dp + 1] = srcData[sp + 1];
              sp += (sfx_1 >>> 16) * 2;
            }
          }
          break;
        case 3 :
          for (var dy_2: int = destHeight, sfy_2: int = sfyi; dy_2 > 0; --dy_2, sp = spr += (sfy_2 >>> 16) * srcStride, sfy_2 = (sfy_2 & 0xffff) + sfyi, dp = dpr += dpryi) {
            for (var dx_2: int = destWidth, sfx_2: int = sfxi; dx_2 > 0; --dx_2, dp += dprxi, sfx_2 = (sfx_2 & 0xffff) + sfxi) {
              destData[dp] = srcData[sp];
              destData[dp + 1] = srcData[sp + 1];
              destData[dp + 2] = srcData[sp + 2];
              sp += (sfx_2 >>> 16) * 3;
            }
          }
          break;
        case 4 :
          for (var dy_3: int = destHeight, sfy_3: int = sfyi; dy_3 > 0; --dy_3, sp = spr += (sfy_3 >>> 16) * srcStride, sfy_3 = (sfy_3 & 0xffff) + sfyi, dp = dpr += dpryi) {
            for (var dx_3: int = destWidth, sfx_3: int = sfxi; dx_3 > 0; --dx_3, dp += dprxi, sfx_3 = (sfx_3 & 0xffff) + sfxi) {
              destData[dp] = srcData[sp];
              destData[dp + 1] = srcData[sp + 1];
              destData[dp + 2] = srcData[sp + 2];
              destData[dp + 3] = srcData[sp + 3];
              sp += (sfx_3 >>> 16) * 4;
            }
          }
          break;
      }
      return;
    }
    var srcRedShift: int = getChannelShift__I(srcRedMask);
    var srcReds: JavaArray = ANY_TO_EIGHT[getChannelWidth__II(srcRedMask, srcRedShift)];
    var srcGreenShift: int = getChannelShift__I(srcGreenMask);
    var srcGreens: JavaArray = ANY_TO_EIGHT[getChannelWidth__II(srcGreenMask, srcGreenShift)];
    var srcBlueShift: int = getChannelShift__I(srcBlueMask);
    var srcBlues: JavaArray = ANY_TO_EIGHT[getChannelWidth__II(srcBlueMask, srcBlueShift)];
    var srcAlphaShift: int = getChannelShift__I(0);
    var srcAlphas: JavaArray = ANY_TO_EIGHT[getChannelWidth__II(0, srcAlphaShift)];
    var destRedShift: int = getChannelShift__I(destRedMask);
    var destRedWidth: int = getChannelWidth__II(destRedMask, destRedShift);
    var destReds: JavaArray = ANY_TO_EIGHT[destRedWidth];
    var destRedPreShift: int = 8 - destRedWidth;
    var destGreenShift: int = getChannelShift__I(destGreenMask);
    var destGreenWidth: int = getChannelWidth__II(destGreenMask, destGreenShift);
    var destGreens: JavaArray = ANY_TO_EIGHT[destGreenWidth];
    var destGreenPreShift: int = 8 - destGreenWidth;
    var destBlueShift: int = getChannelShift__I(destBlueMask);
    var destBlueWidth: int = getChannelWidth__II(destBlueMask, destBlueShift);
    var destBlues: JavaArray = ANY_TO_EIGHT[destBlueWidth];
    var destBluePreShift: int = 8 - destBlueWidth;
    var destAlphaShift: int = getChannelShift__I(0);
    var destAlphaWidth: int = getChannelWidth__II(0, destAlphaShift);
    var destAlphas: JavaArray = ANY_TO_EIGHT[destAlphaWidth];
    var destAlphaPreShift: int = 8 - destAlphaWidth;
    var ap: int = apr;
    var alpha: int = alphaMode;
    var r: int = 0;
    var g: int = 0;
    var b: int = 0;
    var a: int = 0;
    var rq: int = 0;
    var gq: int = 0;
    var bq: int = 0;
    var aq: int = 0;
    for (var dy_4: int = destHeight, sfy_4: int = sfyi; dy_4 > 0; --dy_4, sp = spr += (sfy_4 >>> 16) * srcStride, ap = apr += (sfy_4 >>> 16) * alphaStride, sfy_4 = (sfy_4 & 0xffff) + sfyi, dp = dpr += dpryi) {
      for (var dx_4: int = destWidth, sfx_4: int = sfxi; dx_4 > 0; --dx_4, dp += dprxi, sfx_4 = (sfx_4 & 0xffff) + sfxi) {
        switch (stype) {
          case 0 :
            {
              var data: int = srcData[sp] & 0xff;
              sp += (sfx_4 >>> 16);
              r = srcReds[(data & srcRedMask) >>> srcRedShift] & 0xff;
              g = srcGreens[(data & srcGreenMask) >>> srcGreenShift] & 0xff;
              b = srcBlues[(data & srcBlueMask) >>> srcBlueShift] & 0xff;
              a = srcAlphas[(data & 0) >>> srcAlphaShift] & 0xff;
            }
            break;
          case 1 :
            {
              var data_1: int = ((srcData[sp] & 0xff) << 8) | (srcData[sp + 1] & 0xff);
              sp += (sfx_4 >>> 16) * 2;
              r = srcReds[(data_1 & srcRedMask) >>> srcRedShift] & 0xff;
              g = srcGreens[(data_1 & srcGreenMask) >>> srcGreenShift] & 0xff;
              b = srcBlues[(data_1 & srcBlueMask) >>> srcBlueShift] & 0xff;
              a = srcAlphas[(data_1 & 0) >>> srcAlphaShift] & 0xff;
            }
            break;
          case 2 :
            {
              var data_2: int = ((srcData[sp + 1] & 0xff) << 8) | (srcData[sp] & 0xff);
              sp += (sfx_4 >>> 16) * 2;
              r = srcReds[(data_2 & srcRedMask) >>> srcRedShift] & 0xff;
              g = srcGreens[(data_2 & srcGreenMask) >>> srcGreenShift] & 0xff;
              b = srcBlues[(data_2 & srcBlueMask) >>> srcBlueShift] & 0xff;
              a = srcAlphas[(data_2 & 0) >>> srcAlphaShift] & 0xff;
            }
            break;
          case 3 :
            {
              var data_3: int = ((((srcData[sp] & 0xff) << 8) | (srcData[sp + 1] & 0xff)) << 8) | (srcData[sp + 2] & 0xff);
              sp += (sfx_4 >>> 16) * 3;
              r = srcReds[(data_3 & srcRedMask) >>> srcRedShift] & 0xff;
              g = srcGreens[(data_3 & srcGreenMask) >>> srcGreenShift] & 0xff;
              b = srcBlues[(data_3 & srcBlueMask) >>> srcBlueShift] & 0xff;
              a = srcAlphas[(data_3 & 0) >>> srcAlphaShift] & 0xff;
            }
            break;
          case 4 :
            {
              var data_4: int = ((((((srcData[sp] & 0xff) << 8) | (srcData[sp + 1] & 0xff)) << 8) | (srcData[sp + 2] & 0xff)) << 8) | (srcData[sp + 3] & 0xff);
              sp += (sfx_4 >>> 16) * 4;
              r = srcReds[(data_4 & srcRedMask) >>> srcRedShift] & 0xff;
              g = srcGreens[(data_4 & srcGreenMask) >>> srcGreenShift] & 0xff;
              b = srcBlues[(data_4 & srcBlueMask) >>> srcBlueShift] & 0xff;
              a = srcAlphas[(data_4 & 0) >>> srcAlphaShift] & 0xff;
            }
            break;
          case 5 :
            {
              var data_5: int = ((((((srcData[sp + 3] & 0xff) << 8) | (srcData[sp + 2] & 0xff)) << 8) | (srcData[sp + 1] & 0xff)) << 8) | (srcData[sp] & 0xff);
              sp += (sfx_4 >>> 16) * 4;
              r = srcReds[(data_5 & srcRedMask) >>> srcRedShift] & 0xff;
              g = srcGreens[(data_5 & srcGreenMask) >>> srcGreenShift] & 0xff;
              b = srcBlues[(data_5 & srcBlueMask) >>> srcBlueShift] & 0xff;
              a = srcAlphas[(data_5 & 0) >>> srcAlphaShift] & 0xff;
            }
            break;
        }
        switch (alphaMode) {
          case -1 :
            alpha = int(((alphaData[ap] & 0xff) << 16) / 255);
            ap += (sfx_4 >> 16);
            break;
          case -2 :
            alpha = int((a << 16) / 255);
            break;
          case -3 :
            alpha = (alphaData[ap] != 0) ? 0x10000 : 0;
            ap += (sfx_4 >> 16);
            break;
          case -4 :
            alpha = (alphaData[ap >> 3] << ((ap & 7) + 9)) & 0x10000;
            ap += (sfx_4 >> 16);
            break;
          case -6 :
            alpha = 0x10000;
            for (var i: int = 0; i < alphaData.length; i += 3) {
              if ((r == alphaData[i]) && (g == alphaData[i + 1]) && (b == alphaData[i + 2])) {
                alpha = 0x0000;
                break;
              }
            }
            break;
        }
        if (alpha != 0x10000) {
          if (alpha == 0x0000)
            continue;
          switch (dtype) {
            case 0 :
              {
                var data_6: int = destData[dp] & 0xff;
                rq = destReds[(data_6 & destRedMask) >>> destRedShift] & 0xff;
                gq = destGreens[(data_6 & destGreenMask) >>> destGreenShift] & 0xff;
                bq = destBlues[(data_6 & destBlueMask) >>> destBlueShift] & 0xff;
                aq = destAlphas[(data_6 & 0) >>> destAlphaShift] & 0xff;
              }
              break;
            case 1 :
              {
                var data_7: int = ((destData[dp] & 0xff) << 8) | (destData[dp + 1] & 0xff);
                rq = destReds[(data_7 & destRedMask) >>> destRedShift] & 0xff;
                gq = destGreens[(data_7 & destGreenMask) >>> destGreenShift] & 0xff;
                bq = destBlues[(data_7 & destBlueMask) >>> destBlueShift] & 0xff;
                aq = destAlphas[(data_7 & 0) >>> destAlphaShift] & 0xff;
              }
              break;
            case 2 :
              {
                var data_8: int = ((destData[dp + 1] & 0xff) << 8) | (destData[dp] & 0xff);
                rq = destReds[(data_8 & destRedMask) >>> destRedShift] & 0xff;
                gq = destGreens[(data_8 & destGreenMask) >>> destGreenShift] & 0xff;
                bq = destBlues[(data_8 & destBlueMask) >>> destBlueShift] & 0xff;
                aq = destAlphas[(data_8 & 0) >>> destAlphaShift] & 0xff;
              }
              break;
            case 3 :
              {
                var data_9: int = ((((destData[dp] & 0xff) << 8) | (destData[dp + 1] & 0xff)) << 8) | (destData[dp + 2] & 0xff);
                rq = destReds[(data_9 & destRedMask) >>> destRedShift] & 0xff;
                gq = destGreens[(data_9 & destGreenMask) >>> destGreenShift] & 0xff;
                bq = destBlues[(data_9 & destBlueMask) >>> destBlueShift] & 0xff;
                aq = destAlphas[(data_9 & 0) >>> destAlphaShift] & 0xff;
              }
              break;
            case 4 :
              {
                var data_10: int = ((((((destData[dp] & 0xff) << 8) | (destData[dp + 1] & 0xff)) << 8) | (destData[dp + 2] & 0xff)) << 8) | (destData[dp + 3] & 0xff);
                rq = destReds[(data_10 & destRedMask) >>> destRedShift] & 0xff;
                gq = destGreens[(data_10 & destGreenMask) >>> destGreenShift] & 0xff;
                bq = destBlues[(data_10 & destBlueMask) >>> destBlueShift] & 0xff;
                aq = destAlphas[(data_10 & 0) >>> destAlphaShift] & 0xff;
              }
              break;
            case 5 :
              {
                var data_11: int = ((((((destData[dp + 3] & 0xff) << 8) | (destData[dp + 2] & 0xff)) << 8) | (destData[dp + 1] & 0xff)) << 8) | (destData[dp] & 0xff);
                rq = destReds[(data_11 & destRedMask) >>> destRedShift] & 0xff;
                gq = destGreens[(data_11 & destGreenMask) >>> destGreenShift] & 0xff;
                bq = destBlues[(data_11 & destBlueMask) >>> destBlueShift] & 0xff;
                aq = destAlphas[(data_11 & 0) >>> destAlphaShift] & 0xff;
              }
              break;
          }
          a = aq + ((a - aq) * alpha >> 16);
          r = rq + ((r - rq) * alpha >> 16);
          g = gq + ((g - gq) * alpha >> 16);
          b = bq + ((b - bq) * alpha >> 16);
        }
        var data_12: int = (r >>> destRedPreShift << destRedShift) | (g >>> destGreenPreShift << destGreenShift) | (b >>> destBluePreShift << destBlueShift) | (a >>> destAlphaPreShift << destAlphaShift);
        switch (dtype) {
          case 0 :
            {
              destData[dp] = int(data_12);
            }
            break;
          case 1 :
            {
              destData[dp] = int((data_12 >>> 8));
              destData[dp + 1] = int((data_12 & 0xff));
            }
            break;
          case 2 :
            {
              destData[dp] = int((data_12 & 0xff));
              destData[dp + 1] = int((data_12 >>> 8));
            }
            break;
          case 3 :
            {
              destData[dp] = int((data_12 >>> 16));
              destData[dp + 1] = int((data_12 >>> 8));
              destData[dp + 2] = int((data_12 & 0xff));
            }
            break;
          case 4 :
            {
              destData[dp] = int((data_12 >>> 24));
              destData[dp + 1] = int((data_12 >>> 16));
              destData[dp + 2] = int((data_12 >>> 8));
              destData[dp + 3] = int((data_12 & 0xff));
            }
            break;
          case 5 :
            {
              destData[dp] = int((data_12 & 0xff));
              destData[dp + 1] = int((data_12 >>> 8));
              destData[dp + 2] = int((data_12 >>> 16));
              destData[dp + 3] = int((data_12 >>> 24));
            }
            break;
        }
      }
    }
    return;
  }
  public static function blit__I_3BIIIIIII_3B_3B_3BI_3BIII_3BIIIIIII_3B_3B_3BZZ(op: int, srcData: JavaArray, srcDepth: int, srcStride: int, srcOrder: int, srcX: int, srcY: int, srcWidth: int, srcHeight: int, srcReds: JavaArray, srcGreens: JavaArray, srcBlues: JavaArray, alphaMode: int, alphaData: JavaArray, alphaStride: int, alphaX: int, alphaY: int, destData: JavaArray, destDepth: int, destStride: int, destOrder: int, destX: int, destY: int, destWidth: int, destHeight: int, destReds: JavaArray, destGreens: JavaArray, destBlues: JavaArray, flipX: Boolean, flipY: Boolean): void {
    if ((destWidth <= 0) || (destHeight <= 0) || (alphaMode == 0))
      return;
    var dwm1: int = destWidth - 1;
    var sfxi: int = (dwm1 != 0) ? int((((Number(srcWidth) << 16) - 1) / dwm1)) : 0;
    var dhm1: int = destHeight - 1;
    var sfyi: int = (dhm1 != 0) ? int((((Number(srcHeight) << 16) - 1) / dhm1)) : 0;
    var stype: int;
    switch (srcDepth) {
      case 8 :
        stype = 6;
        break;
      case 4 :
        srcStride <<= 1;
        stype = 7;
        break;
      case 2 :
        srcStride <<= 2;
        stype = 8;
        break;
      case 1 :
        srcStride <<= 3;
        stype = (srcOrder == 1) ? 9 : 10;
        break;
      default :
        return;
    }
    var spr: int = srcY * srcStride + srcX;
    var dtype: int;
    switch (destDepth) {
      case 8 :
        dtype = 6;
        break;
      case 4 :
        destStride <<= 1;
        dtype = 7;
        break;
      case 2 :
        destStride <<= 2;
        dtype = 8;
        break;
      case 1 :
        destStride <<= 3;
        dtype = (destOrder == 1) ? 9 : 10;
        break;
      default :
        return;
    }
    var dpr: int = ((flipY) ? destY + dhm1 : destY) * destStride + ((flipX) ? destX + dwm1 : destX);
    var dprxi: int = (flipX) ? -1 : 1;
    var dpryi: int = (flipY) ? -destStride : destStride;
    var apr: int;
    if ((op & 2) != 0) {
      switch (alphaMode) {
        case -3 :
        case -1 :
          if (alphaData === null)
            alphaMode = 0x10000;
          apr = alphaY * alphaStride + alphaX;
          break;
        case -4 :
          if (alphaData === null)
            alphaMode = 0x10000;
          alphaStride <<= 3;
          apr = alphaY * alphaStride + alphaX;
          break;
        case -5 :
        case -6 :
          if (alphaData === null)
            alphaMode = 0x10000;
          apr = 0;
          break;
        default :
          alphaMode = int((alphaMode << 16) / 255);
          case -2 :
          apr = 0;
          break;
      }
    } else {
      alphaMode = 0x10000;
      apr = 0;
    }
    var ditherEnabled: Boolean = (op & 4) != 0;
    var dp: int = dpr;
    var sp: int = spr;
    var ap: int = apr;
    var destPaletteSize: int = 1 << destDepth;
    if ((destReds !== null) && (destReds.length < destPaletteSize))
      destPaletteSize = destReds.length;
    var paletteMapping: JavaArray = null;
    var isExactPaletteMapping: Boolean = true;
    switch (alphaMode) {
      case 0x10000 :
        if ((stype == dtype) && (srcReds === destReds) && (srcGreens === destGreens) && (srcBlues === destBlues)) {
          paletteMapping = ONE_TO_ONE_MAPPING;
          break;
        } else if ((srcReds === null) || (destReds === null)) {
          if (srcDepth <= destDepth) {
            paletteMapping = ONE_TO_ONE_MAPPING;
          } else {
            paletteMapping = new JavaArray("[B").lengths(1 << srcDepth);
            var mask: int = (0xff << destDepth) >>> 8;
            for (var i: int = 0; i < paletteMapping.length; ++i)
              paletteMapping[i] = int((i & mask));
          }
          break;
        }
      case -3 :
      case -4 :
      case -5 :
      case -6 :
        var srcPaletteSize: int = 1 << srcDepth;
        paletteMapping = new JavaArray("[B").lengths(srcPaletteSize);
        if ((srcReds !== null) && (srcReds.length < srcPaletteSize))
          srcPaletteSize = srcReds.length;
        for (var i_1: int = 0, r: int, g: int, b: int, index: int; i_1 < srcPaletteSize; ++i_1) {
          r = srcReds[i_1] & 0xff;
          g = srcGreens[i_1] & 0xff;
          b = srcBlues[i_1] & 0xff;
          index = 0;
          var minDistance: int = 0x7fffffff;
          for (var j: int = 0, dr: int, dg: int, db: int, distance: int; j < destPaletteSize; ++j) {
            dr = (destReds[j] & 0xff) - r;
            dg = (destGreens[j] & 0xff) - g;
            db = (destBlues[j] & 0xff) - b;
            distance = dr * dr + dg * dg + db * db;
            if (distance < minDistance) {
              index = j;
              if (distance == 0)
                break;
              minDistance = distance;
            }
          }
          paletteMapping[i_1] = int(index);
          if (minDistance != 0)
            isExactPaletteMapping = false;
        }
        break;
    }
    if ((paletteMapping !== null) && (isExactPaletteMapping || !ditherEnabled)) {
      if ((stype == dtype) && (alphaMode == 0x10000)) {
        switch (stype) {
          case 6 :
            for (var dy: int = destHeight, sfy: int = sfyi; dy > 0; --dy, sp = spr += (sfy >>> 16) * srcStride, sfy = (sfy & 0xffff) + sfyi, dp = dpr += dpryi) {
              for (var dx: int = destWidth, sfx: int = sfxi; dx > 0; --dx, dp += dprxi, sfx = (sfx & 0xffff) + sfxi) {
                destData[dp] = paletteMapping[srcData[sp] & 0xff];
                sp += (sfx >>> 16);
              }
            }
            break;
          case 7 :
            for (var dy_1: int = destHeight, sfy_1: int = sfyi; dy_1 > 0; --dy_1, sp = spr += (sfy_1 >>> 16) * srcStride, sfy_1 = (sfy_1 & 0xffff) + sfyi, dp = dpr += dpryi) {
              for (var dx_1: int = destWidth, sfx_1: int = sfxi; dx_1 > 0; --dx_1, dp += dprxi, sfx_1 = (sfx_1 & 0xffff) + sfxi) {
                var v: int;
                if ((sp & 1) != 0)
                  v = paletteMapping[srcData[sp >> 1] & 0x0f];
                else
                  v = (srcData[sp >> 1] >>> 4) & 0x0f;
                sp += (sfx_1 >>> 16);
                if ((dp & 1) != 0)
                  destData[dp >> 1] = int(((destData[dp >> 1] & 0xf0) | v));
                else
                  destData[dp >> 1] = int(((destData[dp >> 1] & 0x0f) | (v << 4)));
              }
            }
            break;
          case 8 :
            for (var dy_2: int = destHeight, sfy_2: int = sfyi; dy_2 > 0; --dy_2, sp = spr += (sfy_2 >>> 16) * srcStride, sfy_2 = (sfy_2 & 0xffff) + sfyi, dp = dpr += dpryi) {
              for (var dx_2: int = destWidth, sfx_2: int = sfxi; dx_2 > 0; --dx_2, dp += dprxi, sfx_2 = (sfx_2 & 0xffff) + sfxi) {
                var index_1: int = paletteMapping[(srcData[sp >> 2] >>> (6 - (sp & 3) * 2)) & 0x03];
                sp += (sfx_2 >>> 16);
                var shift: int = 6 - (dp & 3) * 2;
                destData[dp >> 2] = int((destData[dp >> 2] & ~(0x03 << shift) | (index_1 << shift)));
              }
            }
            break;
          case 9 :
            for (var dy_3: int = destHeight, sfy_3: int = sfyi; dy_3 > 0; --dy_3, sp = spr += (sfy_3 >>> 16) * srcStride, sfy_3 = (sfy_3 & 0xffff) + sfyi, dp = dpr += dpryi) {
              for (var dx_3: int = destWidth, sfx_3: int = sfxi; dx_3 > 0; --dx_3, dp += dprxi, sfx_3 = (sfx_3 & 0xffff) + sfxi) {
                var index_2: int = paletteMapping[(srcData[sp >> 3] >>> (7 - (sp & 7))) & 0x01];
                sp += (sfx_3 >>> 16);
                var shift_1: int = 7 - (dp & 7);
                destData[dp >> 3] = int((destData[dp >> 3] & ~(0x01 << shift_1) | (index_2 << shift_1)));
              }
            }
            break;
          case 10 :
            for (var dy_4: int = destHeight, sfy_4: int = sfyi; dy_4 > 0; --dy_4, sp = spr += (sfy_4 >>> 16) * srcStride, sfy_4 = (sfy_4 & 0xffff) + sfyi, dp = dpr += dpryi) {
              for (var dx_4: int = destWidth, sfx_4: int = sfxi; dx_4 > 0; --dx_4, dp += dprxi, sfx_4 = (sfx_4 & 0xffff) + sfxi) {
                var index_3: int = paletteMapping[(srcData[sp >> 3] >>> (sp & 7)) & 0x01];
                sp += (sfx_4 >>> 16);
                var shift_2: int = dp & 7;
                destData[dp >> 3] = int((destData[dp >> 3] & ~(0x01 << shift_2) | (index_3 << shift_2)));
              }
            }
            break;
        }
      } else {
        for (var dy_5: int = destHeight, sfy_5: int = sfyi; dy_5 > 0; --dy_5, sp = spr += (sfy_5 >>> 16) * srcStride, sfy_5 = (sfy_5 & 0xffff) + sfyi, dp = dpr += dpryi) {
          for (var dx_5: int = destWidth, sfx_5: int = sfxi; dx_5 > 0; --dx_5, dp += dprxi, sfx_5 = (sfx_5 & 0xffff) + sfxi) {
            var index_4: int;
            switch (stype) {
              case 6 :
                index_4 = srcData[sp] & 0xff;
                sp += (sfx_5 >>> 16);
                break;
              case 7 :
                if ((sp & 1) != 0)
                  index_4 = srcData[sp >> 1] & 0x0f;
                else
                  index_4 = (srcData[sp >> 1] >>> 4) & 0x0f;
                sp += (sfx_5 >>> 16);
                break;
              case 8 :
                index_4 = (srcData[sp >> 2] >>> (6 - (sp & 3) * 2)) & 0x03;
                sp += (sfx_5 >>> 16);
                break;
              case 9 :
                index_4 = (srcData[sp >> 3] >>> (7 - (sp & 7))) & 0x01;
                sp += (sfx_5 >>> 16);
                break;
              case 10 :
                index_4 = (srcData[sp >> 3] >>> (sp & 7)) & 0x01;
                sp += (sfx_5 >>> 16);
                break;
              default :
                return;
            }
            switch (alphaMode) {
              case -3 :
                {
                  var mask_1: int = alphaData[ap];
                  ap += (sfx_5 >> 16);
                  if (mask_1 == 0)
                    continue;
                }
                break;
              case -4 :
                {
                  var mask_2: int = alphaData[ap >> 3] & (1 << (ap & 7));
                  ap += (sfx_5 >> 16);
                  if (mask_2 == 0)
                    continue;
                }
                break;
              case -5 :
                {
                  var i_2: int = 0;
                  while (i_2 < alphaData.length) {
                    if (index_4 == (alphaData[i_2] & 0xff))
                      break;
                  }
                  if (i_2 < alphaData.length)
                    continue;
                }
                break;
              case -6 :
                {
                  var r_1: int = srcReds[index_4];
                  var g_1: int = srcGreens[index_4];
                  var b_1: int = srcBlues[index_4];
                  var i_3: int = 0;
                  while (i_3 < alphaData.length) {
                    if ((r_1 == alphaData[i_3]) && (g_1 == alphaData[i_3 + 1]) && (b_1 == alphaData[i_3 + 2]))
                      break;
                    i_3 += 3;
                  }
                  if (i_3 < alphaData.length)
                    continue;
                }
                break;
            }
            index_4 = paletteMapping[index_4] & 0xff;
            switch (dtype) {
              case 6 :
                destData[dp] = int(index_4);
                break;
              case 7 :
                if ((dp & 1) != 0)
                  destData[dp >> 1] = int(((destData[dp >> 1] & 0xf0) | index_4));
                else
                  destData[dp >> 1] = int(((destData[dp >> 1] & 0x0f) | (index_4 << 4)));
                break;
              case 8 :
                {
                  var shift_3: int = 6 - (dp & 3) * 2;
                  destData[dp >> 2] = int((destData[dp >> 2] & ~(0x03 << shift_3) | (index_4 << shift_3)));
                }
                break;
              case 9 :
                {
                  var shift_4: int = 7 - (dp & 7);
                  destData[dp >> 3] = int((destData[dp >> 3] & ~(0x01 << shift_4) | (index_4 << shift_4)));
                }
                break;
              case 10 :
                {
                  var shift_5: int = dp & 7;
                  destData[dp >> 3] = int((destData[dp >> 3] & ~(0x01 << shift_5) | (index_4 << shift_5)));
                }
                break;
            }
          }
        }
      }
      return;
    }
    var alpha: int = alphaMode;
    var index_5: int = 0;
    var indexq: int = 0;
    var lastindex: int = 0;
    var lastr: int = -1;
    var lastg: int = -1;
    var lastb: int = -1;
    var rerr: JavaArray;
    var gerr: JavaArray;
    var berr: JavaArray;
    if (ditherEnabled) {
      rerr = new JavaArray("[I").lengths(destWidth + 2);
      gerr = new JavaArray("[I").lengths(destWidth + 2);
      berr = new JavaArray("[I").lengths(destWidth + 2);
    } else {
      rerr = null;
      gerr = null;
      berr = null;
    }
    for (var dy_6: int = destHeight, sfy_6: int = sfyi; dy_6 > 0; --dy_6, sp = spr += (sfy_6 >>> 16) * srcStride, ap = apr += (sfy_6 >>> 16) * alphaStride, sfy_6 = (sfy_6 & 0xffff) + sfyi, dp = dpr += dpryi) {
      var lrerr: int = 0;
      var lgerr: int = 0;
      var lberr: int = 0;
      for (var dx_6: int = destWidth, sfx_6: int = sfxi; dx_6 > 0; --dx_6, dp += dprxi, sfx_6 = (sfx_6 & 0xffff) + sfxi) {
        switch (stype) {
          case 6 :
            index_5 = srcData[sp] & 0xff;
            sp += (sfx_6 >>> 16);
            break;
          case 7 :
            if ((sp & 1) != 0)
              index_5 = srcData[sp >> 1] & 0x0f;
            else
              index_5 = (srcData[sp >> 1] >>> 4) & 0x0f;
            sp += (sfx_6 >>> 16);
            break;
          case 8 :
            index_5 = (srcData[sp >> 2] >>> (6 - (sp & 3) * 2)) & 0x03;
            sp += (sfx_6 >>> 16);
            break;
          case 9 :
            index_5 = (srcData[sp >> 3] >>> (7 - (sp & 7))) & 0x01;
            sp += (sfx_6 >>> 16);
            break;
          case 10 :
            index_5 = (srcData[sp >> 3] >>> (sp & 7)) & 0x01;
            sp += (sfx_6 >>> 16);
            break;
        }
        var r_2: int = srcReds[index_5] & 0xff;
        var g_2: int = srcGreens[index_5] & 0xff;
        var b_2: int = srcBlues[index_5] & 0xff;
        switch (alphaMode) {
          case -1 :
            alpha = int(((alphaData[ap] & 0xff) << 16) / 255);
            ap += (sfx_6 >> 16);
            break;
          case -3 :
            alpha = (alphaData[ap] != 0) ? 0x10000 : 0;
            ap += (sfx_6 >> 16);
            break;
          case -4 :
            alpha = (alphaData[ap >> 3] << ((ap & 7) + 9)) & 0x10000;
            ap += (sfx_6 >> 16);
            break;
          case -5 :
            {
              var i_4: int = 0;
              while (i_4 < alphaData.length) {
                if (index_5 == (alphaData[i_4] & 0xff))
                  break;
              }
              if (i_4 < alphaData.length)
                continue;
            }
            break;
          case -6 :
            {
              var i_5: int = 0;
              while (i_5 < alphaData.length) {
                if ((r_2 == (alphaData[i_5] & 0xff)) && (g_2 == (alphaData[i_5 + 1] & 0xff)) && (b_2 == (alphaData[i_5 + 2] & 0xff)))
                  break;
                i_5 += 3;
              }
              if (i_5 < alphaData.length)
                continue;
            }
            break;
        }
        if (alpha != 0x10000) {
          if (alpha == 0x0000)
            continue;
          switch (dtype) {
            case 6 :
              indexq = destData[dp] & 0xff;
              break;
            case 7 :
              if ((dp & 1) != 0)
                indexq = destData[dp >> 1] & 0x0f;
              else
                indexq = (destData[dp >> 1] >>> 4) & 0x0f;
              break;
            case 8 :
              indexq = (destData[dp >> 2] >>> (6 - (dp & 3) * 2)) & 0x03;
              break;
            case 9 :
              indexq = (destData[dp >> 3] >>> (7 - (dp & 7))) & 0x01;
              break;
            case 10 :
              indexq = (destData[dp >> 3] >>> (dp & 7)) & 0x01;
              break;
          }
          var rq: int = destReds[indexq] & 0xff;
          var gq: int = destGreens[indexq] & 0xff;
          var bq: int = destBlues[indexq] & 0xff;
          r_2 = rq + ((r_2 - rq) * alpha >> 16);
          g_2 = gq + ((g_2 - gq) * alpha >> 16);
          b_2 = bq + ((b_2 - bq) * alpha >> 16);
        }
        if (ditherEnabled) {
          r_2 += rerr[dx_6] >> 4;
          if (r_2 < 0)
            r_2 = 0;
          else if (r_2 > 255)
            r_2 = 255;
          g_2 += gerr[dx_6] >> 4;
          if (g_2 < 0)
            g_2 = 0;
          else if (g_2 > 255)
            g_2 = 255;
          b_2 += berr[dx_6] >> 4;
          if (b_2 < 0)
            b_2 = 0;
          else if (b_2 > 255)
            b_2 = 255;
          rerr[dx_6] = lrerr;
          gerr[dx_6] = lgerr;
          berr[dx_6] = lberr;
        }
        if (r_2 != lastr || g_2 != lastg || b_2 != lastb) {
          for (var j_1: int = 0, dr_1: int, dg_1: int, db_1: int, distance_1: int, minDistance_1: int = 0x7fffffff; j_1 < destPaletteSize; ++j_1) {
            dr_1 = (destReds[j_1] & 0xff) - r_2;
            dg_1 = (destGreens[j_1] & 0xff) - g_2;
            db_1 = (destBlues[j_1] & 0xff) - b_2;
            distance_1 = dr_1 * dr_1 + dg_1 * dg_1 + db_1 * db_1;
            if (distance_1 < minDistance_1) {
              lastindex = j_1;
              if (distance_1 == 0)
                break;
              minDistance_1 = distance_1;
            }
          }
          lastr = r_2;
          lastg = g_2;
          lastb = b_2;
        }
        if (ditherEnabled) {
          var dxm1: int = dx_6 - 1;
          var dxp1: int = dx_6 + 1;
          var acc: int;
          rerr[dxp1] += acc = (lrerr = r_2 - (destReds[lastindex] & 0xff)) + lrerr + lrerr;
          rerr[dx_6] += acc += lrerr + lrerr;
          rerr[dxm1] += acc + lrerr + lrerr;
          gerr[dxp1] += acc = (lgerr = g_2 - (destGreens[lastindex] & 0xff)) + lgerr + lgerr;
          gerr[dx_6] += acc += lgerr + lgerr;
          gerr[dxm1] += acc + lgerr + lgerr;
          berr[dxp1] += acc = (lberr = b_2 - (destBlues[lastindex] & 0xff)) + lberr + lberr;
          berr[dx_6] += acc += lberr + lberr;
          berr[dxm1] += acc + lberr + lberr;
        }
        switch (dtype) {
          case 6 :
            destData[dp] = int(lastindex);
            break;
          case 7 :
            if ((dp & 1) != 0)
              destData[dp >> 1] = int(((destData[dp >> 1] & 0xf0) | lastindex));
            else
              destData[dp >> 1] = int(((destData[dp >> 1] & 0x0f) | (lastindex << 4)));
            break;
          case 8 :
            {
              var shift_6: int = 6 - (dp & 3) * 2;
              destData[dp >> 2] = int((destData[dp >> 2] & ~(0x03 << shift_6) | (lastindex << shift_6)));
            }
            break;
          case 9 :
            {
              var shift_7: int = 7 - (dp & 7);
              destData[dp >> 3] = int((destData[dp >> 3] & ~(0x01 << shift_7) | (lastindex << shift_7)));
            }
            break;
          case 10 :
            {
              var shift_8: int = dp & 7;
              destData[dp >> 3] = int((destData[dp >> 3] & ~(0x01 << shift_8) | (lastindex << shift_8)));
            }
            break;
        }
      }
    }
    return;
  }
  public static function blit__I_3BIIIIIII_3B_3B_3BI_3BIII_3BIIIIIIIIIIZZ(op: int, srcData: JavaArray, srcDepth: int, srcStride: int, srcOrder: int, srcX: int, srcY: int, srcWidth: int, srcHeight: int, srcReds: JavaArray, srcGreens: JavaArray, srcBlues: JavaArray, alphaMode: int, alphaData: JavaArray, alphaStride: int, alphaX: int, alphaY: int, destData: JavaArray, destDepth: int, destStride: int, destOrder: int, destX: int, destY: int, destWidth: int, destHeight: int, destRedMask: int, destGreenMask: int, destBlueMask: int, flipX: Boolean, flipY: Boolean): void {
    if ((destWidth <= 0) || (destHeight <= 0) || (alphaMode == 0))
      return;
    var destAlphaMask: int = 0;
    var dwm1: int = destWidth - 1;
    var sfxi: int = (dwm1 != 0) ? int((((Number(srcWidth) << 16) - 1) / dwm1)) : 0;
    var dhm1: int = destHeight - 1;
    var sfyi: int = (dhm1 != 0) ? int((((Number(srcHeight) << 16) - 1) / dhm1)) : 0;
    var stype: int;
    switch (srcDepth) {
      case 8 :
        stype = 6;
        break;
      case 4 :
        srcStride <<= 1;
        stype = 7;
        break;
      case 2 :
        srcStride <<= 2;
        stype = 8;
        break;
      case 1 :
        srcStride <<= 3;
        stype = (srcOrder == 1) ? 9 : 10;
        break;
      default :
        return;
    }
    var spr: int = srcY * srcStride + srcX;
    var dbpp: int;
    var dtype: int;
    switch (destDepth) {
      case 8 :
        dbpp = 1;
        dtype = 0;
        break;
      case 16 :
        dbpp = 2;
        dtype = (destOrder == 1) ? 1 : 2;
        break;
      case 24 :
        dbpp = 3;
        dtype = 3;
        break;
      case 32 :
        dbpp = 4;
        dtype = (destOrder == 1) ? 4 : 5;
        break;
      default :
        return;
    }
    var dpr: int = ((flipY) ? destY + dhm1 : destY) * destStride + ((flipX) ? destX + dwm1 : destX) * dbpp;
    var dprxi: int = (flipX) ? -dbpp : dbpp;
    var dpryi: int = (flipY) ? -destStride : destStride;
    var apr: int;
    if ((op & 2) != 0) {
      switch (alphaMode) {
        case -3 :
        case -1 :
          if (alphaData === null)
            alphaMode = 0x10000;
          apr = alphaY * alphaStride + alphaX;
          break;
        case -4 :
          if (alphaData === null)
            alphaMode = 0x10000;
          alphaStride <<= 3;
          apr = alphaY * alphaStride + alphaX;
          break;
        case -5 :
        case -6 :
          if (alphaData === null)
            alphaMode = 0x10000;
          apr = 0;
          break;
        default :
          alphaMode = int((alphaMode << 16) / 255);
          case -2 :
          apr = 0;
          break;
      }
    } else {
      alphaMode = 0x10000;
      apr = 0;
    }
    var destRedShift: int = getChannelShift__I(destRedMask);
    var destRedWidth: int = getChannelWidth__II(destRedMask, destRedShift);
    var destReds: JavaArray = ANY_TO_EIGHT[destRedWidth];
    var destRedPreShift: int = 8 - destRedWidth;
    var destGreenShift: int = getChannelShift__I(destGreenMask);
    var destGreenWidth: int = getChannelWidth__II(destGreenMask, destGreenShift);
    var destGreens: JavaArray = ANY_TO_EIGHT[destGreenWidth];
    var destGreenPreShift: int = 8 - destGreenWidth;
    var destBlueShift: int = getChannelShift__I(destBlueMask);
    var destBlueWidth: int = getChannelWidth__II(destBlueMask, destBlueShift);
    var destBlues: JavaArray = ANY_TO_EIGHT[destBlueWidth];
    var destBluePreShift: int = 8 - destBlueWidth;
    var destAlphaShift: int = getChannelShift__I(0);
    var destAlphaWidth: int = getChannelWidth__II(0, destAlphaShift);
    var destAlphas: JavaArray = ANY_TO_EIGHT[destAlphaWidth];
    var destAlphaPreShift: int = 8 - destAlphaWidth;
    var dp: int = dpr;
    var sp: int = spr;
    var ap: int = apr;
    var alpha: int = alphaMode;
    var r: int = 0;
    var g: int = 0;
    var b: int = 0;
    var a: int = 0;
    var index: int = 0;
    var rq: int = 0;
    var gq: int = 0;
    var bq: int = 0;
    var aq: int = 0;
    for (var dy: int = destHeight, sfy: int = sfyi; dy > 0; --dy, sp = spr += (sfy >>> 16) * srcStride, ap = apr += (sfy >>> 16) * alphaStride, sfy = (sfy & 0xffff) + sfyi, dp = dpr += dpryi) {
      for (var dx: int = destWidth, sfx: int = sfxi; dx > 0; --dx, dp += dprxi, sfx = (sfx & 0xffff) + sfxi) {
        switch (stype) {
          case 6 :
            index = srcData[sp] & 0xff;
            sp += (sfx >>> 16);
            break;
          case 7 :
            if ((sp & 1) != 0)
              index = srcData[sp >> 1] & 0x0f;
            else
              index = (srcData[sp >> 1] >>> 4) & 0x0f;
            sp += (sfx >>> 16);
            break;
          case 8 :
            index = (srcData[sp >> 2] >>> (6 - (sp & 3) * 2)) & 0x03;
            sp += (sfx >>> 16);
            break;
          case 9 :
            index = (srcData[sp >> 3] >>> (7 - (sp & 7))) & 0x01;
            sp += (sfx >>> 16);
            break;
          case 10 :
            index = (srcData[sp >> 3] >>> (sp & 7)) & 0x01;
            sp += (sfx >>> 16);
            break;
        }
        r = srcReds[index] & 0xff;
        g = srcGreens[index] & 0xff;
        b = srcBlues[index] & 0xff;
        switch (alphaMode) {
          case -1 :
            alpha = int(((alphaData[ap] & 0xff) << 16) / 255);
            ap += (sfx >> 16);
            break;
          case -3 :
            alpha = (alphaData[ap] != 0) ? 0x10000 : 0;
            ap += (sfx >> 16);
            break;
          case -4 :
            alpha = (alphaData[ap >> 3] << ((ap & 7) + 9)) & 0x10000;
            ap += (sfx >> 16);
            break;
          case -5 :
            {
              var i: int = 0;
              while (i < alphaData.length) {
                if (index == (alphaData[i] & 0xff))
                  break;
              }
              if (i < alphaData.length)
                continue;
            }
            break;
          case -6 :
            {
              var i_1: int = 0;
              while (i_1 < alphaData.length) {
                if ((r == (alphaData[i_1] & 0xff)) && (g == (alphaData[i_1 + 1] & 0xff)) && (b == (alphaData[i_1 + 2] & 0xff)))
                  break;
                i_1 += 3;
              }
              if (i_1 < alphaData.length)
                continue;
            }
            break;
        }
        if (alpha != 0x10000) {
          if (alpha == 0x0000)
            continue;
          switch (dtype) {
            case 0 :
              {
                var data: int = destData[dp] & 0xff;
                rq = destReds[(data & destRedMask) >>> destRedShift] & 0xff;
                gq = destGreens[(data & destGreenMask) >>> destGreenShift] & 0xff;
                bq = destBlues[(data & destBlueMask) >>> destBlueShift] & 0xff;
                aq = destAlphas[(data & 0) >>> destAlphaShift] & 0xff;
              }
              break;
            case 1 :
              {
                var data_1: int = ((destData[dp] & 0xff) << 8) | (destData[dp + 1] & 0xff);
                rq = destReds[(data_1 & destRedMask) >>> destRedShift] & 0xff;
                gq = destGreens[(data_1 & destGreenMask) >>> destGreenShift] & 0xff;
                bq = destBlues[(data_1 & destBlueMask) >>> destBlueShift] & 0xff;
                aq = destAlphas[(data_1 & 0) >>> destAlphaShift] & 0xff;
              }
              break;
            case 2 :
              {
                var data_2: int = ((destData[dp + 1] & 0xff) << 8) | (destData[dp] & 0xff);
                rq = destReds[(data_2 & destRedMask) >>> destRedShift] & 0xff;
                gq = destGreens[(data_2 & destGreenMask) >>> destGreenShift] & 0xff;
                bq = destBlues[(data_2 & destBlueMask) >>> destBlueShift] & 0xff;
                aq = destAlphas[(data_2 & 0) >>> destAlphaShift] & 0xff;
              }
              break;
            case 3 :
              {
                var data_3: int = ((((destData[dp] & 0xff) << 8) | (destData[dp + 1] & 0xff)) << 8) | (destData[dp + 2] & 0xff);
                rq = destReds[(data_3 & destRedMask) >>> destRedShift] & 0xff;
                gq = destGreens[(data_3 & destGreenMask) >>> destGreenShift] & 0xff;
                bq = destBlues[(data_3 & destBlueMask) >>> destBlueShift] & 0xff;
                aq = destAlphas[(data_3 & 0) >>> destAlphaShift] & 0xff;
              }
              break;
            case 4 :
              {
                var data_4: int = ((((((destData[dp] & 0xff) << 8) | (destData[dp + 1] & 0xff)) << 8) | (destData[dp + 2] & 0xff)) << 8) | (destData[dp + 3] & 0xff);
                rq = destReds[(data_4 & destRedMask) >>> destRedShift] & 0xff;
                gq = destGreens[(data_4 & destGreenMask) >>> destGreenShift] & 0xff;
                bq = destBlues[(data_4 & destBlueMask) >>> destBlueShift] & 0xff;
                aq = destAlphas[(data_4 & 0) >>> destAlphaShift] & 0xff;
              }
              break;
            case 5 :
              {
                var data_5: int = ((((((destData[dp + 3] & 0xff) << 8) | (destData[dp + 2] & 0xff)) << 8) | (destData[dp + 1] & 0xff)) << 8) | (destData[dp] & 0xff);
                rq = destReds[(data_5 & destRedMask) >>> destRedShift] & 0xff;
                gq = destGreens[(data_5 & destGreenMask) >>> destGreenShift] & 0xff;
                bq = destBlues[(data_5 & destBlueMask) >>> destBlueShift] & 0xff;
                aq = destAlphas[(data_5 & 0) >>> destAlphaShift] & 0xff;
              }
              break;
          }
          a = aq + ((a - aq) * alpha >> 16);
          r = rq + ((r - rq) * alpha >> 16);
          g = gq + ((g - gq) * alpha >> 16);
          b = bq + ((b - bq) * alpha >> 16);
        }
        var data_6: int = (r >>> destRedPreShift << destRedShift) | (g >>> destGreenPreShift << destGreenShift) | (b >>> destBluePreShift << destBlueShift) | (a >>> destAlphaPreShift << destAlphaShift);
        switch (dtype) {
          case 0 :
            {
              destData[dp] = int(data_6);
            }
            break;
          case 1 :
            {
              destData[dp] = int((data_6 >>> 8));
              destData[dp + 1] = int((data_6 & 0xff));
            }
            break;
          case 2 :
            {
              destData[dp] = int((data_6 & 0xff));
              destData[dp + 1] = int((data_6 >>> 8));
            }
            break;
          case 3 :
            {
              destData[dp] = int((data_6 >>> 16));
              destData[dp + 1] = int((data_6 >>> 8));
              destData[dp + 2] = int((data_6 & 0xff));
            }
            break;
          case 4 :
            {
              destData[dp] = int((data_6 >>> 24));
              destData[dp + 1] = int((data_6 >>> 16));
              destData[dp + 2] = int((data_6 >>> 8));
              destData[dp + 3] = int((data_6 & 0xff));
            }
            break;
          case 5 :
            {
              destData[dp] = int((data_6 & 0xff));
              destData[dp + 1] = int((data_6 >>> 8));
              destData[dp + 2] = int((data_6 >>> 16));
              destData[dp + 3] = int((data_6 >>> 24));
            }
            break;
        }
      }
    }
    return;
  }
  public static function blit__I_3BIIIIIIIIIII_3BIII_3BIIIIIII_3B_3B_3BZZ(op: int, srcData: JavaArray, srcDepth: int, srcStride: int, srcOrder: int, srcX: int, srcY: int, srcWidth: int, srcHeight: int, srcRedMask: int, srcGreenMask: int, srcBlueMask: int, alphaMode: int, alphaData: JavaArray, alphaStride: int, alphaX: int, alphaY: int, destData: JavaArray, destDepth: int, destStride: int, destOrder: int, destX: int, destY: int, destWidth: int, destHeight: int, destReds: JavaArray, destGreens: JavaArray, destBlues: JavaArray, flipX: Boolean, flipY: Boolean): void {
    if ((destWidth <= 0) || (destHeight <= 0) || (alphaMode == 0))
      return;
    var srcAlphaMask: int = 0;
    var dwm1: int = destWidth - 1;
    var sfxi: int = (dwm1 != 0) ? int((((Number(srcWidth) << 16) - 1) / dwm1)) : 0;
    var dhm1: int = destHeight - 1;
    var sfyi: int = (dhm1 != 0) ? int((((Number(srcHeight) << 16) - 1) / dhm1)) : 0;
    var sbpp: int;
    var stype: int;
    switch (srcDepth) {
      case 8 :
        sbpp = 1;
        stype = 0;
        break;
      case 16 :
        sbpp = 2;
        stype = (srcOrder == 1) ? 1 : 2;
        break;
      case 24 :
        sbpp = 3;
        stype = 3;
        break;
      case 32 :
        sbpp = 4;
        stype = (srcOrder == 1) ? 4 : 5;
        break;
      default :
        return;
    }
    var spr: int = srcY * srcStride + srcX * sbpp;
    var dtype: int;
    switch (destDepth) {
      case 8 :
        dtype = 6;
        break;
      case 4 :
        destStride <<= 1;
        dtype = 7;
        break;
      case 2 :
        destStride <<= 2;
        dtype = 8;
        break;
      case 1 :
        destStride <<= 3;
        dtype = (destOrder == 1) ? 9 : 10;
        break;
      default :
        return;
    }
    var dpr: int = ((flipY) ? destY + dhm1 : destY) * destStride + ((flipX) ? destX + dwm1 : destX);
    var dprxi: int = (flipX) ? -1 : 1;
    var dpryi: int = (flipY) ? -destStride : destStride;
    var apr: int;
    if ((op & 2) != 0) {
      switch (alphaMode) {
        case -3 :
        case -1 :
          if (alphaData === null)
            alphaMode = 0x10000;
          apr = alphaY * alphaStride + alphaX;
          break;
        case -4 :
          if (alphaData === null)
            alphaMode = 0x10000;
          alphaStride <<= 3;
          apr = alphaY * alphaStride + alphaX;
          break;
        case -5 :
          return;
        case -6 :
          if (alphaData === null)
            alphaMode = 0x10000;
          apr = 0;
          break;
        default :
          alphaMode = int((alphaMode << 16) / 255);
          case -2 :
          apr = 0;
          break;
      }
    } else {
      alphaMode = 0x10000;
      apr = 0;
    }
    var ditherEnabled: Boolean = (op & 4) != 0;
    var srcRedShift: int = getChannelShift__I(srcRedMask);
    var srcReds: JavaArray = ANY_TO_EIGHT[getChannelWidth__II(srcRedMask, srcRedShift)];
    var srcGreenShift: int = getChannelShift__I(srcGreenMask);
    var srcGreens: JavaArray = ANY_TO_EIGHT[getChannelWidth__II(srcGreenMask, srcGreenShift)];
    var srcBlueShift: int = getChannelShift__I(srcBlueMask);
    var srcBlues: JavaArray = ANY_TO_EIGHT[getChannelWidth__II(srcBlueMask, srcBlueShift)];
    var srcAlphaShift: int = getChannelShift__I(0);
    var srcAlphas: JavaArray = ANY_TO_EIGHT[getChannelWidth__II(0, srcAlphaShift)];
    var dp: int = dpr;
    var sp: int = spr;
    var ap: int = apr;
    var alpha: int = alphaMode;
    var r: int = 0;
    var g: int = 0;
    var b: int = 0;
    var a: int = 0;
    var indexq: int = 0;
    var lastindex: int = 0;
    var lastr: int = -1;
    var lastg: int = -1;
    var lastb: int = -1;
    var rerr: JavaArray;
    var gerr: JavaArray;
    var berr: JavaArray;
    var destPaletteSize: int = 1 << destDepth;
    if ((destReds !== null) && (destReds.length < destPaletteSize))
      destPaletteSize = destReds.length;
    if (ditherEnabled) {
      rerr = new JavaArray("[I").lengths(destWidth + 2);
      gerr = new JavaArray("[I").lengths(destWidth + 2);
      berr = new JavaArray("[I").lengths(destWidth + 2);
    } else {
      rerr = null;
      gerr = null;
      berr = null;
    }
    for (var dy: int = destHeight, sfy: int = sfyi; dy > 0; --dy, sp = spr += (sfy >>> 16) * srcStride, ap = apr += (sfy >>> 16) * alphaStride, sfy = (sfy & 0xffff) + sfyi, dp = dpr += dpryi) {
      var lrerr: int = 0;
      var lgerr: int = 0;
      var lberr: int = 0;
      for (var dx: int = destWidth, sfx: int = sfxi; dx > 0; --dx, dp += dprxi, sfx = (sfx & 0xffff) + sfxi) {
        switch (stype) {
          case 0 :
            {
              var data: int = srcData[sp] & 0xff;
              sp += (sfx >>> 16);
              r = srcReds[(data & srcRedMask) >>> srcRedShift] & 0xff;
              g = srcGreens[(data & srcGreenMask) >>> srcGreenShift] & 0xff;
              b = srcBlues[(data & srcBlueMask) >>> srcBlueShift] & 0xff;
              a = srcAlphas[(data & 0) >>> srcAlphaShift] & 0xff;
            }
            break;
          case 1 :
            {
              var data_1: int = ((srcData[sp] & 0xff) << 8) | (srcData[sp + 1] & 0xff);
              sp += (sfx >>> 16) * 2;
              r = srcReds[(data_1 & srcRedMask) >>> srcRedShift] & 0xff;
              g = srcGreens[(data_1 & srcGreenMask) >>> srcGreenShift] & 0xff;
              b = srcBlues[(data_1 & srcBlueMask) >>> srcBlueShift] & 0xff;
              a = srcAlphas[(data_1 & 0) >>> srcAlphaShift] & 0xff;
            }
            break;
          case 2 :
            {
              var data_2: int = ((srcData[sp + 1] & 0xff) << 8) | (srcData[sp] & 0xff);
              sp += (sfx >>> 16) * 2;
              r = srcReds[(data_2 & srcRedMask) >>> srcRedShift] & 0xff;
              g = srcGreens[(data_2 & srcGreenMask) >>> srcGreenShift] & 0xff;
              b = srcBlues[(data_2 & srcBlueMask) >>> srcBlueShift] & 0xff;
              a = srcAlphas[(data_2 & 0) >>> srcAlphaShift] & 0xff;
            }
            break;
          case 3 :
            {
              var data_3: int = ((((srcData[sp] & 0xff) << 8) | (srcData[sp + 1] & 0xff)) << 8) | (srcData[sp + 2] & 0xff);
              sp += (sfx >>> 16) * 3;
              r = srcReds[(data_3 & srcRedMask) >>> srcRedShift] & 0xff;
              g = srcGreens[(data_3 & srcGreenMask) >>> srcGreenShift] & 0xff;
              b = srcBlues[(data_3 & srcBlueMask) >>> srcBlueShift] & 0xff;
              a = srcAlphas[(data_3 & 0) >>> srcAlphaShift] & 0xff;
            }
            break;
          case 4 :
            {
              var data_4: int = ((((((srcData[sp] & 0xff) << 8) | (srcData[sp + 1] & 0xff)) << 8) | (srcData[sp + 2] & 0xff)) << 8) | (srcData[sp + 3] & 0xff);
              sp += (sfx >>> 16) * 4;
              r = srcReds[(data_4 & srcRedMask) >>> srcRedShift] & 0xff;
              g = srcGreens[(data_4 & srcGreenMask) >>> srcGreenShift] & 0xff;
              b = srcBlues[(data_4 & srcBlueMask) >>> srcBlueShift] & 0xff;
              a = srcAlphas[(data_4 & 0) >>> srcAlphaShift] & 0xff;
            }
            break;
          case 5 :
            {
              var data_5: int = ((((((srcData[sp + 3] & 0xff) << 8) | (srcData[sp + 2] & 0xff)) << 8) | (srcData[sp + 1] & 0xff)) << 8) | (srcData[sp] & 0xff);
              sp += (sfx >>> 16) * 4;
              r = srcReds[(data_5 & srcRedMask) >>> srcRedShift] & 0xff;
              g = srcGreens[(data_5 & srcGreenMask) >>> srcGreenShift] & 0xff;
              b = srcBlues[(data_5 & srcBlueMask) >>> srcBlueShift] & 0xff;
              a = srcAlphas[(data_5 & 0) >>> srcAlphaShift] & 0xff;
            }
            break;
        }
        switch (alphaMode) {
          case -1 :
            alpha = int(((alphaData[ap] & 0xff) << 16) / 255);
            ap += (sfx >> 16);
            break;
          case -2 :
            alpha = int((a << 16) / 255);
            break;
          case -3 :
            alpha = (alphaData[ap] != 0) ? 0x10000 : 0;
            ap += (sfx >> 16);
            break;
          case -4 :
            alpha = (alphaData[ap >> 3] << ((ap & 7) + 9)) & 0x10000;
            ap += (sfx >> 16);
            break;
          case -6 :
            alpha = 0x10000;
            for (var i: int = 0; i < alphaData.length; i += 3) {
              if ((r == alphaData[i]) && (g == alphaData[i + 1]) && (b == alphaData[i + 2])) {
                alpha = 0x0000;
                break;
              }
            }
            break;
        }
        if (alpha != 0x10000) {
          if (alpha == 0x0000)
            continue;
          switch (dtype) {
            case 6 :
              indexq = destData[dp] & 0xff;
              break;
            case 7 :
              if ((dp & 1) != 0)
                indexq = destData[dp >> 1] & 0x0f;
              else
                indexq = (destData[dp >> 1] >>> 4) & 0x0f;
              break;
            case 8 :
              indexq = (destData[dp >> 2] >>> (6 - (dp & 3) * 2)) & 0x03;
              break;
            case 9 :
              indexq = (destData[dp >> 3] >>> (7 - (dp & 7))) & 0x01;
              break;
            case 10 :
              indexq = (destData[dp >> 3] >>> (dp & 7)) & 0x01;
              break;
          }
          var rq: int = destReds[indexq] & 0xff;
          var gq: int = destGreens[indexq] & 0xff;
          var bq: int = destBlues[indexq] & 0xff;
          r = rq + ((r - rq) * alpha >> 16);
          g = gq + ((g - gq) * alpha >> 16);
          b = bq + ((b - bq) * alpha >> 16);
        }
        if (ditherEnabled) {
          r += rerr[dx] >> 4;
          if (r < 0)
            r = 0;
          else if (r > 255)
            r = 255;
          g += gerr[dx] >> 4;
          if (g < 0)
            g = 0;
          else if (g > 255)
            g = 255;
          b += berr[dx] >> 4;
          if (b < 0)
            b = 0;
          else if (b > 255)
            b = 255;
          rerr[dx] = lrerr;
          gerr[dx] = lgerr;
          berr[dx] = lberr;
        }
        if (r != lastr || g != lastg || b != lastb) {
          for (var j: int = 0, dr: int, dg: int, db: int, distance: int, minDistance: int = 0x7fffffff; j < destPaletteSize; ++j) {
            dr = (destReds[j] & 0xff) - r;
            dg = (destGreens[j] & 0xff) - g;
            db = (destBlues[j] & 0xff) - b;
            distance = dr * dr + dg * dg + db * db;
            if (distance < minDistance) {
              lastindex = j;
              if (distance == 0)
                break;
              minDistance = distance;
            }
          }
          lastr = r;
          lastg = g;
          lastb = b;
        }
        if (ditherEnabled) {
          var dxm1: int = dx - 1;
          var dxp1: int = dx + 1;
          var acc: int;
          rerr[dxp1] += acc = (lrerr = r - (destReds[lastindex] & 0xff)) + lrerr + lrerr;
          rerr[dx] += acc += lrerr + lrerr;
          rerr[dxm1] += acc + lrerr + lrerr;
          gerr[dxp1] += acc = (lgerr = g - (destGreens[lastindex] & 0xff)) + lgerr + lgerr;
          gerr[dx] += acc += lgerr + lgerr;
          gerr[dxm1] += acc + lgerr + lgerr;
          berr[dxp1] += acc = (lberr = b - (destBlues[lastindex] & 0xff)) + lberr + lberr;
          berr[dx] += acc += lberr + lberr;
          berr[dxm1] += acc + lberr + lberr;
        }
        switch (dtype) {
          case 6 :
            destData[dp] = int(lastindex);
            break;
          case 7 :
            if ((dp & 1) != 0)
              destData[dp >> 1] = int(((destData[dp >> 1] & 0xf0) | lastindex));
            else
              destData[dp >> 1] = int(((destData[dp >> 1] & 0x0f) | (lastindex << 4)));
            break;
          case 8 :
            {
              var shift: int = 6 - (dp & 3) * 2;
              destData[dp >> 2] = int((destData[dp >> 2] & ~(0x03 << shift) | (lastindex << shift)));
            }
            break;
          case 9 :
            {
              var shift_1: int = 7 - (dp & 7);
              destData[dp >> 3] = int((destData[dp >> 3] & ~(0x01 << shift_1) | (lastindex << shift_1)));
            }
            break;
          case 10 :
            {
              var shift_2: int = dp & 7;
              destData[dp >> 3] = int((destData[dp >> 3] & ~(0x01 << shift_2) | (lastindex << shift_2)));
            }
            break;
        }
      }
    }
    return;
  }
  public static function getChannelShift__I(mask: int): int {
    if (mask == 0)
      return 0;
    var i: int;
    for (i = 0; ((mask & 1) == 0) && (i < 32); ++i) {
      mask >>>= 1;
    }
    return i;
  }
  public static function getChannelWidth__II(mask: int, shift: int): int {
    if (mask == 0)
      return 0;
    var i: int;
    mask >>>= shift;
    for (i = shift; ((mask & 1) != 0) && (i < 32); ++i) {
      mask >>>= 1;
    }
    return i - shift;
  }
  public static function getChannelField__II(data: int, mask: int): int {
    var shift: int = getChannelShift__I(mask);
    return ANY_TO_EIGHT[getChannelWidth__II(mask, shift)][(data & mask) >>> shift];
  }
  public static function createGradientBand__IIZLorg_eclipse_swt_graphics_RGB_2Lorg_eclipse_swt_graphics_RGB_2III(width: int, height: int, vertical: Boolean, fromRGB: RGB, toRGB: RGB, redBits: int, greenBits: int, blueBits: int): ImageData {
    var bandWidth: int;
    var bandHeight: int;
    var bitmapDepth: int;
    var bitmapData: JavaArray;
    var paletteData: PaletteData;
    if (redBits != 0 && greenBits != 0 && blueBits != 0) {
      paletteData = new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData__III, [0x0000ff00, 0x00ff0000, 0xff000000]));
      bitmapDepth = 32;
      if (redBits >= 8 && greenBits >= 8 && blueBits >= 8) {
        var steps: int;
        if (vertical) {
          bandWidth = 1;
          bandHeight = height;
          steps = bandHeight > 1 ? bandHeight - 1 : 1;
        } else {
          bandWidth = width;
          bandHeight = 1;
          steps = bandWidth > 1 ? bandWidth - 1 : 1;
        }
        var bytesPerLine: int = bandWidth * 4;
        bitmapData = new JavaArray("[B").lengths(bandHeight * bytesPerLine);
        buildPreciseGradientChannel__IIIIIZ_3BII(fromRGB.blue, toRGB.blue, steps, bandWidth, bandHeight, vertical, bitmapData, 0, bytesPerLine);
        buildPreciseGradientChannel__IIIIIZ_3BII(fromRGB.green, toRGB.green, steps, bandWidth, bandHeight, vertical, bitmapData, 1, bytesPerLine);
        buildPreciseGradientChannel__IIIIIZ_3BII(fromRGB.red, toRGB.red, steps, bandWidth, bandHeight, vertical, bitmapData, 2, bytesPerLine);
      } else {
        var steps_1: int;
        if (vertical) {
          bandWidth = (width < 8) ? width : 8;
          bandHeight = height;
          steps_1 = bandHeight > 1 ? bandHeight - 1 : 1;
        } else {
          bandWidth = width;
          bandHeight = (height < 8) ? height : 8;
          steps_1 = bandWidth > 1 ? bandWidth - 1 : 1;
        }
        var bytesPerLine_1: int = bandWidth * 4;
        bitmapData = new JavaArray("[B").lengths(bandHeight * bytesPerLine_1);
        buildDitheredGradientChannel__IIIIIZ_3BIII(fromRGB.blue, toRGB.blue, steps_1, bandWidth, bandHeight, vertical, bitmapData, 0, bytesPerLine_1, blueBits);
        buildDitheredGradientChannel__IIIIIZ_3BIII(fromRGB.green, toRGB.green, steps_1, bandWidth, bandHeight, vertical, bitmapData, 1, bytesPerLine_1, greenBits);
        buildDitheredGradientChannel__IIIIIZ_3BIII(fromRGB.red, toRGB.red, steps_1, bandWidth, bandHeight, vertical, bitmapData, 2, bytesPerLine_1, redBits);
      }
    } else {
      paletteData = new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData___3Lorg_eclipse_swt_graphics_RGB_2, [new JavaArray("[Lorg/eclipse/swt/graphics/RGB;").values(fromRGB, toRGB)]));
      bitmapDepth = 8;
      var blendi: int;
      if (vertical) {
        bandWidth = (width < 8) ? width : 8;
        bandHeight = height;
        blendi = (bandHeight > 1) ? int(0x1040000 / (bandHeight - 1)) + 1 : 1;
      } else {
        bandWidth = width;
        bandHeight = (height < 8) ? height : 8;
        blendi = (bandWidth > 1) ? int(0x1040000 / (bandWidth - 1)) + 1 : 1;
      }
      var bytesPerLine_2: int = (bandWidth + 3) & -4;
      bitmapData = new JavaArray("[B").lengths(bandHeight * bytesPerLine_2);
      if (vertical) {
        for (var dy: int = 0, blend: int = 0, dp: int = 0; dy < bandHeight; ++dy, blend += blendi, dp += bytesPerLine_2) {
          for (var dx: int = 0; dx < bandWidth; ++dx) {
            bitmapData[dp + dx] = (blend + DITHER_MATRIX[dy & 7][dx]) < 0x1000000 ? int(0) : int(1);
          }
        }
      } else {
        for (var dx_1: int = 0, blend_1: int = 0; dx_1 < bandWidth; ++dx_1, blend_1 += blendi) {
          for (var dy_1: int = 0, dptr: int = dx_1; dy_1 < bandHeight; ++dy_1, dptr += bytesPerLine_2) {
            bitmapData[dptr] = (blend_1 + DITHER_MATRIX[dy_1][dx_1 & 7]) < 0x1000000 ? int(0) : int(1);
          }
        }
      }
    }
    return new ImageData(new Arguments(org.eclipse.swt.graphics.ImageData.ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2I_3B, [bandWidth, bandHeight, bitmapDepth, paletteData, 4, bitmapData]));
  }
  public static function buildPreciseGradientChannel__IIIIIZ_3BII(from: int, to_1: int, steps: int, bandWidth: int, bandHeight: int, vertical: Boolean, bitmapData: JavaArray, dp: int, bytesPerLine: int): void {
    var val: int = from << 16;
    var inc: int = int(((to_1 << 16) - val) / steps) + 1;
    if (vertical) {
      for (var dy: int = 0; dy < bandHeight; ++dy, dp += bytesPerLine) {
        bitmapData[dp] = int((val >>> 16));
        val += inc;
      }
    } else {
      for (var dx: int = 0; dx < bandWidth; ++dx, dp += 4) {
        bitmapData[dp] = int((val >>> 16));
        val += inc;
      }
    }
    return;
  }
  public static function buildDitheredGradientChannel__IIIIIZ_3BIII(from: int, to_1: int, steps: int, bandWidth: int, bandHeight: int, vertical: Boolean, bitmapData: JavaArray, dp: int, bytesPerLine: int, bits: int): void {
    var mask: int = 0xff00 >>> bits;
    var val: int = from << 16;
    var inc: int = int(((to_1 << 16) - val) / steps) + 1;
    if (vertical) {
      for (var dy: int = 0; dy < bandHeight; ++dy, dp += bytesPerLine) {
        for (var dx: int = 0, dptr: int = dp; dx < bandWidth; ++dx, dptr += 4) {
          var thresh: int = DITHER_MATRIX[dy & 7][dx] >>> bits;
          var temp: int = val + thresh;
          if (temp > 0xffffff)
            bitmapData[dptr] = -1;
          else
            bitmapData[dptr] = int(((temp >>> 16) & mask));
        }
        val += inc;
      }
    } else {
      for (var dx_1: int = 0; dx_1 < bandWidth; ++dx_1, dp += 4) {
        for (var dy_1: int = 0, dptr_1: int = dp; dy_1 < bandHeight; ++dy_1, dptr_1 += bytesPerLine) {
          var thresh_1: int = DITHER_MATRIX[dy_1][dx_1 & 7] >>> bits;
          var temp_1: int = val + thresh_1;
          if (temp_1 > 0xffffff)
            bitmapData[dptr_1] = -1;
          else
            bitmapData[dptr_1] = int(((temp_1 >>> 16) & mask));
        }
        val += inc;
      }
    }
    return;
  }
  public static function fillGradientRectangle__Lorg_eclipse_swt_graphics_GC_2Lorg_eclipse_swt_graphics_Device_2IIIIZLorg_eclipse_swt_graphics_RGB_2Lorg_eclipse_swt_graphics_RGB_2III(gc: GC, device: Device, x: int, y: int, width: int, height: int, vertical: Boolean, fromRGB: RGB, toRGB: RGB, redBits: int, greenBits: int, blueBits: int): void {
    var band: ImageData = createGradientBand__IIZLorg_eclipse_swt_graphics_RGB_2Lorg_eclipse_swt_graphics_RGB_2III(width, height, vertical, fromRGB, toRGB, redBits, greenBits, blueBits);
    var image: Image = new Image(new Arguments(org.eclipse.swt.graphics.Image.Image__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_ImageData_2, [device, band]));
    if ((band.width == 1) || (band.height == 1)) {
      gc.drawImage__Lorg_eclipse_swt_graphics_Image_2IIIIIIII(image, 0, 0, band.width, band.height, x, y, width, height);
    } else {
      if (vertical) {
        for (var dx: int = 0; dx < width; dx += band.width) {
          var blitWidth: int = width - dx;
          if (blitWidth > band.width)
            blitWidth = band.width;
          gc.drawImage__Lorg_eclipse_swt_graphics_Image_2IIIIIIII(image, 0, 0, blitWidth, band.height, dx + x, y, blitWidth, band.height);
        }
      } else {
        for (var dy: int = 0; dy < height; dy += band.height) {
          var blitHeight: int = height - dy;
          if (blitHeight > band.height)
            blitHeight = band.height;
          gc.drawImage__Lorg_eclipse_swt_graphics_Image_2IIIIIIII(image, 0, 0, band.width, blitHeight, x, dy + y, band.width, blitHeight);
        }
      }
    }
    image.dispose__();
    return;
  }
  public function ImageData(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 4 && vargs[0] is int && vargs[1] is int && vargs[2] is int && vargs[3] is PaletteData) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 6 && vargs[0] is int && vargs[1] is int && vargs[2] is int && vargs[3] is PaletteData && vargs[4] is int && vargs[5] is JavaArray) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is InputStream) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 1 && vargs[0] is String) {
        args = vargs;
        id = 3;
      } else if (vargs.length == 0) {
        id = 4;
      } else if (vargs.length == 16 && vargs[0] is int && vargs[1] is int && vargs[2] is int && vargs[3] is PaletteData && vargs[4] is int && vargs[5] is JavaArray && vargs[6] is int && vargs[7] is JavaArray && vargs[8] is JavaArray && vargs[9] is int && vargs[10] is int && vargs[11] is int && vargs[12] is int && vargs[13] is int && vargs[14] is int && vargs[15] is int) {
        args = vargs;
        id = 5;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1], args[2], args[3]];
        args5 = [args0[0], args0[1], args0[2], args0[3], 4, null, 0, null, null, -1, -1, -1, 0, 0, 0, 0];
        break;
      case 1:
        var args1: Array = [args[0], args[1], args[2], args[3], args[4], args[5]];
        args5 = [args1[0], args1[1], args1[2], args1[3], args1[4], ImageData.checkData___3B(args1[5]), 0, null, null, -1, -1, -1, 0, 0, 0, 0];
        break;
      case 2:
        var args2: Array = [args[0]];
        break;
      case 3:
        var args3: Array = [args[0]];
        break;
      case 4:
        break;
      case 5:
        var args5: Array = [args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14], args[15]];
        break;
    }
    super();
    switch (id) {
      case 0:
        ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2I_3BI_3B_3BIIIIIII(args5[0], args5[1], args5[2], args5[3], args5[4], args5[5], args5[6], args5[7], args5[8], args5[9], args5[10], args5[11], args5[12], args5[13], args5[14], args5[15]);
        ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2(args0[0], args0[1], args0[2], args0[3]);
        break;
      case 1:
        ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2I_3BI_3B_3BIIIIIII(args5[0], args5[1], args5[2], args5[3], args5[4], args5[5], args5[6], args5[7], args5[8], args5[9], args5[10], args5[11], args5[12], args5[13], args5[14], args5[15]);
        ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2I_3B(args1[0], args1[1], args1[2], args1[3], args1[4], args1[5]);
        break;
      case 2:
        ImageData__Ljava_io_InputStream_2(args2[0]);
        break;
      case 3:
        ImageData__Ljava_lang_String_2(args3[0]);
        break;
      case 4:
        ImageData__();
        break;
      case 5:
        ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2I_3BI_3B_3BIIIIIII(args5[0], args5[1], args5[2], args5[3], args5[4], args5[5], args5[6], args5[7], args5[8], args5[9], args5[10], args5[11], args5[12], args5[13], args5[14], args5[15]);
        break;
    }
  }
  public static const ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2 : int = 0;
  public static const ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2I_3B : int = 1;
  public static const ImageData__Ljava_io_InputStream_2 : int = 2;
  public static const ImageData__Ljava_lang_String_2 : int = 3;
  public static const ImageData__ : int = 4;
  public static const ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2I_3BI_3B_3BIIIIIII : int = 5;
}
}
