package org.eclipse.swt.graphics {
import java.io.*;
import java.util.Vector;
import org.eclipse.swt.*;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.image.*;
import java.util.Vector;
import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.image.FileFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ImageLoader {
  public var data: JavaArray;
  public var logicalScreenWidth: int;
  public var logicalScreenHeight: int;
  public var backgroundPixel: int;
  public var repeatCount: int;
  internal var imageLoaderListeners: Vector;
  public function ImageLoader() {
    this.reset__();
    return;
  }
  public function reset__(): void {
    data = null;
    logicalScreenWidth = 0;
    logicalScreenHeight = 0;
    backgroundPixel = -1;
    repeatCount = 1;
    return;
  }
  public function load__Ljava_io_InputStream_2(stream: InputStream): JavaArray {
    if (stream === null)
      SWT.error__I(4);
    this.reset__();
    data = FileFormat.load__Ljava_io_InputStream_2Lorg_eclipse_swt_graphics_ImageLoader_2(stream, this);
    return data;
  }
  public function load__Ljava_lang_String_2(filename: String): JavaArray {
    if (filename === null)
      SWT.error__I(4);
    var stream: InputStream = null;
    try {
      stream = Compatibility.newFileInputStream__Ljava_lang_String_2(filename);
      return this.load__Ljava_io_InputStream_2(stream);
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    } finally {
      try {
        if (stream !== null)
          stream.close__();
      } catch (e_1 : IOException) {
      }
    }
    return null;
  }
  public function save__Ljava_io_OutputStream_2I(stream: OutputStream, format: int): void {
    if (stream === null)
      SWT.error__I(4);
    FileFormat.save__Ljava_io_OutputStream_2ILorg_eclipse_swt_graphics_ImageLoader_2(stream, format, this);
  }
  public function save__Ljava_lang_String_2I(filename: String, format: int): void {
    if (filename === null)
      SWT.error__I(4);
    var stream: OutputStream = null;
    try {
      stream = Compatibility.newFileOutputStream__Ljava_lang_String_2(filename);
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    this.save__Ljava_io_OutputStream_2I(stream, format);
    try {
      stream.close__();
    } catch (e_1 : IOException) {
    }
    return;
  }
  public function addImageLoaderListener__Lorg_eclipse_swt_graphics_ImageLoaderListener_2(listener: ImageLoaderListener): void {
    if (listener === null)
      SWT.error__I(4);
    if (imageLoaderListeners === null) {
      imageLoaderListeners = new Vector(new Arguments(java.util.Vector.Vector__, []));
    }
    imageLoaderListeners.addElement__Ljava_lang_Object_2(listener);
    return;
  }
  public function removeImageLoaderListener__Lorg_eclipse_swt_graphics_ImageLoaderListener_2(listener: ImageLoaderListener): void {
    if (listener === null)
      SWT.error__I(4);
    if (imageLoaderListeners === null)
      return;
    imageLoaderListeners.removeElement__Ljava_lang_Object_2(listener);
  }
  public function hasListeners__(): Boolean {
    return imageLoaderListeners !== null && imageLoaderListeners.size__() > 0;
  }
  public function notifyListeners__Lorg_eclipse_swt_graphics_ImageLoaderEvent_2(event: ImageLoaderEvent): void {
    if (!this.hasListeners__())
      return;
    var size: int = imageLoaderListeners.size__();
    for (var i: int = 0; i < size; i++) {
      var listener: ImageLoaderListener = ImageLoaderListener(imageLoaderListeners.elementAt__I(i));
      listener.imageDataLoaded__Lorg_eclipse_swt_graphics_ImageLoaderEvent_2(event);
    }
    return;
  }
}
}
