package org.eclipse.swt.graphics {
import org.eclipse.swt.*;
import org.eclipse.swt.SWT;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class PaletteData {
  public var isDirect: Boolean;
  public var colors: JavaArray;
  public var redMask: int;
  public var greenMask: int;
  public var blueMask: int;
  public var redShift: int;
  public var greenShift: int;
  public var blueShift: int;
  public function PaletteData___3Lorg_eclipse_swt_graphics_RGB_2(colors: JavaArray): Object {
    if (colors === null)
      SWT.error__I(4);
    this.colors = colors;
    this.isDirect = false;
    return this;
  }
  public function PaletteData__III(redMask: int, greenMask: int, blueMask: int): Object {
    this.redMask = redMask;
    this.greenMask = greenMask;
    this.blueMask = blueMask;
    this.isDirect = true;
    this.redShift = this.shiftForMask__I(redMask);
    this.greenShift = this.shiftForMask__I(greenMask);
    this.blueShift = this.shiftForMask__I(blueMask);
    return this;
  }
  public function getPixel__Lorg_eclipse_swt_graphics_RGB_2(rgb: RGB): int {
    if (rgb === null)
      SWT.error__I(4);
    if (isDirect) {
      var pixel: int = 0;
      pixel |= (redShift < 0 ? rgb.red << -redShift : rgb.red >>> redShift) & redMask;
      pixel |= (greenShift < 0 ? rgb.green << -greenShift : rgb.green >>> greenShift) & greenMask;
      pixel |= (blueShift < 0 ? rgb.blue << -blueShift : rgb.blue >>> blueShift) & blueMask;
      return pixel;
    } else {
      for (var i: int = 0; i < colors.length; i++) {
        if (colors[i].equals__Ljava_lang_Object_2(rgb))
          return i;
      }
      SWT.error__I(5);
      return 0;
    }
    return 0;
  }
  public function getRGB__I(pixel: int): RGB {
    if (isDirect) {
      var r: int = pixel & redMask;
      r = (redShift < 0) ? r >>> -redShift : r << redShift;
      var g: int = pixel & greenMask;
      g = (greenShift < 0) ? g >>> -greenShift : g << greenShift;
      var b: int = pixel & blueMask;
      b = (blueShift < 0) ? b >>> -blueShift : b << blueShift;
      return new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [r, g, b]));
    } else {
      if (pixel < 0 || pixel >= colors.length) {
        SWT.error__I(5);
      }
      return colors[pixel];
    }
    return null;
  }
  public function getRGBs__(): JavaArray {
    return colors;
  }
  public function shiftForMask__I(mask: int): int {
    for (var i: int = 31; i >= 0; i--) {
      if (((mask >> i) & 0x1) != 0)
        return 7 - i;
    }
    return 32;
  }
  public function PaletteData(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is JavaArray) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 3 && vargs[0] is int && vargs[1] is int && vargs[2] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        break;
      case 1:
        var args1: Array = [args[0], args[1], args[2]];
        break;
    }
    super();
    switch (id) {
      case 0:
        PaletteData___3Lorg_eclipse_swt_graphics_RGB_2(args0[0]);
        break;
      case 1:
        PaletteData__III(args1[0], args1[1], args1[2]);
        break;
    }
  }
  public static const PaletteData___3Lorg_eclipse_swt_graphics_RGB_2 : int = 0;
  public static const PaletteData__III : int = 1;
}
}
