package org.eclipse.swt.graphics {
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.*;
import org.eclipse.swt.SWT;
import java.lang.Math__;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class RGB implements SerializableCompatibility {
  public var red: int;
  public var green: int;
  public var blue: int;
  public static const serialVersionUID: Number = 3258415023461249074;
  public function RGB__III(red: int, green: int, blue: int): Object {
    if ((red > 255) || (red < 0) || (green > 255) || (green < 0) || (blue > 255) || (blue < 0))
      SWT.error__I(5);
    this.red = red;
    this.green = green;
    this.blue = blue;
    return this;
  }
  public function RGB__FFF(hue: Number, saturation: Number, brightness: Number): Object {
    if (hue < 0 || hue > 360 || saturation < 0 || saturation > 1 || brightness < 0 || brightness > 1) {
      SWT.error__I(5);
    }
    var r: Number = 0;
    var g: Number = 0;
    var b: Number = 0;
    if (saturation == 0) {
      r = g = b = brightness;
    } else {
      if (hue == 360)
        hue = 0;
      hue /= 60;
      var i: int = int(hue);
      var f: Number = hue - i;
      var p: Number = brightness * (1 - saturation);
      var q: Number = brightness * (1 - saturation * f);
      var t: Number = brightness * (1 - saturation * (1 - f));
      switch (i) {
        case 0 :
          r = brightness;
          g = t;
          b = p;
          break;
        case 1 :
          r = q;
          g = brightness;
          b = p;
          break;
        case 2 :
          r = p;
          g = brightness;
          b = t;
          break;
        case 3 :
          r = p;
          g = q;
          b = brightness;
          break;
        case 4 :
          r = t;
          g = p;
          b = brightness;
          break;
        case 5 :
        default :
          r = brightness;
          g = p;
          b = q;
          break;
      }
    }
    red = int((r * 255 + 0.5));
    green = int((g * 255 + 0.5));
    blue = int((b * 255 + 0.5));
    return this;
  }
  public function getHSB__(): JavaArray {
    var r: Number = red / 255.0;
    var g: Number = green / 255.0;
    var b: Number = blue / 255.0;
    var max: Number = Math__.max__FF(Math__.max__FF(r, g), b);
    var min: Number = Math__.min__FF(Math__.min__FF(r, g), b);
    var delta: Number = max - min;
    var hue: Number = 0;
    var brightness: Number = max;
    var saturation: Number = max == 0 ? 0 : (max - min) / max;
    if (delta != 0) {
      if (r == max) {
        hue = (g - b) / delta;
      } else {
        if (g == max) {
          hue = 2 + (b - r) / delta;
        } else {
          hue = 4 + (r - g) / delta;
        }
      }
      hue *= 60;
      if (hue < 0)
        hue += 360;
    }
    return new JavaArray("[F").values(hue, saturation, brightness);
  }
  public function equals__Ljava_lang_Object_2(object: Object): Boolean {
    if (object === this)
      return true;
    if (!(object is RGB))
      return false;
    var rgb: RGB = RGB(object);
    return (rgb.red == this.red) && (rgb.green == this.green) && (rgb.blue == this.blue);
  }
  public function hashCode__(): int {
    return (blue << 16) | (green << 8) | red;
  }
  public function toString__(): String {
    return "RGB {" + red + ", " + green + ", " + blue + "}";
  }
  public function RGB(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 3 && vargs[0] is int && vargs[1] is int && vargs[2] is int) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 3 && vargs[0] is Number && vargs[1] is Number && vargs[2] is Number) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1], args[2]];
        break;
      case 1:
        var args1: Array = [args[0], args[1], args[2]];
        break;
    }
    super();
    switch (id) {
      case 0:
        RGB__III(args0[0], args0[1], args0[2]);
        break;
      case 1:
        RGB__FFF(args1[0], args1[1], args1[2]);
        break;
    }
  }
  public static const RGB__III : int = 0;
  public static const RGB__FFF : int = 1;
}
}
