package org.eclipse.swt.graphics {
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.*;
import org.eclipse.swt.SWT;
dynamic public class Rectangle implements SerializableCompatibility {
  public var x: int;
  public var y: int;
  public var width: int;
  public var height: int;
  public static const serialVersionUID: Number = 3256439218279428914;
  public function Rectangle(x: int, y: int, width: int, height: int) {
    this.x = x;
    this.y = y;
    this.width = width;
    this.height = height;
    return;
  }
  public function add__Lorg_eclipse_swt_graphics_Rectangle_2(rect: Rectangle): void {
    if (rect === null)
      SWT.error__I(4);
    var left: int = x < rect.x ? x : rect.x;
    var top: int = y < rect.y ? y : rect.y;
    var lhs: int = x + width;
    var rhs: int = rect.x + rect.width;
    var right: int = lhs > rhs ? lhs : rhs;
    lhs = y + height;
    rhs = rect.y + rect.height;
    var bottom: int = lhs > rhs ? lhs : rhs;
    x = left;
    y = top;
    width = right - left;
    height = bottom - top;
    return;
  }
  public function contains__II(x_1: int, y_1: int): Boolean {
    return (x_1 >= this.x) && (y_1 >= this.y) && x_1 < (this.x + width) && y_1 < (this.y + height);
  }
  public function contains__Lorg_eclipse_swt_graphics_Point_2(pt: Point): Boolean {
    if (pt === null)
      SWT.error__I(4);
    return this.contains__II(pt.x, pt.y);
  }
  public function equals__Ljava_lang_Object_2(object: Object): Boolean {
    if (object === this)
      return true;
    if (!(object is Rectangle))
      return false;
    var r: Rectangle = Rectangle(object);
    return (r.x == this.x) && (r.y == this.y) && (r.width == this.width) && (r.height == this.height);
  }
  public function hashCode__(): int {
    return x ^ y ^ width ^ height;
  }
  public function intersect__Lorg_eclipse_swt_graphics_Rectangle_2(rect: Rectangle): void {
    if (rect === null)
      SWT.error__I(4);
    if (this === rect)
      return;
    var left: int = x > rect.x ? x : rect.x;
    var top: int = y > rect.y ? y : rect.y;
    var lhs: int = x + width;
    var rhs: int = rect.x + rect.width;
    var right: int = lhs < rhs ? lhs : rhs;
    lhs = y + height;
    rhs = rect.y + rect.height;
    var bottom: int = lhs < rhs ? lhs : rhs;
    x = right < left ? 0 : left;
    y = bottom < top ? 0 : top;
    width = right < left ? 0 : right - left;
    height = bottom < top ? 0 : bottom - top;
  }
  public function intersection__Lorg_eclipse_swt_graphics_Rectangle_2(rect: Rectangle): Rectangle {
    if (rect === null)
      SWT.error__I(4);
    if (this === rect)
      return new Rectangle(x, y, width, height);
    var left: int = x > rect.x ? x : rect.x;
    var top: int = y > rect.y ? y : rect.y;
    var lhs: int = x + width;
    var rhs: int = rect.x + rect.width;
    var right: int = lhs < rhs ? lhs : rhs;
    lhs = y + height;
    rhs = rect.y + rect.height;
    var bottom: int = lhs < rhs ? lhs : rhs;
    return new Rectangle(right < left ? 0 : left, bottom < top ? 0 : top, right < left ? 0 : right - left, bottom < top ? 0 : bottom - top);
  }
  public function intersects__IIII(x_1: int, y_1: int, width_1: int, height_1: int): Boolean {
    return (x_1 < this.x + this.width) && (y_1 < this.y + this.height) && (x_1 + width_1 > this.x) && (y_1 + height_1 > this.y);
  }
  public function intersects__Lorg_eclipse_swt_graphics_Rectangle_2(rect: Rectangle): Boolean {
    if (rect === null)
      SWT.error__I(4);
    return rect === this || this.intersects__IIII(rect.x, rect.y, rect.width, rect.height);
  }
  public function isEmpty__(): Boolean {
    return (width <= 0) || (height <= 0);
  }
  public function toString__(): String {
    return "Rectangle {" + x + ", " + y + ", " + width + ", " + height + "}";
  }
  public function union__Lorg_eclipse_swt_graphics_Rectangle_2(rect: Rectangle): Rectangle {
    if (rect === null)
      SWT.error__I(4);
    var left: int = x < rect.x ? x : rect.x;
    var top: int = y < rect.y ? y : rect.y;
    var lhs: int = x + width;
    var rhs: int = rect.x + rect.width;
    var right: int = lhs > rhs ? lhs : rhs;
    lhs = y + height;
    rhs = rect.y + rect.height;
    var bottom: int = lhs > rhs ? lhs : rhs;
    return new Rectangle(left, top, right - left, bottom - top);
  }
}
}
