package org.eclipse.swt.graphics {
import flash.display.*;
import org.eclipse.swt.*;
import flash.display.Sprite;
import org.eclipse.swt.SWT;
import flash.display.BlendMode;
import flash.display.Shape;
import flash.display.Graphics;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Region extends Resource {
  public var object: Sprite;
  public function Region__(): Object {
    return this;
  }
  public function Region__Lorg_eclipse_swt_graphics_Device_2(device: Device): Object {
    object = new Sprite();
    if (object === null)
      SWT.error__I(2);
    object.blendMode = BlendMode.LAYER;
    object.cacheAsBitmap = true;
    this.init__();
    return this;
  }
  public function add___3I(pointArray: JavaArray): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (pointArray === null)
      SWT.error__I(4);
    var shape: Shape = new Shape();
    shape.blendMode = BlendMode.ADD;
    var graphics: Graphics = shape.graphics;
    graphics.beginFill(0xFFFFFF, 1);
    graphics.moveTo(pointArray[0], pointArray[1]);
    for (var i: int = 2; i < pointArray.length; i += 2) {
      graphics.lineTo(pointArray[i], pointArray[i + 1]);
    }
    graphics.lineTo(pointArray[0], pointArray[1]);
    object.addChild(shape);
    return;
  }
  public function add__Lorg_eclipse_swt_graphics_Rectangle_2(rect: Rectangle): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (rect === null)
      SWT.error__I(4);
    this.add__IIII(rect.x, rect.y, rect.width, rect.height);
    return;
  }
  public function add__IIII(x: int, y: int, width: int, height: int): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (width < 0 || height < 0)
      SWT.error__I(5);
    var shape: Shape = new Shape();
    shape.blendMode = BlendMode.ADD;
    var graphics: Graphics = shape.graphics;
    graphics.beginFill(0xFFFFFF, 1);
    graphics.drawRect(x, y, width, height);
    object.addChild(shape);
    return;
  }
  public function add__Lorg_eclipse_swt_graphics_Region_2(region: Region): void {
  }
  public function contains__II(x: int, y: int): Boolean {
    return false;
  }
  public function contains__Lorg_eclipse_swt_graphics_Point_2(pt: Point): Boolean {
    return false;
  }
  public override function destroy__(): void {
    object = null;
  }
  public function equals__Ljava_lang_Object_2(object_1: Object): Boolean {
    if (this === object_1)
      return true;
    if (!(object_1 is Region))
      return false;
    var rgn: Region = Region(object_1);
    return object_1 === rgn.object;
  }
  public function getBounds__(): Rectangle {
    return new Rectangle(int(object.x), int(object.y), int(object.width), int(object.height));
  }
  public function hashCode__(): int {
    if (this.isDisposed__())
      return 0;
    return Object(Object.prototype).hashCode__.call(this);
  }
  public function intersect__Lorg_eclipse_swt_graphics_Rectangle_2(rect: Rectangle): void {
  }
  public function intersect__IIII(x: int, y: int, width: int, height: int): void {
  }
  public function intersect__Lorg_eclipse_swt_graphics_Region_2(region: Region): void {
  }
  public function intersects__IIII(x: int, y: int, width: int, height: int): Boolean {
    return false;
  }
  public function intersects__Lorg_eclipse_swt_graphics_Rectangle_2(rect: Rectangle): Boolean {
    return false;
  }
  public override function isDisposed__(): Boolean {
    return object === null;
  }
  public function isEmpty__(): Boolean {
    if (this.isDisposed__())
      SWT.error__I(44);
    return object.numChildren == 0;
  }
  public function subtract___3I(pointArray: JavaArray): void {
  }
  public function subtract__Lorg_eclipse_swt_graphics_Rectangle_2(rect: Rectangle): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (rect === null)
      SWT.error__I(4);
    this.subtract__IIII(rect.x, rect.y, rect.width, rect.height);
  }
  public function subtract__IIII(x: int, y: int, width: int, height: int): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (width < 0 || height < 0)
      SWT.error__I(5);
    var shape: Shape = new Shape();
    shape.blendMode = BlendMode.ERASE;
    var graphics: Graphics = shape.graphics;
    graphics.beginFill(0xFFFFFF, 1);
    graphics.moveTo(x, y);
    graphics.lineTo(x, y + height);
    graphics.lineTo(x + width, y + height);
    graphics.lineTo(x + width, y);
    graphics.lineTo(x, y);
    object.addChild(shape);
  }
  public function subtract__Lorg_eclipse_swt_graphics_Region_2(region: Region): void {
  }
  public function translate__II(x: int, y: int): void {
  }
  public function translate__Lorg_eclipse_swt_graphics_Point_2(pt: Point): void {
  }
  public function toString__(): String {
    if (this.isDisposed__())
      return "Region {*DISPOSED*}";
    return "Region {" + object + "}";
  }
  public static function flex_new__Lorg_eclipse_swt_graphics_Device_2Ljava_lang_Object_2(device: Device, handle: Object): Region {
    return null;
  }
  public function Region(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Device) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        args1 = [null];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args1[0]]);
        break;
      case 1:
        var args1: Array = [args[0]];
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args1[0]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        Region__Lorg_eclipse_swt_graphics_Device_2(args1[0]);
        Region__();
        break;
      case 1:
        Region__Lorg_eclipse_swt_graphics_Device_2(args1[0]);
        break;
    }
  }
  public static const Region__ : int = 0;
  public static const Region__Lorg_eclipse_swt_graphics_Device_2 : int = 1;
}
}
