package org.eclipse.swt.graphics {
import flash.display.CapsStyle;
import flash.display.Graphics;
import flash.display.JointStyle;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.text.TextLineMetrics;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Compatibility;
import java.lang.Math__;
import flash.geom.Point;
import flash.geom.Rectangle;
import java.lang.Character;
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class TextLayout extends Resource {
  internal var font: Font;
  internal var text: String;
  internal var lineSpacing: int;
  internal var ascent: int;
  internal var descent: int;
  internal var alignment: int;
  internal var wrapWidth: int;
  internal var orientation: int;
  internal var indent: int;
  internal var justify: Boolean;
  internal var tabs: JavaArray;
  internal var segments: JavaArray;
  internal var styles: JavaArray;
  internal var textField: TextField;
  public static const BORDER: int = 2;
  public static const TAB_COUNT: int = 32;
  public function TextLayout(device: Device) {
    super(new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [device]));
    ascent = descent = wrapWidth = -1;
    text = "";
    styles = new JavaArray("[Lorg/eclipse/swt/graphics/TextLayout$StyleItem;").lengths(2);
    styles[0] = new TextLayout$StyleItem();
    styles[1] = new TextLayout$StyleItem();
    this.init__();
    return;
  }
  public function checkLayout__(): void {
    if (this.isDisposed__())
      SWT.error__I(44);
  }
  public override function destroy__(): void {
    this.freeRuns__();
    font = null;
    text = null;
    tabs = null;
    styles = null;
  }
  public function computeRuns__(): void {
    this.computeRuns__Lorg_eclipse_swt_graphics_GCData_2(null);
  }
  public function computePolyline__IIII(left: int, top: int, right: int, bottom: int): JavaArray {
    var height: int = bottom - top;
    var width: int = 2 * height;
    var peaks: int = Compatibility.ceil__II(right - left, width);
    if (peaks == 0 && right - left > 2) {
      peaks = 1;
    }
    var length: int = ((2 * peaks) + 1) * 2;
    if (length < 0)
      return new JavaArray("[I").lengths(0);
    var coordinates: JavaArray = new JavaArray("[I").lengths(length);
    for (var i: int = 0; i < peaks; i++) {
      var index: int = 4 * i;
      coordinates[index] = left + (width * i);
      coordinates[index + 1] = bottom;
      coordinates[index + 2] = coordinates[index] + int(width / 2);
      coordinates[index + 3] = top;
    }
    coordinates[length - 2] = left + (width * peaks);
    coordinates[length - 1] = bottom;
    return coordinates;
  }
  public function computeRuns__Lorg_eclipse_swt_graphics_GCData_2(data: GCData): void {
    if (textField !== null) {
      if (data === null)
        return;
      if (textField.parent === null) {
        var currentFg: Number = Number(textField.defaultTextFormat.color);
        var newFg: Number = new Number(data.foreground.handle);
        if (Object(newFg).equals__Ljava_lang_Object_2(currentFg))
          return;
      }
    }
    var length: int = Object(text).length__();
    textField = new TextField();
    textField.text = length == 0 ? " " : text;
    if (length == 0)
      length = 1;
    textField.autoSize = TextFieldAutoSize.LEFT;
    textField.multiline = true;
    textField.selectable = false;
    textField.mouseEnabled = false;
    textField.alwaysShowSelection = true;
    textField.background = false;
    var format: TextFormat = new TextFormat();
    textField.defaultTextFormat = format;
    var defaultFont: Font = this.font !== null ? this.font : device.systemFont;
    format.font = defaultFont.fontFamily;
    format.size = new Number(defaultFont.fontSize);
    if (data !== null) {
      format.color = new Number(data.foreground.handle);
    }
    if (Object(defaultFont.fontStyle).equals__Ljava_lang_Object_2("italic"))
      format.italic = defaultFont.fontStyle;
    if (Object(defaultFont.fontWeight).equals__Ljava_lang_Object_2("bold"))
      format.bold = defaultFont.fontWeight;
    if (wrapWidth != -1) {
      var align: String = TextFormatAlign.LEFT;
      if (justify) {
        align = TextFormatAlign.JUSTIFY;
      } else {
        switch (alignment) {
          case 16777216 :
            align = TextFormatAlign.CENTER;
            break;
          case 131072 :
            align = TextFormatAlign.RIGHT;
        }
      }
      format.align = align;
      textField.width = wrapWidth;
      textField.wordWrap = true;
    }
    format.leading = new Number(lineSpacing);
    format.indent = new Number(indent);
    var tabWidth: int = 0;
    var tabX: int = 0;
    var tabArray: Array = new Array();
    var tabCount: int = 32;
    if (tabs !== null) {
      tabCount = Math__.max__II(32, tabs.length);
      if (tabs.length == 1) {
        tabWidth = tabs[0];
      }
      if (tabs.length > 1) {
        tabWidth = tabs[tabs.length - 1] - tabs[tabs.length - 2];
      }
      for (var i: int = 0; i < tabs.length; i++) {
        tabX += tabs[i];
        tabArray.push(tabX);
        tabCount--;
      }
    }
    while (tabCount > 0) {
      tabX += tabWidth;
      tabArray.push(tabX);
      tabCount--;
    }
    format.tabStops = tabArray;
    textField.setTextFormat(format, 0, length);
    var start: int;
    var end: int;
    for (var i_1: int = 0; i_1 < styles.length - 1; i_1++) {
      var run: TextLayout$StyleItem = styles[i_1];
      if (run.style === null)
        continue;
      var style: TextStyle = run.style;
      start = this.translateOffset__I(run.start);
      end = this.translateOffset__I(styles[i_1 + 1].start);
      format = new TextFormat();
      var font_1: Font = style.font;
      if (font_1 !== null) {
        format.font = font_1.fontFamily;
        format.size = new Number(font_1.fontSize);
        if (Object(font_1.fontStyle).equals__Ljava_lang_Object_2("italic"))
          format.italic = font_1.fontStyle;
        if (Object(font_1.fontWeight).equals__Ljava_lang_Object_2("bold"))
          format.bold = font_1.fontWeight;
      }
      var foreground: Color = style.foreground;
      if (foreground !== null) {
        format.color = new Number(foreground.handle);
      }
      if (style.rise != 0) {
      }
      if (style.metrics !== null) {
      }
      textField.setTextFormat(format, start, end);
    }
    return;
  }
  public function draw__Lorg_eclipse_swt_graphics_GC_2II(gc: GC, x: int, y: int): void {
    this.draw__Lorg_eclipse_swt_graphics_GC_2IIIILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(gc, x, y, -1, -1, null, null);
    return;
  }
  public function draw__Lorg_eclipse_swt_graphics_GC_2IIIILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(gc: GC, x: int, y: int, selectionStart: int, selectionEnd: int, selectionForeground: Color, selectionBackground: Color): void {
    this.draw__Lorg_eclipse_swt_graphics_GC_2IIIILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2I(gc, x, y, selectionStart, selectionEnd, selectionForeground, selectionBackground, 0);
    return;
  }
  public function draw__Lorg_eclipse_swt_graphics_GC_2IIIILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2I(gc: GC, x: int, y: int, selectionStart: int, selectionEnd: int, selectionForeground: Color, selectionBackground: Color, flags: int): void {
    this.checkLayout__();
    if (gc === null)
      SWT.error__I(4);
    if (gc.isDisposed__())
      SWT.error__I(5);
    var data: GCData = gc.data;
    this.computeRuns__Lorg_eclipse_swt_graphics_GCData_2(data);
    if (selectionForeground !== null && selectionForeground.isDisposed__())
      SWT.error__I(5);
    if (selectionBackground !== null && selectionBackground.isDisposed__())
      SWT.error__I(5);
    var length: int = Object(text).length__();
    if (length == 0 && flags == 0)
      return;
    var hasSelection: Boolean = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
    if (hasSelection) {
      textField.setSelection(selectionStart, selectionEnd + 1);
    } else {
      textField.setSelection(-1, -1);
    }
    y -= 2;
    x -= 2;
    if (data.matrix !== null) {
      var point: flash.geom.Point = new flash.geom.Point(x, y);
      point = data.matrix.transformPoint(point);
      textField.x = point.x;
      textField.y = point.y;
    } else {
      textField.x = x;
      textField.y = y;
    }
    if (data.matrix !== null)
      textField.transform.matrix = data.matrix;
    if (data.clip !== null)
      textField.mask = data.clip;
    for (var i: int = 0; i < styles.length - 1; i++) {
      var run: TextLayout$StyleItem = styles[i];
      var style: TextStyle = run.style;
      if (style === null || style.background === null)
        continue;
      var start: int = this.translateOffset__I(run.start);
      var end: int = this.translateOffset__I(styles[i + 1].start);
      var lineY: Number = y + 2;
      for (var lineIndex: int = 0; lineIndex < textField.numLines; lineIndex++) {
        var lineStart: int = textField.getLineOffset(lineIndex);
        var lineEnd: int = lineStart + textField.getLineLength(lineIndex);
        var metrics: TextLineMetrics = textField.getLineMetrics(lineIndex);
        if (!(start > lineEnd || end < lineStart)) {
          var highStart: int = Math__.max__II(lineStart, start);
          var highEnd: int = Math__.min__II(lineEnd, end);
          if (highStart != highEnd) {
            var startRect: flash.geom.Rectangle = textField.getCharBoundaries(highStart);
            var endRect: flash.geom.Rectangle = textField.getCharBoundaries(highEnd - 1);
            var shape: Shape = new Shape();
            if (data.matrix !== null)
              shape.transform.matrix = data.matrix;
            if (data.clip !== null)
              shape.mask = data.clip;
            var graphics: Graphics = shape.graphics;
            graphics.beginFill(style.background.handle, data.alpha / 255.0);
            graphics.drawRect(x + startRect.x, lineY, endRect.right - startRect.left, metrics.height);
            graphics.endFill();
            data.sprite.addChild(shape);
          }
        }
        if (lineEnd > end)
          break;
        lineY += metrics.height;
      }
    }
    data.sprite.addChild(textField);
    for (var j: int = 0; j < styles.length - 1; j++) {
      var run_1: TextLayout$StyleItem = styles[j];
      var style_1: TextStyle = run_1.style;
      if (style_1 === null)
        continue;
      var drawUnderline: Boolean = style_1.underline && (j + 1 >= styles.length || !style_1.isAdherentUnderline__Lorg_eclipse_swt_graphics_TextStyle_2(styles[j + 1].style));
      var drawBorder: Boolean = style_1.borderStyle != 0 && (j + 1 >= styles.length || !style_1.isAdherentBorder__Lorg_eclipse_swt_graphics_TextStyle_2(styles[j + 1].style));
      var drawStrikeout: Boolean = style_1.strikeout;
      if (!drawUnderline && !drawBorder && !drawStrikeout)
        continue;
      var end_1: int = this.translateOffset__I(styles[j + 1].start);
      var lineY_1: Number = y + 2;
      for (var lineIndex_1: int = 0; lineIndex_1 < textField.numLines; lineIndex_1++) {
        var lineStart_1: int = textField.getLineOffset(lineIndex_1);
        var lineEnd_1: int = lineStart_1 + textField.getLineLength(lineIndex_1);
        var metrics_1: TextLineMetrics = textField.getLineMetrics(lineIndex_1);
        if (drawUnderline) {
          var start_1: int = run_1.start;
          for (var k: int = j; k > 0 && style_1.isAdherentUnderline__Lorg_eclipse_swt_graphics_TextStyle_2(styles[k - 1].style); k--) {
            start_1 = styles[k - 1].start;
          }
          start_1 = this.translateOffset__I(start_1);
          if (!(start_1 > lineEnd_1 || end_1 < lineStart_1)) {
            var highStart_1: int = Math__.max__II(lineStart_1, start_1);
            var highEnd_1: int = Math__.min__II(lineEnd_1, end_1);
            if (highStart_1 != highEnd_1) {
              var startRect_1: flash.geom.Rectangle = textField.getCharBoundaries(highStart_1);
              var endRect_1: flash.geom.Rectangle = textField.getCharBoundaries(highEnd_1 - 1);
              var shape_1: Shape = new Shape();
              if (data.matrix !== null)
                shape_1.transform.matrix = data.matrix;
              if (data.clip !== null)
                shape_1.mask = data.clip;
              var graphics_1: Graphics = shape_1.graphics;
              var color: int = data.foreground.handle;
              if (style_1.foreground !== null)
                color = style_1.foreground.handle;
              if (style_1.underlineColor !== null)
                color = style_1.underlineColor.handle;
              var underlineX: Number = x + startRect_1.x;
              var underlineY: Number = lineY_1 + metrics_1.ascent + 1;
              var underlineThickness: Number = 0.5;
              graphics_1.lineStyle(0, color, data.alpha / 255.0, false, "normal", CapsStyle.ROUND, JointStyle.MITER, data.lineMiterLimit);
              switch (style_1.underlineStyle) {
                case 2 :
                case 3 :
                  var squigglyThickness: int = 1;
                  var squigglyHeight: Number = 2 * squigglyThickness;
                  var lineBottom: Number = lineY_1 + metrics_1.height;
                  var squigglyY: Number = Math__.min__DD(underlineY - squigglyHeight / 2, lineBottom - squigglyHeight - 1);
                  var points: JavaArray = this.computePolyline__IIII(int(underlineX), int(squigglyY), int((underlineX + endRect_1.right - startRect_1.left)), int((squigglyY + squigglyHeight)));
                  graphics_1.moveTo(points[0] + 0.5, points[1] + 0.5);
                  for (var i_1: int = 2; i_1 < points.length; i_1 += 2) {
                    graphics_1.lineTo(points[i_1] + 0.5, points[i_1 + 1] + 0.5);
                  }
                  break;
                case 1 :
                  graphics_1.drawRect(underlineX, underlineY + underlineThickness * 4, endRect_1.right - startRect_1.left, underlineThickness);
                case 0 :
                  graphics_1.drawRect(underlineX, underlineY, endRect_1.right - startRect_1.left, underlineThickness);
                  break;
              }
              data.sprite.addChild(shape_1);
            }
          }
        }
        if (drawBorder) {
          var start_2: int = run_1.start;
          for (var k_1: int = j; k_1 > 0 && style_1.isAdherentBorder__Lorg_eclipse_swt_graphics_TextStyle_2(styles[k_1 - 1].style); k_1--) {
            start_2 = styles[k_1 - 1].start;
          }
          start_2 = this.translateOffset__I(start_2);
          if (!(start_2 > lineEnd_1 || end_1 < lineStart_1)) {
            var highStart_2: int = Math__.max__II(lineStart_1, start_2);
            var highEnd_2: int = Math__.min__II(lineEnd_1, end_1);
            if (highStart_2 != highEnd_2) {
              var startRect_2: flash.geom.Rectangle = textField.getCharBoundaries(highStart_2);
              var endRect_2: flash.geom.Rectangle = textField.getCharBoundaries(highEnd_2 - 1);
              var shape_2: Shape = new Shape();
              if (data.matrix !== null)
                shape_2.transform.matrix = data.matrix;
              if (data.clip !== null)
                shape_2.mask = data.clip;
              var color_1: int = data.foreground.handle;
              if (style_1.foreground !== null)
                color_1 = style_1.foreground.handle;
              if (style_1.borderColor !== null)
                color_1 = style_1.borderColor.handle;
              var graphics_2: Graphics = shape_2.graphics;
              graphics_2.lineStyle(0, color_1, data.alpha / 255.0, false, "normal", CapsStyle.ROUND, JointStyle.MITER, data.lineMiterLimit);
              graphics_2.drawRect(x + startRect_2.x, lineY_1, endRect_2.right - startRect_2.left - 1, metrics_1.height - 1);
              data.sprite.addChild(shape_2);
            }
          }
        }
        if (drawStrikeout) {
          var start_3: int = this.translateOffset__I(run_1.start);
          if (!(start_3 > lineEnd_1 || end_1 < lineStart_1)) {
            var highStart_3: int = Math__.max__II(lineStart_1, start_3);
            var highEnd_3: int = Math__.min__II(lineEnd_1, end_1);
            if (highStart_3 != highEnd_3) {
              var startRect_3: flash.geom.Rectangle = textField.getCharBoundaries(highStart_3);
              var endRect_3: flash.geom.Rectangle = textField.getCharBoundaries(highEnd_3 - 1);
              var shape_3: Shape = new Shape();
              if (data.matrix !== null)
                shape_3.transform.matrix = data.matrix;
              if (data.clip !== null)
                shape_3.mask = data.clip;
              var color_2: int = data.foreground.handle;
              if (style_1.foreground !== null)
                color_2 = style_1.foreground.handle;
              if (style_1.strikeoutColor !== null)
                color_2 = style_1.strikeoutColor.handle;
              var graphics_3: Graphics = shape_3.graphics;
              graphics_3.lineStyle(0, color_2, data.alpha / 255.0, false, "normal", CapsStyle.ROUND, JointStyle.MITER, data.lineMiterLimit);
              var striteoutY: Number = lineY_1 + metrics_1.height / 3 * 2;
              graphics_3.moveTo(x + startRect_3.x, striteoutY);
              graphics_3.lineTo(x + startRect_3.x + endRect_3.right - startRect_3.left, striteoutY);
              data.sprite.addChild(shape_3);
            }
          }
        }
        if (lineEnd_1 > end_1)
          break;
        lineY_1 += metrics_1.height;
      }
    }
    return;
  }
  public function freeRuns__(): void {
    textField = null;
    return;
  }
  public function getAlignment__(): int {
    this.checkLayout__();
    return alignment;
  }
  public function getAscent__(): int {
    this.checkLayout__();
    return ascent;
  }
  public function getBounds__(): org.eclipse.swt.graphics.Rectangle {
    this.checkLayout__();
    this.computeRuns__();
    var width: int = Object(text).length__() > 0 ? int(textField.textWidth) : 0;
    var height: int = int(textField.textHeight);
    if (wrapWidth != -1)
      width = wrapWidth;
    if (ascent != -1 && descent != -1) {
      height = Math__.max__II(height, ascent + descent);
    }
    return new org.eclipse.swt.graphics.Rectangle(0, 0, width, height);
  }
  public function getBounds__II(start: int, end: int): org.eclipse.swt.graphics.Rectangle {
    this.checkLayout__();
    this.computeRuns__();
    var length: int = Object(text).length__();
    if (length == 0)
      return new org.eclipse.swt.graphics.Rectangle(0, 0, 0, 0);
    if (start > end)
      return new org.eclipse.swt.graphics.Rectangle(0, 0, 0, 0);
    start = Math__.min__II(Math__.max__II(0, start), length - 1);
    end = Math__.min__II(Math__.max__II(0, end), length - 1);
    start = this.translateOffset__I(start);
    end = this.translateOffset__I(end);
    var startRect: flash.geom.Rectangle = textField.getCharBoundaries(start);
    var endRect: flash.geom.Rectangle = textField.getCharBoundaries(end);
    var rect: flash.geom.Rectangle = startRect.union(endRect);
    if (textField.getLineIndexOfChar(start) != textField.getLineIndexOfChar(end)) {
      rect.x = 2;
      rect.width = textField.width;
    }
    return new org.eclipse.swt.graphics.Rectangle(int(rect.x) - 2, int(rect.y) - 2, int(Math__.ceil__D(rect.width)), int(Math__.ceil__D(rect.height)));
  }
  public function getDescent__(): int {
    this.checkLayout__();
    return descent;
  }
  public function getFont__(): Font {
    this.checkLayout__();
    return font;
  }
  public function getIndent__(): int {
    this.checkLayout__();
    return indent;
  }
  public function getJustify__(): Boolean {
    this.checkLayout__();
    return justify;
  }
  public function getLevel__I(offset: int): int {
    this.checkLayout__();
    return 0;
  }
  public function getLineBounds__I(lineIndex: int): org.eclipse.swt.graphics.Rectangle {
    this.checkLayout__();
    this.computeRuns__();
    if (!(0 <= lineIndex && lineIndex < textField.numLines))
      SWT.error__I(6);
    if (Object(text).length__() == 0) {
      return this.getBounds__();
    }
    var start: int = textField.getLineOffset(lineIndex);
    var rect: flash.geom.Rectangle = textField.getCharBoundaries(start);
    var metrics: TextLineMetrics = textField.getLineMetrics(lineIndex);
    var height: int = int(metrics.height);
    if (ascent != -1 && descent != -1) {
      height = Math__.max__II(height, ascent + descent);
    }
    return new org.eclipse.swt.graphics.Rectangle(int(rect.x) - 2, int(rect.y) - 2, int(metrics.width), height);
  }
  public function getLineCount__(): int {
    this.checkLayout__();
    this.computeRuns__();
    return textField.numLines;
  }
  public function getLineIndex__I(offset: int): int {
    this.checkLayout__();
    this.computeRuns__();
    var length: int = Object(text).length__();
    if (!(0 <= offset && offset <= length))
      SWT.error__I(6);
    if (offset == length)
      return textField.numLines - 1;
    offset = this.translateOffset__I(offset);
    return textField.getLineIndexOfChar(offset);
  }
  public function getLineMetrics__I(lineIndex: int): FontMetrics {
    this.checkLayout__();
    this.computeRuns__();
    var lineCount: int = this.getLineCount__();
    if (!(0 <= lineIndex && lineIndex < lineCount))
      SWT.error__I(6);
    var metrics: TextLineMetrics = textField.getLineMetrics(lineIndex);
    var ascent_1: int = Math__.max__II(this.ascent, int(metrics.ascent));
    var descent_1: int = Math__.max__II(this.descent, int(metrics.descent));
    return FontMetrics.internal_new__IIII(ascent_1, descent_1, ascent_1 + descent_1, 0);
  }
  public function getLineOffsets__(): JavaArray {
    this.checkLayout__();
    this.computeRuns__();
    var offsets: JavaArray = new JavaArray("[I").lengths(textField.numLines + 1);
    for (var i: int = 0; i < offsets.length - 1; i++) {
      offsets[i] = this.untranslateOffset__I(textField.getLineOffset(i));
    }
    offsets[offsets.length - 1] = Object(text).length__();
    return offsets;
  }
  public function getLocation__IZ(offset: int, trailing: Boolean): org.eclipse.swt.graphics.Point {
    this.checkLayout__();
    this.computeRuns__();
    var length: int = Object(text).length__();
    if (!(0 <= offset && offset <= length))
      SWT.error__I(6);
    if (length == 0)
      return new org.eclipse.swt.graphics.Point(0, 0);
    offset = this.translateOffset__I(offset);
    var rect: flash.geom.Rectangle = textField.getCharBoundaries(offset);
    var x: int = int(rect.x);
    if (trailing)
      x += rect.width;
    return new org.eclipse.swt.graphics.Point(x - 2, int(rect.y) - 2);
  }
  public function getNextOffset__II(offset: int, movement: int): int {
    this.checkLayout__();
    return this._getOffset__IIZ(offset, movement, true);
  }
  public function _getOffset__IIZ(offset: int, movement: int, forward: Boolean): int {
    this.computeRuns__();
    var length: int = Object(text).length__();
    if (!(0 <= offset && offset <= length))
      SWT.error__I(6);
    if (forward && offset == length)
      return length;
    if (!forward && offset == 0)
      return 0;
    var step: int = forward ? 1 : -1;
    if ((movement & 1) != 0)
      return offset + step;
    if ((movement & 2) != 0)
      return offset + step;
    offset = this.translateOffset__I(offset);
    var lineIndex: int = textField.getLineIndexOfChar(Math__.max__II(0, Math__.min__II(length - 1, offset)));
    var lineStart: int = textField.getLineOffset(lineIndex);
    var lineLength: int = textField.getLineLength(lineIndex);
    var lineBreak: int = 0;
    while (lineStart <= offset && offset <= lineStart + lineLength) {
      var newOffset: int = offset + step;
      var trailing: int = 0;
      if (forward) {
        if (newOffset + trailing >= lineStart + lineLength - lineBreak) {
          var lineEnd: int = lineStart + lineLength;
          if (trailing != 0)
            lineEnd -= lineBreak;
          return this.untranslateOffset__I(Math__.min__II(length, lineEnd));
        }
      } else {
        if (newOffset + trailing == lineStart) {
          if (lineIndex == 0)
            return 0;
          var lineEnd_1: int = 0;
          return this.untranslateOffset__I(Math__.max__II(0, newOffset + trailing - lineEnd_1));
        }
      }
      offset = newOffset + trailing;
      switch (movement) {
        case 2 :
          return this.untranslateOffset__I(offset);
        case 4 :
        case 16 :
          {
            if (offset > 0) {
              var letterOrDigit: Boolean = Character.isLetterOrDigit__C(Object(text).charAt__I(offset));
              var previousLetterOrDigit: Boolean = Character.isLetterOrDigit__C(Object(text).charAt__I(offset - 1));
              if (letterOrDigit != previousLetterOrDigit || !letterOrDigit) {
                if (!Character.isWhitespace__C(Object(text).charAt__I(offset))) {
                  return this.untranslateOffset__I(offset);
                }
              }
            }
            break;
          }
        case 8 :
          {
            if (offset > 0) {
              var isLetterOrDigit: Boolean = Character.isLetterOrDigit__C(Object(text).charAt__I(offset));
              var previousLetterOrDigit_1: Boolean = Character.isLetterOrDigit__C(Object(text).charAt__I(offset - 1));
              if (!isLetterOrDigit && previousLetterOrDigit_1) {
                return this.untranslateOffset__I(offset);
              }
            }
            break;
          }
      }
    }
    return forward ? length : 0;
  }
  public function getOffset__Lorg_eclipse_swt_graphics_Point_2_3I(point: org.eclipse.swt.graphics.Point, trailing: JavaArray): int {
    this.checkLayout__();
    this.computeRuns__();
    if (point === null)
      SWT.error__I(4);
    return this.getOffset__II_3I(point.x, point.y, trailing);
  }
  public function getOffset__II_3I(x: int, y: int, trailing: JavaArray): int {
    this.checkLayout__();
    this.computeRuns__();
    if (trailing !== null && trailing.length < 1)
      SWT.error__I(5);
    var length: int = Object(text).length__();
    if (length == 0)
      return 0;
    var nx: Number = Math__.max__DD(2, Math__.min__DD(x + 2, textField.textWidth + 2 - 1));
    var ny: Number = Math__.max__DD(2, Math__.min__DD(y + 2, textField.textHeight + 2 - 1));
    var offset: int = textField.getCharIndexAtPoint(nx, ny);
    if (offset == -1) {
      var rect: flash.geom.Rectangle;
      for (var i: int = 0; i < Object(text).length__(); i++) {
        rect = textField.getCharBoundaries(i);
        if (rect !== null && rect.contains(nx, ny)) {
          offset = i;
          break;
        }
      }
    }
    if (offset == -1)
      return 0;
    if (trailing !== null) {
      var rect_1: flash.geom.Rectangle = textField.getCharBoundaries(offset);
      trailing[0] = (nx - rect_1.x) > rect_1.width / 2 ? 1 : 0;
    }
    return Math__.min__II(this.untranslateOffset__I(offset), length - 1);
  }
  public function getOrientation__(): int {
    this.checkLayout__();
    return orientation;
  }
  public function getPreviousOffset__II(offset: int, movement: int): int {
    this.checkLayout__();
    return this._getOffset__IIZ(offset, movement, false);
  }
  public function getRanges__(): JavaArray {
    this.checkLayout__();
    var result: JavaArray = new JavaArray("[I").lengths(styles.length * 2);
    var count: int = 0;
    for (var i: int = 0; i < styles.length - 1; i++) {
      if (styles[i].style !== null) {
        result[count++] = styles[i].start;
        result[count++] = styles[i + 1].start - 1;
      }
    }
    if (count != result.length) {
      var newResult: JavaArray = new JavaArray("[I").lengths(count);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(result, 0, newResult, 0, count);
      result = newResult;
    }
    return result;
  }
  public function getSegments__(): JavaArray {
    this.checkLayout__();
    return segments;
  }
  public function getSpacing__(): int {
    this.checkLayout__();
    return lineSpacing;
  }
  public function getStyle__I(offset: int): TextStyle {
    this.checkLayout__();
    var length: int = Object(text).length__();
    if (!(0 <= offset && offset < length))
      SWT.error__I(6);
    for (var i: int = 1; i < styles.length; i++) {
      if (styles[i].start > offset) {
        return styles[i - 1].style;
      }
    }
    return null;
  }
  public function getStyles__(): JavaArray {
    this.checkLayout__();
    var result: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/TextStyle;").lengths(styles.length);
    var count: int = 0;
    for (var i: int = 0; i < styles.length; i++) {
      if (styles[i].style !== null) {
        result[count++] = styles[i].style;
      }
    }
    if (count != result.length) {
      var newResult: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/TextStyle;").lengths(count);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(result, 0, newResult, 0, count);
      result = newResult;
    }
    return result;
  }
  public function getTabs__(): JavaArray {
    this.checkLayout__();
    return tabs;
  }
  public function getText__(): String {
    this.checkLayout__();
    return text;
  }
  public function getWidth__(): int {
    this.checkLayout__();
    return wrapWidth;
  }
  public override function isDisposed__(): Boolean {
    return device === null;
  }
  public function setAlignment__I(alignment_1: int): void {
    this.checkLayout__();
    var mask: int = 16384 | 16777216 | 131072;
    alignment_1 &= mask;
    if (alignment_1 == 0)
      return;
    if ((alignment_1 & 16384) != 0)
      alignment_1 = 16384;
    if ((alignment_1 & 131072) != 0)
      alignment_1 = 131072;
    if (this.alignment == alignment_1)
      return;
    this.freeRuns__();
    this.alignment = alignment_1;
  }
  public function setAscent__I(ascent_1: int): void {
    this.checkLayout__();
    if (ascent_1 < -1)
      SWT.error__I(5);
    if (this.ascent == ascent_1)
      return;
    this.freeRuns__();
    this.ascent = ascent_1;
  }
  public function setDescent__I(descent_1: int): void {
    this.checkLayout__();
    if (descent_1 < -1)
      SWT.error__I(5);
    if (this.descent == descent_1)
      return;
    this.freeRuns__();
    this.descent = descent_1;
  }
  public function setFont__Lorg_eclipse_swt_graphics_Font_2(font_1: Font): void {
    this.checkLayout__();
    if (font_1 !== null && font_1.isDisposed__())
      SWT.error__I(5);
    if (this.font === font_1)
      return;
    if (font_1 !== null && font_1.equals__Ljava_lang_Object_2(this.font))
      return;
    this.freeRuns__();
    this.font = font_1;
  }
  public function setIndent__I(indent_1: int): void {
    this.checkLayout__();
    if (indent_1 < 0)
      return;
    if (this.indent == indent_1)
      return;
    this.freeRuns__();
    this.indent = indent_1;
  }
  public function setJustify__Z(justify_1: Boolean): void {
    this.checkLayout__();
    if (this.justify == justify_1)
      return;
    this.freeRuns__();
    this.justify = justify_1;
  }
  public function setOrientation__I(orientation_1: int): void {
    this.checkLayout__();
    var mask: int = 33554432 | 67108864;
    orientation_1 &= mask;
    if (orientation_1 == 0)
      return;
    if ((orientation_1 & 33554432) != 0)
      orientation_1 = 33554432;
    if (this.orientation == orientation_1)
      return;
    this.orientation = orientation_1;
    this.freeRuns__();
  }
  public function setSegments___3I(segments_1: JavaArray): void {
    this.checkLayout__();
    if (this.segments === null && segments_1 === null)
      return;
    if (this.segments !== null && segments_1 !== null) {
      if (this.segments.length == segments_1.length) {
        var i: int;
        for (i = 0; i < segments_1.length; i++) {
          if (this.segments[i] != segments_1[i])
            break;
        }
        if (i == segments_1.length)
          return;
      }
    }
    this.freeRuns__();
    this.segments = segments_1;
    return;
  }
  public function setSpacing__I(spacing: int): void {
    this.checkLayout__();
    if (spacing < 0)
      SWT.error__I(5);
    if (this.lineSpacing == spacing)
      return;
    this.freeRuns__();
    this.lineSpacing = spacing;
  }
  public function setStyle__Lorg_eclipse_swt_graphics_TextStyle_2II(style: TextStyle, start: int, end: int): void {
    this.checkLayout__();
    var length: int = Object(text).length__();
    if (length == 0)
      return;
    if (start > end)
      return;
    start = Math__.min__II(Math__.max__II(0, start), length - 1);
    end = Math__.min__II(Math__.max__II(0, end), length - 1);
    var low: int = -1;
    var high: int = styles.length;
    while (high - low > 1) {
      var index: int = int((high + low) / 2);
      if (styles[index + 1].start > start) {
        high = index;
      } else {
        low = index;
      }
    }
    if (0 <= high && high < styles.length) {
      var item: TextLayout$StyleItem = styles[high];
      if (item.start == start && styles[high + 1].start - 1 == end) {
        if (style === null) {
          if (item.style === null)
            return;
        } else {
          if (style.equals__Ljava_lang_Object_2(item.style))
            return;
        }
      }
    }
    this.freeRuns__();
    var modifyStart: int = high;
    var modifyEnd: int = modifyStart;
    while (modifyEnd < styles.length) {
      if (styles[modifyEnd + 1].start > end)
        break;
      modifyEnd++;
    }
    if (modifyStart == modifyEnd) {
      var styleStart: int = styles[modifyStart].start;
      var styleEnd: int = styles[modifyEnd + 1].start - 1;
      if (styleStart == start && styleEnd == end) {
        styles[modifyStart].style = style;
        return;
      }
      if (styleStart != start && styleEnd != end) {
        var newStyles: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/TextLayout$StyleItem;").lengths(styles.length + 2);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(styles, 0, newStyles, 0, modifyStart + 1);
        var item_1: TextLayout$StyleItem = new TextLayout$StyleItem();
        item_1.start = start;
        item_1.style = style;
        newStyles[modifyStart + 1] = item_1;
        item_1 = new TextLayout$StyleItem();
        item_1.start = end + 1;
        item_1.style = styles[modifyStart].style;
        newStyles[modifyStart + 2] = item_1;
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(styles, modifyEnd + 1, newStyles, modifyEnd + 3, styles.length - modifyEnd - 1);
        styles = newStyles;
        return;
      }
    }
    if (start == styles[modifyStart].start)
      modifyStart--;
    if (end == styles[modifyEnd + 1].start - 1)
      modifyEnd++;
    var newLength: int = styles.length + 1 - (modifyEnd - modifyStart - 1);
    var newStyles_1: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/TextLayout$StyleItem;").lengths(newLength);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(styles, 0, newStyles_1, 0, modifyStart + 1);
    var item_2: TextLayout$StyleItem = new TextLayout$StyleItem();
    item_2.start = start;
    item_2.style = style;
    newStyles_1[modifyStart + 1] = item_2;
    styles[modifyEnd].start = end + 1;
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(styles, modifyEnd, newStyles_1, modifyStart + 2, styles.length - modifyEnd);
    styles = newStyles_1;
    return;
  }
  public function setTabs___3I(tabs_1: JavaArray): void {
    this.checkLayout__();
    if (this.tabs === null && tabs_1 === null)
      return;
    if (this.tabs !== null && tabs_1 !== null) {
      if (this.tabs.length == tabs_1.length) {
        var i: int;
        for (i = 0; i < tabs_1.length; i++) {
          if (this.tabs[i] != tabs_1[i])
            break;
        }
        if (i == tabs_1.length)
          return;
      }
    }
    this.freeRuns__();
    this.tabs = tabs_1;
    return;
  }
  public function setText__Ljava_lang_String_2(text_1: String): void {
    this.checkLayout__();
    if (text_1 === null)
      SWT.error__I(4);
    if (Object(text_1).equals__Ljava_lang_Object_2(this.text))
      return;
    this.freeRuns__();
    this.text = text_1;
    styles = new JavaArray("[Lorg/eclipse/swt/graphics/TextLayout$StyleItem;").lengths(2);
    styles[0] = new TextLayout$StyleItem();
    styles[1] = new TextLayout$StyleItem();
    styles[1].start = Object(text_1).length__();
  }
  public function setWidth__I(width: int): void {
    this.checkLayout__();
    if (width < -1 || width == 0)
      SWT.error__I(5);
    if (this.wrapWidth == width)
      return;
    this.freeRuns__();
    this.wrapWidth = width;
  }
  public function toString__(): String {
    if (this.isDisposed__())
      return "TextLayout {*DISPOSED*}";
    return "TextLayout {}";
  }
  public function translateOffset__I(offset: int): int {
    return offset;
  }
  public function untranslateOffset__I(offset: int): int {
    return offset;
  }
}
}
