package org.eclipse.swt.graphics {
import org.eclipse.swt.*;
import org.eclipse.swt.SWT;
import java.lang.StringBuffer;
import java.lang.Arguments;
dynamic public class TextStyle {
  public var font: Font;
  public var foreground: Color;
  public var background: Color;
  public var underline: Boolean;
  public var underlineColor: Color;
  public var underlineStyle: int;
  public var strikeout: Boolean;
  public var strikeoutColor: Color;
  public var borderStyle: int;
  public var borderColor: Color;
  public var metrics: GlyphMetrics;
  public var rise: int;
  public var data: Object;
  public function TextStyle__(): Object {
    return this;
  }
  public function TextStyle__Lorg_eclipse_swt_graphics_Font_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(font: Font, foreground: Color, background: Color): Object {
    if (font !== null && font.isDisposed__())
      SWT.error__I(5);
    if (foreground !== null && foreground.isDisposed__())
      SWT.error__I(5);
    if (background !== null && background.isDisposed__())
      SWT.error__I(5);
    this.font = font;
    this.foreground = foreground;
    this.background = background;
    return this;
  }
  public function TextStyle__Lorg_eclipse_swt_graphics_TextStyle_2(style: TextStyle): Object {
    if (style === null)
      SWT.error__I(5);
    font = style.font;
    foreground = style.foreground;
    background = style.background;
    underline = style.underline;
    underlineColor = style.underlineColor;
    underlineStyle = style.underlineStyle;
    strikeout = style.strikeout;
    strikeoutColor = style.strikeoutColor;
    borderStyle = style.borderStyle;
    borderColor = style.borderColor;
    metrics = style.metrics;
    rise = style.rise;
    data = style.data;
    return this;
  }
  public function equals__Ljava_lang_Object_2(object: Object): Boolean {
    if (object === this)
      return true;
    if (object === null)
      return false;
    if (!(object is TextStyle))
      return false;
    var style: TextStyle = TextStyle(object);
    if (foreground !== null) {
      if (!foreground.equals__Ljava_lang_Object_2(style.foreground))
        return false;
    } else if (style.foreground !== null)
      return false;
    if (background !== null) {
      if (!background.equals__Ljava_lang_Object_2(style.background))
        return false;
    } else if (style.background !== null)
      return false;
    if (font !== null) {
      if (!font.equals__Ljava_lang_Object_2(style.font))
        return false;
    } else if (style.font !== null)
      return false;
    if (metrics !== null || style.metrics !== null)
      return false;
    if (underline != style.underline)
      return false;
    if (underlineStyle != style.underlineStyle)
      return false;
    if (borderStyle != style.borderStyle)
      return false;
    if (strikeout != style.strikeout)
      return false;
    if (rise != style.rise)
      return false;
    if (underlineColor !== null) {
      if (!underlineColor.equals__Ljava_lang_Object_2(style.underlineColor))
        return false;
    } else if (style.underlineColor !== null)
      return false;
    if (strikeoutColor !== null) {
      if (!strikeoutColor.equals__Ljava_lang_Object_2(style.strikeoutColor))
        return false;
    } else if (style.strikeoutColor !== null)
      return false;
    if (underlineStyle != style.underlineStyle)
      return false;
    if (borderColor !== null) {
      if (!borderColor.equals__Ljava_lang_Object_2(style.borderColor))
        return false;
    } else if (style.borderColor !== null)
      return false;
    if (data !== null) {
      if (!Object(data).equals__Ljava_lang_Object_2(style.data))
        return false;
    } else if (style.data !== null)
      return false;
    return true;
  }
  public function hashCode__(): int {
    var hash: int = 0;
    if (foreground !== null)
      hash ^= foreground.hashCode__();
    if (background !== null)
      hash ^= background.hashCode__();
    if (font !== null)
      hash ^= font.hashCode__();
    if (metrics !== null)
      hash ^= metrics.hashCode__();
    if (underline)
      hash ^= hash;
    if (strikeout)
      hash ^= hash;
    hash ^= rise;
    if (underlineColor !== null)
      hash ^= underlineColor.hashCode__();
    if (strikeoutColor !== null)
      hash ^= strikeoutColor.hashCode__();
    if (borderColor !== null)
      hash ^= borderColor.hashCode__();
    hash ^= underlineStyle;
    return hash;
  }
  public function isAdherentBorder__Lorg_eclipse_swt_graphics_TextStyle_2(style: TextStyle): Boolean {
    if (this === style)
      return true;
    if (style === null)
      return false;
    if (borderStyle != style.borderStyle)
      return false;
    if (borderColor !== null) {
      if (!borderColor.equals__Ljava_lang_Object_2(style.borderColor))
        return false;
    } else {
      if (style.borderColor !== null)
        return false;
      if (foreground !== null) {
        if (!foreground.equals__Ljava_lang_Object_2(style.foreground))
          return false;
      } else if (style.foreground !== null)
        return false;
    }
    return true;
  }
  public function isAdherentUnderline__Lorg_eclipse_swt_graphics_TextStyle_2(style: TextStyle): Boolean {
    if (this === style)
      return true;
    if (style === null)
      return false;
    if (underline != style.underline)
      return false;
    if (underlineStyle != style.underlineStyle)
      return false;
    if (underlineColor !== null) {
      if (!underlineColor.equals__Ljava_lang_Object_2(style.underlineColor))
        return false;
    } else {
      if (style.underlineColor !== null)
        return false;
      if (foreground !== null) {
        if (!foreground.equals__Ljava_lang_Object_2(style.foreground))
          return false;
      } else if (style.foreground !== null)
        return false;
    }
    return true;
  }
  public function isAdherentStrikeout__Lorg_eclipse_swt_graphics_TextStyle_2(style: TextStyle): Boolean {
    if (this === style)
      return true;
    if (style === null)
      return false;
    if (strikeout != style.strikeout)
      return false;
    if (strikeoutColor !== null) {
      if (!strikeoutColor.equals__Ljava_lang_Object_2(style.strikeoutColor))
        return false;
    } else {
      if (style.strikeoutColor !== null)
        return false;
      if (foreground !== null) {
        if (!foreground.equals__Ljava_lang_Object_2(style.foreground))
          return false;
      } else if (style.foreground !== null)
        return false;
    }
    return true;
  }
  public function toString__(): String {
    var buffer: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__Ljava_lang_String_2, ["TextStyle {"]));
    var startLength: int = buffer.length__();
    if (font !== null) {
      if (buffer.length__() > startLength)
        buffer.append__Ljava_lang_String_2(", ");
      buffer.append__Ljava_lang_String_2("font=");
      buffer.append__Ljava_lang_Object_2(font);
    }
    if (foreground !== null) {
      if (buffer.length__() > startLength)
        buffer.append__Ljava_lang_String_2(", ");
      buffer.append__Ljava_lang_String_2("foreground=");
      buffer.append__Ljava_lang_Object_2(foreground);
    }
    if (background !== null) {
      if (buffer.length__() > startLength)
        buffer.append__Ljava_lang_String_2(", ");
      buffer.append__Ljava_lang_String_2("background=");
      buffer.append__Ljava_lang_Object_2(background);
    }
    if (underline) {
      if (buffer.length__() > startLength)
        buffer.append__Ljava_lang_String_2(", ");
      buffer.append__Ljava_lang_String_2("underline=");
      switch (underlineStyle) {
        case 0 :
          buffer.append__Ljava_lang_String_2("single");
          break;
        case 1 :
          buffer.append__Ljava_lang_String_2("double");
          break;
        case 3 :
          buffer.append__Ljava_lang_String_2("squiggle");
          break;
        case 2 :
          buffer.append__Ljava_lang_String_2("error");
          break;
        case 4 :
          buffer.append__Ljava_lang_String_2("link");
          break;
      }
      if (underlineColor !== null) {
        buffer.append__Ljava_lang_String_2(", underlineColor=");
        buffer.append__Ljava_lang_Object_2(underlineColor);
      }
    }
    if (strikeout) {
      if (buffer.length__() > startLength)
        buffer.append__Ljava_lang_String_2(", ");
      buffer.append__Ljava_lang_String_2("striked out");
      if (strikeoutColor !== null) {
        buffer.append__Ljava_lang_String_2(", strikeoutColor=");
        buffer.append__Ljava_lang_Object_2(strikeoutColor);
      }
    }
    if (borderStyle != 0) {
      if (buffer.length__() > startLength)
        buffer.append__Ljava_lang_String_2(", ");
      buffer.append__Ljava_lang_String_2("border=");
      switch (borderStyle) {
        case 1 :
          buffer.append__Ljava_lang_String_2("solid");
          break;
        case 4 :
          buffer.append__Ljava_lang_String_2("dot");
          break;
        case 2 :
          buffer.append__Ljava_lang_String_2("dash");
          break;
      }
      if (borderColor !== null) {
        buffer.append__Ljava_lang_String_2(", borderColor=");
        buffer.append__Ljava_lang_Object_2(borderColor);
      }
    }
    if (rise != 0) {
      if (buffer.length__() > startLength)
        buffer.append__Ljava_lang_String_2(", ");
      buffer.append__Ljava_lang_String_2("rise=");
      buffer.append__I(rise);
    }
    if (metrics !== null) {
      if (buffer.length__() > startLength)
        buffer.append__Ljava_lang_String_2(", ");
      buffer.append__Ljava_lang_String_2("metrics=");
      buffer.append__Ljava_lang_Object_2(metrics);
    }
    buffer.append__Ljava_lang_String_2("}");
    return buffer.toString__();
  }
  public function TextStyle(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 3 && vargs[0] is Font && vargs[1] is Color && vargs[2] is Color) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is TextStyle) {
        args = vargs;
        id = 2;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0], args[1], args[2]];
        break;
      case 2:
        var args2: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        TextStyle__();
        break;
      case 1:
        TextStyle__Lorg_eclipse_swt_graphics_Font_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(args1[0], args1[1], args1[2]);
        break;
      case 2:
        TextStyle__Lorg_eclipse_swt_graphics_TextStyle_2(args2[0]);
        break;
    }
  }
  public static const TextStyle__ : int = 0;
  public static const TextStyle__Lorg_eclipse_swt_graphics_Font_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2 : int = 1;
  public static const TextStyle__Lorg_eclipse_swt_graphics_TextStyle_2 : int = 2;
}
}
