package org.eclipse.swt.graphics {
import org.eclipse.swt.*;
import org.eclipse.swt.internal.*;
import flash.geom.Matrix;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Compatibility;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Transform extends Resource {
  public var object: Matrix;
  public function Transform__Lorg_eclipse_swt_graphics_Device_2(device: Device): Object {
    return this;
  }
  public function Transform__Lorg_eclipse_swt_graphics_Device_2_3F(device: Device, elements: JavaArray): Object {
    return this;
  }
  public function Transform__Lorg_eclipse_swt_graphics_Device_2FFFFFF(device: Device, m11: Number, m12: Number, m21: Number, m22: Number, dx: Number, dy: Number): Object {
    object = new Matrix(m11, m12, m21, m22, dx, dy);
    if (object === null)
      SWT.error__I(2);
    this.init__();
    return this;
  }
  public static function checkTransform___3F(elements: JavaArray): JavaArray {
    if (elements === null)
      SWT.error__I(4);
    if (elements.length < 6)
      SWT.error__I(5);
    return elements;
  }
  public override function destroy__(): void {
    object = null;
  }
  public function getElements___3F(elements: JavaArray): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (elements === null)
      SWT.error__I(4);
    if (elements.length < 6)
      SWT.error__I(5);
    elements[0] = Number(object.a);
    elements[1] = Number(object.b);
    elements[2] = Number(object.c);
    elements[3] = Number(object.d);
    elements[4] = Number(object.tx);
    elements[5] = Number(object.ty);
  }
  public function identity__(): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    object.identity();
  }
  public function invert__(): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    object.invert();
  }
  public override function isDisposed__(): Boolean {
    return object === null;
  }
  public function isIdentity__(): Boolean {
    if (this.isDisposed__())
      SWT.error__I(44);
    return object.a == 1 && object.b == 0 && object.c == 0 && object.d == 1 && object.tx == 0 && object.ty == 0;
  }
  public function multiply__Lorg_eclipse_swt_graphics_Transform_2(matrix: Transform): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (matrix === null)
      SWT.error__I(4);
    if (matrix.isDisposed__())
      SWT.error__I(5);
    var m: Matrix = Matrix(matrix.object.clone());
    m.concat(object);
    object.a = m.a;
    object.b = m.b;
    object.c = m.c;
    object.d = m.d;
    object.tx = m.tx;
    object.ty = m.ty;
  }
  public function rotate__F(angle: Number): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    object.rotate(angle * Number(Compatibility.PI) / 180);
  }
  public function scale__FF(scaleX: Number, scaleY: Number): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    object.scale(scaleX, scaleY);
  }
  public function setElements__FFFFFF(m11: Number, m12: Number, m21: Number, m22: Number, dx: Number, dy: Number): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    object.a = m11;
    object.b = m12;
    object.c = m21;
    object.d = m22;
    object.tx = dx;
    object.ty = dy;
  }
  public function shear__FF(shearX: Number, shearY: Number): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    var matrix: Matrix = new Matrix(1, shearX, shearY, 1, 0, 0);
    matrix.concat(object);
    object.a = matrix.a;
    object.b = matrix.b;
    object.c = matrix.c;
    object.d = matrix.d;
    object.tx = matrix.tx;
    object.ty = matrix.ty;
  }
  public function transform___3F(pointArray: JavaArray): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    if (pointArray === null)
      SWT.error__I(4);
  }
  public function translate__FF(offsetX: Number, offsetY: Number): void {
    if (this.isDisposed__())
      SWT.error__I(44);
    object.translate(offsetX, offsetY);
  }
  public function toString__(): String {
    if (this.isDisposed__())
      return "Transform {*DISPOSED*}";
    var elements: JavaArray = new JavaArray("[F").lengths(6);
    this.getElements___3F(elements);
    return "Transform {" + elements[0] + "," + elements[1] + "," + elements[2] + "," + elements[3] + "," + elements[4] + "," + elements[5] + "}";
  }
  public function Transform(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is Device) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Device && vargs[1] is JavaArray) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 7 && vargs[0] is Device && vargs[1] is Number && vargs[2] is Number && vargs[3] is Number && vargs[4] is Number && vargs[5] is Number && vargs[6] is Number) {
        args = vargs;
        id = 2;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        args2 = [args0[0], 1, 0, 0, 1, 0, 0];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args2[0]]);
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        args2 = [args1[0], Transform.checkTransform___3F(args1[1])[0], args1[1][1], args1[1][2], args1[1][3], args1[1][4], args1[1][5]];
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args2[0]]);
        break;
      case 2:
        var args2: Array = [args[0], args[1], args[2], args[3], args[4], args[5], args[6]];
        superArgs = new Arguments(org.eclipse.swt.graphics.Resource.Resource__Lorg_eclipse_swt_graphics_Device_2, [args2[0]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        Transform__Lorg_eclipse_swt_graphics_Device_2FFFFFF(args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6]);
        Transform__Lorg_eclipse_swt_graphics_Device_2(args0[0]);
        break;
      case 1:
        Transform__Lorg_eclipse_swt_graphics_Device_2FFFFFF(args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6]);
        Transform__Lorg_eclipse_swt_graphics_Device_2_3F(args1[0], args1[1]);
        break;
      case 2:
        Transform__Lorg_eclipse_swt_graphics_Device_2FFFFFF(args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6]);
        break;
    }
  }
  public static const Transform__Lorg_eclipse_swt_graphics_Device_2 : int = 0;
  public static const Transform__Lorg_eclipse_swt_graphics_Device_2_3F : int = 1;
  public static const Transform__Lorg_eclipse_swt_graphics_Device_2FFFFFF : int = 2;
}
}
