package org.eclipse.swt.internal {
import java.lang.Class__;
import java.lang.Arguments;
dynamic public class Callback {
  internal var object: Object;
  internal var method: String;
  internal var signature: String;
  internal var argCount: int;
  internal var address: int;
  internal var errorResult: int;
  internal var isStatic: Boolean;
  internal var isArrayBased: Boolean;
  public static var PTR_SIGNATURE: String = C.PTR_SIZEOF == 4 ? "I" : "J";
  public static var SIGNATURE_0: String = getSignature__I(0);
  public static var SIGNATURE_1: String = getSignature__I(1);
  public static var SIGNATURE_2: String = getSignature__I(2);
  public static var SIGNATURE_3: String = getSignature__I(3);
  public static var SIGNATURE_4: String = getSignature__I(4);
  public static var SIGNATURE_N: String = "([" + PTR_SIGNATURE + ")" + PTR_SIGNATURE;
  public function Callback__Ljava_lang_Object_2Ljava_lang_String_2I(object: Object, method: String, argCount: int): Object {
    return this;
  }
  public function Callback__Ljava_lang_Object_2Ljava_lang_String_2IZ(object: Object, method: String, argCount: int, isArrayBased: Boolean): Object {
    return this;
  }
  public function Callback__Ljava_lang_Object_2Ljava_lang_String_2IZI(object: Object, method: String, argCount: int, isArrayBased: Boolean, errorResult: int): Object {
    this.object = object;
    this.method = method;
    this.argCount = argCount;
    this.isStatic = object is Class__;
    this.isArrayBased = isArrayBased;
    this.errorResult = errorResult;
    if (isArrayBased) {
      signature = SIGNATURE_N;
    } else {
      switch (argCount) {
        case 0 :
          signature = SIGNATURE_0;
          break;
        case 1 :
          signature = SIGNATURE_1;
          break;
        case 2 :
          signature = SIGNATURE_2;
          break;
        case 3 :
          signature = SIGNATURE_3;
          break;
        case 4 :
          signature = SIGNATURE_4;
          break;
        default :
          signature = Callback.getSignature__I(argCount);
      }
    }
    address = Callback.bind__Lorg_eclipse_swt_internal_Callback_2Ljava_lang_Object_2Ljava_lang_String_2Ljava_lang_String_2IZZI(this, object, method, signature, argCount, isStatic, isArrayBased, errorResult);
    return this;
  }
  public static function bind__Lorg_eclipse_swt_internal_Callback_2Ljava_lang_Object_2Ljava_lang_String_2Ljava_lang_String_2IZZI(callback: Callback, object: Object, method: String, signature: String, argCount: int, isStatic: Boolean, isArrayBased: Boolean, errorResult: int): int { // native
    return 0;
  }
  public function dispose__(): void {
    if (object === null)
      return;
    Callback.unbind__Lorg_eclipse_swt_internal_Callback_2(this);
    object = method = signature = null;
    address = 0;
  }
  public function getAddress__(): int {
    return address;
  }
  public static function getPlatform__(): String { // native
    return null;
  }
  public static function getEntryCount__(): int { // native
    return 0;
  }
  public static function getSignature__I(argCount: int): String {
    var signature: String = "(";
    for (var i: int = 0; i < argCount; i++)
      signature += PTR_SIGNATURE;
    signature += ")" + PTR_SIGNATURE;
    return signature;
  }
  public static function setEnabled__Z(enable: Boolean): void { // native
    return;
  }
  public static function getEnabled__(): Boolean { // native
    return false;
  }
  public static function ignoreCallbacks__Z(ignore: Boolean): void {
    setEnabled__Z(!ignore);
  }
  public static function reset__(): void { // native
    return;
  }
  public static function unbind__Lorg_eclipse_swt_internal_Callback_2(callback: Callback): void { // native
    return;
  }
  public function Callback(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 3 && vargs[0] is Object && vargs[1] is String && vargs[2] is int) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 4 && vargs[0] is Object && vargs[1] is String && vargs[2] is int && vargs[3] is Boolean) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 5 && vargs[0] is Object && vargs[1] is String && vargs[2] is int && vargs[3] is Boolean && vargs[4] is int) {
        args = vargs;
        id = 2;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1], args[2]];
        args1 = [args0[0], args0[1], args0[2], false];
        args2 = [args1[0], args1[1], args1[2], args1[3], 0];
        break;
      case 1:
        var args1: Array = [args[0], args[1], args[2], args[3]];
        args2 = [args1[0], args1[1], args1[2], args1[3], 0];
        break;
      case 2:
        var args2: Array = [args[0], args[1], args[2], args[3], args[4]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Callback__Ljava_lang_Object_2Ljava_lang_String_2IZI(args2[0], args2[1], args2[2], args2[3], args2[4]);
        Callback__Ljava_lang_Object_2Ljava_lang_String_2IZ(args1[0], args1[1], args1[2], args1[3]);
        Callback__Ljava_lang_Object_2Ljava_lang_String_2I(args0[0], args0[1], args0[2]);
        break;
      case 1:
        Callback__Ljava_lang_Object_2Ljava_lang_String_2IZI(args2[0], args2[1], args2[2], args2[3], args2[4]);
        Callback__Ljava_lang_Object_2Ljava_lang_String_2IZ(args1[0], args1[1], args1[2], args1[3]);
        break;
      case 2:
        Callback__Ljava_lang_Object_2Ljava_lang_String_2IZI(args2[0], args2[1], args2[2], args2[3], args2[4]);
        break;
    }
  }
  public static const Callback__Ljava_lang_Object_2Ljava_lang_String_2I : int = 0;
  public static const Callback__Ljava_lang_Object_2Ljava_lang_String_2IZ : int = 1;
  public static const Callback__Ljava_lang_Object_2Ljava_lang_String_2IZI : int = 2;
}
}
