package org.eclipse.swt.internal {
import java.io.*;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.SWT;
import java.lang.Math__;
import java.io.OutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.Character;
import java.lang.Thread;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Compatibility {
  public static var PI: Number = 3.141592653589793;
  public static var toRadians: Number = PI / 180;
  public static var msgs: ResourceBundle = null;
  public static function cos__II(angle: int, length: int): int {
    return int((Math__.cos__D(angle * toRadians) * length));
  }
  public static function sin__II(angle: int, length: int): int {
    return int((Math__.sin__D(angle * toRadians) * length));
  }
  public static function ceil__II(p: int, q: int): int {
    return int(Math__.ceil__D(Number(p) / q));
  }
  public static function fileExists__Ljava_lang_String_2Ljava_lang_String_2(parent: String, child: String): Boolean {
    return false;
  }
  public static function floor__II(p: int, q: int): int {
    return int(Math__.floor__D(Number(p) / q));
  }
  public static function round__II(p: int, q: int): int {
    return Math__.round__F(Number(p) / q);
  }
  public static function pow2__I(n: int): int {
    if (n >= 1 && n <= 30)
      return 2 << (n - 1);
    else if (n != 0) {
      SWT.error__I(6);
    }
    return 1;
  }
  public static function newDeflaterOutputStream__Ljava_io_OutputStream_2(stream: OutputStream): OutputStream {
    return null;
  }
  public static function newFileInputStream__Ljava_lang_String_2(filename: String): InputStream {
    throw new IOException(new Arguments(java.io.IOException.IOException__, []));
  }
  public static function newFileOutputStream__Ljava_lang_String_2(filename: String): OutputStream {
    throw new IOException(new Arguments(java.io.IOException.IOException__, []));
  }
  public static function newInflaterInputStream__Ljava_io_InputStream_2(stream: InputStream): InputStream {
    return null;
  }
  public static function isLetter__C(c: uint): Boolean {
    return Character.isLetter__C(c);
  }
  public static function isLetterOrDigit__C(c: uint): Boolean {
    return Character.isLetterOrDigit__C(c);
  }
  public static function isSpaceChar__C(c: uint): Boolean {
    return Character.isWhitespace__C(c);
  }
  public static function isWhitespace__C(c: uint): Boolean {
    return Character.isWhitespace__C(c);
  }
  public static function exec__Ljava_lang_String_2(prog: String): void {
    throw new IOException(new Arguments(java.io.IOException.IOException__, []));
  }
  public static function exec___3Ljava_lang_String_2(progArray: JavaArray): void {
    throw new IOException(new Arguments(java.io.IOException.IOException__, []));
  }
  public static function getMessage__Ljava_lang_String_2(key: String): String {
    var answer: String = key;
    if (key === null) {
      SWT.error__I(4);
    }
    if (msgs === null) {
      try {
        msgs = ResourceBundle.getBundle__Ljava_lang_String_2("org.eclipse.swt.internal.SWTMessages");
      } catch (ex : MissingResourceException) {
        answer = key + " (no resource bundle)";
      }
    }
    if (msgs !== null) {
      try {
        answer = msgs.getString__Ljava_lang_String_2(key);
      } catch (ex2 : MissingResourceException) {
      }
    }
    return answer;
  }
  public static function getMessage__Ljava_lang_String_2_3Ljava_lang_Object_2(key: String, args: JavaArray): String {
    var answer: String = key;
    if (key === null || args === null) {
      SWT.error__I(4);
    }
    if (msgs === null) {
      try {
        msgs = ResourceBundle.getBundle__Ljava_lang_String_2("org.eclipse.swt.internal.SWTMessages");
      } catch (ex : MissingResourceException) {
        answer = key + " (no resource bundle)";
      }
    }
    if (msgs !== null) {
      try {
        var formatter: MessageFormat = new MessageFormat("");
        formatter.applyPattern__Ljava_lang_String_2(msgs.getString__Ljava_lang_String_2(key));
        answer = formatter.format__Ljava_lang_Object_2(args);
      } catch (ex2 : MissingResourceException) {
      }
    }
    return answer;
  }
  public static function interrupt__(): void {
    Thread.currentThread__().interrupt__();
  }
  public static function equalsIgnoreCase__Ljava_lang_String_2Ljava_lang_String_2(s1: String, s2: String): Boolean {
    return Object(s1).equalsIgnoreCase__Ljava_lang_String_2(s2);
  }
}
}
