package org.eclipse.swt.internal {
import java.lang.System;
import java.lang.Character;
import java.lang.Integer;
import java.lang.NumberFormatException;
dynamic public class Library {
  public static var MAJOR_VERSION: int = 3;
  public static var MINOR_VERSION: int = 530;
  public static var REVISION: int = 0;
  public static var JAVA_VERSION: int;
  public static var SWT_VERSION: int;

  __clinit();

  static private function __clinit(): void {
    {
      JAVA_VERSION = parseVersion__Ljava_lang_String_2(System.getProperty__Ljava_lang_String_2("java.version"));
      SWT_VERSION = SWT_VERSION__II(MAJOR_VERSION, MINOR_VERSION);
    }
  }
  public static function parseVersion__Ljava_lang_String_2(version: String): int {
    if (version === null)
      return 0;
    var major: int = 0;
    var minor: int = 0;
    var micro: int = 0;
    var length: int = Object(version).length__();
    var index: int = 0;
    var start: int = 0;
    while (index < length && Character.isDigit__C(Object(version).charAt__I(index)))
      index++;
    try {
      if (start < length)
        major = Integer.parseInt__Ljava_lang_String_2(Object(version).substring__II(start, index));
    } catch (e : NumberFormatException) {
    }
    start = ++index;
    while (index < length && Character.isDigit__C(Object(version).charAt__I(index)))
      index++;
    try {
      if (start < length)
        minor = Integer.parseInt__Ljava_lang_String_2(Object(version).substring__II(start, index));
    } catch (e_1 : NumberFormatException) {
    }
    start = ++index;
    while (index < length && Character.isDigit__C(Object(version).charAt__I(index)))
      index++;
    try {
      if (start < length)
        micro = Integer.parseInt__Ljava_lang_String_2(Object(version).substring__II(start, index));
    } catch (e_2 : NumberFormatException) {
    }
    return JAVA_VERSION__III(major, minor, micro);
  }
  public static function JAVA_VERSION__III(major: int, minor: int, micro: int): int {
    return (major << 16) + (minor << 8) + micro;
  }
  public static function SWT_VERSION__II(major: int, minor: int): int {
    return major * 1000 + minor;
  }
  public static function loadLibrary__Ljava_lang_String_2(name: String): void {
    loadLibrary__Ljava_lang_String_2Z(name, true);
  }
  public static function loadLibrary__Ljava_lang_String_2Z(name: String, mapName: Boolean): void {
  }
}
}
