package org.eclipse.swt.internal.flex {
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import mx.collections.ICollectionView;
import mx.controls.menuClasses.IMenuDataDescriptor;
dynamic public class SWTMenuDataDescriptor implements IMenuDataDescriptor {

  public function addChildAt(arg0: Object, arg1: Object, arg2: int, arg3: Object = null): Boolean {
    return _addChildAt(arg0, arg1, arg2, arg3);
  }
  public function getChildren(arg0: Object, arg1: Object = null): ICollectionView {
    return _getChildren(arg0, arg1);
  }
  public function getData(arg0: Object, arg1: Object = null): Object {
    return _getData(arg0, arg1);
  }
  public function hasChildren(arg0: Object, arg1: Object = null): Boolean {
    return _hasChildren(arg0, arg1);
  }
  public function isBranch(arg0: Object, arg1: Object = null): Boolean {
    return _isBranch(arg0, arg1);
  }
  public function removeChildAt(arg0: Object, arg1: Object, arg2: int, arg3: Object = null): Boolean {
    return _removeChildAt(arg0, arg1, arg2, arg3);
  }

  public function _addChildAt(parent: Object, newChild: Object, index: int, arg3: Object): Boolean {
    return false;
  }
  public function _getChildren(node: Object, model: Object): ICollectionView {
    if (node === null)
      return null;
    var item: MenuItem = MenuItem(node);
    var menu: Menu = item.getMenu__();
    if (menu !== null) {
      return menu.items;
    }
    return null;
  }
  public function _getData(node: Object, model: Object): Object {
    return node;
  }
  public function getGroupName(node: Object): String {
    return "";
  }
  public function getType(node: Object): String {
    if (node === null)
      return "normal";
    var item: MenuItem = MenuItem(node);
    var style: int = item.getStyle__();
    if ((style & 16) != 0)
      return "radio";
    if ((style & 32) != 0)
      return "check";
    if ((style & 2) != 0)
      return "separator";
    return "normal";
  }
  public function _hasChildren(node: Object, model: Object): Boolean {
    if (node === null)
      return false;
    var item: MenuItem = MenuItem(node);
    var menu: Menu = item.getMenu__();
    if (menu !== null) {
      return menu.items.length != 0;
    }
    return false;
  }
  public function _isBranch(node: Object, model: Object): Boolean {
    return this._hasChildren(node, model);
  }
  public function isEnabled(node: Object): Boolean {
    if (node === null)
      return false;
    var item: MenuItem = MenuItem(node);
    return item.isEnabled__();
  }
  public function isToggled(node: Object): Boolean {
    if (node === null)
      return false;
    var item: MenuItem = MenuItem(node);
    return item.getSelection__();
  }
  public function _removeChildAt(parent: Object, arg1: Object, arg2: int, model: Object): Boolean {
    return false;
  }
  public function setEnabled(node: Object, value: Boolean): void {
    if (node === null)
      return;
    var item: MenuItem = MenuItem(node);
    item.setEnabled__Z(value);
  }
  public function setToggled(node: Object, value: Boolean): void {
    if (node === null)
      return;
    var item: MenuItem = MenuItem(node);
    item.setSelection__Z(value);
  }
}
}
