package org.eclipse.swt.internal.flex {
import flash.events.MouseEvent;
import mx.core.Container;
import mx.core.EdgeMetrics;
import mx.core.ScrollControlBase;
import mx.events.ScrollEvent;
import mx.events.ScrollEventDirection;
import mx.managers.IFocusManagerComponent;
import java.lang.Math__;
dynamic public class SWTScrollControlBase extends ScrollControlBase implements IFocusManagerComponent {
  internal var content: Container;
  public function SWTScrollControlBase(content: Container) {
    this.content = content;
    return;
  }
  public function getContent__(): Container {
    return content;
  }
  protected override function updateDisplayList(unscaledWidth: Number, unscaledHeight: Number): void {
    super.updateDisplayList(unscaledWidth, unscaledHeight);
    var vm: EdgeMetrics = viewMetrics;
    var w: Number = unscaledWidth;
    var h: Number = unscaledHeight;
    var wd: Number = w - vm.left - vm.right;
    var ht: Number = h - vm.top - vm.bottom;
    content.width = wd < 0 ? 0 : wd;
    content.height = ht < 0 ? 0 : ht;
    content.x = vm.left;
    content.y = vm.top;
    content.mask = maskShape;
  }
  protected override function mouseWheelHandler(event: MouseEvent): void {
    if (verticalScrollBar !== null && verticalScrollBar.visible) {
      event.stopPropagation();
      var oldPosition: Number = verticalScrollBar.scrollPosition;
      var newPosition: Number = oldPosition - event.delta * verticalScrollBar.lineScrollSize;
      newPosition = Math__.max__DD(verticalScrollBar.minScrollPosition, Math__.min__DD(newPosition, verticalScrollBar.maxScrollPosition));
      if (oldPosition != newPosition) {
        verticalScrollPosition = newPosition;
        var scrollEvent: ScrollEvent = new ScrollEvent(ScrollEvent.SCROLL);
        scrollEvent.direction = ScrollEventDirection.VERTICAL;
        scrollEvent.position = newPosition;
        scrollEvent.delta = newPosition - oldPosition;
        this.dispatchEvent(scrollEvent);
      }
    }
    return;
  }
}
}
