package org.eclipse.swt.internal.flex {
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.*;
import flash.display.Bitmap;
import flash.events.MouseEvent;
import mx.containers.HBox;
import mx.controls.CheckBox;
import mx.controls.Image;
import mx.core.ScrollPolicy;
import mx.core.UITextField;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.graphics.Image;
dynamic public class TableItemRenderer extends HBox {
  internal var table: Table;
  internal var column: TableColumn;
  internal var headerRenderer: Boolean;
  internal var text: UITextField;
  internal var image: mx.controls.Image;
  internal var checkBox: CheckBox;

  override public function set data(value:Object):void
	{
		super.data = value;
		invalidateProperties();
	}

  public function TableItemRenderer(parent: Table, column: TableColumn, headerRenderer: Boolean) {
    this.table = parent;
    this.column = column;
    this.headerRenderer = headerRenderer;
    verticalScrollPolicy = ScrollPolicy.OFF;
    horizontalScrollPolicy = ScrollPolicy.OFF;
    return;
  }
  public function clickHandler__Lflash_events_MouseEvent_2(event: MouseEvent): void {
    var item: TableItem = TableItem(data);
    item.setChecked__Z(checkBox.selected);
    return;
  }
  public function clickHandlerFunction__(): Function {
    return clickHandler__Lflash_events_MouseEvent_2;
  }
  protected override function createChildren(): void {
    super.createChildren();
    if ((table.getStyle__() & 32) != 0 && !headerRenderer) {
      var index: int = table.indexOf__Lorg_eclipse_swt_widgets_TableColumn_2(column);
      if (index == 0) {
        checkBox = new CheckBox();
        this.setStyle("paddingLeft", 4);
        this.addChild(checkBox);
        checkBox.addEventListener(MouseEvent.CLICK, this.clickHandlerFunction__());
      }
    }
    image = new mx.controls.Image();
    this.addChild(image);
    text = new UITextField();
    this.addChild(text);
    return;
  }
  public override function validateProperties(): void {
    super.validateProperties();
    var string: String;
    var img: org.eclipse.swt.graphics.Image;
    if (headerRenderer) {
      string = column.getText__();
      img = column.getImage__();
    } else {
      var item: TableItem = TableItem(data);
      if (item === null)
        return;
      var index: int = column !== null ? table.indexOf__Lorg_eclipse_swt_widgets_TableColumn_2(column) : 0;
      if (checkBox !== null) {
        checkBox.selected = item.getChecked__();
      }
      string = item.getText__I(index);
      img = item.getImage__I(index);
    }
    text.text = string;
    image.source = img !== null ? new Bitmap(img.object) : null;
    return;
  }
}
}
