package org.eclipse.swt.internal.image {
import java.io.*;
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.graphics.ImageLoader;
import java.lang.Exception;
import java.io.IOException;
import org.eclipse.swt.SWT;
import java.io.InputStream;
import java.lang.Class__;
import java.lang.ClassNotFoundException;
import java.io.OutputStream;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class FileFormat {
  public static const FORMAT_PACKAGE: String = "org.eclipse.swt.internal.image";
  public static const FORMAT_SUFFIX: String = "FileFormat";
  public static var FORMATS: JavaArray = new JavaArray("[Ljava/lang/String;").values("WinBMP", "WinBMP", "GIF", "WinICO", "JPEG", "PNG", "TIFF", "OS2BMP");
  internal var inputStream: LEDataInputStream;
  internal var outputStream: LEDataOutputStream;
  internal var loader: ImageLoader;
  internal var compression: int;
  public function isFileFormat__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(stream: LEDataInputStream): Boolean { // abstract
    return false;
  }
  public function loadFromByteStream__(): JavaArray { // abstract
    return null;
  }
  public function loadFromStream__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(stream: LEDataInputStream): JavaArray {
    try {
      inputStream = stream;
      return this.loadFromByteStream__();
    } catch (e : Exception) {
      if (e is IOException) {
        SWT.error__ILjava_lang_Throwable_2(39, e);
      } else {
        SWT.error__ILjava_lang_Throwable_2(40, e);
      }
      return null;
    }
    return null;
  }
  public static function load__Ljava_io_InputStream_2Lorg_eclipse_swt_graphics_ImageLoader_2(is_1: InputStream, loader: ImageLoader): JavaArray {
    var fileFormat: FileFormat = null;
    var stream: LEDataInputStream = new LEDataInputStream(new Arguments(org.eclipse.swt.internal.image.LEDataInputStream.LEDataInputStream__Ljava_io_InputStream_2, [is_1]));
    var isSupported: Boolean = false;
    for (var i: int = 1; i < FORMATS.length; i++) {
      if (FORMATS[i] !== null) {
        try {
          var clazz: Class__ = Class__.forName__Ljava_lang_String_2("org.eclipse.swt.internal.image" + String.fromCharCode(46) + FORMATS[i] + "FileFormat");
          fileFormat = FileFormat(clazz.newInstance__());
          if (fileFormat.isFileFormat__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(stream)) {
            isSupported = true;
            break;
          }
        } catch (e : ClassNotFoundException) {
          FORMATS[i] = null;
        } catch (e_1 : Exception) {
        }
      }
    }
    if (!isSupported)
      SWT.error__I(42);
    fileFormat.loader = loader;
    return fileFormat.loadFromStream__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(stream);
  }
  public static function save__Ljava_io_OutputStream_2ILorg_eclipse_swt_graphics_ImageLoader_2(os: OutputStream, format: int, loader: ImageLoader): void {
    if (format < 0 || format >= FORMATS.length)
      SWT.error__I(42);
    if (FORMATS[format] === null)
      SWT.error__I(42);
    if (loader.data === null || loader.data.length < 1)
      SWT.error__I(5);
    var stream: LEDataOutputStream = new LEDataOutputStream(os);
    var fileFormat: FileFormat = null;
    try {
      var clazz: Class__ = Class__.forName__Ljava_lang_String_2("org.eclipse.swt.internal.image" + String.fromCharCode(46) + FORMATS[format] + "FileFormat");
      fileFormat = FileFormat(clazz.newInstance__());
    } catch (e : Exception) {
      SWT.error__I(42);
    }
    if (format == 1) {
      switch (loader.data[0].depth) {
        case 8 :
          fileFormat.compression = 1;
          break;
        case 4 :
          fileFormat.compression = 2;
          break;
      }
    }
    fileFormat.unloadIntoStream__Lorg_eclipse_swt_graphics_ImageLoader_2Lorg_eclipse_swt_internal_image_LEDataOutputStream_2(loader, stream);
    return;
  }
  public function unloadIntoByteStream__Lorg_eclipse_swt_graphics_ImageLoader_2(loader_1: ImageLoader): void { } // abstract
  public function unloadIntoStream__Lorg_eclipse_swt_graphics_ImageLoader_2Lorg_eclipse_swt_internal_image_LEDataOutputStream_2(loader_1: ImageLoader, stream: LEDataOutputStream): void {
    try {
      outputStream = stream;
      this.unloadIntoByteStream__Lorg_eclipse_swt_graphics_ImageLoader_2(loader_1);
      outputStream.flush__();
    } catch (e : Exception) {
      try {
        outputStream.flush__();
      } catch (f : Exception) {
      }
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    return;
  }
}
}
