package org.eclipse.swt.internal.image {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import java.io.*;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import java.lang.Exception;
import org.eclipse.swt.SWT;
import java.io.IOException;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import java.lang.System;
import org.eclipse.swt.graphics.ImageLoader;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class GIFFileFormat extends FileFormat {
  internal var signature: String;
  internal var screenWidth: int;
  internal var screenHeight: int;
  internal var backgroundPixel: int;
  internal var bitsPerPixel: int;
  internal var defaultDepth: int;
  internal var disposalMethod: int = 0;
  internal var delayTime: int = 0;
  internal var transparentPixel: int = -1;
  internal var repeatCount: int = 1;
  public static const GIF_APPLICATION_EXTENSION_BLOCK_ID: int = 0xFF;
  public static const GIF_GRAPHICS_CONTROL_BLOCK_ID: int = 0xF9;
  public static const GIF_PLAIN_TEXT_BLOCK_ID: int = 0x01;
  public static const GIF_COMMENT_BLOCK_ID: int = 0xFE;
  public static const GIF_EXTENSION_BLOCK_ID: int = 0x21;
  public static const GIF_IMAGE_BLOCK_ID: int = 0x2C;
  public static const GIF_TRAILER_ID: int = 0x3B;
  public static var GIF89a: JavaArray = new JavaArray("[B").values(int(71), int(73), int(70), int(56), int(57), int(97));
  public static var NETSCAPE2_0: JavaArray = new JavaArray("[B").values(int(78), int(69), int(84), int(83), int(67), int(65), int(80), int(69), int(50), int(46), int(48));
  public static function grayRamp__I(numGrays: int): PaletteData {
    var n: int = numGrays - 1;
    var colors: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/RGB;").lengths(numGrays);
    for (var i: int = 0; i < numGrays; i++) {
      var intensity: int = int((int((i * 3) * 256 / n)));
      colors[i] = new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [intensity, intensity, intensity]));
    }
    return new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData___3Lorg_eclipse_swt_graphics_RGB_2, [colors]));
  }
  public override function isFileFormat__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(stream: LEDataInputStream): Boolean {
    try {
      var signature_1: JavaArray = new JavaArray("[B").lengths(3);
      stream.read___3B(signature_1);
      stream.unread___3B(signature_1);
      return signature_1[0] == 71 && signature_1[1] == 73 && signature_1[2] == 70;
    } catch (e : Exception) {
      return false;
    }
    return false;
  }
  public override function loadFromByteStream__(): JavaArray {
    var signature_1: JavaArray = new JavaArray("[B").lengths(3);
    var versionBytes: JavaArray = new JavaArray("[B").lengths(3);
    var block: JavaArray = new JavaArray("[B").lengths(7);
    try {
      inputStream.read___3B(signature_1);
      if (!(signature_1[0] == 71 && signature_1[1] == 73 && signature_1[2] == 70))
        SWT.error__I(40);
      inputStream.read___3B(versionBytes);
      inputStream.read___3B(block);
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    screenWidth = (block[0] & 0xFF) | ((block[1] & 0xFF) << 8);
    loader.logicalScreenWidth = screenWidth;
    screenHeight = (block[2] & 0xFF) | ((block[3] & 0xFF) << 8);
    loader.logicalScreenHeight = screenHeight;
    var bitField: int = block[4];
    backgroundPixel = block[5] & 0xFF;
    bitsPerPixel = ((bitField >> 4) & 0x07) + 1;
    defaultDepth = (bitField & 0x7) + 1;
    var palette: PaletteData = null;
    if ((bitField & 0x80) != 0) {
      palette = this.readPalette__I(1 << defaultDepth);
    } else {
      backgroundPixel = -1;
      defaultDepth = bitsPerPixel;
    }
    loader.backgroundPixel = backgroundPixel;
    this.getExtensions__();
    var id: int = this.readID__();
    var images: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/ImageData;").lengths(0);
    while (id == 44) {
      var image: ImageData = this.readImageBlock__Lorg_eclipse_swt_graphics_PaletteData_2(palette);
      if (loader.hasListeners__()) {
        loader.notifyListeners__Lorg_eclipse_swt_graphics_ImageLoaderEvent_2(new ImageLoaderEvent(loader, image, 3, true));
      }
      var oldImages: JavaArray = images;
      images = new JavaArray("[Lorg/eclipse/swt/graphics/ImageData;").lengths(oldImages.length + 1);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(oldImages, 0, images, 0, oldImages.length);
      images[images.length - 1] = image;
      try {
        id = inputStream.read__();
        if (id > 0) {
          inputStream.unread___3B(new JavaArray("[B").values(int(id)));
        }
      } catch (e_1 : IOException) {
        SWT.error__ILjava_lang_Throwable_2(39, e_1);
      }
      this.getExtensions__();
      id = this.readID__();
    }
    return images;
  }
  public function readID__(): int {
    try {
      return inputStream.read__();
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    return -1;
  }
  public function getExtensions__(): void {
    var id: int = this.readID__();
    while (id != 44 && id != 59 && id > 0) {
      if (id == 33) {
        this.readExtension__();
      } else {
        SWT.error__I(40);
      }
      id = this.readID__();
    }
    if (id == 44 || id == 59) {
      try {
        inputStream.unread___3B(new JavaArray("[B").values(int(id)));
      } catch (e : IOException) {
        SWT.error__ILjava_lang_Throwable_2(39, e);
      }
    }
    return;
  }
  public function readExtension__(): JavaArray {
    var extensionID: int = this.readID__();
    if (extensionID == 254)
      return this.readCommentExtension__();
    if (extensionID == 1)
      return this.readPlainTextExtension__();
    if (extensionID == 249)
      return this.readGraphicsControlExtension__();
    if (extensionID == 255)
      return this.readApplicationExtension__();
    try {
      var extSize: int = inputStream.read__();
      if (extSize < 0) {
        SWT.error__I(40);
      }
      var ext: JavaArray = new JavaArray("[B").lengths(extSize);
      inputStream.read___3BII(ext, 0, extSize);
      return ext;
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
      return null;
    }
    return null;
  }
  public function readCommentExtension__(): JavaArray {
    try {
      var comment: JavaArray = new JavaArray("[B").lengths(0);
      var block: JavaArray = new JavaArray("[B").lengths(255);
      var size: int = inputStream.read__();
      while ((size > 0) && (inputStream.read___3BII(block, 0, size) != -1)) {
        var oldComment: JavaArray = comment;
        comment = new JavaArray("[B").lengths(oldComment.length + size);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(oldComment, 0, comment, 0, oldComment.length);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(block, 0, comment, oldComment.length, size);
        size = inputStream.read__();
      }
      return comment;
    } catch (e : Exception) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
      return null;
    }
    return null;
  }
  public function readPlainTextExtension__(): JavaArray {
    try {
      inputStream.read__();
      var info: JavaArray = new JavaArray("[B").lengths(12);
      inputStream.read___3B(info);
      var text: JavaArray = new JavaArray("[B").lengths(0);
      var block: JavaArray = new JavaArray("[B").lengths(255);
      var size: int = inputStream.read__();
      while ((size > 0) && (inputStream.read___3BII(block, 0, size) != -1)) {
        var oldText: JavaArray = text;
        text = new JavaArray("[B").lengths(oldText.length + size);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(oldText, 0, text, 0, oldText.length);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(block, 0, text, oldText.length, size);
        size = inputStream.read__();
      }
      return text;
    } catch (e : Exception) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
      return null;
    }
    return null;
  }
  public function readGraphicsControlExtension__(): JavaArray {
    try {
      inputStream.read__();
      var controlBlock: JavaArray = new JavaArray("[B").lengths(4);
      inputStream.read___3B(controlBlock);
      var bitField: int = controlBlock[0];
      disposalMethod = (bitField >> 2) & 0x07;
      delayTime = (controlBlock[1] & 0xFF) | ((controlBlock[2] & 0xFF) << 8);
      if ((bitField & 0x01) != 0) {
        transparentPixel = controlBlock[3] & 0xFF;
      } else {
        transparentPixel = -1;
      }
      inputStream.read__();
      return controlBlock;
    } catch (e : Exception) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
      return null;
    }
    return null;
  }
  public function readApplicationExtension__(): JavaArray {
    try {
      inputStream.read__();
      var application: JavaArray = new JavaArray("[B").lengths(8);
      inputStream.read___3B(application);
      var authentication: JavaArray = new JavaArray("[B").lengths(3);
      inputStream.read___3B(authentication);
      var data: JavaArray = new JavaArray("[B").lengths(0);
      var block: JavaArray = new JavaArray("[B").lengths(255);
      var size: int = inputStream.read__();
      while ((size > 0) && (inputStream.read___3BII(block, 0, size) != -1)) {
        var oldData: JavaArray = data;
        data = new JavaArray("[B").lengths(oldData.length + size);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(oldData, 0, data, 0, oldData.length);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(block, 0, data, oldData.length, size);
        size = inputStream.read__();
      }
      var netscape: Boolean = application[0] == 78 && application[1] == 69 && application[2] == 84 && application[3] == 83 && application[4] == 67 && application[5] == 65 && application[6] == 80 && application[7] == 69;
      var authentic: Boolean = authentication[0] == 50 && authentication[1] == 46 && authentication[2] == 48;
      if (netscape && authentic && data[0] == 01) {
        repeatCount = (data[1] & 0xFF) | ((data[2] & 0xFF) << 8);
        loader.repeatCount = repeatCount;
      }
      return data;
    } catch (e : Exception) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
      return null;
    }
    return null;
  }
  public function readImageBlock__Lorg_eclipse_swt_graphics_PaletteData_2(defaultPalette: PaletteData): ImageData {
    var depth: int;
    var palette: PaletteData;
    var block: JavaArray = new JavaArray("[B").lengths(9);
    try {
      inputStream.read___3B(block);
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    var left: int = (block[0] & 0xFF) | ((block[1] & 0xFF) << 8);
    var top: int = (block[2] & 0xFF) | ((block[3] & 0xFF) << 8);
    var width: int = (block[4] & 0xFF) | ((block[5] & 0xFF) << 8);
    var height: int = (block[6] & 0xFF) | ((block[7] & 0xFF) << 8);
    var bitField: int = block[8];
    var interlaced: Boolean = (bitField & 0x40) != 0;
    if ((bitField & 0x80) != 0) {
      depth = (bitField & 0x7) + 1;
      palette = this.readPalette__I(1 << depth);
    } else {
      depth = defaultDepth;
      palette = defaultPalette;
    }
    if (transparentPixel > 1 << depth) {
      transparentPixel = -1;
    }
    if (!(depth == 1 || depth == 4 || depth == 8)) {
      if (depth < 4)
        depth = 4;
      else
        depth = 8;
    }
    if (palette === null) {
      palette = GIFFileFormat.grayRamp__I(1 << depth);
    }
    var initialCodeSize: int = -1;
    try {
      initialCodeSize = inputStream.read__();
    } catch (e_1 : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e_1);
    }
    if (initialCodeSize < 0) {
      SWT.error__I(40);
    }
    var image: ImageData = ImageData.internal_new__IIILorg_eclipse_swt_graphics_PaletteData_2I_3BI_3B_3BIIIIIII(width, height, depth, palette, 4, null, 0, null, null, -1, transparentPixel, 2, left, top, disposalMethod, delayTime);
    var codec: LZWCodec = new LZWCodec();
    codec.decode__Lorg_eclipse_swt_internal_image_LEDataInputStream_2Lorg_eclipse_swt_graphics_ImageLoader_2Lorg_eclipse_swt_graphics_ImageData_2ZI(inputStream, loader, image, interlaced, initialCodeSize);
    return image;
  }
  public function readPalette__I(numColors: int): PaletteData {
    var bytes: JavaArray = new JavaArray("[B").lengths(numColors * 3);
    try {
      if (inputStream.read___3B(bytes) != bytes.length)
        SWT.error__I(40);
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    var colors: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/RGB;").lengths(numColors);
    for (var i: int = 0; i < numColors; i++)
      colors[i] = new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [bytes[i * 3] & 0xFF, bytes[i * 3 + 1] & 0xFF, bytes[i * 3 + 2] & 0xFF]));
    return new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData___3Lorg_eclipse_swt_graphics_RGB_2, [colors]));
  }
  public override function unloadIntoByteStream__Lorg_eclipse_swt_graphics_ImageLoader_2(loader_1: ImageLoader): void {
    var data: JavaArray = loader_1.data;
    var frameCount: int = data.length;
    var multi: Boolean = frameCount > 1;
    var firstImage: ImageData = data[0];
    var logicalScreenWidth: int = multi ? loader_1.logicalScreenWidth : firstImage.width;
    var logicalScreenHeight: int = multi ? loader_1.logicalScreenHeight : firstImage.height;
    var backgroundPixel_1: int = loader_1.backgroundPixel;
    var depth: int = firstImage.depth;
    var palette: PaletteData = firstImage.palette;
    var colors: JavaArray = palette.getRGBs__();
    var globalTable: int = 1;
    if (!(depth == 1 || depth == 4 || depth == 8)) {
      SWT.error__I(38);
    }
    for (var i: int = 0; i < frameCount; i++) {
      if (data[i].palette.isDirect) {
        SWT.error__I(40);
      }
      if (multi) {
        if (!(data[i].height <= logicalScreenHeight && data[i].width <= logicalScreenWidth && data[i].depth == depth)) {
          SWT.error__I(40);
        }
        if (globalTable == 1) {
          var rgbs: JavaArray = data[i].palette.getRGBs__();
          if (rgbs.length != colors.length) {
            globalTable = 0;
          } else {
            for (var j: int = 0; j < colors.length; j++) {
              if (!(rgbs[j].red == colors[j].red && rgbs[j].green == colors[j].green && rgbs[j].blue == colors[j].blue))
                globalTable = 0;
            }
          }
        }
      }
    }
    try {
      outputStream.write___3B(GIF89a);
      var bitField: int = globalTable * 128 + (depth - 1) * 16 + depth - 1;
      outputStream.writeShort__I(int(logicalScreenWidth));
      outputStream.writeShort__I(int(logicalScreenHeight));
      outputStream.write__I(bitField);
      outputStream.write__I(backgroundPixel_1);
      outputStream.write__I(0);
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    if (globalTable == 1) {
      this.writePalette__Lorg_eclipse_swt_graphics_PaletteData_2I(palette, depth);
    }
    if (multi) {
      var repeatCount_1: int = loader_1.repeatCount;
      try {
        outputStream.write__I(33);
        outputStream.write__I(255);
        outputStream.write__I(NETSCAPE2_0.length);
        outputStream.write___3B(NETSCAPE2_0);
        outputStream.write__I(3);
        outputStream.write__I(1);
        outputStream.writeShort__I(int(repeatCount_1));
        outputStream.write__I(0);
      } catch (e_1 : IOException) {
        SWT.error__ILjava_lang_Throwable_2(39, e_1);
      }
    }
    for (var frame: int = 0; frame < frameCount; frame++) {
      if (multi || data[frame].transparentPixel != -1) {
        this.writeGraphicsControlBlock__Lorg_eclipse_swt_graphics_ImageData_2(data[frame]);
      }
      var x: int = data[frame].x;
      var y: int = data[frame].y;
      var width: int = data[frame].width;
      var height: int = data[frame].height;
      try {
        outputStream.write__I(44);
        var block: JavaArray = new JavaArray("[B").lengths(9);
        block[0] = int((x & 0xFF));
        block[1] = int(((x >> 8) & 0xFF));
        block[2] = int((y & 0xFF));
        block[3] = int(((y >> 8) & 0xFF));
        block[4] = int((width & 0xFF));
        block[5] = int(((width >> 8) & 0xFF));
        block[6] = int((height & 0xFF));
        block[7] = int(((height >> 8) & 0xFF));
        block[8] = int((globalTable == 0 ? (depth - 1) | 0x80 : 0x00));
        outputStream.write___3B(block);
      } catch (e_2 : IOException) {
        SWT.error__ILjava_lang_Throwable_2(39, e_2);
      }
      if (globalTable == 0) {
        this.writePalette__Lorg_eclipse_swt_graphics_PaletteData_2I(data[frame].palette, depth);
      }
      try {
        outputStream.write__I(depth);
      } catch (e_3 : IOException) {
        SWT.error__ILjava_lang_Throwable_2(39, e_3);
      }
      new LZWCodec().encode__Lorg_eclipse_swt_internal_image_LEDataOutputStream_2Lorg_eclipse_swt_graphics_ImageData_2(outputStream, data[frame]);
    }
    try {
      outputStream.write__I(0x3B);
    } catch (e_4 : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e_4);
    }
    return;
  }
  public function writeGraphicsControlBlock__Lorg_eclipse_swt_graphics_ImageData_2(image: ImageData): void {
    try {
      outputStream.write__I(33);
      outputStream.write__I(249);
      var gcBlock: JavaArray = new JavaArray("[B").lengths(4);
      gcBlock[0] = 0;
      gcBlock[1] = 0;
      gcBlock[2] = 0;
      gcBlock[3] = 0;
      if (image.transparentPixel != -1) {
        gcBlock[0] = int(0x01);
        gcBlock[3] = int(image.transparentPixel);
      }
      if (image.disposalMethod != 0) {
        gcBlock[0] |= int(((image.disposalMethod & 0x07) << 2));
      }
      if (image.delayTime != 0) {
        gcBlock[1] = int((image.delayTime & 0xFF));
        gcBlock[2] = int(((image.delayTime >> 8) & 0xFF));
      }
      outputStream.write__I(int(gcBlock.length));
      outputStream.write___3B(gcBlock);
      outputStream.write__I(0);
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    return;
  }
  public function writePalette__Lorg_eclipse_swt_graphics_PaletteData_2I(palette: PaletteData, depth: int): void {
    var bytes: JavaArray = new JavaArray("[B").lengths((1 << depth) * 3);
    var offset: int = 0;
    for (var i: int = 0; i < palette.colors.length; i++) {
      var color: RGB = palette.colors[i];
      bytes[offset] = int(color.red);
      bytes[offset + 1] = int(color.green);
      bytes[offset + 2] = int(color.blue);
      offset += 3;
    }
    try {
      outputStream.write___3B(bytes);
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    return;
  }
}
}
