package org.eclipse.swt.internal.image {
import java.io.*;
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.SWT;
import java.io.InputStream;
import java.lang.System;
import java.io.IOException;
import java.lang.Math__;
import java.lang.Exception;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class JPEGDecoder {
  public static const DCTSIZE: int = 8;
  public static const DCTSIZE2: int = 64;
  public static const NUM_QUANT_TBLS: int = 4;
  public static const NUM_HUFF_TBLS: int = 4;
  public static const NUM_ARITH_TBLS: int = 16;
  public static const MAX_COMPS_IN_SCAN: int = 4;
  public static const MAX_COMPONENTS: int = 10;
  public static const MAX_SAMP_FACTOR: int = 4;
  public static const D_MAX_BLOCKS_IN_MCU: int = 10;
  public static const HUFF_LOOKAHEAD: int = 8;
  public static const MAX_Q_COMPS: int = 4;
  public static const IFAST_SCALE_BITS: int = 2;
  public static const MAXJSAMPLE: int = 255;
  public static const CENTERJSAMPLE: int = 128;
  public static const MIN_GET_BITS: int = 32 - 7;
  public static const INPUT_BUFFER_SIZE: int = 4096;
  public static const SCALEBITS: int = 16;
  public static const ONE_HALF: int = 1 << (16 - 1);
  public static const RGB_RED: int = 2;
  public static const RGB_GREEN: int = 1;
  public static const RGB_BLUE: int = 0;
  public static const RGB_PIXELSIZE: int = 3;
  public static const JBUF_PASS_THRU: int = 0;
  public static const JBUF_SAVE_SOURCE: int = 1;
  public static const JBUF_CRANK_DEST: int = 2;
  public static const JBUF_SAVE_AND_PASS: int = 3;
  public static const JPEG_MAX_DIMENSION: int = 65500;
  public static const BITS_IN_JSAMPLE: int = 8;
  public static const JDITHER_NONE: int = 0;
  public static const JDITHER_ORDERED: int = 1;
  public static const JDITHER_FS: int = 2;
  public static const JDCT_ISLOW: int = 0;
  public static const JDCT_IFAST: int = 1;
  public static const JDCT_FLOAT: int = 2;
  public static const JDCT_DEFAULT: int = 0;
  public static const JCS_UNKNOWN: int = 0;
  public static const JCS_GRAYSCALE: int = 1;
  public static const JCS_RGB: int = 2;
  public static const JCS_YCbCr: int = 3;
  public static const JCS_CMYK: int = 4;
  public static const JCS_YCCK: int = 5;
  public static const SAVED_COEFS: int = 6;
  public static const Q01_POS: int = 1;
  public static const Q10_POS: int = 8;
  public static const Q20_POS: int = 16;
  public static const Q11_POS: int = 9;
  public static const Q02_POS: int = 2;
  public static const CTX_PREPARE_FOR_IMCU: int = 0;
  public static const CTX_PROCESS_IMCU: int = 1;
  public static const CTX_POSTPONED_ROW: int = 2;
  public static const APP0_DATA_LEN: int = 14;
  public static const APP14_DATA_LEN: int = 12;
  public static const APPN_DATA_LEN: int = 14;
  public static const M_SOF0: int = 0xc0;
  public static const M_SOF1: int = 0xc1;
  public static const M_SOF2: int = 0xc2;
  public static const M_SOF3: int = 0xc3;
  public static const M_SOF5: int = 0xc5;
  public static const M_SOF6: int = 0xc6;
  public static const M_SOF7: int = 0xc7;
  public static const M_JPG: int = 0xc8;
  public static const M_SOF9: int = 0xc9;
  public static const M_SOF10: int = 0xca;
  public static const M_SOF11: int = 0xcb;
  public static const M_SOF13: int = 0xcd;
  public static const M_SOF14: int = 0xce;
  public static const M_SOF15: int = 0xcf;
  public static const M_DHT: int = 0xc4;
  public static const M_DAC: int = 0xcc;
  public static const M_RST0: int = 0xd0;
  public static const M_RST1: int = 0xd1;
  public static const M_RST2: int = 0xd2;
  public static const M_RST3: int = 0xd3;
  public static const M_RST4: int = 0xd4;
  public static const M_RST5: int = 0xd5;
  public static const M_RST6: int = 0xd6;
  public static const M_RST7: int = 0xd7;
  public static const M_SOI: int = 0xd8;
  public static const M_EOI: int = 0xd9;
  public static const M_SOS: int = 0xda;
  public static const M_DQT: int = 0xdb;
  public static const M_DNL: int = 0xdc;
  public static const M_DRI: int = 0xdd;
  public static const M_DHP: int = 0xde;
  public static const M_EXP: int = 0xdf;
  public static const M_APP0: int = 0xe0;
  public static const M_APP1: int = 0xe1;
  public static const M_APP2: int = 0xe2;
  public static const M_APP3: int = 0xe3;
  public static const M_APP4: int = 0xe4;
  public static const M_APP5: int = 0xe5;
  public static const M_APP6: int = 0xe6;
  public static const M_APP7: int = 0xe7;
  public static const M_APP8: int = 0xe8;
  public static const M_APP9: int = 0xe9;
  public static const M_APP10: int = 0xea;
  public static const M_APP11: int = 0xeb;
  public static const M_APP12: int = 0xec;
  public static const M_APP13: int = 0xed;
  public static const M_APP14: int = 0xee;
  public static const M_APP15: int = 0xef;
  public static const M_JPG0: int = 0xf0;
  public static const M_JPG13: int = 0xfd;
  public static const M_COM: int = 0xfe;
  public static const M_TEM: int = 0x01;
  public static const M_ERROR: int = 0x100;
  public static const CSTATE_START: int = 100;
  public static const CSTATE_SCANNING: int = 101;
  public static const CSTATE_RAW_OK: int = 102;
  public static const CSTATE_WRCOEFS: int = 103;
  public static const DSTATE_START: int = 200;
  public static const DSTATE_INHEADER: int = 201;
  public static const DSTATE_READY: int = 202;
  public static const DSTATE_PRELOAD: int = 203;
  public static const DSTATE_PRESCAN: int = 204;
  public static const DSTATE_SCANNING: int = 205;
  public static const DSTATE_RAW_OK: int = 206;
  public static const DSTATE_BUFIMAGE: int = 207;
  public static const DSTATE_BUFPOST: int = 208;
  public static const DSTATE_RDCOEFS: int = 209;
  public static const DSTATE_STOPPING: int = 210;
  public static const JPEG_REACHED_SOS: int = 1;
  public static const JPEG_REACHED_EOI: int = 2;
  public static const JPEG_ROW_COMPLETED: int = 3;
  public static const JPEG_SCAN_COMPLETED: int = 4;
  public static const JPEG_SUSPENDED: int = 0;
  public static const JPEG_HEADER_OK: int = 1;
  public static const JPEG_HEADER_TABLES_ONLY: int = 2;
  public static const DECOMPRESS_DATA: int = 0;
  public static const DECOMPRESS_SMOOTH_DATA: int = 1;
  public static const DECOMPRESS_ONEPASS: int = 2;
  public static const CONSUME_DATA: int = 0;
  public static const DUMMY_CONSUME_DATA: int = 1;
  public static const PROCESS_DATA_SIMPLE_MAIN: int = 0;
  public static const PROCESS_DATA_CONTEXT_MAIN: int = 1;
  public static const PROCESS_DATA_CRANK_POST: int = 2;
  public static const POST_PROCESS_1PASS: int = 0;
  public static const POST_PROCESS_DATA_UPSAMPLE: int = 1;
  public static const NULL_CONVERT: int = 0;
  public static const GRAYSCALE_CONVERT: int = 1;
  public static const YCC_RGB_CONVERT: int = 2;
  public static const GRAY_RGB_CONVERT: int = 3;
  public static const YCCK_CMYK_CONVERT: int = 4;
  public static const NOOP_UPSAMPLE: int = 0;
  public static const FULLSIZE_UPSAMPLE: int = 1;
  public static const H2V1_FANCY_UPSAMPLE: int = 2;
  public static const H2V1_UPSAMPLE: int = 3;
  public static const H2V2_FANCY_UPSAMPLE: int = 4;
  public static const H2V2_UPSAMPLE: int = 5;
  public static const INT_UPSAMPLE: int = 6;
  public static const INPUT_CONSUME_INPUT: int = 0;
  public static const COEF_CONSUME_INPUT: int = 1;
  public static var extend_test: JavaArray = new JavaArray("[I").values(0, 0x0001, 0x0002, 0x0004, 0x0008, 0x0010, 0x0020, 0x0040, 0x0080, 0x0100, 0x0200, 0x0400, 0x0800, 0x1000, 0x2000, 0x4000);
  public static var extend_offset: JavaArray = new JavaArray("[I").values(0, ((-1) << 1) + 1, ((-1) << 2) + 1, ((-1) << 3) + 1, ((-1) << 4) + 1, ((-1) << 5) + 1, ((-1) << 6) + 1, ((-1) << 7) + 1, ((-1) << 8) + 1, ((-1) << 9) + 1, ((-1) << 10) + 1, ((-1) << 11) + 1, ((-1) << 12) + 1, ((-1) << 13) + 1, ((-1) << 14) + 1, ((-1) << 15) + 1);
  public static var jpeg_natural_order: JavaArray = new JavaArray("[I").values(0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63);
  public static const CONST_BITS: int = 13;
  public static const PASS1_BITS: int = 2;
  public static const RANGE_MASK: int = (255 * 4 + 3);
  public static function error__(): void {
    SWT.error__I(40);
    return;
  }
  public static function error__I(code: int): void {
    SWT.error__I(code);
    return;
  }
  public static function error__Ljava_lang_String_2(msg: String): void {
    SWT.error__ILjava_lang_Throwable_2Ljava_lang_String_2(40, null, msg);
    return;
  }
  public static function jinit_marker_reader__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var marker: JPEGDecoder$jpeg_marker_reader = cinfo.marker = new JPEGDecoder$jpeg_marker_reader();
    marker.length_limit_COM = 0;
    reset_marker_reader__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    return;
  }
  public static function jinit_d_coef_controller__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Z(cinfo: JPEGDecoder$jpeg_decompress_struct, need_full_buffer: Boolean): void {
    var coef: JPEGDecoder$jpeg_d_coef_controller = new JPEGDecoder$jpeg_d_coef_controller();
    cinfo.coef = coef;
    coef.coef_bits_latch = null;
    if (need_full_buffer) {
      var ci: int;
      var access_rows: int;
      var compptr: JPEGDecoder$jpeg_component_info;
      for (ci = 0; ci < cinfo.num_components; ci++) {
        compptr = cinfo.comp_info[ci];
        access_rows = compptr.v_samp_factor;
        if (cinfo.progressive_mode)
          access_rows *= 3;
        coef.whole_image[ci] = new JavaArray("[[[S").lengths(int(jround_up__JJ(compptr.height_in_blocks, compptr.v_samp_factor)), int(jround_up__JJ(compptr.width_in_blocks, compptr.h_samp_factor)), 64);
      }
      coef.decompress_data = 0;
      coef.coef_arrays = coef.whole_image[0];
    } else {
      coef.MCU_buffer = new JavaArray("[[S").lengths(10, 64);
      coef.decompress_data = 2;
      coef.coef_arrays = null;
    }
    return;
  }
  public static function start_output_pass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var coef: JPEGDecoder$jpeg_d_coef_controller = cinfo.coef;
    if (coef.coef_arrays !== null) {
      if (cinfo.do_block_smoothing && smoothing_ok__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo))
        coef.decompress_data = 1;
      else
        coef.decompress_data = 0;
    }
    cinfo.output_iMCU_row = 0;
    return;
  }
  public static function jpeg_create_decompress__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    cinfo.is_decompressor = true;
    cinfo.marker_list = null;
    jinit_marker_reader__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    jinit_input_controller__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    cinfo.global_state = 200;
    return;
  }
  public static function jpeg_calc_output_dimensions__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    if (cinfo.global_state != 202)
      error__();
    cinfo.output_width = cinfo.image_width;
    cinfo.output_height = cinfo.image_height;
    switch (cinfo.out_color_space) {
      case 1 :
        cinfo.out_color_components = 1;
        break;
      case 2 :
      case 3 :
        cinfo.out_color_components = 3;
        break;
      case 4 :
      case 5 :
        cinfo.out_color_components = 4;
        break;
      default :
        cinfo.out_color_components = cinfo.num_components;
        break;
    }
    cinfo.output_components = (cinfo.quantize_colors ? 1 : cinfo.out_color_components);
    if (use_merged_upsample__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo))
      cinfo.rec_outbuf_height = cinfo.max_v_samp_factor;
    else
      cinfo.rec_outbuf_height = 1;
    return;
  }
  public static function use_merged_upsample__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): Boolean {
    if (cinfo.do_fancy_upsampling || cinfo.CCIR601_sampling)
      return false;
    if (cinfo.jpeg_color_space != 3 || cinfo.num_components != 3 || cinfo.out_color_space != 2 || cinfo.out_color_components != 3)
      return false;
    if (cinfo.comp_info[0].h_samp_factor != 2 || cinfo.comp_info[1].h_samp_factor != 1 || cinfo.comp_info[2].h_samp_factor != 1 || cinfo.comp_info[0].v_samp_factor > 2 || cinfo.comp_info[1].v_samp_factor != 1 || cinfo.comp_info[2].v_samp_factor != 1)
      return false;
    if (cinfo.comp_info[0].DCT_scaled_size != cinfo.min_DCT_scaled_size || cinfo.comp_info[1].DCT_scaled_size != cinfo.min_DCT_scaled_size || cinfo.comp_info[2].DCT_scaled_size != cinfo.min_DCT_scaled_size)
      return false;
    return true;
  }
  public static function prepare_range_limit_table__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var table: JavaArray;
    var i: int;
    table = new JavaArray("[B").lengths(5 * (255 + 1) + 128);
    var offset: int = (255 + 1);
    cinfo.sample_range_limit_offset = offset;
    cinfo.sample_range_limit = table;
    for (i = 0; i <= 255; i++)
      table[i + offset] = int(i);
    offset += 128;
    for (i = 128; i < 2 * (255 + 1); i++)
      table[i + offset] = int(255);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(cinfo.sample_range_limit, cinfo.sample_range_limit_offset, table, offset + (4 * (255 + 1) - 128), 128);
  }
  public static function build_ycc_rgb_table__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var cconvert: JPEGDecoder$jpeg_color_deconverter = cinfo.cconvert;
    var i: int;
    var x: int;
    cconvert.Cr_r_tab = new JavaArray("[I").lengths(255 + 1);
    cconvert.Cb_b_tab = new JavaArray("[I").lengths(255 + 1);
    cconvert.Cr_g_tab = new JavaArray("[I").lengths(255 + 1);
    cconvert.Cb_g_tab = new JavaArray("[I").lengths(255 + 1);
    for (i = 0, x = -128; i <= 255; i++, x++) {
      cconvert.Cr_r_tab[i] = (int((1.4019999504089355 * (1 << 16) + 0.5)) * x + 32768) >> 16;
      cconvert.Cb_b_tab[i] = (int((1.7719999551773071 * (1 << 16) + 0.5)) * x + 32768) >> 16;
      cconvert.Cr_g_tab[i] = (int((-(0.714139997959137 * (1 << 16) + 0.5))) * x);
      cconvert.Cb_g_tab[i] = (int((-(0.3441399931907654 * (1 << 16) + 0.5))) * x + 32768);
    }
    return;
  }
  public static function jinit_color_deconverter__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var cconvert: JPEGDecoder$jpeg_color_deconverter = cinfo.cconvert = new JPEGDecoder$jpeg_color_deconverter();
    switch (cinfo.jpeg_color_space) {
      case 1 :
        if (cinfo.num_components != 1)
          error__();
        break;
      case 2 :
      case 3 :
        if (cinfo.num_components != 3)
          error__();
        break;
      case 4 :
      case 5 :
        if (cinfo.num_components != 4)
          error__();
        break;
      default :
        if (cinfo.num_components < 1)
          error__();
        break;
    }
    var ci: int;
    switch (cinfo.out_color_space) {
      case 1 :
        cinfo.out_color_components = 1;
        if (cinfo.jpeg_color_space == 1 || cinfo.jpeg_color_space == 3) {
          cconvert.color_convert = 1;
          for (ci = 1; ci < cinfo.num_components; ci++)
            cinfo.comp_info[ci].component_needed = false;
        } else
          error__();
        break;
      case 2 :
        cinfo.out_color_components = 3;
        if (cinfo.jpeg_color_space == 3) {
          cconvert.color_convert = 2;
          build_ycc_rgb_table__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
        } else if (cinfo.jpeg_color_space == 1) {
          cconvert.color_convert = 3;
        } else if (cinfo.jpeg_color_space == 2) {
          cconvert.color_convert = 0;
        } else
          error__();
        break;
      case 4 :
        cinfo.out_color_components = 4;
        if (cinfo.jpeg_color_space == 5) {
          cconvert.color_convert = 4;
          build_ycc_rgb_table__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
        } else if (cinfo.jpeg_color_space == 4) {
          cconvert.color_convert = 0;
        } else
          error__();
        break;
      default :
        if (cinfo.out_color_space == cinfo.jpeg_color_space) {
          cinfo.out_color_components = cinfo.num_components;
          cconvert.color_convert = 0;
        } else
          error__();
        break;
    }
    if (cinfo.quantize_colors)
      cinfo.output_components = 1;
    else
      cinfo.output_components = cinfo.out_color_components;
    return;
  }
  public static function jinit_d_post_controller__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Z(cinfo: JPEGDecoder$jpeg_decompress_struct, need_full_buffer: Boolean): void {
    var post: JPEGDecoder$jpeg_d_post_controller = cinfo.post = new JPEGDecoder$jpeg_d_post_controller();
    post.whole_image = null;
    post.buffer = null;
    if (cinfo.quantize_colors) {
      error__I(20);
    }
    return;
  }
  public static function make_funny_pointers__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var main: JPEGDecoder$jpeg_d_main_controller = cinfo.main;
    var ci: int;
    var i: int;
    var rgroup: int;
    var M: int = cinfo.min_DCT_scaled_size;
    var compptr: JPEGDecoder$jpeg_component_info;
    var buf: JavaArray;
    var xbuf0: JavaArray;
    var xbuf1: JavaArray;
    for (ci = 0; ci < cinfo.num_components; ci++) {
      compptr = cinfo.comp_info[ci];
      rgroup = int((compptr.v_samp_factor * compptr.DCT_scaled_size) / cinfo.min_DCT_scaled_size);
      xbuf0 = main.xbuffer[0][ci];
      var xbuf0_offset: int = main.xbuffer_offset[0][ci];
      xbuf1 = main.xbuffer[1][ci];
      var xbuf1_offset: int = main.xbuffer_offset[1][ci];
      buf = main.buffer[ci];
      for (i = 0; i < rgroup * (M + 2); i++) {
        xbuf0[i + xbuf0_offset] = xbuf1[i + xbuf1_offset] = buf[i];
      }
      for (i = 0; i < rgroup * 2; i++) {
        xbuf1[rgroup * (M - 2) + i + xbuf1_offset] = buf[rgroup * M + i];
        xbuf1[rgroup * M + i + xbuf1_offset] = buf[rgroup * (M - 2) + i];
      }
      for (i = 0; i < rgroup; i++) {
        xbuf0[i - rgroup + xbuf0_offset] = xbuf0[0 + xbuf0_offset];
      }
    }
    return;
  }
  public static function alloc_funny_pointers__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var main: JPEGDecoder$jpeg_d_main_controller = cinfo.main;
    var ci: int;
    var rgroup: int;
    var M: int = cinfo.min_DCT_scaled_size;
    var compptr: JPEGDecoder$jpeg_component_info;
    var xbuf: JavaArray;
    main.xbuffer[0] = new JavaArray("[[[B").lengths(cinfo.num_components);
    main.xbuffer[1] = new JavaArray("[[[B").lengths(cinfo.num_components);
    main.xbuffer_offset[0] = new JavaArray("[I").lengths(cinfo.num_components);
    main.xbuffer_offset[1] = new JavaArray("[I").lengths(cinfo.num_components);
    for (ci = 0; ci < cinfo.num_components; ci++) {
      compptr = cinfo.comp_info[ci];
      rgroup = int((compptr.v_samp_factor * compptr.DCT_scaled_size) / cinfo.min_DCT_scaled_size);
      xbuf = new JavaArray("[[B").lengths(2 * (rgroup * (M + 4)));
      var offset: int = rgroup;
      main.xbuffer_offset[0][ci] = offset;
      main.xbuffer[0][ci] = xbuf;
      offset += rgroup * (M + 4);
      main.xbuffer_offset[1][ci] = offset;
      main.xbuffer[1][ci] = xbuf;
    }
    return;
  }
  public static function jinit_d_main_controller__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Z(cinfo: JPEGDecoder$jpeg_decompress_struct, need_full_buffer: Boolean): void {
    var ci: int;
    var rgroup: int;
    var ngroups: int;
    var compptr: JPEGDecoder$jpeg_component_info;
    var main: JPEGDecoder$jpeg_d_main_controller = cinfo.main = new JPEGDecoder$jpeg_d_main_controller();
    if (need_full_buffer)
      error__();
    if (cinfo.upsample.need_context_rows) {
      if (cinfo.min_DCT_scaled_size < 2)
        error__();
      alloc_funny_pointers__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      ngroups = cinfo.min_DCT_scaled_size + 2;
    } else {
      ngroups = cinfo.min_DCT_scaled_size;
    }
    for (ci = 0; ci < cinfo.num_components; ci++) {
      compptr = cinfo.comp_info[ci];
      rgroup = int((compptr.v_samp_factor * compptr.DCT_scaled_size) / cinfo.min_DCT_scaled_size);
      main.buffer[ci] = new JavaArray("[[B").lengths(rgroup * ngroups, compptr.width_in_blocks * compptr.DCT_scaled_size);
    }
    return;
  }
  public static function jround_up__JJ(a: Number, b: Number): Number {
    a += b - 1;
    return a - (a % b);
  }
  public static function jinit_upsampler__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var ci: int;
    var compptr: JPEGDecoder$jpeg_component_info;
    var need_buffer: Boolean;
    var do_fancy: Boolean;
    var h_in_group: int;
    var v_in_group: int;
    var h_out_group: int;
    var v_out_group: int;
    var upsample: JPEGDecoder$jpeg_upsampler = new JPEGDecoder$jpeg_upsampler();
    cinfo.upsample = upsample;
    upsample.need_context_rows = false;
    if (cinfo.CCIR601_sampling)
      error__();
    do_fancy = cinfo.do_fancy_upsampling && cinfo.min_DCT_scaled_size > 1;
    for (ci = 0; ci < cinfo.num_components; ci++) {
      compptr = cinfo.comp_info[ci];
      h_in_group = int((compptr.h_samp_factor * compptr.DCT_scaled_size) / cinfo.min_DCT_scaled_size);
      v_in_group = int((compptr.v_samp_factor * compptr.DCT_scaled_size) / cinfo.min_DCT_scaled_size);
      h_out_group = cinfo.max_h_samp_factor;
      v_out_group = cinfo.max_v_samp_factor;
      upsample.rowgroup_height[ci] = v_in_group;
      need_buffer = true;
      if (!compptr.component_needed) {
        upsample.methods[ci] = 0;
        need_buffer = false;
      } else if (h_in_group == h_out_group && v_in_group == v_out_group) {
        upsample.methods[ci] = 1;
        need_buffer = false;
      } else if (h_in_group * 2 == h_out_group && v_in_group == v_out_group) {
        if (do_fancy && compptr.downsampled_width > 2)
          upsample.methods[ci] = 2;
        else
          upsample.methods[ci] = 3;
      } else if (h_in_group * 2 == h_out_group && v_in_group * 2 == v_out_group) {
        if (do_fancy && compptr.downsampled_width > 2) {
          upsample.methods[ci] = 4;
          upsample.need_context_rows = true;
        } else
          upsample.methods[ci] = 5;
      } else if ((h_out_group % h_in_group) == 0 && (v_out_group % v_in_group) == 0) {
        upsample.methods[ci] = 6;
        upsample.h_expand[ci] = int((int(h_out_group / h_in_group)));
        upsample.v_expand[ci] = int((int(v_out_group / v_in_group)));
      } else
        error__();
      if (need_buffer) {
        upsample.color_buf[ci] = new JavaArray("[[B").lengths(cinfo.max_v_samp_factor, int(jround_up__JJ(cinfo.output_width, cinfo.max_h_samp_factor)));
      }
    }
    return;
  }
  public static function jinit_phuff_decoder__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var coef_bit_ptr: JavaArray;
    var ci: int;
    var i: int;
    cinfo.entropy = new JPEGDecoder$phuff_entropy_decoder();
    cinfo.coef_bits = new JavaArray("[[I").lengths(cinfo.num_components, 64);
    coef_bit_ptr = cinfo.coef_bits;
    for (ci = 0; ci < cinfo.num_components; ci++)
      for (i = 0; i < 64; i++)
        coef_bit_ptr[ci][i] = -1;
    return;
  }
  public static function jinit_huff_decoder__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    cinfo.entropy = new JPEGDecoder$huff_entropy_decoder();
    return;
  }
  public static function jinit_inverse_dct__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var ci: int;
    var compptr: JPEGDecoder$jpeg_component_info;
    var idct: JPEGDecoder$jpeg_inverse_dct = cinfo.idct = new JPEGDecoder$jpeg_inverse_dct();
    for (ci = 0; ci < cinfo.num_components; ci++) {
      compptr = cinfo.comp_info[ci];
      compptr.dct_table = new JavaArray("[I").lengths(64);
      idct.cur_method[ci] = -1;
    }
    return;
  }
  public static function jpeg_idct_islow__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1component_1info_2_3S_3_3BII(cinfo: JPEGDecoder$jpeg_decompress_struct, compptr: JPEGDecoder$jpeg_component_info, coef_block: JavaArray, output_buf: JavaArray, output_buf_offset: int, output_col: int): void {
    var tmp0: int;
    var tmp1: int;
    var tmp2: int;
    var tmp3: int;
    var tmp10: int;
    var tmp11: int;
    var tmp12: int;
    var tmp13: int;
    var z1: int;
    var z2: int;
    var z3: int;
    var z4: int;
    var z5: int;
    var inptr: JavaArray;
    var quantptr: JavaArray;
    var wsptr: JavaArray;
    var outptr: JavaArray;
    var range_limit: JavaArray = cinfo.sample_range_limit;
    var range_limit_offset: int = cinfo.sample_range_limit_offset + 128;
    var ctr: int;
    var workspace: JavaArray = cinfo.workspace;
    inptr = coef_block;
    quantptr = compptr.dct_table;
    wsptr = workspace;
    var inptr_offset: int = 0;
    var quantptr_offset: int = 0;
    var wsptr_offset: int = 0;
    for (ctr = 8; ctr > 0; ctr--) {
      if (inptr[8 * 1 + inptr_offset] == 0 && inptr[8 * 2 + inptr_offset] == 0 && inptr[8 * 3 + inptr_offset] == 0 && inptr[8 * 4 + inptr_offset] == 0 && inptr[8 * 5 + inptr_offset] == 0 && inptr[8 * 6 + inptr_offset] == 0 && inptr[8 * 7 + inptr_offset] == 0) {
        var dcval: int = ((inptr[8 * 0 + inptr_offset]) * quantptr[8 * 0 + quantptr_offset]) << 2;
        wsptr[8 * 0 + wsptr_offset] = dcval;
        wsptr[8 * 1 + wsptr_offset] = dcval;
        wsptr[8 * 2 + wsptr_offset] = dcval;
        wsptr[8 * 3 + wsptr_offset] = dcval;
        wsptr[8 * 4 + wsptr_offset] = dcval;
        wsptr[8 * 5 + wsptr_offset] = dcval;
        wsptr[8 * 6 + wsptr_offset] = dcval;
        wsptr[8 * 7 + wsptr_offset] = dcval;
        inptr_offset++;
        quantptr_offset++;
        wsptr_offset++;
        continue;
      }
      z2 = ((inptr[8 * 2 + inptr_offset]) * quantptr[8 * 2 + quantptr_offset]);
      z3 = ((inptr[8 * 6 + inptr_offset]) * quantptr[8 * 6 + quantptr_offset]);
      z1 = ((z2 + z3) * 4433);
      tmp2 = z1 + (z3 * -15137);
      tmp3 = z1 + (z2 * 6270);
      z2 = ((inptr[8 * 0 + inptr_offset]) * quantptr[8 * 0 + quantptr_offset]);
      z3 = ((inptr[8 * 4 + inptr_offset]) * quantptr[8 * 4 + quantptr_offset]);
      tmp0 = (z2 + z3) << 13;
      tmp1 = (z2 - z3) << 13;
      tmp10 = tmp0 + tmp3;
      tmp13 = tmp0 - tmp3;
      tmp11 = tmp1 + tmp2;
      tmp12 = tmp1 - tmp2;
      tmp0 = ((inptr[8 * 7 + inptr_offset]) * quantptr[8 * 7 + quantptr_offset]);
      tmp1 = ((inptr[8 * 5 + inptr_offset]) * quantptr[8 * 5 + quantptr_offset]);
      tmp2 = ((inptr[8 * 3 + inptr_offset]) * quantptr[8 * 3 + quantptr_offset]);
      tmp3 = ((inptr[8 * 1 + inptr_offset]) * quantptr[8 * 1 + quantptr_offset]);
      z1 = tmp0 + tmp3;
      z2 = tmp1 + tmp2;
      z3 = tmp0 + tmp2;
      z4 = tmp1 + tmp3;
      z5 = ((z3 + z4) * 9633);
      tmp0 = (tmp0 * 2446);
      tmp1 = (tmp1 * 16819);
      tmp2 = (tmp2 * 25172);
      tmp3 = (tmp3 * 12299);
      z1 = (z1 * -7373);
      z2 = (z2 * -20995);
      z3 = (z3 * -16069);
      z4 = (z4 * -3196);
      z3 += z5;
      z4 += z5;
      tmp0 += z1 + z3;
      tmp1 += z2 + z4;
      tmp2 += z2 + z3;
      tmp3 += z1 + z4;
      wsptr[8 * 0 + wsptr_offset] = (((tmp10 + tmp3) + (1 << ((13 - 2) - 1))) >> (13 - 2));
      wsptr[8 * 7 + wsptr_offset] = (((tmp10 - tmp3) + (1 << ((13 - 2) - 1))) >> (13 - 2));
      wsptr[8 * 1 + wsptr_offset] = (((tmp11 + tmp2) + (1 << ((13 - 2) - 1))) >> (13 - 2));
      wsptr[8 * 6 + wsptr_offset] = (((tmp11 - tmp2) + (1 << ((13 - 2) - 1))) >> (13 - 2));
      wsptr[8 * 2 + wsptr_offset] = (((tmp12 + tmp1) + (1 << ((13 - 2) - 1))) >> (13 - 2));
      wsptr[8 * 5 + wsptr_offset] = (((tmp12 - tmp1) + (1 << ((13 - 2) - 1))) >> (13 - 2));
      wsptr[8 * 3 + wsptr_offset] = (((tmp13 + tmp0) + (1 << ((13 - 2) - 1))) >> (13 - 2));
      wsptr[8 * 4 + wsptr_offset] = (((tmp13 - tmp0) + (1 << ((13 - 2) - 1))) >> (13 - 2));
      inptr_offset++;
      quantptr_offset++;
      wsptr_offset++;
    }
    var outptr_offset: int = 0;
    wsptr = workspace;
    wsptr_offset = 0;
    for (ctr = 0; ctr < 8; ctr++) {
      outptr = output_buf[ctr + output_buf_offset];
      outptr_offset = output_col;
      if (wsptr[1 + wsptr_offset] == 0 && wsptr[2 + wsptr_offset] == 0 && wsptr[3 + wsptr_offset] == 0 && wsptr[4 + wsptr_offset] == 0 && wsptr[5 + wsptr_offset] == 0 && wsptr[6 + wsptr_offset] == 0 && wsptr[7 + wsptr_offset] == 0) {
        var dcval_1: int = range_limit[range_limit_offset + ((((wsptr[0 + wsptr_offset]) + (1 << ((2 + 3) - 1))) >> 2 + 3) & 1023)];
        outptr[0 + outptr_offset] = dcval_1;
        outptr[1 + outptr_offset] = dcval_1;
        outptr[2 + outptr_offset] = dcval_1;
        outptr[3 + outptr_offset] = dcval_1;
        outptr[4 + outptr_offset] = dcval_1;
        outptr[5 + outptr_offset] = dcval_1;
        outptr[6 + outptr_offset] = dcval_1;
        outptr[7 + outptr_offset] = dcval_1;
        wsptr_offset += 8;
        continue;
      }
      z2 = wsptr[2 + wsptr_offset];
      z3 = wsptr[6 + wsptr_offset];
      z1 = ((z2 + z3) * 4433);
      tmp2 = z1 + (z3 * -15137);
      tmp3 = z1 + (z2 * 6270);
      tmp0 = (wsptr[0 + wsptr_offset] + wsptr[4 + wsptr_offset]) << 13;
      tmp1 = (wsptr[0 + wsptr_offset] - wsptr[4 + wsptr_offset]) << 13;
      tmp10 = tmp0 + tmp3;
      tmp13 = tmp0 - tmp3;
      tmp11 = tmp1 + tmp2;
      tmp12 = tmp1 - tmp2;
      tmp0 = wsptr[7 + wsptr_offset];
      tmp1 = wsptr[5 + wsptr_offset];
      tmp2 = wsptr[3 + wsptr_offset];
      tmp3 = wsptr[1 + wsptr_offset];
      z1 = tmp0 + tmp3;
      z2 = tmp1 + tmp2;
      z3 = tmp0 + tmp2;
      z4 = tmp1 + tmp3;
      z5 = ((z3 + z4) * 9633);
      tmp0 = (tmp0 * 2446);
      tmp1 = (tmp1 * 16819);
      tmp2 = (tmp2 * 25172);
      tmp3 = (tmp3 * 12299);
      z1 = (z1 * -7373);
      z2 = (z2 * -20995);
      z3 = (z3 * -16069);
      z4 = (z4 * -3196);
      z3 += z5;
      z4 += z5;
      tmp0 += z1 + z3;
      tmp1 += z2 + z4;
      tmp2 += z2 + z3;
      tmp3 += z1 + z4;
      outptr[0 + outptr_offset] = range_limit[range_limit_offset + ((((tmp10 + tmp3) + (1 << ((13 + 2 + 3) - 1))) >> 13 + 2 + 3) & 1023)];
      outptr[7 + outptr_offset] = range_limit[range_limit_offset + ((((tmp10 - tmp3) + (1 << ((13 + 2 + 3) - 1))) >> 13 + 2 + 3) & 1023)];
      outptr[1 + outptr_offset] = range_limit[range_limit_offset + ((((tmp11 + tmp2) + (1 << ((13 + 2 + 3) - 1))) >> 13 + 2 + 3) & 1023)];
      outptr[6 + outptr_offset] = range_limit[range_limit_offset + ((((tmp11 - tmp2) + (1 << ((13 + 2 + 3) - 1))) >> 13 + 2 + 3) & 1023)];
      outptr[2 + outptr_offset] = range_limit[range_limit_offset + ((((tmp12 + tmp1) + (1 << ((13 + 2 + 3) - 1))) >> 13 + 2 + 3) & 1023)];
      outptr[5 + outptr_offset] = range_limit[range_limit_offset + ((((tmp12 - tmp1) + (1 << ((13 + 2 + 3) - 1))) >> 13 + 2 + 3) & 1023)];
      outptr[3 + outptr_offset] = range_limit[range_limit_offset + ((((tmp13 + tmp0) + (1 << ((13 + 2 + 3) - 1))) >> 13 + 2 + 3) & 1023)];
      outptr[4 + outptr_offset] = range_limit[range_limit_offset + ((((tmp13 - tmp0) + (1 << ((13 + 2 + 3) - 1))) >> 13 + 2 + 3) & 1023)];
      wsptr_offset += 8;
    }
    return;
  }
  public static function upsample__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3I_3II_3_3B_3II(cinfo: JPEGDecoder$jpeg_decompress_struct, input_buf: JavaArray, input_buf_offset: JavaArray, in_row_group_ctr: JavaArray, in_row_groups_avail: int, output_buf: JavaArray, out_row_ctr: JavaArray, out_rows_avail: int): void {
    sep_upsample__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3I_3II_3_3B_3II(cinfo, input_buf, input_buf_offset, in_row_group_ctr, in_row_groups_avail, output_buf, out_row_ctr, out_rows_avail);
    return;
  }
  public static function smoothing_ok__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): Boolean {
    var coef: JPEGDecoder$jpeg_d_coef_controller = cinfo.coef;
    var smoothing_useful: Boolean = false;
    var ci: int;
    var coefi: int;
    var compptr: JPEGDecoder$jpeg_component_info;
    var qtable: JPEGDecoder$JQUANT_TBL;
    var coef_bits: JavaArray;
    var coef_bits_latch: JavaArray;
    if (!cinfo.progressive_mode || cinfo.coef_bits === null)
      return false;
    if (coef.coef_bits_latch === null)
      coef.coef_bits_latch = new JavaArray("[I").lengths(cinfo.num_components * 6);
    coef_bits_latch = coef.coef_bits_latch;
    var coef_bits_latch_offset: int = 0;
    for (ci = 0; ci < cinfo.num_components; ci++) {
      compptr = cinfo.comp_info[ci];
      if ((qtable = compptr.quant_table) === null)
        return false;
      if (qtable.quantval[0] == 0 || qtable.quantval[1] == 0 || qtable.quantval[8] == 0 || qtable.quantval[16] == 0 || qtable.quantval[9] == 0 || qtable.quantval[2] == 0)
        return false;
      coef_bits = cinfo.coef_bits[ci];
      if (coef_bits[0] < 0)
        return false;
      for (coefi = 1; coefi <= 5; coefi++) {
        coef_bits_latch[coefi + coef_bits_latch_offset] = coef_bits[coefi];
        if (coef_bits[coefi] != 0)
          smoothing_useful = true;
      }
      coef_bits_latch_offset += 6;
    }
    return smoothing_useful;
  }
  public static function master_selection__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var master: JPEGDecoder$jpeg_decomp_master = cinfo.master;
    var use_c_buffer: Boolean;
    var samplesperrow: Number = 0;
    var jd_samplesperrow: int;
    jpeg_calc_output_dimensions__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    prepare_range_limit_table__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    samplesperrow = Number(cinfo.output_width) * Number(cinfo.out_color_components);
    jd_samplesperrow = int(samplesperrow);
    if (jd_samplesperrow != samplesperrow)
      error__();
    master.pass_number = 0;
    master.using_merged_upsample = use_merged_upsample__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    master.quantizer_1pass = null;
    master.quantizer_2pass = null;
    if (!cinfo.quantize_colors || !cinfo.buffered_image) {
      cinfo.enable_1pass_quant = false;
      cinfo.enable_external_quant = false;
      cinfo.enable_2pass_quant = false;
    }
    if (cinfo.quantize_colors) {
      error__I(20);
    }
    if (!cinfo.raw_data_out) {
      if (master.using_merged_upsample) {
        error__();
      } else {
        jinit_color_deconverter__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
        jinit_upsampler__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      }
      jinit_d_post_controller__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Z(cinfo, cinfo.enable_2pass_quant);
    }
    jinit_inverse_dct__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    if (cinfo.arith_code) {
      error__();
    } else {
      if (cinfo.progressive_mode) {
        jinit_phuff_decoder__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      } else
        jinit_huff_decoder__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    }
    use_c_buffer = cinfo.inputctl.has_multiple_scans || cinfo.buffered_image;
    jinit_d_coef_controller__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Z(cinfo, use_c_buffer);
    if (!cinfo.raw_data_out)
      jinit_d_main_controller__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Z(cinfo, false);
    start_input_pass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    return;
  }
  public static function jinit_master_decompress__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var master: JPEGDecoder$jpeg_decomp_master = new JPEGDecoder$jpeg_decomp_master();
    cinfo.master = master;
    master.is_dummy_pass = false;
    master_selection__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    return;
  }
  public static function jcopy_sample_rows___3_3BI_3_3BIII(input_array: JavaArray, source_row: int, output_array: JavaArray, dest_row: int, num_rows: int, num_cols: int): void {
    var inptr: JavaArray;
    var outptr: JavaArray;
    var count: int = num_cols;
    var row: int;
    var input_array_offset: int = source_row;
    var output_array_offset: int = dest_row;
    for (row = num_rows; row > 0; row--) {
      inptr = input_array[input_array_offset++];
      outptr = output_array[output_array_offset++];
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(inptr, 0, outptr, 0, count);
    }
    return;
  }
  public static function jpeg_start_decompress__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): Boolean {
    if (cinfo.global_state == 202) {
      jinit_master_decompress__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      if (cinfo.buffered_image) {
        cinfo.global_state = 207;
        return true;
      }
      cinfo.global_state = 203;
    }
    if (cinfo.global_state == 203) {
      if (cinfo.inputctl.has_multiple_scans) {
        for (;;) {
          var retcode: int;
          retcode = consume_input__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
          if (retcode == 0)
            return false;
          if (retcode == 2)
            break;
        }
      }
      cinfo.output_scan_number = cinfo.input_scan_number;
    } else if (cinfo.global_state != 204)
      error__();
    return output_pass_setup__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
  }
  public static function prepare_for_output_pass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var master: JPEGDecoder$jpeg_decomp_master = cinfo.master;
    if (master.is_dummy_pass) {
      error__I(20);
    } else {
      if (cinfo.quantize_colors && cinfo.colormap === null) {
        if (cinfo.two_pass_quantize && cinfo.enable_2pass_quant) {
          cinfo.cquantize = master.quantizer_2pass;
          master.is_dummy_pass = true;
        } else if (cinfo.enable_1pass_quant) {
          cinfo.cquantize = master.quantizer_1pass;
        } else {
          error__();
        }
      }
      cinfo.idct.start_pass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      start_output_pass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      if (!cinfo.raw_data_out) {
        if (!master.using_merged_upsample)
          cinfo.cconvert.start_pass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
        cinfo.upsample.start_pass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
        if (cinfo.quantize_colors)
          cinfo.cquantize.start_pass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Z(cinfo, master.is_dummy_pass);
        cinfo.post.start_pass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2I(cinfo, (master.is_dummy_pass ? 3 : 0));
        cinfo.main.start_pass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2I(cinfo, 0);
      }
    }
    return;
  }
  public static function jpeg_resync_to_restart__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2I(cinfo: JPEGDecoder$jpeg_decompress_struct, desired: int): Boolean {
    var marker: int = cinfo.unread_marker;
    var action: int = 1;
    for (;;) {
      if (marker < 192)
        action = 2;
      else if (marker < 208 || marker > 215)
        action = 3;
      else {
        if (marker == (208 + ((desired + 1) & 7)) || marker == (208 + ((desired + 2) & 7)))
          action = 3;
        else if (marker == (208 + ((desired - 1) & 7)) || marker == (208 + ((desired - 2) & 7)))
          action = 2;
        else
          action = 1;
      }
      switch (action) {
        case 1 :
          cinfo.unread_marker = 0;
          return true;
        case 2 :
          if (!next_marker__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo))
            return false;
          marker = cinfo.unread_marker;
          break;
        case 3 :
          return true;
      }
    }
    return false;
  }
  public static function read_restart_marker__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): Boolean {
    if (cinfo.unread_marker == 0) {
      if (!next_marker__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo))
        return false;
    }
    if (cinfo.unread_marker == (208 + cinfo.marker.next_restart_num)) {
      cinfo.unread_marker = 0;
    } else {
      if (!jpeg_resync_to_restart__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2I(cinfo, cinfo.marker.next_restart_num))
        return false;
    }
    cinfo.marker.next_restart_num = (cinfo.marker.next_restart_num + 1) & 7;
    return true;
  }
  public static function jpeg_fill_bit_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$bitread_1working_1state_2III(state: JPEGDecoder$bitread_working_state, get_buffer: int, bits_left: int, nbits: int): Boolean {
    var buffer: JavaArray = state.buffer;
    var bytes_in_buffer: int = state.bytes_in_buffer;
    var bytes_offset: int = state.bytes_offset;
    var cinfo: JPEGDecoder$jpeg_decompress_struct = state.cinfo;
    if (cinfo.unread_marker == 0) {
      while (bits_left < 25) {
        var c: int;
        if (bytes_offset == bytes_in_buffer) {
          if (!fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo))
            return false;
          buffer = cinfo.buffer;
          bytes_in_buffer = cinfo.bytes_in_buffer;
          bytes_offset = cinfo.bytes_offset;
        }
        c = buffer[bytes_offset++] & 0xFF;
        if (c == 0xFF) {
          do {
            if (bytes_offset == bytes_in_buffer) {
              if (!fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo))
                return false;
              buffer = cinfo.buffer;
              bytes_in_buffer = cinfo.bytes_in_buffer;
              bytes_offset = cinfo.bytes_offset;
            }
            c = buffer[bytes_offset++] & 0xFF;
          } while (c == 0xFF);
          if (c == 0) {
            c = 0xFF;
          } else {
            cinfo.unread_marker = c;
            if (nbits > bits_left) {
              if (!cinfo.entropy.insufficient_data) {
                cinfo.entropy.insufficient_data = true;
              }
              get_buffer <<= 25 - bits_left;
              bits_left = 25;
            }
            state.buffer = buffer;
            state.bytes_in_buffer = bytes_in_buffer;
            state.bytes_offset = bytes_offset;
            state.get_buffer = get_buffer;
            state.bits_left = bits_left;
            return true;
          }
        }
        get_buffer = (get_buffer << 8) | c;
        bits_left += 8;
      }
    } else {
      if (nbits > bits_left) {
        if (!cinfo.entropy.insufficient_data) {
          cinfo.entropy.insufficient_data = true;
        }
        get_buffer <<= 25 - bits_left;
        bits_left = 25;
      }
    }
    state.buffer = buffer;
    state.bytes_in_buffer = bytes_in_buffer;
    state.bytes_offset = bytes_offset;
    state.get_buffer = get_buffer;
    state.bits_left = bits_left;
    return true;
  }
  public static function jpeg_huff_decode__Lorg_eclipse_swt_internal_image_JPEGDecoder$bitread_1working_1state_2IILorg_eclipse_swt_internal_image_JPEGDecoder$d_1derived_1tbl_2I(state: JPEGDecoder$bitread_working_state, get_buffer: int, bits_left: int, htbl: JPEGDecoder$d_derived_tbl, min_bits: int): int {
    var l: int = min_bits;
    var code: int;
    {
      if (bits_left < (l)) {
        if (!jpeg_fill_bit_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$bitread_1working_1state_2III(state, get_buffer, bits_left, l)) {
          return -1;
        }
        get_buffer = (state).get_buffer;
        bits_left = (state).bits_left;
      }
    }
    code = (((get_buffer >> (bits_left -= (l)))) & ((1 << (l)) - 1));
    while (code > htbl.maxcode[l]) {
      code <<= 1;
      {
        if (bits_left < (1)) {
          if (!jpeg_fill_bit_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$bitread_1working_1state_2III(state, get_buffer, bits_left, 1)) {
            return -1;
          }
          get_buffer = (state).get_buffer;
          bits_left = (state).bits_left;
        }
      }
      code |= (((get_buffer >> (bits_left -= (1)))) & ((1 << (1)) - 1));
      l++;
    }
    state.get_buffer = get_buffer;
    state.bits_left = bits_left;
    if (l > 16) {
      return 0;
    }
    return htbl.pub.huffval[(code + htbl.valoffset[l])] & 0xFF;
  }
  public static function decompress_onepass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3I(cinfo: JPEGDecoder$jpeg_decompress_struct, output_buf: JavaArray, output_buf_offset: JavaArray): int {
    var coef: JPEGDecoder$jpeg_d_coef_controller = cinfo.coef;
    var MCU_col_num: int;
    var last_MCU_col: int = cinfo.MCUs_per_row - 1;
    var last_iMCU_row: int = cinfo.total_iMCU_rows - 1;
    var blkn: int;
    var ci: int;
    var xindex: int;
    var yindex: int;
    var yoffset: int;
    var useful_width: int;
    var output_ptr: JavaArray;
    var start_col: int;
    var output_col: int;
    var compptr: JPEGDecoder$jpeg_component_info;
    for (yoffset = coef.MCU_vert_offset; yoffset < coef.MCU_rows_per_iMCU_row; yoffset++) {
      for (MCU_col_num = coef.MCU_ctr; MCU_col_num <= last_MCU_col; MCU_col_num++) {
        for (var i: int = 0; i < cinfo.blocks_in_MCU; i++) {
          var blk: JavaArray = coef.MCU_buffer[i];
          for (var j: int = 0; j < blk.length; j++) {
            blk[j] = 0;
          }
        }
        if (!cinfo.entropy.decode_mcu__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3S(cinfo, coef.MCU_buffer)) {
          coef.MCU_vert_offset = yoffset;
          coef.MCU_ctr = MCU_col_num;
          return 0;
        }
        blkn = 0;
        for (ci = 0; ci < cinfo.comps_in_scan; ci++) {
          compptr = cinfo.cur_comp_info[ci];
          if (!compptr.component_needed) {
            blkn += compptr.MCU_blocks;
            continue;
          }
          useful_width = (MCU_col_num < last_MCU_col) ? compptr.MCU_width : compptr.last_col_width;
          output_ptr = output_buf[compptr.component_index];
          var output_ptr_offset: int = output_buf_offset[compptr.component_index] + yoffset * compptr.DCT_scaled_size;
          start_col = MCU_col_num * compptr.MCU_sample_width;
          for (yindex = 0; yindex < compptr.MCU_height; yindex++) {
            if (cinfo.input_iMCU_row < last_iMCU_row || yoffset + yindex < compptr.last_row_height) {
              output_col = start_col;
              for (xindex = 0; xindex < useful_width; xindex++) {
                jpeg_idct_islow__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1component_1info_2_3S_3_3BII(cinfo, compptr, coef.MCU_buffer[blkn + xindex], output_ptr, output_ptr_offset, output_col);
                output_col += compptr.DCT_scaled_size;
              }
            }
            blkn += compptr.MCU_width;
            output_ptr_offset += compptr.DCT_scaled_size;
          }
        }
      }
      coef.MCU_ctr = 0;
    }
    cinfo.output_iMCU_row++;
    if (++(cinfo.input_iMCU_row) < cinfo.total_iMCU_rows) {
      coef.start_iMCU_row__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      return 3;
    }
    finish_input_pass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    return 4;
  }
  public static function decompress_smooth_data__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3I(cinfo: JPEGDecoder$jpeg_decompress_struct, output_buf: JavaArray, output_buf_offset: JavaArray): int {
    var coef: JPEGDecoder$jpeg_d_coef_controller = cinfo.coef;
    var last_iMCU_row: int = cinfo.total_iMCU_rows - 1;
    var block_num: int;
    var last_block_column: int;
    var ci: int;
    var block_row: int;
    var block_rows: int;
    var access_rows: int;
    var buffer: JavaArray;
    var buffer_ptr: JavaArray;
    var prev_block_row: JavaArray;
    var next_block_row: JavaArray;
    var output_ptr: JavaArray;
    var output_col: int;
    var compptr: JPEGDecoder$jpeg_component_info;
    var first_row: Boolean;
    var last_row: Boolean;
    var workspace: JavaArray = coef.workspace;
    if (workspace === null)
      workspace = coef.workspace = new JavaArray("[S").lengths(64);
    var coef_bits: JavaArray;
    var quanttbl: JPEGDecoder$JQUANT_TBL;
    var Q00: int;
    var Q01: int;
    var Q02: int;
    var Q10: int;
    var Q11: int;
    var Q20: int;
    var num: int;
    var DC1: int;
    var DC2: int;
    var DC3: int;
    var DC4: int;
    var DC5: int;
    var DC6: int;
    var DC7: int;
    var DC8: int;
    var DC9: int;
    var Al: int;
    var pred: int;
    while (cinfo.input_scan_number <= cinfo.output_scan_number && !cinfo.inputctl.eoi_reached) {
      if (cinfo.input_scan_number == cinfo.output_scan_number) {
        var delta: int = (cinfo.Ss == 0) ? 1 : 0;
        if (cinfo.input_iMCU_row > cinfo.output_iMCU_row + delta)
          break;
      }
      if (consume_input__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo) == 0)
        return 0;
    }
    for (ci = 0; ci < cinfo.num_components; ci++) {
      compptr = cinfo.comp_info[ci];
      if (!compptr.component_needed)
        continue;
      if (cinfo.output_iMCU_row < last_iMCU_row) {
        block_rows = compptr.v_samp_factor;
        access_rows = block_rows * 2;
        last_row = false;
      } else {
        block_rows = (compptr.height_in_blocks % compptr.v_samp_factor);
        if (block_rows == 0)
          block_rows = compptr.v_samp_factor;
        access_rows = block_rows;
        last_row = true;
      }
      var buffer_offset: int;
      if (cinfo.output_iMCU_row > 0) {
        access_rows += compptr.v_samp_factor;
        buffer = coef.whole_image[ci];
        buffer_offset = (cinfo.output_iMCU_row - 1) * compptr.v_samp_factor;
        buffer_offset += compptr.v_samp_factor;
        first_row = false;
      } else {
        buffer = coef.whole_image[ci];
        buffer_offset = 0;
        first_row = true;
      }
      coef_bits = coef.coef_bits_latch;
      var coef_offset: int = (ci * 6);
      quanttbl = compptr.quant_table;
      Q00 = quanttbl.quantval[0];
      Q01 = quanttbl.quantval[1];
      Q10 = quanttbl.quantval[8];
      Q20 = quanttbl.quantval[16];
      Q11 = quanttbl.quantval[9];
      Q02 = quanttbl.quantval[2];
      output_ptr = output_buf[ci];
      var output_ptr_offset: int = output_buf_offset[ci];
      for (block_row = 0; block_row < block_rows; block_row++) {
        buffer_ptr = buffer[block_row + buffer_offset];
        var buffer_ptr_offset: int = 0;
        var prev_block_row_offset: int = 0;
        var next_block_row_offset: int = 0;
        if (first_row && block_row == 0) {
          prev_block_row = buffer_ptr;
          prev_block_row_offset = buffer_ptr_offset;
        } else {
          prev_block_row = buffer[block_row - 1 + buffer_offset];
          prev_block_row_offset = 0;
        }
        if (last_row && block_row == block_rows - 1) {
          next_block_row = buffer_ptr;
          next_block_row_offset = buffer_ptr_offset;
        } else {
          next_block_row = buffer[block_row + 1 + buffer_offset];
          next_block_row_offset = 0;
        }
        DC1 = DC2 = DC3 = prev_block_row[0 + prev_block_row_offset][0];
        DC4 = DC5 = DC6 = buffer_ptr[0 + buffer_ptr_offset][0];
        DC7 = DC8 = DC9 = next_block_row[0 + next_block_row_offset][0];
        output_col = 0;
        last_block_column = compptr.width_in_blocks - 1;
        for (block_num = 0; block_num <= last_block_column; block_num++) {
          System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(buffer_ptr[buffer_ptr_offset], 0, workspace, 0, workspace.length);
          if (block_num < last_block_column) {
            DC3 = prev_block_row[1 + prev_block_row_offset][0];
            DC6 = buffer_ptr[1 + buffer_ptr_offset][0];
            DC9 = next_block_row[1 + next_block_row_offset][0];
          }
          if ((Al = coef_bits[1 + coef_offset]) != 0 && workspace[1] == 0) {
            num = 36 * Q00 * (DC4 - DC6);
            if (num >= 0) {
              pred = (int(((Q01 << 7) + num) / (Q01 << 8)));
              if (Al > 0 && pred >= (1 << Al))
                pred = (1 << Al) - 1;
            } else {
              pred = (int(((Q01 << 7) - num) / (Q01 << 8)));
              if (Al > 0 && pred >= (1 << Al))
                pred = (1 << Al) - 1;
              pred = -pred;
            }
            workspace[1] = int(pred);
          }
          if ((Al = coef_bits[2 + coef_offset]) != 0 && workspace[8] == 0) {
            num = 36 * Q00 * (DC2 - DC8);
            if (num >= 0) {
              pred = (int(((Q10 << 7) + num) / (Q10 << 8)));
              if (Al > 0 && pred >= (1 << Al))
                pred = (1 << Al) - 1;
            } else {
              pred = (int(((Q10 << 7) - num) / (Q10 << 8)));
              if (Al > 0 && pred >= (1 << Al))
                pred = (1 << Al) - 1;
              pred = -pred;
            }
            workspace[8] = int(pred);
          }
          if ((Al = coef_bits[3 + coef_offset]) != 0 && workspace[16] == 0) {
            num = 9 * Q00 * (DC2 + DC8 - 2 * DC5);
            if (num >= 0) {
              pred = (int(((Q20 << 7) + num) / (Q20 << 8)));
              if (Al > 0 && pred >= (1 << Al))
                pred = (1 << Al) - 1;
            } else {
              pred = (int(((Q20 << 7) - num) / (Q20 << 8)));
              if (Al > 0 && pred >= (1 << Al))
                pred = (1 << Al) - 1;
              pred = -pred;
            }
            workspace[16] = int(pred);
          }
          if ((Al = coef_bits[4 + coef_offset]) != 0 && workspace[9] == 0) {
            num = 5 * Q00 * (DC1 - DC3 - DC7 + DC9);
            if (num >= 0) {
              pred = (int(((Q11 << 7) + num) / (Q11 << 8)));
              if (Al > 0 && pred >= (1 << Al))
                pred = (1 << Al) - 1;
            } else {
              pred = (int(((Q11 << 7) - num) / (Q11 << 8)));
              if (Al > 0 && pred >= (1 << Al))
                pred = (1 << Al) - 1;
              pred = -pred;
            }
            workspace[9] = int(pred);
          }
          if ((Al = coef_bits[5 + coef_offset]) != 0 && workspace[2] == 0) {
            num = 9 * Q00 * (DC4 + DC6 - 2 * DC5);
            if (num >= 0) {
              pred = (int(((Q02 << 7) + num) / (Q02 << 8)));
              if (Al > 0 && pred >= (1 << Al))
                pred = (1 << Al) - 1;
            } else {
              pred = (int(((Q02 << 7) - num) / (Q02 << 8)));
              if (Al > 0 && pred >= (1 << Al))
                pred = (1 << Al) - 1;
              pred = -pred;
            }
            workspace[2] = int(pred);
          }
          jpeg_idct_islow__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1component_1info_2_3S_3_3BII(cinfo, compptr, workspace, output_ptr, output_ptr_offset, output_col);
          DC1 = DC2;
          DC2 = DC3;
          DC4 = DC5;
          DC5 = DC6;
          DC7 = DC8;
          DC8 = DC9;
          buffer_ptr_offset++;
          prev_block_row_offset++;
          next_block_row_offset++;
          output_col += compptr.DCT_scaled_size;
        }
        output_ptr_offset += compptr.DCT_scaled_size;
      }
    }
    if (++(cinfo.output_iMCU_row) < cinfo.total_iMCU_rows)
      return 3;
    return 4;
  }
  public static function decompress_data__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3I(cinfo: JPEGDecoder$jpeg_decompress_struct, output_buf: JavaArray, output_buf_offset: JavaArray): int {
    var coef: JPEGDecoder$jpeg_d_coef_controller = cinfo.coef;
    var last_iMCU_row: int = cinfo.total_iMCU_rows - 1;
    var block_num: int;
    var ci: int;
    var block_row: int;
    var block_rows: int;
    var buffer: JavaArray;
    var buffer_ptr: JavaArray;
    var output_ptr: JavaArray;
    var output_col: int;
    var compptr: JPEGDecoder$jpeg_component_info;
    while (cinfo.input_scan_number < cinfo.output_scan_number || (cinfo.input_scan_number == cinfo.output_scan_number && cinfo.input_iMCU_row <= cinfo.output_iMCU_row)) {
      if (consume_input__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo) == 0)
        return 0;
    }
    for (ci = 0; ci < cinfo.num_components; ci++) {
      compptr = cinfo.comp_info[ci];
      if (!compptr.component_needed)
        continue;
      buffer = coef.whole_image[ci];
      var buffer_offset: int = cinfo.output_iMCU_row * compptr.v_samp_factor;
      if (cinfo.output_iMCU_row < last_iMCU_row)
        block_rows = compptr.v_samp_factor;
      else {
        block_rows = (compptr.height_in_blocks % compptr.v_samp_factor);
        if (block_rows == 0)
          block_rows = compptr.v_samp_factor;
      }
      output_ptr = output_buf[ci];
      var output_ptr_offset: int = output_buf_offset[ci];
      for (block_row = 0; block_row < block_rows; block_row++) {
        buffer_ptr = buffer[block_row + buffer_offset];
        var buffer_ptr_offset: int = 0;
        output_col = 0;
        for (block_num = 0; block_num < compptr.width_in_blocks; block_num++) {
          jpeg_idct_islow__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1component_1info_2_3S_3_3BII(cinfo, compptr, buffer_ptr[buffer_ptr_offset], output_ptr, output_ptr_offset, output_col);
          buffer_ptr_offset++;
          output_col += compptr.DCT_scaled_size;
        }
        output_ptr_offset += compptr.DCT_scaled_size;
      }
    }
    if (++(cinfo.output_iMCU_row) < cinfo.total_iMCU_rows)
      return 3;
    return 4;
  }
  public static function post_process_data__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3I_3II_3_3B_3II(cinfo: JPEGDecoder$jpeg_decompress_struct, input_buf: JavaArray, input_buf_offset: JavaArray, in_row_group_ctr: JavaArray, in_row_groups_avail: int, output_buf: JavaArray, out_row_ctr: JavaArray, out_rows_avail: int): void {
    upsample__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3I_3II_3_3B_3II(cinfo, input_buf, input_buf_offset, in_row_group_ctr, in_row_groups_avail, output_buf, out_row_ctr, out_rows_avail);
  }
  public static function set_bottom_pointers__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var main: JPEGDecoder$jpeg_d_main_controller = cinfo.main;
    var ci: int;
    var i: int;
    var rgroup: int;
    var iMCUheight: int;
    var rows_left: int;
    var compptr: JPEGDecoder$jpeg_component_info;
    var xbuf: JavaArray;
    for (ci = 0; ci < cinfo.num_components; ci++) {
      compptr = cinfo.comp_info[ci];
      iMCUheight = compptr.v_samp_factor * compptr.DCT_scaled_size;
      rgroup = int(iMCUheight / cinfo.min_DCT_scaled_size);
      rows_left = (compptr.downsampled_height % iMCUheight);
      if (rows_left == 0)
        rows_left = iMCUheight;
      if (ci == 0) {
        main.rowgroups_avail = (int((rows_left - 1) / rgroup) + 1);
      }
      xbuf = main.xbuffer[main.whichptr][ci];
      var xbuf_offset: int = main.xbuffer_offset[main.whichptr][ci];
      for (i = 0; i < rgroup * 2; i++) {
        xbuf[rows_left + i + xbuf_offset] = xbuf[rows_left - 1 + xbuf_offset];
      }
    }
    return;
  }
  public static function set_wraparound_pointers__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var main: JPEGDecoder$jpeg_d_main_controller = cinfo.main;
    var ci: int;
    var i: int;
    var rgroup: int;
    var M: int = cinfo.min_DCT_scaled_size;
    var compptr: JPEGDecoder$jpeg_component_info;
    var xbuf0: JavaArray;
    var xbuf1: JavaArray;
    for (ci = 0; ci < cinfo.num_components; ci++) {
      compptr = cinfo.comp_info[ci];
      rgroup = int((compptr.v_samp_factor * compptr.DCT_scaled_size) / cinfo.min_DCT_scaled_size);
      xbuf0 = main.xbuffer[0][ci];
      var xbuf0_offset: int = main.xbuffer_offset[0][ci];
      xbuf1 = main.xbuffer[1][ci];
      var xbuf1_offset: int = main.xbuffer_offset[1][ci];
      for (i = 0; i < rgroup; i++) {
        xbuf0[i - rgroup + xbuf0_offset] = xbuf0[rgroup * (M + 1) + i + xbuf0_offset];
        xbuf1[i - rgroup + xbuf1_offset] = xbuf1[rgroup * (M + 1) + i + xbuf1_offset];
        xbuf0[rgroup * (M + 2) + i + xbuf0_offset] = xbuf0[i + xbuf0_offset];
        xbuf1[rgroup * (M + 2) + i + xbuf1_offset] = xbuf1[i + xbuf1_offset];
      }
    }
    return;
  }
  public static function process_data_crank_post__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3B_3II(cinfo: JPEGDecoder$jpeg_decompress_struct, output_buf: JavaArray, out_row_ctr: JavaArray, out_rows_avail: int): void {
    error__();
    return;
  }
  public static function process_data_context_main__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3B_3II(cinfo: JPEGDecoder$jpeg_decompress_struct, output_buf: JavaArray, out_row_ctr: JavaArray, out_rows_avail: int): void {
    var main: JPEGDecoder$jpeg_d_main_controller = cinfo.main;
    if (!main.buffer_full) {
      var result: int;
      switch (cinfo.coef.decompress_data) {
        case 0 :
          result = decompress_data__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3I(cinfo, main.xbuffer[main.whichptr], main.xbuffer_offset[main.whichptr]);
          break;
        case 1 :
          result = decompress_smooth_data__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3I(cinfo, main.xbuffer[main.whichptr], main.xbuffer_offset[main.whichptr]);
          break;
        case 2 :
          result = decompress_onepass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3I(cinfo, main.xbuffer[main.whichptr], main.xbuffer_offset[main.whichptr]);
          break;
        default :
          result = 0;
      }
      if (result == 0)
        return;
      main.buffer_full = true;
      main.iMCU_row_ctr++;
    }
    switch (main.context_state) {
      case 2 :
        post_process_data__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3I_3II_3_3B_3II(cinfo, main.xbuffer[main.whichptr], main.xbuffer_offset[main.whichptr], main.rowgroup_ctr, main.rowgroups_avail, output_buf, out_row_ctr, out_rows_avail);
        if (main.rowgroup_ctr[0] < main.rowgroups_avail)
          return;
        main.context_state = 0;
        if (out_row_ctr[0] >= out_rows_avail)
          return;
      case 0 :
        main.rowgroup_ctr[0] = 0;
        main.rowgroups_avail = (cinfo.min_DCT_scaled_size - 1);
        if (main.iMCU_row_ctr == cinfo.total_iMCU_rows)
          set_bottom_pointers__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
        main.context_state = 1;
      case 1 :
        post_process_data__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3I_3II_3_3B_3II(cinfo, main.xbuffer[main.whichptr], main.xbuffer_offset[main.whichptr], main.rowgroup_ctr, main.rowgroups_avail, output_buf, out_row_ctr, out_rows_avail);
        if (main.rowgroup_ctr[0] < main.rowgroups_avail)
          return;
        if (main.iMCU_row_ctr == 1)
          set_wraparound_pointers__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
        main.whichptr ^= 1;
        main.buffer_full = false;
        main.rowgroup_ctr[0] = (cinfo.min_DCT_scaled_size + 1);
        main.rowgroups_avail = (cinfo.min_DCT_scaled_size + 2);
        main.context_state = 2;
    }
  }
  public static function process_data_simple_main__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3B_3II(cinfo: JPEGDecoder$jpeg_decompress_struct, output_buf: JavaArray, out_row_ctr: JavaArray, out_rows_avail: int): void {
    var main: JPEGDecoder$jpeg_d_main_controller = cinfo.main;
    var rowgroups_avail: int;
    if (!main.buffer_full) {
      var result: int;
      switch (cinfo.coef.decompress_data) {
        case 0 :
          result = decompress_data__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3I(cinfo, main.buffer, main.buffer_offset);
          break;
        case 1 :
          result = decompress_smooth_data__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3I(cinfo, main.buffer, main.buffer_offset);
          break;
        case 2 :
          result = decompress_onepass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3I(cinfo, main.buffer, main.buffer_offset);
          break;
        default :
          result = 0;
      }
      if (result == 0)
        return;
      main.buffer_full = true;
    }
    rowgroups_avail = cinfo.min_DCT_scaled_size;
    post_process_data__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3I_3II_3_3B_3II(cinfo, main.buffer, main.buffer_offset, main.rowgroup_ctr, rowgroups_avail, output_buf, out_row_ctr, out_rows_avail);
    if (main.rowgroup_ctr[0] >= rowgroups_avail) {
      main.buffer_full = false;
      main.rowgroup_ctr[0] = 0;
    }
    return;
  }
  public static function jpeg_read_scanlines__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3BI(cinfo: JPEGDecoder$jpeg_decompress_struct, scanlines: JavaArray, max_lines: int): int {
    if (cinfo.global_state != 205)
      error__();
    if (cinfo.output_scanline >= cinfo.output_height) {
      return 0;
    }
    cinfo.row_ctr[0] = 0;
    switch (cinfo.main.process_data) {
      case 0 :
        process_data_simple_main__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3B_3II(cinfo, scanlines, cinfo.row_ctr, max_lines);
        break;
      case 1 :
        process_data_context_main__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3B_3II(cinfo, scanlines, cinfo.row_ctr, max_lines);
        break;
      case 2 :
        process_data_crank_post__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3B_3II(cinfo, scanlines, cinfo.row_ctr, max_lines);
        break;
      default :
        error__();
    }
    cinfo.output_scanline += cinfo.row_ctr[0];
    return cinfo.row_ctr[0];
  }
  public static function output_pass_setup__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): Boolean {
    if (cinfo.global_state != 204) {
      prepare_for_output_pass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      cinfo.output_scanline = 0;
      cinfo.global_state = 204;
    }
    while (cinfo.master.is_dummy_pass) {
      error__();
    }
    cinfo.global_state = cinfo.raw_data_out ? 206 : 205;
    return true;
  }
  public static function get_dht__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): Boolean {
    var length: int;
    var bits: JavaArray = new JavaArray("[B").lengths(17);
    var huffval: JavaArray = new JavaArray("[B").lengths(256);
    var i: int;
    var index: int;
    var count: int;
    var htblptr: JPEGDecoder$JHUFF_TBL;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    length = (cinfo.buffer[cinfo.bytes_offset++] & 0xFF) << 8;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    length |= cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
    length -= 2;
    while (length > 16) {
      if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
        fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      index = cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
      bits[0] = 0;
      count = 0;
      for (i = 1; i <= 16; i++) {
        if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
          fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
        bits[i] = cinfo.buffer[cinfo.bytes_offset++];
        count += bits[i] & 0xFF;
      }
      length -= 1 + 16;
      if (count > 256 || (count) > length)
        error__();
      for (i = 0; i < count; i++) {
        if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
          fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
        huffval[i] = cinfo.buffer[cinfo.bytes_offset++];
      }
      length -= count;
      if ((index & 0x10) != 0) {
        index -= 0x10;
        htblptr = cinfo.ac_huff_tbl_ptrs[index] = new JPEGDecoder$JHUFF_TBL();
      } else {
        htblptr = cinfo.dc_huff_tbl_ptrs[index] = new JPEGDecoder$JHUFF_TBL();
      }
      if (index < 0 || index >= 4)
        error__();
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(bits, 0, htblptr.bits, 0, bits.length);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(huffval, 0, htblptr.huffval, 0, huffval.length);
    }
    if (length != 0)
      error__();
    return true;
  }
  public static function get_dqt__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): Boolean {
    var length: int;
    var n: int;
    var i: int;
    var prec: int;
    var tmp: int;
    var quant_ptr: JPEGDecoder$JQUANT_TBL;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    length = (cinfo.buffer[cinfo.bytes_offset++] & 0xFF) << 8;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    length |= cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
    length -= 2;
    while (length > 0) {
      if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
        fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      n = cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
      prec = n >> 4;
      n &= 0x0F;
      if (n >= 4)
        error__();
      if (cinfo.quant_tbl_ptrs[n] === null)
        cinfo.quant_tbl_ptrs[n] = new JPEGDecoder$JQUANT_TBL();
      quant_ptr = cinfo.quant_tbl_ptrs[n];
      for (i = 0; i < 64; i++) {
        if (prec != 0) {
          if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
            fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
          tmp = (cinfo.buffer[cinfo.bytes_offset++] & 0xFF) << 8;
          if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
            fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
          tmp |= cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
        } else {
          if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
            fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
          tmp = cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
        }
        quant_ptr.quantval[jpeg_natural_order[i]] = int(tmp);
      }
      length -= (64 + 1);
      if (prec != 0)
        length -= 64;
    }
    if (length != 0)
      error__();
    return true;
  }
  public static function get_dri__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): Boolean {
    var length: int;
    var tmp: int;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    length = (cinfo.buffer[cinfo.bytes_offset++] & 0xFF) << 8;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    length |= cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
    if (length != 4)
      error__();
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    tmp = (cinfo.buffer[cinfo.bytes_offset++] & 0xFF) << 8;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    tmp |= cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
    cinfo.restart_interval = tmp;
    return true;
  }
  public static function get_dac__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): Boolean {
    var length: int;
    var index: int;
    var val: int;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    length = (cinfo.buffer[cinfo.bytes_offset++] & 0xFF) << 8;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    length |= cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
    length -= 2;
    while (length > 0) {
      if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
        fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      index = cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
      if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
        fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      val = cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
      length -= 2;
      if (index < 0 || index >= (2 * 16))
        error__();
      if (index >= 16) {
        cinfo.arith_ac_K[index - 16] = int(val);
      } else {
        cinfo.arith_dc_L[index] = int((val & 0x0F));
        cinfo.arith_dc_U[index] = int((val >> 4));
        if (cinfo.arith_dc_L[index] > cinfo.arith_dc_U[index])
          error__();
      }
    }
    if (length != 0)
      error__();
    return true;
  }
  public static function get_sos__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): Boolean {
    var length: int;
    var i: int;
    var ci: int;
    var n: int;
    var c: int;
    var cc: int;
    var compptr: JPEGDecoder$jpeg_component_info = null;
    if (!cinfo.marker.saw_SOF)
      error__();
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    length = (cinfo.buffer[cinfo.bytes_offset++] & 0xFF) << 8;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    length |= cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    n = cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
    if (length != (n * 2 + 6) || n < 1 || n > 4)
      error__();
    cinfo.comps_in_scan = n;
    for (i = 0; i < n; i++) {
      if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
        fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      cc = cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
      if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
        fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      c = cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
      for (ci = 0; ci < cinfo.num_components; ci++) {
        compptr = cinfo.comp_info[ci];
        if (cc == compptr.component_id)
          break;
      }
      if (ci == cinfo.num_components)
        error__();
      cinfo.cur_comp_info[i] = compptr;
      compptr.dc_tbl_no = (c >> 4) & 15;
      compptr.ac_tbl_no = (c) & 15;
    }
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    c = cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
    cinfo.Ss = c;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    c = cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
    cinfo.Se = c;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    c = cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
    cinfo.Ah = (c >> 4) & 15;
    cinfo.Al = (c) & 15;
    cinfo.marker.next_restart_num = 0;
    cinfo.input_scan_number++;
    return true;
  }
  public static function get_sof__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2ZZ(cinfo: JPEGDecoder$jpeg_decompress_struct, is_prog: Boolean, is_arith: Boolean): Boolean {
    var length: int;
    var c: int;
    var ci: int;
    cinfo.progressive_mode = is_prog;
    cinfo.arith_code = is_arith;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    length = (cinfo.buffer[cinfo.bytes_offset++] & 0xFF) << 8;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    length |= cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    cinfo.data_precision = cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    cinfo.image_height = (cinfo.buffer[cinfo.bytes_offset++] & 0xFF) << 8;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    cinfo.image_height |= cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    cinfo.image_width = (cinfo.buffer[cinfo.bytes_offset++] & 0xFF) << 8;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    cinfo.image_width |= cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    cinfo.num_components = cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
    length -= 8;
    if (cinfo.marker.saw_SOF)
      error__();
    if (cinfo.image_height <= 0 || cinfo.image_width <= 0 || cinfo.num_components <= 0)
      error__();
    if (length != (cinfo.num_components * 3))
      error__();
    if (cinfo.comp_info === null)
      cinfo.comp_info = new JavaArray("[Lorg/eclipse/swt/internal/image/JPEGDecoder$jpeg_component_info;").lengths(cinfo.num_components);
    for (ci = 0; ci < cinfo.num_components; ci++) {
      var compptr: JPEGDecoder$jpeg_component_info = cinfo.comp_info[ci] = new JPEGDecoder$jpeg_component_info();
      compptr.component_index = ci;
      if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
        fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      compptr.component_id = cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
      if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
        fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      c = cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
      compptr.h_samp_factor = (c >> 4) & 15;
      compptr.v_samp_factor = (c) & 15;
      if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
        fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      compptr.quant_tbl_no = cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
    }
    cinfo.marker.saw_SOF = true;
    return true;
  }
  public static function sep_upsample__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3I_3II_3_3B_3II(cinfo: JPEGDecoder$jpeg_decompress_struct, input_buf: JavaArray, input_buf_offset: JavaArray, in_row_group_ctr: JavaArray, in_row_groups_avail: int, output_buf: JavaArray, out_row_ctr: JavaArray, out_rows_avail: int): void {
    var upsample: JPEGDecoder$jpeg_upsampler = cinfo.upsample;
    var ci: int;
    var compptr: JPEGDecoder$jpeg_component_info;
    var num_rows: int;
    if (upsample.next_row_out >= cinfo.max_v_samp_factor) {
      for (ci = 0; ci < cinfo.num_components; ci++) {
        compptr = cinfo.comp_info[ci];
        var offset: int = input_buf_offset[ci] + (in_row_group_ctr[0] * upsample.rowgroup_height[ci]);
        switch (upsample.methods[ci]) {
          case 0 :
            noop_upsample__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1component_1info_2_3_3BI_3_3_3B_3II(cinfo, compptr, input_buf[ci], offset, upsample.color_buf, upsample.color_buf_offset, ci);
            break;
          case 1 :
            fullsize_upsample__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1component_1info_2_3_3BI_3_3_3B_3II(cinfo, compptr, input_buf[ci], offset, upsample.color_buf, upsample.color_buf_offset, ci);
            break;
          case 2 :
            h2v1_fancy_upsample__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1component_1info_2_3_3BI_3_3_3B_3II(cinfo, compptr, input_buf[ci], offset, upsample.color_buf, upsample.color_buf_offset, ci);
            break;
          case 3 :
            h2v1_upsample__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1component_1info_2_3_3BI_3_3_3B_3II(cinfo, compptr, input_buf[ci], offset, upsample.color_buf, upsample.color_buf_offset, ci);
            break;
          case 4 :
            h2v2_fancy_upsample__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1component_1info_2_3_3BI_3_3_3B_3II(cinfo, compptr, input_buf[ci], offset, upsample.color_buf, upsample.color_buf_offset, ci);
            break;
          case 5 :
            h2v2_upsample__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1component_1info_2_3_3BI_3_3_3B_3II(cinfo, compptr, input_buf[ci], offset, upsample.color_buf, upsample.color_buf_offset, ci);
            break;
          case 6 :
            int_upsample__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1component_1info_2_3_3BI_3_3_3B_3II(cinfo, compptr, input_buf[ci], offset, upsample.color_buf, upsample.color_buf_offset, ci);
            break;
        }
      }
      upsample.next_row_out = 0;
    }
    num_rows = (cinfo.max_v_samp_factor - upsample.next_row_out);
    if (num_rows > upsample.rows_to_go)
      num_rows = upsample.rows_to_go;
    out_rows_avail -= out_row_ctr[0];
    if (num_rows > out_rows_avail)
      num_rows = out_rows_avail;
    switch (cinfo.cconvert.color_convert) {
      case 0 :
        null_convert__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3II_3_3BII(cinfo, upsample.color_buf, upsample.color_buf_offset, upsample.next_row_out, output_buf, out_row_ctr[0], num_rows);
        break;
      case 1 :
        grayscale_convert__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3II_3_3BII(cinfo, upsample.color_buf, upsample.color_buf_offset, upsample.next_row_out, output_buf, out_row_ctr[0], num_rows);
        break;
      case 2 :
        ycc_rgb_convert__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3II_3_3BII(cinfo, upsample.color_buf, upsample.color_buf_offset, upsample.next_row_out, output_buf, out_row_ctr[0], num_rows);
        break;
      case 3 :
        gray_rgb_convert__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3II_3_3BII(cinfo, upsample.color_buf, upsample.color_buf_offset, upsample.next_row_out, output_buf, out_row_ctr[0], num_rows);
        break;
      case 4 :
        error__();
        break;
    }
    out_row_ctr[0] += num_rows;
    upsample.rows_to_go -= num_rows;
    upsample.next_row_out += num_rows;
    if (upsample.next_row_out >= cinfo.max_v_samp_factor) {
      in_row_group_ctr[0]++;
    }
    return;
  }
  public static function noop_upsample__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1component_1info_2_3_3BI_3_3_3B_3II(cinfo: JPEGDecoder$jpeg_decompress_struct, compptr: JPEGDecoder$jpeg_component_info, input_data: JavaArray, input_data_offset: int, output_data_ptr: JavaArray, output_data_offset: JavaArray, output_data_index: int): void {
    output_data_ptr[output_data_index] = null;
    return;
  }
  public static function fullsize_upsample__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1component_1info_2_3_3BI_3_3_3B_3II(cinfo: JPEGDecoder$jpeg_decompress_struct, compptr: JPEGDecoder$jpeg_component_info, input_data: JavaArray, input_data_offset: int, output_data_ptr: JavaArray, output_data_offset: JavaArray, output_data_index: int): void {
    output_data_ptr[output_data_index] = input_data;
    output_data_offset[output_data_index] = input_data_offset;
    return;
  }
  public static function h2v1_upsample__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1component_1info_2_3_3BI_3_3_3B_3II(cinfo: JPEGDecoder$jpeg_decompress_struct, compptr: JPEGDecoder$jpeg_component_info, input_data: JavaArray, input_data_offset: int, output_data_ptr: JavaArray, output_data_offset: JavaArray, output_data_index: int): void {
    var output_data: JavaArray = output_data_ptr[output_data_index];
    var inptr: JavaArray;
    var outptr: JavaArray;
    var invalue: int;
    var outend: int;
    var inrow: int;
    output_data_offset[output_data_index] = 0;
    for (inrow = 0; inrow < cinfo.max_v_samp_factor; inrow++) {
      inptr = input_data[inrow + input_data_offset];
      outptr = output_data[inrow];
      var inptr_offset: int = 0;
      var outptr_offset: int = 0;
      outend = outptr_offset + cinfo.output_width;
      while (outptr_offset < outend) {
        invalue = inptr[inptr_offset++];
        outptr[outptr_offset++] = invalue;
        outptr[outptr_offset++] = invalue;
      }
    }
    return;
  }
  public static function h2v2_upsample__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1component_1info_2_3_3BI_3_3_3B_3II(cinfo: JPEGDecoder$jpeg_decompress_struct, compptr: JPEGDecoder$jpeg_component_info, input_data: JavaArray, input_data_offset: int, output_data_ptr: JavaArray, output_data_offset: JavaArray, output_data_index: int): void {
    var output_data: JavaArray = output_data_ptr[output_data_index];
    var inptr: JavaArray;
    var outptr: JavaArray;
    var invalue: int;
    var outend: int;
    var inrow: int;
    var outrow: int;
    output_data_offset[output_data_index] = 0;
    inrow = outrow = 0;
    while (outrow < cinfo.max_v_samp_factor) {
      inptr = input_data[inrow + input_data_offset];
      outptr = output_data[outrow];
      var inptr_offset: int = 0;
      var outptr_offset: int = 0;
      outend = outptr_offset + cinfo.output_width;
      while (outptr_offset < outend) {
        invalue = inptr[inptr_offset++];
        outptr[outptr_offset++] = invalue;
        outptr[outptr_offset++] = invalue;
      }
      jcopy_sample_rows___3_3BI_3_3BIII(output_data, outrow, output_data, outrow + 1, 1, cinfo.output_width);
      inrow++;
      outrow += 2;
    }
    return;
  }
  public static function h2v1_fancy_upsample__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1component_1info_2_3_3BI_3_3_3B_3II(cinfo: JPEGDecoder$jpeg_decompress_struct, compptr: JPEGDecoder$jpeg_component_info, input_data: JavaArray, input_data_offset: int, output_data_ptr: JavaArray, output_data_offset: JavaArray, output_data_index: int): void {
    var output_data: JavaArray = output_data_ptr[output_data_index];
    var inptr: JavaArray;
    var outptr: JavaArray;
    var invalue: int;
    var colctr: int;
    var inrow: int;
    output_data_offset[output_data_index] = 0;
    for (inrow = 0; inrow < cinfo.max_v_samp_factor; inrow++) {
      inptr = input_data[inrow + input_data_offset];
      outptr = output_data[inrow];
      var inptr_offset: int = 0;
      var outptr_offset: int = 0;
      invalue = inptr[inptr_offset++] & 0xFF;
      outptr[outptr_offset++] = int(invalue);
      outptr[outptr_offset++] = int(((invalue * 3 + (inptr[inptr_offset] & 0xFF) + 2) >> 2));
      for (colctr = compptr.downsampled_width - 2; colctr > 0; colctr--) {
        invalue = (inptr[inptr_offset++] & 0xFF) * 3;
        outptr[outptr_offset++] = int(((invalue + (inptr[inptr_offset - 2] & 0xFF) + 1) >> 2));
        outptr[outptr_offset++] = int(((invalue + (inptr[inptr_offset] & 0xFF) + 2) >> 2));
      }
      invalue = (inptr[inptr_offset] & 0xFF);
      outptr[outptr_offset++] = int(((invalue * 3 + (inptr[inptr_offset - 1] & 0xFF) + 1) >> 2));
      outptr[outptr_offset++] = int(invalue);
    }
    return;
  }
  public static function h2v2_fancy_upsample__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1component_1info_2_3_3BI_3_3_3B_3II(cinfo: JPEGDecoder$jpeg_decompress_struct, compptr: JPEGDecoder$jpeg_component_info, input_data: JavaArray, input_data_offset: int, output_data_ptr: JavaArray, output_data_offset: JavaArray, output_data_index: int): void {
    var output_data: JavaArray = output_data_ptr[output_data_index];
    var inptr0: JavaArray;
    var inptr1: JavaArray;
    var outptr: JavaArray;
    var thiscolsum: int;
    var lastcolsum: int;
    var nextcolsum: int;
    var colctr: int;
    var inrow: int;
    var outrow: int;
    var v: int;
    output_data_offset[output_data_index] = 0;
    inrow = outrow = 0;
    while (outrow < cinfo.max_v_samp_factor) {
      for (v = 0; v < 2; v++) {
        inptr0 = input_data[inrow + input_data_offset];
        if (v == 0)
          inptr1 = input_data[inrow - 1 + input_data_offset];
        else
          inptr1 = input_data[inrow + 1 + input_data_offset];
        outptr = output_data[outrow++];
        var inptr0_offset: int = 0;
        var inptr1_offset: int = 0;
        var outptr_offset: int = 0;
        thiscolsum = (inptr0[inptr0_offset++] & 0xFF) * 3 + (inptr1[inptr1_offset++] & 0xFF);
        nextcolsum = (inptr0[inptr0_offset++] & 0xFF) * 3 + (inptr1[inptr1_offset++] & 0xFF);
        outptr[outptr_offset++] = int(((thiscolsum * 4 + 8) >> 4));
        outptr[outptr_offset++] = int(((thiscolsum * 3 + nextcolsum + 7) >> 4));
        lastcolsum = thiscolsum;
        thiscolsum = nextcolsum;
        for (colctr = compptr.downsampled_width - 2; colctr > 0; colctr--) {
          nextcolsum = (inptr0[inptr0_offset++] & 0xFF) * 3 + (inptr1[inptr1_offset++] & 0xFF);
          outptr[outptr_offset++] = int(((thiscolsum * 3 + lastcolsum + 8) >> 4));
          outptr[outptr_offset++] = int(((thiscolsum * 3 + nextcolsum + 7) >> 4));
          lastcolsum = thiscolsum;
          thiscolsum = nextcolsum;
        }
        outptr[outptr_offset++] = int(((thiscolsum * 3 + lastcolsum + 8) >> 4));
        outptr[outptr_offset++] = int(((thiscolsum * 4 + 7) >> 4));
      }
      inrow++;
    }
    return;
  }
  public static function int_upsample__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1component_1info_2_3_3BI_3_3_3B_3II(cinfo: JPEGDecoder$jpeg_decompress_struct, compptr: JPEGDecoder$jpeg_component_info, input_data: JavaArray, input_data_offset: int, output_data_ptr: JavaArray, output_data_offset: JavaArray, output_data_index: int): void {
    var upsample: JPEGDecoder$jpeg_upsampler = cinfo.upsample;
    var output_data: JavaArray = output_data_ptr[output_data_index];
    var inptr: JavaArray;
    var outptr: JavaArray;
    var invalue: int;
    var h: int;
    var outend: int;
    var h_expand: int;
    var v_expand: int;
    var inrow: int;
    var outrow: int;
    output_data_offset[output_data_index] = 0;
    h_expand = upsample.h_expand[compptr.component_index];
    v_expand = upsample.v_expand[compptr.component_index];
    inrow = outrow = 0;
    while (outrow < cinfo.max_v_samp_factor) {
      inptr = input_data[inrow + input_data_offset];
      var inptr_offset: int = 0;
      outptr = output_data[outrow];
      var outptr_offset: int = 0;
      outend = outptr_offset + cinfo.output_width;
      while (outptr_offset < outend) {
        invalue = inptr[inptr_offset++];
        for (h = h_expand; h > 0; h--) {
          outptr[outptr_offset++] = invalue;
        }
      }
      if (v_expand > 1) {
        jcopy_sample_rows___3_3BI_3_3BIII(output_data, outrow, output_data, outrow + 1, v_expand - 1, cinfo.output_width);
      }
      inrow++;
      outrow += v_expand;
    }
    return;
  }
  public static function null_convert__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3II_3_3BII(cinfo: JPEGDecoder$jpeg_decompress_struct, input_buf: JavaArray, input_buf_offset: JavaArray, input_row: int, output_buf: JavaArray, output_buf_offset: int, num_rows: int): void {
    var inptr: JavaArray;
    var outptr: JavaArray;
    var count: int;
    var num_components: int = cinfo.num_components;
    var num_cols: int = cinfo.output_width;
    var ci: int;
    while (--num_rows >= 0) {
      for (ci = 0; ci < num_components; ci++) {
        inptr = input_buf[ci][input_row + input_buf_offset[0]];
        outptr = output_buf[output_buf_offset];
        var offset: int = 0;
        switch (ci) {
          case 2 :
            offset = 0;
            break;
          case 1 :
            offset = 1;
            break;
          case 0 :
            offset = 2;
            break;
        }
        var outptr_offset: int = offset;
        var inptr_offset: int = 0;
        for (count = num_cols; count > 0; count--) {
          outptr[outptr_offset] = inptr[inptr_offset++];
          outptr_offset += num_components;
        }
      }
      input_row++;
      output_buf_offset++;
    }
    return;
  }
  public static function grayscale_convert__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3II_3_3BII(cinfo: JPEGDecoder$jpeg_decompress_struct, input_buf: JavaArray, input_buf_offset: JavaArray, input_row: int, output_buf: JavaArray, output_buf_offset: int, num_rows: int): void {
    jcopy_sample_rows___3_3BI_3_3BIII(input_buf[0], input_row + input_buf_offset[0], output_buf, output_buf_offset, num_rows, cinfo.output_width);
    return;
  }
  public static function gray_rgb_convert__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3II_3_3BII(cinfo: JPEGDecoder$jpeg_decompress_struct, input_buf: JavaArray, input_buf_offset: JavaArray, input_row: int, output_buf: JavaArray, output_buf_offset: int, num_rows: int): void {
    var inptr: JavaArray;
    var outptr: JavaArray;
    var col: int;
    var num_cols: int = cinfo.output_width;
    while (--num_rows >= 0) {
      inptr = input_buf[0][input_row++ + input_buf_offset[0]];
      outptr = output_buf[output_buf_offset++];
      var outptr_offset: int = 0;
      for (col = 0; col < num_cols; col++) {
        outptr[2 + outptr_offset] = outptr[1 + outptr_offset] = outptr[0 + outptr_offset] = inptr[col];
        outptr_offset += 3;
      }
    }
    return;
  }
  public static function ycc_rgb_convert__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3_3B_3II_3_3BII(cinfo: JPEGDecoder$jpeg_decompress_struct, input_buf: JavaArray, input_buf_offset: JavaArray, input_row: int, output_buf: JavaArray, output_buf_offset: int, num_rows: int): void {
    var cconvert: JPEGDecoder$jpeg_color_deconverter = cinfo.cconvert;
    var y: int;
    var cb: int;
    var cr: int;
    var outptr: JavaArray;
    var inptr0: JavaArray;
    var inptr1: JavaArray;
    var inptr2: JavaArray;
    var col: int;
    var num_cols: int = cinfo.output_width;
    var range_limit: JavaArray = cinfo.sample_range_limit;
    var range_limit_offset: int = cinfo.sample_range_limit_offset;
    var Crrtab: JavaArray = cconvert.Cr_r_tab;
    var Cbbtab: JavaArray = cconvert.Cb_b_tab;
    var Crgtab: JavaArray = cconvert.Cr_g_tab;
    var Cbgtab: JavaArray = cconvert.Cb_g_tab;
    while (--num_rows >= 0) {
      inptr0 = input_buf[0][input_row + input_buf_offset[0]];
      inptr1 = input_buf[1][input_row + input_buf_offset[1]];
      inptr2 = input_buf[2][input_row + input_buf_offset[2]];
      input_row++;
      outptr = output_buf[output_buf_offset++];
      var outptr_offset: int = 0;
      for (col = 0; col < num_cols; col++) {
        y = (inptr0[col] & 0xFF);
        cb = (inptr1[col] & 0xFF);
        cr = (inptr2[col] & 0xFF);
        outptr[outptr_offset + 2] = range_limit[y + Crrtab[cr] + range_limit_offset];
        outptr[outptr_offset + 1] = range_limit[y + ((Cbgtab[cb] + Crgtab[cr] >> 16)) + range_limit_offset];
        outptr[outptr_offset + 0] = range_limit[y + Cbbtab[cb] + range_limit_offset];
        outptr_offset += 3;
      }
    }
    return;
  }
  public static function process_APPn__ILorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(n: int, cinfo: JPEGDecoder$jpeg_decompress_struct): Boolean {
    if (n == 0 || n == 14) {
      return get_interesting_appn__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    }
    return skip_variable__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
  }
  public static function process_COM__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): Boolean {
    return skip_variable__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
  }
  public static function skip_input_data__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2I(cinfo: JPEGDecoder$jpeg_decompress_struct, num_bytes: int): void {
    if (num_bytes > 0) {
      while (num_bytes > cinfo.bytes_in_buffer - cinfo.bytes_offset) {
        num_bytes -= cinfo.bytes_in_buffer - cinfo.bytes_offset;
        if (!fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo))
          error__();
      }
      cinfo.bytes_offset += num_bytes;
    }
    return;
  }
  public static function skip_variable__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): Boolean {
    var length: int;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    length = (cinfo.buffer[cinfo.bytes_offset++] & 0xFF) << 8;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    length |= cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
    length -= 2;
    if (length > 0) {
      skip_input_data__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2I(cinfo, length);
    }
    return true;
  }
  public static function get_interesting_appn__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): Boolean {
    var length: int;
    var b: JavaArray = new JavaArray("[B").lengths(14);
    var i: int;
    var numtoread: int;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    length = (cinfo.buffer[cinfo.bytes_offset++] & 0xFF) << 8;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    length |= cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
    length -= 2;
    if (length >= 14)
      numtoread = 14;
    else if (length > 0)
      numtoread = length;
    else
      numtoread = 0;
    for (i = 0; i < numtoread; i++) {
      if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
        fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      b[i] = cinfo.buffer[cinfo.bytes_offset++];
    }
    length -= numtoread;
    switch (cinfo.unread_marker) {
      case 224 :
        examine_app0__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3BII(cinfo, b, numtoread, length);
        break;
      case 238 :
        examine_app14__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3BII(cinfo, b, numtoread, length);
        break;
      default :
        error__();
        break;
    }
    if (length > 0)
      skip_input_data__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2I(cinfo, length);
    return true;
  }
  public static function examine_app0__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3BII(cinfo: JPEGDecoder$jpeg_decompress_struct, data: JavaArray, datalen: int, remaining: int): void {
    var totallen: int = datalen + remaining;
    if (datalen >= 14 && (data[0] & 0xFF) == 0x4A && (data[1] & 0xFF) == 0x46 && (data[2] & 0xFF) == 0x49 && (data[3] & 0xFF) == 0x46 && (data[4] & 0xFF) == 0) {
      cinfo.saw_JFIF_marker = true;
      cinfo.JFIF_major_version = (data[5]);
      cinfo.JFIF_minor_version = int((data[6] & 0xFF));
      cinfo.density_unit = int((data[7] & 0xFF));
      cinfo.X_density = int((((data[8] & 0xFF) << 8) + (data[9] & 0xFF)));
      cinfo.Y_density = int((((data[10] & 0xFF) << 8) + (data[11] & 0xFF)));
      if (cinfo.JFIF_major_version != 1) {
      }
      if (((data[12] & 0xFF) | (data[13]) & 0xFF) != 0) {
      }
      totallen -= 14;
      if (totallen != ((data[12] & 0xFF) * (data[13] & 0xFF) * 3)) {
      }
    } else if (datalen >= 6 && (data[0] & 0xFF) == 0x4A && (data[1] & 0xFF) == 0x46 && (data[2] & 0xFF) == 0x58 && (data[3] & 0xFF) == 0x58 && (data[4] & 0xFF) == 0) {
      switch ((data[5]) & 0xFF) {
        case 0x10 :
          break;
        case 0x11 :
          break;
        case 0x13 :
          break;
        default :
          break;
      }
    } else {
    }
    return;
  }
  public static function examine_app14__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3BII(cinfo: JPEGDecoder$jpeg_decompress_struct, data: JavaArray, datalen: int, remaining: int): void {
    var transform: int;
    if (datalen >= 12 && (data[0] & 0xFF) == 0x41 && (data[1] & 0xFF) == 0x64 && (data[2] & 0xFF) == 0x6F && (data[3] & 0xFF) == 0x62 && (data[4] & 0xFF) == 0x65) {
      transform = (data[11] & 0xFF);
      cinfo.saw_Adobe_marker = true;
      cinfo.Adobe_transform = int(transform);
    } else {
    }
    return;
  }
  public static function get_soi__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): Boolean {
    var i: int;
    if (cinfo.marker.saw_SOI)
      error__();
    for (i = 0; i < 16; i++) {
      cinfo.arith_dc_L[i] = 0;
      cinfo.arith_dc_U[i] = 1;
      cinfo.arith_ac_K[i] = 5;
    }
    cinfo.restart_interval = 0;
    cinfo.jpeg_color_space = 0;
    cinfo.CCIR601_sampling = false;
    cinfo.saw_JFIF_marker = false;
    cinfo.JFIF_major_version = 1;
    cinfo.JFIF_minor_version = 1;
    cinfo.density_unit = 0;
    cinfo.X_density = 1;
    cinfo.Y_density = 1;
    cinfo.saw_Adobe_marker = false;
    cinfo.Adobe_transform = 0;
    cinfo.marker.saw_SOI = true;
    return true;
  }
  public static function jinit_input_controller__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var inputctl: JPEGDecoder$jpeg_input_controller = cinfo.inputctl = new JPEGDecoder$jpeg_input_controller();
    inputctl.has_multiple_scans = false;
    inputctl.eoi_reached = false;
    inputctl.inheaders = true;
  }
  public static function reset_marker_reader__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var marker: JPEGDecoder$jpeg_marker_reader = cinfo.marker;
    cinfo.comp_info = null;
    cinfo.input_scan_number = 0;
    cinfo.unread_marker = 0;
    marker.saw_SOI = false;
    marker.saw_SOF = false;
    marker.discarded_bytes = 0;
  }
  public static function reset_input_controller__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var inputctl: JPEGDecoder$jpeg_input_controller = cinfo.inputctl;
    inputctl.has_multiple_scans = false;
    inputctl.eoi_reached = false;
    inputctl.inheaders = true;
    reset_marker_reader__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    cinfo.coef_bits = null;
  }
  public static function finish_output_pass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var master: JPEGDecoder$jpeg_decomp_master = cinfo.master;
    if (cinfo.quantize_colors) {
      error__I(20);
    }
    master.pass_number++;
    return;
  }
  public static function jpeg_destroy__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    cinfo.global_state = 0;
    return;
  }
  public static function jpeg_destroy_decompress__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    jpeg_destroy__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    return;
  }
  public static function jpeg_input_complete__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): Boolean {
    if (cinfo.global_state < 200 || cinfo.global_state > 210)
      error__();
    return cinfo.inputctl.eoi_reached;
  }
  public static function jpeg_start_output__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2I(cinfo: JPEGDecoder$jpeg_decompress_struct, scan_number: int): Boolean {
    if (cinfo.global_state != 207 && cinfo.global_state != 204)
      error__();
    if (scan_number <= 0)
      scan_number = 1;
    if (cinfo.inputctl.eoi_reached && scan_number > cinfo.input_scan_number)
      scan_number = cinfo.input_scan_number;
    cinfo.output_scan_number = scan_number;
    return output_pass_setup__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
  }
  public static function jpeg_finish_output__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): Boolean {
    if ((cinfo.global_state == 205 || cinfo.global_state == 206) && cinfo.buffered_image) {
      finish_output_pass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      cinfo.global_state = 208;
    } else if (cinfo.global_state != 208) {
      error__();
    }
    while (cinfo.input_scan_number <= cinfo.output_scan_number && !cinfo.inputctl.eoi_reached) {
      if (consume_input__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo) == 0)
        return false;
    }
    cinfo.global_state = 207;
    return true;
  }
  public static function jpeg_finish_decompress__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): Boolean {
    if ((cinfo.global_state == 205 || cinfo.global_state == 206) && !cinfo.buffered_image) {
      if (cinfo.output_scanline < cinfo.output_height)
        error__();
      finish_output_pass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      cinfo.global_state = 210;
    } else if (cinfo.global_state == 207) {
      cinfo.global_state = 210;
    } else if (cinfo.global_state != 210) {
      error__();
    }
    while (!cinfo.inputctl.eoi_reached) {
      if (consume_input__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo) == 0)
        return false;
    }
    jpeg_abort__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    return true;
  }
  public static function jpeg_read_header__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Z(cinfo: JPEGDecoder$jpeg_decompress_struct, require_image: Boolean): int {
    var retcode: int;
    if (cinfo.global_state != 200 && cinfo.global_state != 201)
      error__();
    retcode = jpeg_consume_input__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    switch (retcode) {
      case 1 :
        retcode = 1;
        break;
      case 2 :
        if (require_image)
          error__();
        jpeg_abort__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
        retcode = 2;
        break;
      case 0 :
        break;
    }
    return retcode;
  }
  public static function dummy_consume_data__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): int {
    return 0;
  }
  public static function consume_data__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): int {
    var coef: JPEGDecoder$jpeg_d_coef_controller = cinfo.coef;
    var MCU_col_num: int;
    var blkn: int;
    var ci: int;
    var xindex: int;
    var yindex: int;
    var yoffset: int;
    var start_col: int;
    var buffer_ptr: JavaArray;
    var compptr: JPEGDecoder$jpeg_component_info;
    for (yoffset = coef.MCU_vert_offset; yoffset < coef.MCU_rows_per_iMCU_row; yoffset++) {
      for (MCU_col_num = coef.MCU_ctr; MCU_col_num < cinfo.MCUs_per_row; MCU_col_num++) {
        blkn = 0;
        for (ci = 0; ci < cinfo.comps_in_scan; ci++) {
          compptr = cinfo.cur_comp_info[ci];
          start_col = MCU_col_num * compptr.MCU_width;
          for (yindex = 0; yindex < compptr.MCU_height; yindex++) {
            buffer_ptr = coef.whole_image[compptr.component_index][yindex + yoffset + cinfo.input_iMCU_row * compptr.v_samp_factor];
            var buffer_ptr_offset: int = start_col;
            for (xindex = 0; xindex < compptr.MCU_width; xindex++) {
              coef.MCU_buffer[blkn++] = buffer_ptr[buffer_ptr_offset++];
            }
          }
        }
        if (!cinfo.entropy.decode_mcu__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3S(cinfo, coef.MCU_buffer)) {
          coef.MCU_vert_offset = yoffset;
          coef.MCU_ctr = MCU_col_num;
          return 0;
        }
      }
      coef.MCU_ctr = 0;
    }
    if (++(cinfo.input_iMCU_row) < cinfo.total_iMCU_rows) {
      coef.start_iMCU_row__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      return 3;
    }
    finish_input_pass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    return 4;
  }
  public static function consume_input__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): int {
    switch (cinfo.inputctl.consume_input) {
      case 1 :
        switch (cinfo.coef.consume_data) {
          case 0 :
            return consume_data__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
          case 1 :
            return dummy_consume_data__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
          default :
            error__();
        }
        break;
      case 0 :
        return consume_markers__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      default :
        error__();
    }
    return 0;
  }
  public static function fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): Boolean {
    try {
      var inputStream: InputStream = cinfo.inputStream;
      var nbytes: int = inputStream.read___3B(cinfo.buffer);
      if (nbytes <= 0) {
        if (cinfo.start_of_file)
          error__();
        cinfo.buffer[0] = int(0xFF);
        cinfo.buffer[1] = int(217);
        nbytes = 2;
      }
      cinfo.bytes_in_buffer = nbytes;
      cinfo.bytes_offset = 0;
      cinfo.start_of_file = false;
    } catch (e : IOException) {
      error__I(39);
      return false;
    }
    return true;
  }
  public static function first_marker__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): Boolean {
    var c: int;
    var c2: int;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    c = cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
    if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
      fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    c2 = cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
    if (c != 0xFF || c2 != 216)
      error__();
    cinfo.unread_marker = c2;
    return true;
  }
  public static function next_marker__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): Boolean {
    var c: int;
    for (;;) {
      if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
        fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
      c = cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
      while (c != 0xFF) {
        cinfo.marker.discarded_bytes++;
        if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
          fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
        c = cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
      }
      do {
        if (cinfo.bytes_offset == cinfo.bytes_in_buffer)
          fill_input_buffer__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
        c = cinfo.buffer[cinfo.bytes_offset++] & 0xFF;
      } while (c == 0xFF);
      if (c != 0)
        break;
      cinfo.marker.discarded_bytes += 2;
    }
    if (cinfo.marker.discarded_bytes != 0) {
      cinfo.marker.discarded_bytes = 0;
    }
    cinfo.unread_marker = c;
    return true;
  }
  public static function read_markers__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): int {
    for (;;) {
      if (cinfo.unread_marker == 0) {
        if (!cinfo.marker.saw_SOI) {
          if (!first_marker__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo))
            return 0;
        } else {
          if (!next_marker__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo))
            return 0;
        }
      }
      switch (cinfo.unread_marker) {
        case 216 :
          if (!get_soi__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo))
            return 0;
          break;
        case 192 :
        case 193 :
          if (!get_sof__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2ZZ(cinfo, false, false))
            return 0;
          break;
        case 194 :
          if (!get_sof__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2ZZ(cinfo, true, false))
            return 0;
          break;
        case 201 :
          if (!get_sof__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2ZZ(cinfo, false, true))
            return 0;
          break;
        case 202 :
          if (!get_sof__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2ZZ(cinfo, true, true))
            return 0;
          break;
        case 195 :
        case 197 :
        case 198 :
        case 199 :
        case 200 :
        case 203 :
        case 205 :
        case 206 :
        case 207 :
          error__();
          break;
        case 218 :
          if (!get_sos__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo))
            return 0;
          cinfo.unread_marker = 0;
          return 1;
        case 217 :
          cinfo.unread_marker = 0;
          return 2;
        case 204 :
          if (!get_dac__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo))
            return 0;
          break;
        case 196 :
          if (!get_dht__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo))
            return 0;
          break;
        case 219 :
          if (!get_dqt__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo))
            return 0;
          break;
        case 221 :
          if (!get_dri__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo))
            return 0;
          break;
        case 224 :
        case 225 :
        case 226 :
        case 227 :
        case 228 :
        case 229 :
        case 230 :
        case 231 :
        case 232 :
        case 233 :
        case 234 :
        case 235 :
        case 236 :
        case 237 :
        case 238 :
        case 239 :
          if (!process_APPn__ILorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo.unread_marker - 224, cinfo))
            return 0;
          break;
        case 254 :
          if (!process_COM__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo))
            return 0;
          break;
        case 208 :
        case 209 :
        case 210 :
        case 211 :
        case 212 :
        case 213 :
        case 214 :
        case 215 :
        case 1 :
          break;
        case 220 :
          if (!skip_variable__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo))
            return 0;
          break;
        default :
          error__();
          break;
      }
      cinfo.unread_marker = 0;
    }
    return 0;
  }
  public static function jdiv_round_up__JJ(a: Number, b: Number): Number {
    return (a + b - 1) / b;
  }
  public static function initial_setup__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var ci: int;
    var compptr: JPEGDecoder$jpeg_component_info;
    if (cinfo.image_height > 65500 || cinfo.image_width > 65500)
      error__();
    if (cinfo.data_precision != 8)
      error__Ljava_lang_String_2(" [data precision=" + cinfo.data_precision + "]");
    if (cinfo.num_components > 10)
      error__();
    cinfo.max_h_samp_factor = 1;
    cinfo.max_v_samp_factor = 1;
    for (ci = 0; ci < cinfo.num_components; ci++) {
      compptr = cinfo.comp_info[ci];
      if (compptr.h_samp_factor <= 0 || compptr.h_samp_factor > 4 || compptr.v_samp_factor <= 0 || compptr.v_samp_factor > 4)
        error__();
      cinfo.max_h_samp_factor = Math__.max__II(cinfo.max_h_samp_factor, compptr.h_samp_factor);
      cinfo.max_v_samp_factor = Math__.max__II(cinfo.max_v_samp_factor, compptr.v_samp_factor);
    }
    cinfo.min_DCT_scaled_size = 8;
    for (ci = 0; ci < cinfo.num_components; ci++) {
      compptr = cinfo.comp_info[ci];
      compptr.DCT_scaled_size = 8;
      compptr.width_in_blocks = int(jdiv_round_up__JJ(Number(cinfo.image_width) * Number(compptr.h_samp_factor), (cinfo.max_h_samp_factor * 8)));
      compptr.height_in_blocks = int(jdiv_round_up__JJ(Number(cinfo.image_height) * Number(compptr.v_samp_factor), (cinfo.max_v_samp_factor * 8)));
      compptr.downsampled_width = int(jdiv_round_up__JJ(Number(cinfo.image_width) * Number(compptr.h_samp_factor), cinfo.max_h_samp_factor));
      compptr.downsampled_height = int(jdiv_round_up__JJ(Number(cinfo.image_height) * Number(compptr.v_samp_factor), cinfo.max_v_samp_factor));
      compptr.component_needed = true;
      compptr.quant_table = null;
    }
    cinfo.total_iMCU_rows = int(jdiv_round_up__JJ(cinfo.image_height, (cinfo.max_v_samp_factor * 8)));
    if (cinfo.comps_in_scan < cinfo.num_components || cinfo.progressive_mode)
      cinfo.inputctl.has_multiple_scans = true;
    else
      cinfo.inputctl.has_multiple_scans = false;
    return;
  }
  public static function per_scan_setup__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var ci: int;
    var mcublks: int;
    var tmp: int = 0;
    var compptr: JPEGDecoder$jpeg_component_info;
    if (cinfo.comps_in_scan == 1) {
      compptr = cinfo.cur_comp_info[0];
      cinfo.MCUs_per_row = compptr.width_in_blocks;
      cinfo.MCU_rows_in_scan = compptr.height_in_blocks;
      compptr.MCU_width = 1;
      compptr.MCU_height = 1;
      compptr.MCU_blocks = 1;
      compptr.MCU_sample_width = compptr.DCT_scaled_size;
      compptr.last_col_width = 1;
      tmp = (compptr.height_in_blocks % compptr.v_samp_factor);
      if (tmp == 0)
        tmp = compptr.v_samp_factor;
      compptr.last_row_height = tmp;
      cinfo.blocks_in_MCU = 1;
      cinfo.MCU_membership[0] = 0;
    } else {
      if (cinfo.comps_in_scan <= 0 || cinfo.comps_in_scan > 4)
        error__();
      cinfo.MCUs_per_row = int(jdiv_round_up__JJ(cinfo.image_width, (cinfo.max_h_samp_factor * 8)));
      cinfo.MCU_rows_in_scan = int(jdiv_round_up__JJ(cinfo.image_height, (cinfo.max_v_samp_factor * 8)));
      cinfo.blocks_in_MCU = 0;
      for (ci = 0; ci < cinfo.comps_in_scan; ci++) {
        compptr = cinfo.cur_comp_info[ci];
        compptr.MCU_width = compptr.h_samp_factor;
        compptr.MCU_height = compptr.v_samp_factor;
        compptr.MCU_blocks = compptr.MCU_width * compptr.MCU_height;
        compptr.MCU_sample_width = compptr.MCU_width * compptr.DCT_scaled_size;
        tmp = (compptr.width_in_blocks % compptr.MCU_width);
        if (tmp == 0)
          tmp = compptr.MCU_width;
        compptr.last_col_width = tmp;
        tmp = (compptr.height_in_blocks % compptr.MCU_height);
        if (tmp == 0)
          tmp = compptr.MCU_height;
        compptr.last_row_height = tmp;
        mcublks = compptr.MCU_blocks;
        if (cinfo.blocks_in_MCU + mcublks > 10)
          error__();
        while (mcublks-- > 0) {
          cinfo.MCU_membership[cinfo.blocks_in_MCU++] = ci;
        }
      }
    }
    return;
  }
  public static function latch_quant_tables__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    var ci: int;
    var qtblno: int;
    var compptr: JPEGDecoder$jpeg_component_info;
    var qtbl: JPEGDecoder$JQUANT_TBL;
    for (ci = 0; ci < cinfo.comps_in_scan; ci++) {
      compptr = cinfo.cur_comp_info[ci];
      if (compptr.quant_table !== null)
        continue;
      qtblno = compptr.quant_tbl_no;
      if (qtblno < 0 || qtblno >= 4 || cinfo.quant_tbl_ptrs[qtblno] === null)
        error__();
      qtbl = new JPEGDecoder$JQUANT_TBL();
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(cinfo.quant_tbl_ptrs[qtblno].quantval, 0, qtbl.quantval, 0, qtbl.quantval.length);
      qtbl.sent_table = cinfo.quant_tbl_ptrs[qtblno].sent_table;
      compptr.quant_table = qtbl;
    }
    return;
  }
  public static function jpeg_make_d_derived_tbl__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2ZILorg_eclipse_swt_internal_image_JPEGDecoder$d_1derived_1tbl_2(cinfo: JPEGDecoder$jpeg_decompress_struct, isDC: Boolean, tblno: int, dtbl: JPEGDecoder$d_derived_tbl): void {
    var htbl: JPEGDecoder$JHUFF_TBL;
    var p: int;
    var i: int = 0;
    var l: int;
    var si: int;
    var numsymbols: int;
    var lookbits: int;
    var ctr: int;
    var huffsize: JavaArray = new JavaArray("[B").lengths(257);
    var huffcode: JavaArray = new JavaArray("[I").lengths(257);
    var code: int;
    if (tblno < 0 || tblno >= 4)
      error__();
    htbl = isDC ? cinfo.dc_huff_tbl_ptrs[tblno] : cinfo.ac_huff_tbl_ptrs[tblno];
    if (htbl === null)
      error__();
    dtbl.pub = htbl;
    p = 0;
    for (l = 1; l <= 16; l++) {
      i = htbl.bits[l] & 0xFF;
      if (i < 0 || p + i > 256)
        error__();
      while (i-- != 0)
        huffsize[p++] = int(l);
    }
    huffsize[p] = 0;
    numsymbols = p;
    code = 0;
    si = huffsize[0];
    p = 0;
    while ((huffsize[p]) != 0) {
      while ((huffsize[p]) == si) {
        huffcode[p++] = code;
        code++;
      }
      if ((code) >= ((1) << si))
        error__();
      code <<= 1;
      si++;
    }
    p = 0;
    for (l = 1; l <= 16; l++) {
      if ((htbl.bits[l] & 0xFF) != 0) {
        dtbl.valoffset[l] = p - huffcode[p];
        p += (htbl.bits[l] & 0xFF);
        dtbl.maxcode[l] = huffcode[p - 1];
      } else {
        dtbl.maxcode[l] = -1;
      }
    }
    dtbl.maxcode[17] = 0xFFFFF;
    for (var j: int = 0; j < dtbl.look_nbits.length; j++) {
      dtbl.look_nbits[j] = 0;
    }
    p = 0;
    for (l = 1; l <= 8; l++) {
      for (i = 1; i <= (htbl.bits[l] & 0xFF); i++, p++) {
        lookbits = huffcode[p] << (8 - l);
        for (ctr = 1 << (8 - l); ctr > 0; ctr--) {
          dtbl.look_nbits[lookbits] = l;
          dtbl.look_sym[lookbits] = htbl.huffval[p];
          lookbits++;
        }
      }
    }
    if (isDC) {
      for (i = 0; i < numsymbols; i++) {
        var sym: int = htbl.huffval[i] & 0xFF;
        if (sym < 0 || sym > 15)
          error__();
      }
    }
    return;
  }
  public static function start_input_pass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    per_scan_setup__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    latch_quant_tables__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    cinfo.entropy.start_pass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    cinfo.coef.start_input_pass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    cinfo.inputctl.consume_input = 1;
    return;
  }
  public static function finish_input_pass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    cinfo.inputctl.consume_input = 0;
    return;
  }
  public static function consume_markers__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): int {
    var inputctl: JPEGDecoder$jpeg_input_controller = cinfo.inputctl;
    var val: int;
    if (inputctl.eoi_reached)
      return 2;
    val = read_markers__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    switch (val) {
      case 1 :
        if (inputctl.inheaders) {
          initial_setup__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
          inputctl.inheaders = false;
        } else {
          if (!inputctl.has_multiple_scans)
            error__();
          start_input_pass__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
        }
        break;
      case 2 :
        inputctl.eoi_reached = true;
        if (inputctl.inheaders) {
          if (cinfo.marker.saw_SOF)
            error__();
        } else {
          if (cinfo.output_scan_number > cinfo.input_scan_number)
            cinfo.output_scan_number = cinfo.input_scan_number;
        }
        break;
      case 0 :
        break;
    }
    return val;
  }
  public static function default_decompress_parms__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    switch (cinfo.num_components) {
      case 1 :
        cinfo.jpeg_color_space = 1;
        cinfo.out_color_space = 1;
        break;
      case 3 :
        if (cinfo.saw_JFIF_marker) {
          cinfo.jpeg_color_space = 3;
        } else if (cinfo.saw_Adobe_marker) {
          switch (cinfo.Adobe_transform) {
            case 0 :
              cinfo.jpeg_color_space = 2;
              break;
            case 1 :
              cinfo.jpeg_color_space = 3;
              break;
            default :
              cinfo.jpeg_color_space = 3;
              break;
          }
        } else {
          var cid0: int = cinfo.comp_info[0].component_id;
          var cid1: int = cinfo.comp_info[1].component_id;
          var cid2: int = cinfo.comp_info[2].component_id;
          if (cid0 == 1 && cid1 == 2 && cid2 == 3)
            cinfo.jpeg_color_space = 3;
          else if (cid0 == 82 && cid1 == 71 && cid2 == 66)
            cinfo.jpeg_color_space = 2;
          else {
            cinfo.jpeg_color_space = 3;
          }
        }
        cinfo.out_color_space = 2;
        break;
      case 4 :
        if (cinfo.saw_Adobe_marker) {
          switch (cinfo.Adobe_transform) {
            case 0 :
              cinfo.jpeg_color_space = 4;
              break;
            case 2 :
              cinfo.jpeg_color_space = 5;
              break;
            default :
              cinfo.jpeg_color_space = 5;
              break;
          }
        } else {
          cinfo.jpeg_color_space = 4;
        }
        cinfo.out_color_space = 4;
        break;
      default :
        cinfo.jpeg_color_space = 0;
        cinfo.out_color_space = 0;
        break;
    }
    cinfo.scale_num = 1;
    cinfo.scale_denom = 1;
    cinfo.output_gamma = 1.0;
    cinfo.buffered_image = false;
    cinfo.raw_data_out = false;
    cinfo.dct_method = 0;
    cinfo.do_fancy_upsampling = true;
    cinfo.do_block_smoothing = true;
    cinfo.quantize_colors = false;
    cinfo.dither_mode = 2;
    cinfo.two_pass_quantize = true;
    cinfo.desired_number_of_colors = 256;
    cinfo.colormap = null;
    cinfo.enable_1pass_quant = false;
    cinfo.enable_external_quant = false;
    cinfo.enable_2pass_quant = false;
    return;
  }
  public static function init_source__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    cinfo.buffer = new JavaArray("[B").lengths(4096);
    cinfo.bytes_in_buffer = 0;
    cinfo.bytes_offset = 0;
    cinfo.start_of_file = true;
    return;
  }
  public static function jpeg_consume_input__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): int {
    var retcode: int = 0;
    switch (cinfo.global_state) {
      case 200 :
        reset_input_controller__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
        init_source__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
        cinfo.global_state = 201;
      case 201 :
        retcode = consume_input__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
        if (retcode == 1) {
          default_decompress_parms__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
          cinfo.global_state = 202;
        }
        break;
      case 202 :
        retcode = 1;
        break;
      case 203 :
      case 204 :
      case 205 :
      case 206 :
      case 207 :
      case 208 :
      case 210 :
        retcode = consume_input__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
        break;
      default :
        error__();
    }
    return retcode;
  }
  public static function jpeg_abort__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo: JPEGDecoder$jpeg_decompress_struct): void {
    if (cinfo.is_decompressor) {
      cinfo.global_state = 200;
    } else {
      cinfo.global_state = 100;
    }
    return;
  }
  public static function isFileFormat__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(stream: LEDataInputStream): Boolean {
    try {
      var buffer: JavaArray = new JavaArray("[B").lengths(2);
      stream.read___3B(buffer);
      stream.unread___3B(buffer);
      return (buffer[0] & 0xFF) == 0xFF && (buffer[1] & 0xFF) == 216;
    } catch (e : Exception) {
      return false;
    }
    return false;
  }
  public static function loadFromByteStream__Ljava_io_InputStream_2Lorg_eclipse_swt_graphics_ImageLoader_2(inputStream: InputStream, loader: ImageLoader): JavaArray {
    var cinfo: JPEGDecoder$jpeg_decompress_struct = new JPEGDecoder$jpeg_decompress_struct();
    cinfo.inputStream = inputStream;
    jpeg_create_decompress__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    jpeg_read_header__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2Z(cinfo, true);
    cinfo.buffered_image = cinfo.progressive_mode && loader.hasListeners__();
    jpeg_start_decompress__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    var palette: PaletteData = null;
    switch (cinfo.out_color_space) {
      case 2 :
        palette = new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData__III, [0xFF, 0xFF00, 0xFF0000]));
        break;
      case 1 :
        var colors: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/RGB;").lengths(256);
        for (var i: int = 0; i < colors.length; i++) {
          colors[i] = new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [i, i, i]));
        }
        palette = new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData___3Lorg_eclipse_swt_graphics_RGB_2, [colors]));
        break;
      default :
        error__();
    }
    var scanlinePad: int = 4;
    var row_stride: int = int(((int((cinfo.output_width * cinfo.out_color_components * 8 + 7) / 8)) + (scanlinePad - 1)) / scanlinePad) * scanlinePad;
    var buffer: JavaArray = new JavaArray("[[B").lengths(1, row_stride);
    var data: JavaArray = new JavaArray("[B").lengths(row_stride * cinfo.output_height);
    var imageData: ImageData = ImageData.internal_new__IIILorg_eclipse_swt_graphics_PaletteData_2I_3BI_3B_3BIIIIIII(cinfo.output_width, cinfo.output_height, palette.isDirect ? 24 : 8, palette, scanlinePad, data, 0, null, null, -1, -1, 4, 0, 0, 0, 0);
    if (cinfo.buffered_image) {
      var done: Boolean;
      do {
        var incrementCount: int = cinfo.input_scan_number - 1;
        jpeg_start_output__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2I(cinfo, cinfo.input_scan_number);
        while (cinfo.output_scanline < cinfo.output_height) {
          var offset: int = row_stride * cinfo.output_scanline;
          jpeg_read_scanlines__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3BI(cinfo, buffer, 1);
          System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(buffer[0], 0, data, offset, row_stride);
        }
        jpeg_finish_output__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
        loader.notifyListeners__Lorg_eclipse_swt_graphics_ImageLoaderEvent_2(new ImageLoaderEvent(loader, ImageData(imageData.clone__()), incrementCount, done = jpeg_input_complete__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo)));
      } while (!done);
    } else {
      while (cinfo.output_scanline < cinfo.output_height) {
        var offset_1: int = row_stride * cinfo.output_scanline;
        jpeg_read_scanlines__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2_3_3BI(cinfo, buffer, 1);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(buffer[0], 0, data, offset_1, row_stride);
      }
    }
    jpeg_finish_decompress__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    jpeg_destroy_decompress__Lorg_eclipse_swt_internal_image_JPEGDecoder$jpeg_1decompress_1struct_2(cinfo);
    return new JavaArray("[Lorg/eclipse/swt/graphics/ImageData;").values(imageData);
  }
}
}
