package org.eclipse.swt.internal.image {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import java.io.*;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.ImageData;
import java.lang.System;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.PaletteData;
import java.lang.Exception;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import java.io.IOException;
import org.eclipse.swt.graphics.ImageLoader;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class JPEGFileFormat extends FileFormat {
  internal var restartInterval: int;
  internal var frameHeader: JPEGFrameHeader;
  internal var imageWidth: int;
  internal var imageHeight: int;
  internal var interleavedMcuCols: int;
  internal var interleavedMcuRows: int;
  internal var maxV: int;
  internal var maxH: int;
  internal var progressive: Boolean;
  internal var samplePrecision: int;
  internal var nComponents: int;
  internal var frameComponents: JavaArray;
  internal var componentIds: JavaArray;
  internal var imageComponents: JavaArray;
  internal var dataUnit: JavaArray;
  internal var dataUnits: JavaArray;
  internal var precedingDCs: JavaArray;
  internal var scanHeader: JPEGScanHeader;
  internal var dataBuffer: JavaArray;
  internal var currentBitCount: int;
  internal var bufferCurrentPosition: int;
  internal var restartsToGo: int;
  internal var nextRestartNumber: int;
  internal var acHuffmanTables: JavaArray;
  internal var dcHuffmanTables: JavaArray;
  internal var quantizationTables: JavaArray;
  internal var currentByte: int;
  internal var encoderQFactor: int = 75;
  internal var eobrun: int = 0;
  public static const DCTSIZE: int = 8;
  public static const DCTSIZESQR: int = 64;
  public static const FIX_0_899976223: int = 7373;
  public static const FIX_1_961570560: int = 16069;
  public static const FIX_2_053119869: int = 16819;
  public static const FIX_0_298631336: int = 2446;
  public static const FIX_1_847759065: int = 15137;
  public static const FIX_1_175875602: int = 9633;
  public static const FIX_3_072711026: int = 25172;
  public static const FIX_0_765366865: int = 6270;
  public static const FIX_2_562915447: int = 20995;
  public static const FIX_0_541196100: int = 4433;
  public static const FIX_0_390180644: int = 3196;
  public static const FIX_1_501321110: int = 12299;
  public static const APP0: int = 0xFFE0;
  public static const APP15: int = 0xFFEF;
  public static const COM: int = 0xFFFE;
  public static const DAC: int = 0xFFCC;
  public static const DHP: int = 0xFFDE;
  public static const DHT: int = 0xFFC4;
  public static const DNL: int = 0xFFDC;
  public static const DRI: int = 0xFFDD;
  public static const DQT: int = 0xFFDB;
  public static const EOI: int = 0xFFD9;
  public static const EXP: int = 0xFFDF;
  public static const JPG: int = 0xFFC8;
  public static const JPG0: int = 0xFFF0;
  public static const JPG13: int = 0xFFFD;
  public static const RST0: int = 0xFFD0;
  public static const RST1: int = 0xFFD1;
  public static const RST2: int = 0xFFD2;
  public static const RST3: int = 0xFFD3;
  public static const RST4: int = 0xFFD4;
  public static const RST5: int = 0xFFD5;
  public static const RST6: int = 0xFFD6;
  public static const RST7: int = 0xFFD7;
  public static const SOF0: int = 0xFFC0;
  public static const SOF1: int = 0xFFC1;
  public static const SOF2: int = 0xFFC2;
  public static const SOF3: int = 0xFFC3;
  public static const SOF5: int = 0xFFC5;
  public static const SOF6: int = 0xFFC6;
  public static const SOF7: int = 0xFFC7;
  public static const SOF9: int = 0xFFC9;
  public static const SOF10: int = 0xFFCA;
  public static const SOF11: int = 0xFFCB;
  public static const SOF13: int = 0xFFCD;
  public static const SOF14: int = 0xFFCE;
  public static const SOF15: int = 0xFFCF;
  public static const SOI: int = 0xFFD8;
  public static const SOS: int = 0xFFDA;
  public static const TEM: int = 0xFF01;
  public static const TQI: int = 0;
  public static const HI: int = 1;
  public static const VI: int = 2;
  public static const CW: int = 3;
  public static const CH: int = 4;
  public static const DC: int = 0;
  public static const AC: int = 1;
  public static const ID_Y: int = 1 - 1;
  public static const ID_CB: int = 2 - 1;
  public static const ID_CR: int = 3 - 1;
  public static var RGB16: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/RGB;").values(new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [0, 0, 0])), new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [0x80, 0, 0])), new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [0, 0x80, 0])), new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [0x80, 0x80, 0])), new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [0, 0, 0x80])), new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [0x80, 0, 0x80])), new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [0, 0x80, 0x80])), new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [0xC0, 0xC0, 0xC0])), new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [0x80, 0x80, 0x80])), new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [0xFF, 0, 0])), new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [0, 0xFF, 0])), new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [0xFF, 0xFF, 0])), new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [0, 0, 0xFF])), new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [0xFF, 0, 0xFF])), new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [0, 0xFF, 0xFF])), new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [0xFF, 0xFF, 0xFF])));
  public static var ExtendTest: JavaArray = new JavaArray("[I").values(0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144);
  public static var ExtendOffset: JavaArray = new JavaArray("[I").values(0, -1, -3, -7, -15, -31, -63, -127, -255, -511, -1023, -2047, -4095, -8191, -16383, -32767, -65535, -131071, -262143);
  public static var ZigZag8x8: JavaArray = new JavaArray("[I").values(0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63);
  public static var CrRTable: JavaArray;
  public static var CbBTable: JavaArray;
  public static var CrGTable: JavaArray;
  public static var CbGTable: JavaArray;
  public static var RYTable: JavaArray;
  public static var GYTable: JavaArray;
  public static var BYTable: JavaArray;
  public static var RCbTable: JavaArray;
  public static var GCbTable: JavaArray;
  public static var BCbTable: JavaArray;
  public static var RCrTable: JavaArray;
  public static var GCrTable: JavaArray;
  public static var BCrTable: JavaArray;
  public static var NBitsTable: JavaArray;

  __clinit();

  static private function __clinit(): void {
    {
      var rYTable: JavaArray = new JavaArray("[I").lengths(256);
      var gYTable: JavaArray = new JavaArray("[I").lengths(256);
      var bYTable: JavaArray = new JavaArray("[I").lengths(256);
      var rCbTable: JavaArray = new JavaArray("[I").lengths(256);
      var gCbTable: JavaArray = new JavaArray("[I").lengths(256);
      var bCbTable: JavaArray = new JavaArray("[I").lengths(256);
      var gCrTable: JavaArray = new JavaArray("[I").lengths(256);
      var bCrTable: JavaArray = new JavaArray("[I").lengths(256);
      for (var i: int = 0; i < 256; i++) {
        rYTable[i] = i * 19595;
        gYTable[i] = i * 38470;
        bYTable[i] = i * 7471 + 32768;
        rCbTable[i] = i * -11059;
        gCbTable[i] = i * -21709;
        bCbTable[i] = i * 32768 + 8388608;
        gCrTable[i] = i * -27439;
        bCrTable[i] = i * -5329;
      }
      RYTable = rYTable;
      GYTable = gYTable;
      BYTable = bYTable;
      RCbTable = rCbTable;
      GCbTable = gCbTable;
      BCbTable = bCbTable;
      RCrTable = bCbTable;
      GCrTable = gCrTable;
      BCrTable = bCrTable;
      var crRTable: JavaArray = new JavaArray("[I").lengths(256);
      var cbBTable: JavaArray = new JavaArray("[I").lengths(256);
      var crGTable: JavaArray = new JavaArray("[I").lengths(256);
      var cbGTable: JavaArray = new JavaArray("[I").lengths(256);
      for (var i_1: int = 0; i_1 < 256; i_1++) {
        var x2: int = 2 * i_1 - 255;
        crRTable[i_1] = (45941 * x2 + 32768) >> 16;
        cbBTable[i_1] = (58065 * x2 + 32768) >> 16;
        crGTable[i_1] = -23401 * x2;
        cbGTable[i_1] = -11277 * x2 + 32768;
      }
      CrRTable = crRTable;
      CbBTable = cbBTable;
      CrGTable = crGTable;
      CbGTable = cbGTable;
      var nBits: int = 1;
      var power2: int = 2;
      var nBitsTable: JavaArray = new JavaArray("[I").lengths(2048);
      nBitsTable[0] = 0;
      for (var i_2: int = 1; i_2 < nBitsTable.length; i_2++) {
        if (!(i_2 < power2)) {
          nBits++;
          power2 *= 2;
        }
        nBitsTable[i_2] = nBits;
      }
      NBitsTable = nBitsTable;
    }
  }
  public function compress__Lorg_eclipse_swt_graphics_ImageData_2_3B_3B_3B(image: ImageData, dataYComp: JavaArray, dataCbComp: JavaArray, dataCrComp: JavaArray): void {
    var srcWidth: int = image.width;
    var srcHeight: int = image.height;
    var vhFactor: int = maxV * maxH;
    var frameComponent: JavaArray;
    imageComponents = new JavaArray("[[B").lengths(nComponents);
    for (var i: int = 0; i < nComponents; i++) {
      frameComponent = frameComponents[componentIds[i]];
      imageComponents[i] = new JavaArray("[B").lengths(frameComponent[3] * frameComponent[4]);
    }
    frameComponent = frameComponents[componentIds[0]];
    for (var yPos: int = 0; yPos < srcHeight; yPos++) {
      var srcOfs: int = yPos * srcWidth;
      var dstOfs: int = yPos * frameComponent[3];
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(dataYComp, srcOfs, imageComponents[0], dstOfs, srcWidth);
    }
    frameComponent = frameComponents[componentIds[1]];
    for (var yPos_1: int = 0; yPos_1 < int(srcHeight / maxV); yPos_1++) {
      var destRowIndex: int = yPos_1 * frameComponent[3];
      for (var xPos: int = 0; xPos < int(srcWidth / maxH); xPos++) {
        var sum: int = 0;
        for (var iv: int = 0; iv < maxV; iv++) {
          var srcIndex: int = (yPos_1 * maxV + iv) * srcWidth + (xPos * maxH);
          for (var ih: int = 0; ih < maxH; ih++) {
            sum += dataCbComp[srcIndex + ih] & 0xFF;
          }
        }
        imageComponents[1][destRowIndex + xPos] = int((int(sum / vhFactor)));
      }
    }
    frameComponent = frameComponents[componentIds[2]];
    for (var yPos_2: int = 0; yPos_2 < int(srcHeight / maxV); yPos_2++) {
      var destRowIndex_1: int = yPos_2 * frameComponent[3];
      for (var xPos_1: int = 0; xPos_1 < int(srcWidth / maxH); xPos_1++) {
        var sum_1: int = 0;
        for (var iv_1: int = 0; iv_1 < maxV; iv_1++) {
          var srcIndex_1: int = (yPos_2 * maxV + iv_1) * srcWidth + (xPos_1 * maxH);
          for (var ih_1: int = 0; ih_1 < maxH; ih_1++) {
            sum_1 += dataCrComp[srcIndex_1 + ih_1] & 0xFF;
          }
        }
        imageComponents[2][destRowIndex_1 + xPos_1] = int((int(sum_1 / vhFactor)));
      }
    }
    for (var iComp: int = 0; iComp < nComponents; iComp++) {
      var imageComponent: JavaArray = imageComponents[iComp];
      frameComponent = frameComponents[componentIds[iComp]];
      var hFactor: int = frameComponent[1];
      var vFactor: int = frameComponent[2];
      var componentWidth: int = frameComponent[3];
      var componentHeight: int = frameComponent[4];
      var compressedWidth: int = int(srcWidth / (int(maxH / hFactor)));
      var compressedHeight: int = int(srcHeight / (int(maxV / vFactor)));
      if (compressedWidth < componentWidth) {
        var delta: int = componentWidth - compressedWidth;
        for (var yPos_3: int = 0; yPos_3 < compressedHeight; yPos_3++) {
          var dstOfs_1: int = ((yPos_3 + 1) * componentWidth - delta);
          var dataValue: int = imageComponent[(dstOfs_1 > 0) ? dstOfs_1 - 1 : 0] & 0xFF;
          for (var i_1: int = 0; i_1 < delta; i_1++) {
            imageComponent[dstOfs_1 + i_1] = int(dataValue);
          }
        }
      }
      if (compressedHeight < componentHeight) {
        var srcOfs_1: int = (compressedHeight > 0) ? (compressedHeight - 1) * componentWidth : 1;
        for (var yPos_4: int = (compressedHeight > 0) ? compressedHeight : 1; yPos_4 <= componentHeight; yPos_4++) {
          var dstOfs_2: int = (yPos_4 - 1) * componentWidth;
          System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(imageComponent, srcOfs_1, imageComponent, dstOfs_2, componentWidth);
        }
      }
    }
    return;
  }
  public function convert4BitRGBToYCbCr__Lorg_eclipse_swt_graphics_ImageData_2(image: ImageData): void {
    var rgbs: JavaArray = image.getRGBs__();
    var paletteSize: int = rgbs.length;
    var yComp: JavaArray = new JavaArray("[B").lengths(paletteSize);
    var cbComp: JavaArray = new JavaArray("[B").lengths(paletteSize);
    var crComp: JavaArray = new JavaArray("[B").lengths(paletteSize);
    var srcWidth: int = image.width;
    var srcHeight: int = image.height;
    for (var i: int = 0; i < paletteSize; i++) {
      var color: RGB = rgbs[i];
      var r: int = color.red;
      var g: int = color.green;
      var b: int = color.blue;
      var n: int = RYTable[r] + GYTable[g] + BYTable[b];
      yComp[i] = int((n >> 16));
      if ((n < 0) && ((n & 0xFFFF) != 0))
        yComp[i]--;
      n = RCbTable[r] + GCbTable[g] + BCbTable[b];
      cbComp[i] = int((n >> 16));
      if ((n < 0) && ((n & 0xFFFF) != 0))
        cbComp[i]--;
      n = RCrTable[r] + GCrTable[g] + BCrTable[b];
      crComp[i] = int((n >> 16));
      if ((n < 0) && ((n & 0xFFFF) != 0))
        crComp[i]--;
    }
    var bSize: int = srcWidth * srcHeight;
    var dataYComp: JavaArray = new JavaArray("[B").lengths(bSize);
    var dataCbComp: JavaArray = new JavaArray("[B").lengths(bSize);
    var dataCrComp: JavaArray = new JavaArray("[B").lengths(bSize);
    var origData: JavaArray = image.data;
    var bytesPerLine: int = image.bytesPerLine;
    var maxScanlineByte: int = srcWidth >> 1;
    for (var yPos: int = 0; yPos < srcHeight; yPos++) {
      for (var xPos: int = 0; xPos < maxScanlineByte; xPos++) {
        var srcIndex: int = yPos * bytesPerLine + xPos;
        var dstIndex: int = yPos * srcWidth + (xPos * 2);
        var value2: int = origData[srcIndex] & 0xFF;
        var value1: int = value2 >> 4;
        value2 &= 0x0F;
        dataYComp[dstIndex] = yComp[value1];
        dataCbComp[dstIndex] = cbComp[value1];
        dataCrComp[dstIndex] = crComp[value1];
        dataYComp[dstIndex + 1] = yComp[value2];
        dataCbComp[dstIndex + 1] = cbComp[value2];
        dataCrComp[dstIndex + 1] = crComp[value2];
      }
    }
    this.compress__Lorg_eclipse_swt_graphics_ImageData_2_3B_3B_3B(image, dataYComp, dataCbComp, dataCrComp);
    return;
  }
  public function convert8BitRGBToYCbCr__Lorg_eclipse_swt_graphics_ImageData_2(image: ImageData): void {
    var rgbs: JavaArray = image.getRGBs__();
    var paletteSize: int = rgbs.length;
    var yComp: JavaArray = new JavaArray("[B").lengths(paletteSize);
    var cbComp: JavaArray = new JavaArray("[B").lengths(paletteSize);
    var crComp: JavaArray = new JavaArray("[B").lengths(paletteSize);
    var srcWidth: int = image.width;
    var srcHeight: int = image.height;
    for (var i: int = 0; i < paletteSize; i++) {
      var color: RGB = rgbs[i];
      var r: int = color.red;
      var g: int = color.green;
      var b: int = color.blue;
      var n: int = RYTable[r] + GYTable[g] + BYTable[b];
      yComp[i] = int((n >> 16));
      if ((n < 0) && ((n & 0xFFFF) != 0))
        yComp[i]--;
      n = RCbTable[r] + GCbTable[g] + BCbTable[b];
      cbComp[i] = int((n >> 16));
      if ((n < 0) && ((n & 0xFFFF) != 0))
        cbComp[i]--;
      n = RCrTable[r] + GCrTable[g] + BCrTable[b];
      crComp[i] = int((n >> 16));
      if ((n < 0) && ((n & 0xFFFF) != 0))
        crComp[i]--;
    }
    var dstWidth: int = image.width;
    var dstHeight: int = srcHeight;
    var stride: int = ((srcWidth + 3) >> 2) << 2;
    var bSize: int = dstWidth * dstHeight;
    var dataYComp: JavaArray = new JavaArray("[B").lengths(bSize);
    var dataCbComp: JavaArray = new JavaArray("[B").lengths(bSize);
    var dataCrComp: JavaArray = new JavaArray("[B").lengths(bSize);
    var origData: JavaArray = image.data;
    for (var yPos: int = 0; yPos < srcHeight; yPos++) {
      var srcRowIndex: int = yPos * stride;
      var dstRowIndex: int = yPos * dstWidth;
      for (var xPos: int = 0; xPos < srcWidth; xPos++) {
        var value: int = origData[srcRowIndex + xPos] & 0xFF;
        var dstIndex: int = dstRowIndex + xPos;
        dataYComp[dstIndex] = yComp[value];
        dataCbComp[dstIndex] = cbComp[value];
        dataCrComp[dstIndex] = crComp[value];
      }
    }
    this.compress__Lorg_eclipse_swt_graphics_ImageData_2_3B_3B_3B(image, dataYComp, dataCbComp, dataCrComp);
    return;
  }
  public function convertCMYKToRGB__(): JavaArray {
    return new JavaArray("[B").lengths(0);
  }
  public function convertImageToYCbCr__Lorg_eclipse_swt_graphics_ImageData_2(image: ImageData): void {
    switch (image.depth) {
      case 4 :
        this.convert4BitRGBToYCbCr__Lorg_eclipse_swt_graphics_ImageData_2(image);
        return;
      case 8 :
        this.convert8BitRGBToYCbCr__Lorg_eclipse_swt_graphics_ImageData_2(image);
        return;
      case 16 :
      case 24 :
      case 32 :
        this.convertMultiRGBToYCbCr__Lorg_eclipse_swt_graphics_ImageData_2(image);
        return;
      default :
        SWT.error__I(38);
    }
    return;
  }
  public function convertMultiRGBToYCbCr__Lorg_eclipse_swt_graphics_ImageData_2(image: ImageData): void {
    var srcWidth: int = image.width;
    var srcHeight: int = image.height;
    var bSize: int = srcWidth * srcHeight;
    var dataYComp: JavaArray = new JavaArray("[B").lengths(bSize);
    var dataCbComp: JavaArray = new JavaArray("[B").lengths(bSize);
    var dataCrComp: JavaArray = new JavaArray("[B").lengths(bSize);
    var palette: PaletteData = image.palette;
    var buffer: JavaArray = new JavaArray("[I").lengths(srcWidth);
    if (palette.isDirect) {
      var redMask: int = palette.redMask;
      var greenMask: int = palette.greenMask;
      var blueMask: int = palette.blueMask;
      var redShift: int = palette.redShift;
      var greenShift: int = palette.greenShift;
      var blueShift: int = palette.blueShift;
      for (var yPos: int = 0; yPos < srcHeight; yPos++) {
        image.getPixels__III_3II(0, yPos, srcWidth, buffer, 0);
        var dstRowIndex: int = yPos * srcWidth;
        for (var xPos: int = 0; xPos < srcWidth; xPos++) {
          var pixel: int = buffer[xPos];
          var dstDataIndex: int = dstRowIndex + xPos;
          var r: int = pixel & redMask;
          r = (redShift < 0) ? r >>> -redShift : r << redShift;
          var g: int = pixel & greenMask;
          g = (greenShift < 0) ? g >>> -greenShift : g << greenShift;
          var b: int = pixel & blueMask;
          b = (blueShift < 0) ? b >>> -blueShift : b << blueShift;
          dataYComp[dstDataIndex] = int(((RYTable[r] + GYTable[g] + BYTable[b]) >> 16));
          dataCbComp[dstDataIndex] = int(((RCbTable[r] + GCbTable[g] + BCbTable[b]) >> 16));
          dataCrComp[dstDataIndex] = int(((RCrTable[r] + GCrTable[g] + BCrTable[b]) >> 16));
        }
      }
    } else {
      for (var yPos_1: int = 0; yPos_1 < srcHeight; yPos_1++) {
        image.getPixels__III_3II(0, yPos_1, srcWidth, buffer, 0);
        var dstRowIndex_1: int = yPos_1 * srcWidth;
        for (var xPos_1: int = 0; xPos_1 < srcWidth; xPos_1++) {
          var pixel_1: int = buffer[xPos_1];
          var dstDataIndex_1: int = dstRowIndex_1 + xPos_1;
          var rgb: RGB = palette.getRGB__I(pixel_1);
          var r_1: int = rgb.red;
          var g_1: int = rgb.green;
          var b_1: int = rgb.blue;
          dataYComp[dstDataIndex_1] = int(((RYTable[r_1] + GYTable[g_1] + BYTable[b_1]) >> 16));
          dataCbComp[dstDataIndex_1] = int(((RCbTable[r_1] + GCbTable[g_1] + BCbTable[b_1]) >> 16));
          dataCrComp[dstDataIndex_1] = int(((RCrTable[r_1] + GCrTable[g_1] + BCrTable[b_1]) >> 16));
        }
      }
    }
    this.compress__Lorg_eclipse_swt_graphics_ImageData_2_3B_3B_3B(image, dataYComp, dataCbComp, dataCrComp);
    return;
  }
  public function convertYToRGB__(): JavaArray {
    var compWidth: int = frameComponents[componentIds[0]][3];
    var bytesPerLine: int = int(((int((imageWidth * 8 + 7) / 8)) + 3) / 4) * 4;
    var data: JavaArray = new JavaArray("[B").lengths(bytesPerLine * imageHeight);
    var yComp: JavaArray = imageComponents[0];
    var destIndex: int = 0;
    for (var i: int = 0; i < imageHeight; i++) {
      var srcIndex: int = i * compWidth;
      for (var j: int = 0; j < bytesPerLine; j++) {
        var y: int = yComp[srcIndex] & 0xFF;
        if (y < 0) {
          y = 0;
        } else {
          if (y > 255)
            y = 255;
        }
        if (j >= imageWidth) {
          y = 0;
        }
        data[destIndex] = int(y);
        srcIndex++;
        destIndex++;
      }
    }
    return data;
  }
  public function convertYCbCrToRGB__(): JavaArray {
    var bSize: int = imageWidth * imageHeight * nComponents;
    var rgbData: JavaArray = new JavaArray("[B").lengths(bSize);
    var destIndex: int = 0;
    this.expandImageComponents__();
    var yComp: JavaArray = imageComponents[0];
    var cbComp: JavaArray = imageComponents[1];
    var crComp: JavaArray = imageComponents[2];
    var compWidth: int = frameComponents[componentIds[0]][3];
    for (var v: int = 0; v < imageHeight; v++) {
      var srcIndex: int = v * compWidth;
      for (var i: int = 0; i < imageWidth; i++) {
        var y: int = yComp[srcIndex] & 0xFF;
        var cb: int = cbComp[srcIndex] & 0xFF;
        var cr: int = crComp[srcIndex] & 0xFF;
        var r: int = y + CrRTable[cr];
        var g: int = y + ((CbGTable[cb] + CrGTable[cr]) >> 16);
        var b: int = y + CbBTable[cb];
        if (r < 0) {
          r = 0;
        } else {
          if (r > 255)
            r = 255;
        }
        if (g < 0) {
          g = 0;
        } else {
          if (g > 255)
            g = 255;
        }
        if (b < 0) {
          b = 0;
        } else {
          if (b > 255)
            b = 255;
        }
        rgbData[destIndex] = int(b);
        rgbData[destIndex + 1] = int(g);
        rgbData[destIndex + 2] = int(r);
        destIndex += 3;
        srcIndex++;
      }
    }
    return rgbData;
  }
  public function decodeACCoefficients___3II(dataUnit_1: JavaArray, iComp: int): void {
    var sParams: JavaArray = scanHeader.componentParameters[componentIds[iComp]];
    var acTable: JPEGHuffmanTable = acHuffmanTables[sParams[1]];
    var k: int = 1;
    while (k < 64) {
      var rs: int = this.decodeUsingTable__Lorg_eclipse_swt_internal_image_JPEGHuffmanTable_2(acTable);
      var r: int = rs >> 4;
      var s: int = rs & 0xF;
      if (s == 0) {
        if (r == 15) {
          k += 16;
        } else {
          break;
        }
      } else {
        k += r;
        var bits: int = this.receive__I(s);
        dataUnit_1[ZigZag8x8[k]] = this.extendBy__II(bits, s);
        k++;
      }
    }
    return;
  }
  public function decodeACFirstCoefficients___3IIIII(dataUnit_1: JavaArray, iComp: int, start: int, end: int, approxBit: int): void {
    if (eobrun > 0) {
      eobrun--;
      return;
    }
    var sParams: JavaArray = scanHeader.componentParameters[componentIds[iComp]];
    var acTable: JPEGHuffmanTable = acHuffmanTables[sParams[1]];
    var k: int = start;
    while (k <= end) {
      var rs: int = this.decodeUsingTable__Lorg_eclipse_swt_internal_image_JPEGHuffmanTable_2(acTable);
      var r: int = rs >> 4;
      var s: int = rs & 0xF;
      if (s == 0) {
        if (r == 15) {
          k += 16;
        } else {
          eobrun = (1 << r) + this.receive__I(r) - 1;
          break;
        }
      } else {
        k += r;
        var bits: int = this.receive__I(s);
        dataUnit_1[ZigZag8x8[k]] = this.extendBy__II(bits, s) << approxBit;
        k++;
      }
    }
    return;
  }
  public function decodeACRefineCoefficients___3IIIII(dataUnit_1: JavaArray, iComp: int, start: int, end: int, approxBit: int): void {
    var sParams: JavaArray = scanHeader.componentParameters[componentIds[iComp]];
    var acTable: JPEGHuffmanTable = acHuffmanTables[sParams[1]];
    var k: int = start;
    while (k <= end) {
      if (eobrun > 0) {
        while (k <= end) {
          var zzIndex: int = ZigZag8x8[k];
          if (dataUnit_1[zzIndex] != 0) {
            dataUnit_1[zzIndex] = this.refineAC__II(dataUnit_1[zzIndex], approxBit);
          }
          k++;
        }
        eobrun--;
      } else {
        var rs: int = this.decodeUsingTable__Lorg_eclipse_swt_internal_image_JPEGHuffmanTable_2(acTable);
        var r: int = rs >> 4;
        var s: int = rs & 0xF;
        if (s == 0) {
          if (r == 15) {
            var zeros: int = 0;
            while (zeros < 16 && k <= end) {
              var zzIndex_1: int = ZigZag8x8[k];
              if (dataUnit_1[zzIndex_1] != 0) {
                dataUnit_1[zzIndex_1] = this.refineAC__II(dataUnit_1[zzIndex_1], approxBit);
              } else {
                zeros++;
              }
              k++;
            }
          } else {
            eobrun = (1 << r) + this.receive__I(r);
          }
        } else {
          var bit: int = this.receive__I(s);
          var zeros_1: int = 0;
          var zzIndex_2: int = ZigZag8x8[k];
          while ((zeros_1 < r || dataUnit_1[zzIndex_2] != 0) && k <= end) {
            if (dataUnit_1[zzIndex_2] != 0) {
              dataUnit_1[zzIndex_2] = this.refineAC__II(dataUnit_1[zzIndex_2], approxBit);
            } else {
              zeros_1++;
            }
            k++;
            zzIndex_2 = ZigZag8x8[k];
          }
          if (bit != 0) {
            dataUnit_1[zzIndex_2] = 1 << approxBit;
          } else {
            dataUnit_1[zzIndex_2] = -1 << approxBit;
          }
          k++;
        }
      }
    }
    return;
  }
  public function refineAC__II(ac: int, approxBit: int): int {
    if (ac > 0) {
      var bit: int = this.nextBit__();
      if (bit != 0) {
        ac += 1 << approxBit;
      }
    } else if (ac < 0) {
      var bit_1: int = this.nextBit__();
      if (bit_1 != 0) {
        ac += -1 << approxBit;
      }
    }
    return ac;
  }
  public function decodeDCCoefficient___3IIZI(dataUnit_1: JavaArray, iComp: int, first: Boolean, approxBit: int): void {
    var sParams: JavaArray = scanHeader.componentParameters[componentIds[iComp]];
    var dcTable: JPEGHuffmanTable = dcHuffmanTables[sParams[0]];
    var lastDC: int = 0;
    if (progressive && !first) {
      var bit: int = this.nextBit__();
      lastDC = dataUnit_1[0] + (bit << approxBit);
    } else {
      lastDC = precedingDCs[iComp];
      var nBits: int = this.decodeUsingTable__Lorg_eclipse_swt_internal_image_JPEGHuffmanTable_2(dcTable);
      if (nBits != 0) {
        var bits: int = this.receive__I(nBits);
        var diff: int = this.extendBy__II(bits, nBits);
        lastDC += diff;
        precedingDCs[iComp] = lastDC;
      }
      if (progressive) {
        lastDC = lastDC << approxBit;
      }
    }
    dataUnit_1[0] = lastDC;
    return;
  }
  public function dequantize___3II(dataUnit_1: JavaArray, iComp: int): void {
    var qTable: JavaArray = quantizationTables[frameComponents[componentIds[iComp]][0]];
    for (var i: int = 0; i < dataUnit_1.length; i++) {
      var zzIndex: int = ZigZag8x8[i];
      dataUnit_1[zzIndex] = dataUnit_1[zzIndex] * qTable[i];
    }
    return;
  }
  public function decodeImageComponents__(): JavaArray {
    if (nComponents == 3) {
      return this.convertYCbCrToRGB__();
    }
    if (nComponents == 4) {
      return this.convertCMYKToRGB__();
    }
    return this.convertYToRGB__();
  }
  public function decodeMCUAtXAndY__IIIZIII(xmcu: int, ymcu: int, nComponentsInScan: int, first: Boolean, start: int, end: int, approxBit: int): void {
    for (var iComp: int = 0; iComp < nComponentsInScan; iComp++) {
      var scanComponent: int = iComp;
      while (scanHeader.componentParameters[componentIds[scanComponent]] === null) {
        scanComponent++;
      }
      var frameComponent: JavaArray = frameComponents[componentIds[scanComponent]];
      var hi: int = frameComponent[1];
      var vi: int = frameComponent[2];
      if (nComponentsInScan == 1) {
        hi = 1;
        vi = 1;
      }
      var compWidth: int = frameComponent[3];
      for (var ivi: int = 0; ivi < vi; ivi++) {
        for (var ihi: int = 0; ihi < hi; ihi++) {
          if (progressive) {
            var index: int = (ymcu * vi + ivi) * compWidth + xmcu * hi + ihi;
            dataUnit = dataUnits[scanComponent][index];
            if (dataUnit === null) {
              dataUnit = new JavaArray("[I").lengths(64);
              dataUnits[scanComponent][index] = dataUnit;
            }
          } else {
            for (var i: int = 0; i < dataUnit.length; i++) {
              dataUnit[i] = 0;
            }
          }
          if (!progressive || scanHeader.isDCProgressiveScan__()) {
            this.decodeDCCoefficient___3IIZI(dataUnit, scanComponent, first, approxBit);
          }
          if (!progressive) {
            this.decodeACCoefficients___3II(dataUnit, scanComponent);
          } else {
            if (scanHeader.isACProgressiveScan__()) {
              if (first) {
                this.decodeACFirstCoefficients___3IIIII(dataUnit, scanComponent, start, end, approxBit);
              } else {
                this.decodeACRefineCoefficients___3IIIII(dataUnit, scanComponent, start, end, approxBit);
              }
            }
            if (loader.hasListeners__()) {
              var temp: JavaArray = dataUnit;
              dataUnit = new JavaArray("[I").lengths(64);
              System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(temp, 0, dataUnit, 0, 64);
            }
          }
          if (!progressive || (progressive && loader.hasListeners__())) {
            this.dequantize___3II(dataUnit, scanComponent);
            this.inverseDCT___3I(dataUnit);
            this.storeData___3IIIIIIII(dataUnit, scanComponent, xmcu, ymcu, hi, ihi, vi, ivi);
          }
        }
      }
    }
    return;
  }
  public function decodeScan__(): void {
    if (progressive && !scanHeader.verifyProgressiveScan__()) {
      SWT.error__I(40);
    }
    var nComponentsInScan: int = scanHeader.getNumberOfImageComponents__();
    var mcuRowsInScan: int = interleavedMcuRows;
    var mcusPerRow: int = interleavedMcuCols;
    if (nComponentsInScan == 1) {
      var scanComponent: int = 0;
      while (scanHeader.componentParameters[componentIds[scanComponent]] === null) {
        scanComponent++;
      }
      var frameComponent: JavaArray = frameComponents[componentIds[scanComponent]];
      var hi: int = frameComponent[1];
      var vi: int = frameComponent[2];
      var mcuWidth: int = int(8 * maxH / hi);
      var mcuHeight: int = int(8 * maxV / vi);
      mcusPerRow = int((imageWidth + mcuWidth - 1) / mcuWidth);
      mcuRowsInScan = int((imageHeight + mcuHeight - 1) / mcuHeight);
    }
    var first: Boolean = scanHeader.isFirstScan__();
    var start: int = scanHeader.getStartOfSpectralSelection__();
    var end: int = scanHeader.getEndOfSpectralSelection__();
    var approxBit: int = scanHeader.getApproxBitPositionLow__();
    restartsToGo = restartInterval;
    nextRestartNumber = 0;
    for (var ymcu: int = 0; ymcu < mcuRowsInScan; ymcu++) {
      for (var xmcu: int = 0; xmcu < mcusPerRow; xmcu++) {
        if (restartInterval != 0) {
          if (restartsToGo == 0)
            this.processRestartInterval__();
          restartsToGo--;
        }
        this.decodeMCUAtXAndY__IIIZIII(xmcu, ymcu, nComponentsInScan, first, start, end, approxBit);
      }
    }
    return;
  }
  public function decodeUsingTable__Lorg_eclipse_swt_internal_image_JPEGHuffmanTable_2(huffmanTable: JPEGHuffmanTable): int {
    var i: int = 0;
    var maxCodes: JavaArray = huffmanTable.getDhMaxCodes__();
    var minCodes: JavaArray = huffmanTable.getDhMinCodes__();
    var valPtrs: JavaArray = huffmanTable.getDhValPtrs__();
    var huffVals: JavaArray = huffmanTable.getDhValues__();
    var code: int = this.nextBit__();
    while (code > maxCodes[i]) {
      code = code * 2 + this.nextBit__();
      i++;
    }
    var j: int = valPtrs[i] + code - minCodes[i];
    return huffVals[j];
  }
  public function emit__II(huffCode: int, nBits: int): void {
    if (nBits == 0) {
      SWT.error__I(40);
    }
    var power2m1: JavaArray = new JavaArray("[I").values(1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, 32767, 65535, 131125);
    var code: int = (huffCode & power2m1[nBits - 1]) << (24 - nBits - currentBitCount);
    var codeBuffer: JavaArray = new JavaArray("[B").lengths(4);
    codeBuffer[0] = int((code & 0xFF));
    codeBuffer[1] = int(((code >> 8) & 0xFF));
    codeBuffer[2] = int(((code >> 16) & 0xFF));
    codeBuffer[3] = int(((code >> 24) & 0xFF));
    var abs: int = nBits - (8 - currentBitCount);
    if (abs < 0)
      abs = -abs;
    if ((abs >> 3) > 0) {
      currentByte += codeBuffer[2];
      this.emitByte__B(int(currentByte));
      this.emitByte__B(codeBuffer[1]);
      currentByte = codeBuffer[0];
      currentBitCount += nBits - 16;
    } else {
      currentBitCount += nBits;
      if (currentBitCount >= 8) {
        currentByte += codeBuffer[2];
        this.emitByte__B(int(currentByte));
        currentByte = codeBuffer[1];
        currentBitCount -= 8;
      } else {
        currentByte += codeBuffer[2];
      }
    }
    return;
  }
  public function emitByte__B(byteValue: int): void {
    if (bufferCurrentPosition >= 512) {
      this.resetOutputBuffer__();
    }
    dataBuffer[bufferCurrentPosition] = byteValue;
    bufferCurrentPosition++;
    if (byteValue == -1) {
      this.emitByte__B(int(0));
    }
    return;
  }
  public function encodeACCoefficients___3II(dataUnit_1: JavaArray, iComp: int): void {
    var sParams: JavaArray = scanHeader.componentParameters[iComp];
    var acTable: JPEGHuffmanTable = acHuffmanTables[sParams[1]];
    var ehCodes: JavaArray = acTable.ehCodes;
    var ehSizes: JavaArray = acTable.ehCodeLengths;
    var r: int = 0;
    var k: int = 1;
    while (k < 64) {
      k++;
      var acValue: int = dataUnit_1[ZigZag8x8[k - 1]];
      if (acValue == 0) {
        if (k == 64) {
          this.emit__II(ehCodes[0], ehSizes[0] & 0xFF);
        } else {
          r++;
        }
      } else {
        while (r > 15) {
          this.emit__II(ehCodes[0xF0], ehSizes[0xF0] & 0xFF);
          r -= 16;
        }
        if (acValue < 0) {
          var absACValue: int = acValue;
          if (absACValue < 0)
            absACValue = -absACValue;
          var nBits: int = NBitsTable[absACValue];
          var rs: int = r * 16 + nBits;
          this.emit__II(ehCodes[rs], ehSizes[rs] & 0xFF);
          this.emit__II(0xFFFFFF - absACValue, nBits);
        } else {
          var nBits_1: int = NBitsTable[acValue];
          var rs_1: int = r * 16 + nBits_1;
          this.emit__II(ehCodes[rs_1], ehSizes[rs_1] & 0xFF);
          this.emit__II(acValue, nBits_1);
        }
        r = 0;
      }
    }
    return;
  }
  public function encodeDCCoefficients___3II(dataUnit_1: JavaArray, iComp: int): void {
    var sParams: JavaArray = scanHeader.componentParameters[iComp];
    var dcTable: JPEGHuffmanTable = dcHuffmanTables[sParams[0]];
    var lastDC: int = precedingDCs[iComp];
    var dcValue: int = dataUnit_1[0];
    var diff: int = dcValue - lastDC;
    precedingDCs[iComp] = dcValue;
    if (diff < 0) {
      var absDiff: int = 0 - diff;
      var nBits: int = NBitsTable[absDiff];
      this.emit__II(dcTable.ehCodes[nBits], dcTable.ehCodeLengths[nBits]);
      this.emit__II(0xFFFFFF - absDiff, nBits);
    } else {
      var nBits_1: int = NBitsTable[diff];
      this.emit__II(dcTable.ehCodes[nBits_1], dcTable.ehCodeLengths[nBits_1]);
      if (nBits_1 != 0) {
        this.emit__II(diff, nBits_1);
      }
    }
    return;
  }
  public function encodeMCUAtXAndY__II(xmcu: int, ymcu: int): void {
    var nComponentsInScan: int = scanHeader.getNumberOfImageComponents__();
    dataUnit = new JavaArray("[I").lengths(64);
    for (var iComp: int = 0; iComp < nComponentsInScan; iComp++) {
      var frameComponent: JavaArray = frameComponents[componentIds[iComp]];
      var hi: int = frameComponent[1];
      var vi: int = frameComponent[2];
      for (var ivi: int = 0; ivi < vi; ivi++) {
        for (var ihi: int = 0; ihi < hi; ihi++) {
          this.extractData___3IIIIII(dataUnit, iComp, xmcu, ymcu, ihi, ivi);
          this.forwardDCT___3I(dataUnit);
          this.quantizeData___3II(dataUnit, iComp);
          this.encodeDCCoefficients___3II(dataUnit, iComp);
          this.encodeACCoefficients___3II(dataUnit, iComp);
        }
      }
    }
    return;
  }
  public function encodeScan__(): void {
    for (var ymcu: int = 0; ymcu < interleavedMcuRows; ymcu++) {
      for (var xmcu: int = 0; xmcu < interleavedMcuCols; xmcu++) {
        this.encodeMCUAtXAndY__II(xmcu, ymcu);
      }
    }
    if (currentBitCount != 0) {
      this.emitByte__B(int(currentByte));
    }
    this.resetOutputBuffer__();
    return;
  }
  public function expandImageComponents__(): void {
    for (var iComp: int = 0; iComp < nComponents; iComp++) {
      var frameComponent: JavaArray = frameComponents[componentIds[iComp]];
      var hi: int = frameComponent[1];
      var vi: int = frameComponent[2];
      var upH: int = int(maxH / hi);
      var upV: int = int(maxV / vi);
      if ((upH * upV) > 1) {
        var component: JavaArray = imageComponents[iComp];
        var compWidth: int = frameComponent[3];
        var compHeight: int = frameComponent[4];
        var upCompWidth: int = compWidth * upH;
        var upCompHeight: int = compHeight * upV;
        var src: ImageData = new ImageData(new Arguments(org.eclipse.swt.graphics.ImageData.ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2I_3B, [compWidth, compHeight, 8, new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData___3Lorg_eclipse_swt_graphics_RGB_2, [RGB16])), 4, component]));
        var dest: ImageData = src.scaledTo__II(upCompWidth, upCompHeight);
        imageComponents[iComp] = dest.data;
      }
    }
    return;
  }
  public function extendBy__II(diff: int, t: int): int {
    if (diff < ExtendTest[t]) {
      return diff + ExtendOffset[t];
    } else {
      return diff;
    }
    return 0;
  }
  public function extractData___3IIIIII(dataUnit_1: JavaArray, iComp: int, xmcu: int, ymcu: int, ihi: int, ivi: int): void {
    var compImage: JavaArray = imageComponents[iComp];
    var frameComponent: JavaArray = frameComponents[componentIds[iComp]];
    var hi: int = frameComponent[1];
    var vi: int = frameComponent[2];
    var compWidth: int = frameComponent[3];
    var srcIndex: int = ((ymcu * vi + ivi) * compWidth * 8) + ((xmcu * hi + ihi) * 8);
    var destIndex: int = 0;
    for (var i: int = 0; i < 8; i++) {
      for (var col: int = 0; col < 8; col++) {
        dataUnit_1[destIndex] = (compImage[srcIndex + col] & 0xFF) - 128;
        destIndex++;
      }
      srcIndex += compWidth;
    }
    return;
  }
  public function forwardDCT___3I(dataUnit_1: JavaArray): void {
    for (var row: int = 0; row < 8; row++) {
      var rIndex: int = row * 8;
      var tmp0: int = dataUnit_1[rIndex] + dataUnit_1[rIndex + 7];
      var tmp7: int = dataUnit_1[rIndex] - dataUnit_1[rIndex + 7];
      var tmp1: int = dataUnit_1[rIndex + 1] + dataUnit_1[rIndex + 6];
      var tmp6: int = dataUnit_1[rIndex + 1] - dataUnit_1[rIndex + 6];
      var tmp2: int = dataUnit_1[rIndex + 2] + dataUnit_1[rIndex + 5];
      var tmp5: int = dataUnit_1[rIndex + 2] - dataUnit_1[rIndex + 5];
      var tmp3: int = dataUnit_1[rIndex + 3] + dataUnit_1[rIndex + 4];
      var tmp4: int = dataUnit_1[rIndex + 3] - dataUnit_1[rIndex + 4];
      var tmp10: int = tmp0 + tmp3;
      var tmp13: int = tmp0 - tmp3;
      var tmp11: int = tmp1 + tmp2;
      var tmp12: int = tmp1 - tmp2;
      dataUnit_1[rIndex] = (tmp10 + tmp11) * 4;
      dataUnit_1[rIndex + 4] = (tmp10 - tmp11) * 4;
      var z1: int = (tmp12 + tmp13) * 4433;
      var n: int = z1 + (tmp13 * 6270) + 1024;
      dataUnit_1[rIndex + 2] = n >> 11;
      if ((n < 0) && ((n & 0x07FF) != 0))
        dataUnit_1[rIndex + 2]--;
      n = z1 + (tmp12 * (0 - 15137)) + 1024;
      dataUnit_1[rIndex + 6] = n >> 11;
      if ((n < 0) && ((n & 0x07FF) != 0))
        dataUnit_1[rIndex + 6]--;
      z1 = tmp4 + tmp7;
      var z2: int = tmp5 + tmp6;
      var z3: int = tmp4 + tmp6;
      var z4: int = tmp5 + tmp7;
      var z5: int = (z3 + z4) * 9633;
      tmp4 *= 2446;
      tmp5 *= 16819;
      tmp6 *= 25172;
      tmp7 *= 12299;
      z1 *= 0 - 7373;
      z2 *= 0 - 20995;
      z3 *= 0 - 16069;
      z4 *= 0 - 3196;
      z3 += z5;
      z4 += z5;
      n = tmp4 + z1 + z3 + 1024;
      dataUnit_1[rIndex + 7] = n >> 11;
      if ((n < 0) && ((n & 0x07FF) != 0))
        dataUnit_1[rIndex + 7]--;
      n = tmp5 + z2 + z4 + 1024;
      dataUnit_1[rIndex + 5] = n >> 11;
      if ((n < 0) && ((n & 0x07FF) != 0))
        dataUnit_1[rIndex + 5]--;
      n = tmp6 + z2 + z3 + 1024;
      dataUnit_1[rIndex + 3] = n >> 11;
      if ((n < 0) && ((n & 0x07FF) != 0))
        dataUnit_1[rIndex + 3]--;
      n = tmp7 + z1 + z4 + 1024;
      dataUnit_1[rIndex + 1] = n >> 11;
      if ((n < 0) && ((n & 0x07FF) != 0))
        dataUnit_1[rIndex + 1]--;
    }
    for (var col: int = 0; col < 8; col++) {
      var c0: int = col;
      var c1: int = col + 8;
      var c2: int = col + 16;
      var c3: int = col + 24;
      var c4: int = col + 32;
      var c5: int = col + 40;
      var c6: int = col + 48;
      var c7: int = col + 56;
      var tmp0_1: int = dataUnit_1[c0] + dataUnit_1[c7];
      var tmp7_1: int = dataUnit_1[c0] - dataUnit_1[c7];
      var tmp1_1: int = dataUnit_1[c1] + dataUnit_1[c6];
      var tmp6_1: int = dataUnit_1[c1] - dataUnit_1[c6];
      var tmp2_1: int = dataUnit_1[c2] + dataUnit_1[c5];
      var tmp5_1: int = dataUnit_1[c2] - dataUnit_1[c5];
      var tmp3_1: int = dataUnit_1[c3] + dataUnit_1[c4];
      var tmp4_1: int = dataUnit_1[c3] - dataUnit_1[c4];
      var tmp10_1: int = tmp0_1 + tmp3_1;
      var tmp13_1: int = tmp0_1 - tmp3_1;
      var tmp11_1: int = tmp1_1 + tmp2_1;
      var tmp12_1: int = tmp1_1 - tmp2_1;
      var n_1: int = tmp10_1 + tmp11_1 + 16;
      dataUnit_1[c0] = n_1 >> 5;
      if ((n_1 < 0) && ((n_1 & 0x1F) != 0))
        dataUnit_1[c0]--;
      n_1 = tmp10_1 - tmp11_1 + 16;
      dataUnit_1[c4] = n_1 >> 5;
      if ((n_1 < 0) && ((n_1 & 0x1F) != 0))
        dataUnit_1[c4]--;
      var z1_1: int = (tmp12_1 + tmp13_1) * 4433;
      n_1 = z1_1 + (tmp13_1 * 6270) + 131072;
      dataUnit_1[c2] = n_1 >> 18;
      if ((n_1 < 0) && ((n_1 & 0x3FFFF) != 0))
        dataUnit_1[c2]--;
      n_1 = z1_1 + (tmp12_1 * (0 - 15137)) + 131072;
      dataUnit_1[c6] = n_1 >> 18;
      if ((n_1 < 0) && ((n_1 & 0x3FFFF) != 0))
        dataUnit_1[c6]--;
      z1_1 = tmp4_1 + tmp7_1;
      var z2_1: int = tmp5_1 + tmp6_1;
      var z3_1: int = tmp4_1 + tmp6_1;
      var z4_1: int = tmp5_1 + tmp7_1;
      var z5_1: int = (z3_1 + z4_1) * 9633;
      tmp4_1 *= 2446;
      tmp5_1 *= 16819;
      tmp6_1 *= 25172;
      tmp7_1 *= 12299;
      z1_1 *= 0 - 7373;
      z2_1 *= 0 - 20995;
      z3_1 *= 0 - 16069;
      z4_1 *= 0 - 3196;
      z3_1 += z5_1;
      z4_1 += z5_1;
      n_1 = tmp4_1 + z1_1 + z3_1 + 131072;
      dataUnit_1[c7] = n_1 >> 18;
      if ((n_1 < 0) && ((n_1 & 0x3FFFF) != 0))
        dataUnit_1[c7]--;
      n_1 = tmp5_1 + z2_1 + z4_1 + 131072;
      dataUnit_1[c5] = n_1 >> 18;
      if ((n_1 < 0) && ((n_1 & 0x3FFFF) != 0))
        dataUnit_1[c5]--;
      n_1 = tmp6_1 + z2_1 + z3_1 + 131072;
      dataUnit_1[c3] = n_1 >> 18;
      if ((n_1 < 0) && ((n_1 & 0x3FFFF) != 0))
        dataUnit_1[c3]--;
      n_1 = tmp7_1 + z1_1 + z4_1 + 131072;
      dataUnit_1[c1] = n_1 >> 18;
      if ((n_1 < 0) && ((n_1 & 0x3FFFF) != 0))
        dataUnit_1[c1]--;
    }
    return;
  }
  public function getAPP0__(): void {
    var appn: JPEGAppn = new JPEGAppn(new Arguments(org.eclipse.swt.internal.image.JPEGAppn.JPEGAppn__Lorg_eclipse_swt_internal_image_LEDataInputStream_2, [inputStream]));
    if (!appn.verify__()) {
      SWT.error__I(40);
    }
    return;
  }
  public function getCOM__(): void {
    new JPEGComment(new Arguments(org.eclipse.swt.internal.image.JPEGComment.JPEGComment__Lorg_eclipse_swt_internal_image_LEDataInputStream_2, [inputStream]));
    return;
  }
  public function getDAC__(): void {
    new JPEGArithmeticConditioningTable(inputStream);
    return;
  }
  public function getDHT__(): void {
    var dht: JPEGHuffmanTable = new JPEGHuffmanTable(new Arguments(org.eclipse.swt.internal.image.JPEGHuffmanTable.JPEGHuffmanTable__Lorg_eclipse_swt_internal_image_LEDataInputStream_2, [inputStream]));
    if (!dht.verify__()) {
      SWT.error__I(40);
    }
    if (acHuffmanTables === null) {
      acHuffmanTables = new JavaArray("[Lorg/eclipse/swt/internal/image/JPEGHuffmanTable;").lengths(4);
    }
    if (dcHuffmanTables === null) {
      dcHuffmanTables = new JavaArray("[Lorg/eclipse/swt/internal/image/JPEGHuffmanTable;").lengths(4);
    }
    var dhtTables: JavaArray = dht.getAllTables__();
    for (var i: int = 0; i < dhtTables.length; i++) {
      var dhtTable: JPEGHuffmanTable = dhtTables[i];
      if (dhtTable.getTableClass__() == 0) {
        dcHuffmanTables[dhtTable.getTableIdentifier__()] = dhtTable;
      } else {
        acHuffmanTables[dhtTable.getTableIdentifier__()] = dhtTable;
      }
    }
    return;
  }
  public function getDNL__(): void {
    new JPEGRestartInterval(inputStream);
    return;
  }
  public function getDQT__(): void {
    var dqt: JPEGQuantizationTable = new JPEGQuantizationTable(new Arguments(org.eclipse.swt.internal.image.JPEGQuantizationTable.JPEGQuantizationTable__Lorg_eclipse_swt_internal_image_LEDataInputStream_2, [inputStream]));
    var currentTables: JavaArray = quantizationTables;
    if (currentTables === null) {
      currentTables = new JavaArray("[[I").lengths(4);
    }
    var dqtTablesKeys: JavaArray = dqt.getQuantizationTablesKeys__();
    var dqtTablesValues: JavaArray = dqt.getQuantizationTablesValues__();
    for (var i: int = 0; i < dqtTablesKeys.length; i++) {
      var index: int = dqtTablesKeys[i];
      currentTables[index] = dqtTablesValues[i];
    }
    quantizationTables = currentTables;
    return;
  }
  public function getDRI__(): void {
    var dri: JPEGRestartInterval = new JPEGRestartInterval(inputStream);
    if (!dri.verify__()) {
      SWT.error__I(40);
    }
    restartInterval = dri.getRestartInterval__();
    return;
  }
  public function inverseDCT___3I(dataUnit_1: JavaArray): void {
    for (var row: int = 0; row < 8; row++) {
      var rIndex: int = row * 8;
      if (this.isZeroInRow___3II(dataUnit_1, rIndex)) {
        var dcVal: int = dataUnit_1[rIndex] << 2;
        for (var i: int = rIndex + 7; i >= rIndex; i--) {
          dataUnit_1[i] = dcVal;
        }
      } else {
        var z2: int = dataUnit_1[rIndex + 2];
        var z3: int = dataUnit_1[rIndex + 6];
        var z1: int = (z2 + z3) * 4433;
        var tmp2: int = z1 + (z3 * (0 - 15137));
        var tmp3: int = z1 + (z2 * 6270);
        var tmp0: int = (dataUnit_1[rIndex] + dataUnit_1[rIndex + 4]) << 13;
        var tmp1: int = (dataUnit_1[rIndex] - dataUnit_1[rIndex + 4]) << 13;
        var tmp10: int = tmp0 + tmp3;
        var tmp13: int = tmp0 - tmp3;
        var tmp11: int = tmp1 + tmp2;
        var tmp12: int = tmp1 - tmp2;
        tmp0 = dataUnit_1[rIndex + 7];
        tmp1 = dataUnit_1[rIndex + 5];
        tmp2 = dataUnit_1[rIndex + 3];
        tmp3 = dataUnit_1[rIndex + 1];
        z1 = tmp0 + tmp3;
        z2 = tmp1 + tmp2;
        z3 = tmp0 + tmp2;
        var z4: int = tmp1 + tmp3;
        var z5: int = (z3 + z4) * 9633;
        tmp0 *= 2446;
        tmp1 *= 16819;
        tmp2 *= 25172;
        tmp3 *= 12299;
        z1 *= 0 - 7373;
        z2 *= 0 - 20995;
        z3 *= 0 - 16069;
        z4 *= 0 - 3196;
        z3 += z5;
        z4 += z5;
        tmp0 += z1 + z3;
        tmp1 += z2 + z4;
        tmp2 += z2 + z3;
        tmp3 += z1 + z4;
        dataUnit_1[rIndex] = (tmp10 + tmp3 + 1024) >> 11;
        dataUnit_1[rIndex + 7] = (tmp10 - tmp3 + 1024) >> 11;
        dataUnit_1[rIndex + 1] = (tmp11 + tmp2 + 1024) >> 11;
        dataUnit_1[rIndex + 6] = (tmp11 - tmp2 + 1024) >> 11;
        dataUnit_1[rIndex + 2] = (tmp12 + tmp1 + 1024) >> 11;
        dataUnit_1[rIndex + 5] = (tmp12 - tmp1 + 1024) >> 11;
        dataUnit_1[rIndex + 3] = (tmp13 + tmp0 + 1024) >> 11;
        dataUnit_1[rIndex + 4] = (tmp13 - tmp0 + 1024) >> 11;
      }
    }
    for (var col: int = 0; col < 8; col++) {
      var c0: int = col;
      var c1: int = col + 8;
      var c2: int = col + 16;
      var c3: int = col + 24;
      var c4: int = col + 32;
      var c5: int = col + 40;
      var c6: int = col + 48;
      var c7: int = col + 56;
      if (this.isZeroInColumn___3II(dataUnit_1, col)) {
        var dcVal_1: int = (dataUnit_1[c0] + 16) >> 5;
        dataUnit_1[c0] = dcVal_1;
        dataUnit_1[c1] = dcVal_1;
        dataUnit_1[c2] = dcVal_1;
        dataUnit_1[c3] = dcVal_1;
        dataUnit_1[c4] = dcVal_1;
        dataUnit_1[c5] = dcVal_1;
        dataUnit_1[c6] = dcVal_1;
        dataUnit_1[c7] = dcVal_1;
      } else {
        var z0: int = dataUnit_1[c0];
        var z2_1: int = dataUnit_1[c2];
        var z3_1: int = dataUnit_1[c6];
        var z4_1: int = dataUnit_1[c4];
        var z1_1: int = (z2_1 + z3_1) * 4433;
        var tmp2_1: int = z1_1 + (z3_1 * (0 - 15137));
        var tmp3_1: int = z1_1 + (z2_1 * 6270);
        var tmp0_1: int = (z0 + z4_1) << 13;
        var tmp1_1: int = (z0 - z4_1) << 13;
        var tmp10_1: int = tmp0_1 + tmp3_1;
        var tmp13_1: int = tmp0_1 - tmp3_1;
        var tmp11_1: int = tmp1_1 + tmp2_1;
        var tmp12_1: int = tmp1_1 - tmp2_1;
        tmp0_1 = dataUnit_1[c7];
        tmp1_1 = dataUnit_1[c5];
        tmp2_1 = dataUnit_1[c3];
        tmp3_1 = dataUnit_1[c1];
        z1_1 = tmp0_1 + tmp3_1;
        z2_1 = tmp1_1 + tmp2_1;
        z3_1 = tmp0_1 + tmp2_1;
        z4_1 = tmp1_1 + tmp3_1;
        z0 = (z3_1 + z4_1) * 9633;
        tmp0_1 *= 2446;
        tmp1_1 *= 16819;
        tmp2_1 *= 25172;
        tmp3_1 *= 12299;
        z1_1 *= 0 - 7373;
        z2_1 *= 0 - 20995;
        z3_1 *= 0 - 16069;
        z4_1 *= 0 - 3196;
        z3_1 += z0;
        z4_1 += z0;
        tmp0_1 += z1_1 + z3_1;
        tmp1_1 += z2_1 + z4_1;
        tmp2_1 += z2_1 + z3_1;
        tmp3_1 += z1_1 + z4_1;
        dataUnit_1[c0] = (tmp10_1 + tmp3_1 + 131072) >> 18;
        dataUnit_1[c7] = (tmp10_1 - tmp3_1 + 131072) >> 18;
        dataUnit_1[c1] = (tmp11_1 + tmp2_1 + 131072) >> 18;
        dataUnit_1[c6] = (tmp11_1 - tmp2_1 + 131072) >> 18;
        dataUnit_1[c2] = (tmp12_1 + tmp1_1 + 131072) >> 18;
        dataUnit_1[c5] = (tmp12_1 - tmp1_1 + 131072) >> 18;
        dataUnit_1[c3] = (tmp13_1 + tmp0_1 + 131072) >> 18;
        dataUnit_1[c4] = (tmp13_1 - tmp0_1 + 131072) >> 18;
      }
    }
    return;
  }
  public override function isFileFormat__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(stream: LEDataInputStream): Boolean {
    try {
      var soi: JPEGStartOfImage = new JPEGStartOfImage(new Arguments(org.eclipse.swt.internal.image.JPEGStartOfImage.JPEGStartOfImage__Lorg_eclipse_swt_internal_image_LEDataInputStream_2, [stream]));
      stream.unread___3B(soi.reference);
      return soi.verify__();
    } catch (e : Exception) {
      return false;
    }
    return false;
  }
  public function isZeroInColumn___3II(dataUnit_1: JavaArray, col: int): Boolean {
    return dataUnit_1[col + 8] == 0 && dataUnit_1[col + 16] == 0 && dataUnit_1[col + 24] == 0 && dataUnit_1[col + 32] == 0 && dataUnit_1[col + 40] == 0 && dataUnit_1[col + 48] == 0 && dataUnit_1[col + 56] == 0;
  }
  public function isZeroInRow___3II(dataUnit_1: JavaArray, rIndex: int): Boolean {
    return dataUnit_1[rIndex + 1] == 0 && dataUnit_1[rIndex + 2] == 0 && dataUnit_1[rIndex + 3] == 0 && dataUnit_1[rIndex + 4] == 0 && dataUnit_1[rIndex + 5] == 0 && dataUnit_1[rIndex + 6] == 0 && dataUnit_1[rIndex + 7] == 0;
  }
  public override function loadFromByteStream__(): JavaArray {
    if (System.getProperty__Ljava_lang_String_2("org.eclipse.swt.internal.image.JPEGFileFormat_3.2") === null) {
      return JPEGDecoder.loadFromByteStream__Ljava_io_InputStream_2Lorg_eclipse_swt_graphics_ImageLoader_2(inputStream, loader);
    }
    var soi: JPEGStartOfImage = new JPEGStartOfImage(new Arguments(org.eclipse.swt.internal.image.JPEGStartOfImage.JPEGStartOfImage__Lorg_eclipse_swt_internal_image_LEDataInputStream_2, [inputStream]));
    if (!soi.verify__())
      SWT.error__I(40);
    restartInterval = 0;
    this.processTables__();
    frameHeader = new JPEGFrameHeader(new Arguments(org.eclipse.swt.internal.image.JPEGFrameHeader.JPEGFrameHeader__Lorg_eclipse_swt_internal_image_LEDataInputStream_2, [inputStream]));
    if (!frameHeader.verify__())
      SWT.error__I(40);
    imageWidth = frameHeader.getSamplesPerLine__();
    imageHeight = frameHeader.getNumberOfLines__();
    maxH = frameHeader.getMaxHFactor__();
    maxV = frameHeader.getMaxVFactor__();
    var mcuWidth: int = maxH * 8;
    var mcuHeight: int = maxV * 8;
    interleavedMcuCols = int((imageWidth + mcuWidth - 1) / mcuWidth);
    interleavedMcuRows = int((imageHeight + mcuHeight - 1) / mcuHeight);
    progressive = frameHeader.isProgressive__();
    samplePrecision = frameHeader.getSamplePrecision__();
    nComponents = frameHeader.getNumberOfImageComponents__();
    frameComponents = frameHeader.componentParameters;
    componentIds = frameHeader.componentIdentifiers;
    imageComponents = new JavaArray("[[B").lengths(nComponents);
    if (progressive) {
      dataUnits = new JavaArray("[[[I").lengths(nComponents);
    } else {
      dataUnit = new JavaArray("[I").lengths(8 * 8);
    }
    for (var i: int = 0; i < nComponents; i++) {
      var frameComponent: JavaArray = frameComponents[componentIds[i]];
      var bufferSize: int = frameComponent[3] * frameComponent[4];
      imageComponents[i] = new JavaArray("[B").lengths(bufferSize);
      if (progressive) {
        dataUnits[i] = new JavaArray("[[I").lengths(bufferSize);
      }
    }
    this.processTables__();
    scanHeader = new JPEGScanHeader(new Arguments(org.eclipse.swt.internal.image.JPEGScanHeader.JPEGScanHeader__Lorg_eclipse_swt_internal_image_LEDataInputStream_2, [inputStream]));
    if (!scanHeader.verify__())
      SWT.error__I(40);
    var progressiveScanCount: int = 0;
    var done: Boolean = false;
    while (!done) {
      this.resetInputBuffer__();
      precedingDCs = new JavaArray("[I").lengths(4);
      this.decodeScan__();
      if (progressive && loader.hasListeners__()) {
        var imageData: ImageData = this.createImageData__();
        loader.notifyListeners__Lorg_eclipse_swt_graphics_ImageLoaderEvent_2(new ImageLoaderEvent(loader, imageData, progressiveScanCount, false));
        progressiveScanCount++;
      }
      var delta: int = 512 - bufferCurrentPosition - 1;
      if (delta > 0) {
        var unreadBuffer: JavaArray = new JavaArray("[B").lengths(delta);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(dataBuffer, bufferCurrentPosition + 1, unreadBuffer, 0, delta);
        try {
          inputStream.unread___3B(unreadBuffer);
        } catch (e : IOException) {
          SWT.error__ILjava_lang_Throwable_2(39, e);
        }
      }
      var jpegSegment: JPEGSegment = this.processTables__();
      if (jpegSegment === null || jpegSegment.getSegmentMarker__() == 65497) {
        done = true;
      } else {
        scanHeader = new JPEGScanHeader(new Arguments(org.eclipse.swt.internal.image.JPEGScanHeader.JPEGScanHeader__Lorg_eclipse_swt_internal_image_LEDataInputStream_2, [inputStream]));
        if (!scanHeader.verify__())
          SWT.error__I(40);
      }
    }
    if (progressive) {
      for (var ymcu: int = 0; ymcu < interleavedMcuRows; ymcu++) {
        for (var xmcu: int = 0; xmcu < interleavedMcuCols; xmcu++) {
          for (var iComp: int = 0; iComp < nComponents; iComp++) {
            var frameComponent_1: JavaArray = frameComponents[componentIds[iComp]];
            var hi: int = frameComponent_1[1];
            var vi: int = frameComponent_1[2];
            var compWidth: int = frameComponent_1[3];
            for (var ivi: int = 0; ivi < vi; ivi++) {
              for (var ihi: int = 0; ihi < hi; ihi++) {
                var index: int = (ymcu * vi + ivi) * compWidth + xmcu * hi + ihi;
                dataUnit = dataUnits[iComp][index];
                this.dequantize___3II(dataUnit, iComp);
                this.inverseDCT___3I(dataUnit);
                this.storeData___3IIIIIIII(dataUnit, iComp, xmcu, ymcu, hi, ihi, vi, ivi);
              }
            }
          }
        }
      }
      dataUnits = null;
    }
    var imageData_1: ImageData = this.createImageData__();
    if (progressive && loader.hasListeners__()) {
      loader.notifyListeners__Lorg_eclipse_swt_graphics_ImageLoaderEvent_2(new ImageLoaderEvent(loader, imageData_1, progressiveScanCount, true));
    }
    return new JavaArray("[Lorg/eclipse/swt/graphics/ImageData;").values(imageData_1);
  }
  public function createImageData__(): ImageData {
    return ImageData.internal_new__IIILorg_eclipse_swt_graphics_PaletteData_2I_3BI_3B_3BIIIIIII(imageWidth, imageHeight, nComponents * samplePrecision, this.setUpPalette__(), nComponents == 1 ? 4 : 1, this.decodeImageComponents__(), 0, null, null, -1, -1, 4, 0, 0, 0, 0);
  }
  public function nextBit__(): int {
    if (currentBitCount != 0) {
      currentBitCount--;
      currentByte *= 2;
      if (currentByte > 255) {
        currentByte -= 256;
        return 1;
      } else {
        return 0;
      }
    }
    bufferCurrentPosition++;
    if (bufferCurrentPosition >= 512) {
      this.resetInputBuffer__();
      bufferCurrentPosition = 0;
    }
    currentByte = dataBuffer[bufferCurrentPosition] & 0xFF;
    currentBitCount = 8;
    var nextByte: int;
    if (bufferCurrentPosition == 511) {
      this.resetInputBuffer__();
      currentBitCount = 8;
      nextByte = dataBuffer[0];
    } else {
      nextByte = dataBuffer[bufferCurrentPosition + 1];
    }
    if (currentByte == 0xFF) {
      if (nextByte == 0) {
        bufferCurrentPosition++;
        currentBitCount--;
        currentByte *= 2;
        if (currentByte > 255) {
          currentByte -= 256;
          return 1;
        } else {
          return 0;
        }
      } else {
        if ((nextByte & 0xFF) + 0xFF00 == 65500) {
          this.getDNL__();
          return 0;
        } else {
          SWT.error__I(40);
          return 0;
        }
      }
    } else {
      currentBitCount--;
      currentByte *= 2;
      if (currentByte > 255) {
        currentByte -= 256;
        return 1;
      } else {
        return 0;
      }
    }
    return 0;
  }
  public function processRestartInterval__(): void {
    do {
      bufferCurrentPosition++;
      if (bufferCurrentPosition > 511) {
        this.resetInputBuffer__();
        bufferCurrentPosition = 0;
      }
      currentByte = dataBuffer[bufferCurrentPosition] & 0xFF;
    } while (currentByte != 0xFF);
    while (currentByte == 0xFF) {
      bufferCurrentPosition++;
      if (bufferCurrentPosition > 511) {
        this.resetInputBuffer__();
        bufferCurrentPosition = 0;
      }
      currentByte = dataBuffer[bufferCurrentPosition] & 0xFF;
    }
    if (currentByte != ((65488 + nextRestartNumber) & 0xFF)) {
      SWT.error__I(40);
    }
    bufferCurrentPosition++;
    if (bufferCurrentPosition > 511) {
      this.resetInputBuffer__();
      bufferCurrentPosition = 0;
    }
    currentByte = dataBuffer[bufferCurrentPosition] & 0xFF;
    currentBitCount = 8;
    restartsToGo = restartInterval;
    nextRestartNumber = (nextRestartNumber + 1) & 0x7;
    precedingDCs = new JavaArray("[I").lengths(4);
    eobrun = 0;
    return;
  }
  public function processTables__(): JPEGSegment {
    while (true) {
      var jpegSegment: JPEGSegment = JPEGFileFormat.seekUnspecifiedMarker__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(inputStream);
      if (jpegSegment === null)
        return null;
      var sof: JPEGFrameHeader = new JPEGFrameHeader(new Arguments(org.eclipse.swt.internal.image.JPEGFrameHeader.JPEGFrameHeader___3B, [jpegSegment.reference]));
      if (sof.verify__()) {
        return jpegSegment;
      }
      var marker: int = jpegSegment.getSegmentMarker__();
      switch (marker) {
        case 65496 :
          SWT.error__I(40);
        case 65497 :
        case 65498 :
          return jpegSegment;
        case 65499 :
          this.getDQT__();
          break;
        case 65476 :
          this.getDHT__();
          break;
        case 65484 :
          this.getDAC__();
          break;
        case 65501 :
          this.getDRI__();
          break;
        case 65504 :
          this.getAPP0__();
          break;
        case 65534 :
          this.getCOM__();
          break;
        default :
          JPEGFileFormat.skipSegmentFrom__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(inputStream);
      }
    }
    return null;
  }
  public function quantizeData___3II(dataUnit_1: JavaArray, iComp: int): void {
    var qTable: JavaArray = quantizationTables[frameComponents[componentIds[iComp]][0]];
    for (var i: int = 0; i < dataUnit_1.length; i++) {
      var zzIndex: int = ZigZag8x8[i];
      var data: int = dataUnit_1[zzIndex];
      var absData: int = data < 0 ? 0 - data : data;
      var qValue: int = qTable[i];
      var q2: int = qValue >> 1;
      absData += q2;
      if (absData < qValue) {
        dataUnit_1[zzIndex] = 0;
      } else {
        absData /= qValue;
        if (data >= 0) {
          dataUnit_1[zzIndex] = absData;
        } else {
          dataUnit_1[zzIndex] = 0 - absData;
        }
      }
    }
    return;
  }
  public function receive__I(nBits: int): int {
    var v: int = 0;
    for (var i: int = 0; i < nBits; i++) {
      v = v * 2 + this.nextBit__();
    }
    return v;
  }
  public function resetInputBuffer__(): void {
    if (dataBuffer === null) {
      dataBuffer = new JavaArray("[B").lengths(512);
    }
    try {
      inputStream.read___3B(dataBuffer);
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    currentBitCount = 0;
    bufferCurrentPosition = -1;
    return;
  }
  public function resetOutputBuffer__(): void {
    if (dataBuffer === null) {
      dataBuffer = new JavaArray("[B").lengths(512);
    } else {
      try {
        outputStream.write___3BII(dataBuffer, 0, bufferCurrentPosition);
      } catch (e : IOException) {
        SWT.error__ILjava_lang_Throwable_2(39, e);
      }
    }
    bufferCurrentPosition = 0;
    return;
  }
  public static function seekUnspecifiedMarker__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(byteStream: LEDataInputStream): JPEGSegment {
    var byteArray: JavaArray = new JavaArray("[B").lengths(2);
    try {
      while (true) {
        if (byteStream.read___3BII(byteArray, 0, 1) != 1)
          return null;
        if (byteArray[0] == int(0xFF)) {
          if (byteStream.read___3BII(byteArray, 1, 1) != 1)
            return null;
          if (byteArray[1] != int(0xFF) && byteArray[1] != 0) {
            byteStream.unread___3B(byteArray);
            return new JPEGSegment(new Arguments(org.eclipse.swt.internal.image.JPEGSegment.JPEGSegment___3B, [byteArray]));
          }
        }
      }
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    return null;
  }
  public function setUpPalette__(): PaletteData {
    if (nComponents == 1) {
      var entries: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/RGB;").lengths(256);
      for (var i: int = 0; i < 256; i++) {
        entries[i] = new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [i, i, i]));
      }
      return new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData___3Lorg_eclipse_swt_graphics_RGB_2, [entries]));
    }
    return new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData__III, [0xFF, 0xFF00, 0xFF0000]));
  }
  public static function skipSegmentFrom__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(byteStream: LEDataInputStream): void {
    try {
      var byteArray: JavaArray = new JavaArray("[B").lengths(4);
      var jpegSegment: JPEGSegment = new JPEGSegment(new Arguments(org.eclipse.swt.internal.image.JPEGSegment.JPEGSegment___3B, [byteArray]));
      if (byteStream.read___3B(byteArray) != byteArray.length) {
        SWT.error__I(40);
      }
      if (!(byteArray[0] == -1 && byteArray[1] != 0 && byteArray[1] != -1)) {
        SWT.error__I(40);
      }
      var delta: int = jpegSegment.getSegmentLength__() - 2;
      byteStream.skip__J(delta);
    } catch (e : Exception) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    return;
  }
  public function storeData___3IIIIIIII(dataUnit_1: JavaArray, iComp: int, xmcu: int, ymcu: int, hi: int, ihi: int, vi: int, ivi: int): void {
    var compImage: JavaArray = imageComponents[iComp];
    var frameComponent: JavaArray = frameComponents[componentIds[iComp]];
    var compWidth: int = frameComponent[3];
    var destIndex: int = ((ymcu * vi + ivi) * compWidth * 8) + ((xmcu * hi + ihi) * 8);
    var srcIndex: int = 0;
    for (var i: int = 0; i < 8; i++) {
      for (var col: int = 0; col < 8; col++) {
        var x: int = dataUnit_1[srcIndex] + 128;
        if (x < 0) {
          x = 0;
        } else {
          if (x > 255)
            x = 255;
        }
        compImage[destIndex + col] = int(x);
        srcIndex++;
      }
      destIndex += compWidth;
    }
    return;
  }
  public override function unloadIntoByteStream__Lorg_eclipse_swt_graphics_ImageLoader_2(loader_1: ImageLoader): void {
    var image: ImageData = loader_1.data[0];
    if (!new JPEGStartOfImage(new Arguments(org.eclipse.swt.internal.image.JPEGStartOfImage.JPEGStartOfImage__, [])).writeToStream__Lorg_eclipse_swt_internal_image_LEDataOutputStream_2(outputStream)) {
      SWT.error__I(39);
    }
    var appn: JPEGAppn = new JPEGAppn(new Arguments(org.eclipse.swt.internal.image.JPEGAppn.JPEGAppn___3B, [new JavaArray("[B").values(int(0xFF), int(0xE0), 0, 0x10, 0x4A, 0x46, 0x49, 0x46, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0)]));
    if (!appn.writeToStream__Lorg_eclipse_swt_internal_image_LEDataOutputStream_2(outputStream)) {
      SWT.error__I(39);
    }
    quantizationTables = new JavaArray("[[I").lengths(4);
    var chromDQT: JPEGQuantizationTable = JPEGQuantizationTable.defaultChrominanceTable__();
    chromDQT.scaleBy__I(encoderQFactor);
    var jpegDQTKeys: JavaArray = chromDQT.getQuantizationTablesKeys__();
    var jpegDQTValues: JavaArray = chromDQT.getQuantizationTablesValues__();
    for (var i: int = 0; i < jpegDQTKeys.length; i++) {
      quantizationTables[jpegDQTKeys[i]] = jpegDQTValues[i];
    }
    var lumDQT: JPEGQuantizationTable = JPEGQuantizationTable.defaultLuminanceTable__();
    lumDQT.scaleBy__I(encoderQFactor);
    jpegDQTKeys = lumDQT.getQuantizationTablesKeys__();
    jpegDQTValues = lumDQT.getQuantizationTablesValues__();
    for (var i_1: int = 0; i_1 < jpegDQTKeys.length; i_1++) {
      quantizationTables[jpegDQTKeys[i_1]] = jpegDQTValues[i_1];
    }
    if (!lumDQT.writeToStream__Lorg_eclipse_swt_internal_image_LEDataOutputStream_2(outputStream)) {
      SWT.error__I(39);
    }
    if (!chromDQT.writeToStream__Lorg_eclipse_swt_internal_image_LEDataOutputStream_2(outputStream)) {
      SWT.error__I(39);
    }
    var frameLength: int;
    var scanLength: int;
    var precision: int;
    var frameParams: JavaArray;
    var scanParams: JavaArray;
    if (image.depth == 1) {
      frameLength = 11;
      frameParams = new JavaArray("[[I").lengths(1);
      frameParams[0] = new JavaArray("[I").values(1, 1, 1, 0, 0);
      scanParams = new JavaArray("[[I").lengths(1);
      scanParams[0] = new JavaArray("[I").values(0, 0);
      scanLength = 8;
      nComponents = 1;
      precision = 1;
    } else {
      frameLength = 17;
      frameParams = new JavaArray("[[I").lengths(3);
      frameParams[0] = new JavaArray("[I").values(0, 2, 2, 0, 0);
      frameParams[1] = new JavaArray("[I").values(1, 1, 1, 0, 0);
      frameParams[2] = new JavaArray("[I").values(1, 1, 1, 0, 0);
      scanParams = new JavaArray("[[I").lengths(3);
      scanParams[0] = new JavaArray("[I").values(0, 0);
      scanParams[1] = new JavaArray("[I").values(1, 1);
      scanParams[2] = new JavaArray("[I").values(1, 1);
      scanLength = 12;
      nComponents = 3;
      precision = 8;
    }
    imageWidth = image.width;
    imageHeight = image.height;
    frameHeader = new JPEGFrameHeader(new Arguments(org.eclipse.swt.internal.image.JPEGFrameHeader.JPEGFrameHeader___3B, [new JavaArray("[B").lengths(19)]));
    frameHeader.setSegmentMarker__I(65472);
    frameHeader.setSegmentLength__I(frameLength);
    frameHeader.setSamplePrecision__I(precision);
    frameHeader.setSamplesPerLine__I(imageWidth);
    frameHeader.setNumberOfLines__I(imageHeight);
    frameHeader.setNumberOfImageComponents__I(nComponents);
    frameHeader.componentParameters = frameParams;
    frameHeader.componentIdentifiers = new JavaArray("[I").values(0, 1, 2);
    frameHeader.initializeContents__();
    if (!frameHeader.writeToStream__Lorg_eclipse_swt_internal_image_LEDataOutputStream_2(outputStream)) {
      SWT.error__I(39);
    }
    frameComponents = frameParams;
    componentIds = frameHeader.componentIdentifiers;
    maxH = frameHeader.getMaxHFactor__();
    maxV = frameHeader.getMaxVFactor__();
    var mcuWidth: int = maxH * 8;
    var mcuHeight: int = maxV * 8;
    interleavedMcuCols = int((imageWidth + mcuWidth - 1) / mcuWidth);
    interleavedMcuRows = int((imageHeight + mcuHeight - 1) / mcuHeight);
    acHuffmanTables = new JavaArray("[Lorg/eclipse/swt/internal/image/JPEGHuffmanTable;").lengths(4);
    dcHuffmanTables = new JavaArray("[Lorg/eclipse/swt/internal/image/JPEGHuffmanTable;").lengths(4);
    var dhtTables: JavaArray = new JavaArray("[Lorg/eclipse/swt/internal/image/JPEGHuffmanTable;").values(JPEGHuffmanTable.getDefaultDCLuminanceTable__(), JPEGHuffmanTable.getDefaultDCChrominanceTable__(), JPEGHuffmanTable.getDefaultACLuminanceTable__(), JPEGHuffmanTable.getDefaultACChrominanceTable__());
    for (var i_2: int = 0; i_2 < dhtTables.length; i_2++) {
      var dhtTable: JPEGHuffmanTable = dhtTables[i_2];
      if (!dhtTable.writeToStream__Lorg_eclipse_swt_internal_image_LEDataOutputStream_2(outputStream)) {
        SWT.error__I(39);
      }
      var allTables: JavaArray = dhtTable.getAllTables__();
      for (var j: int = 0; j < allTables.length; j++) {
        var huffmanTable: JPEGHuffmanTable = allTables[j];
        if (huffmanTable.getTableClass__() == 0) {
          dcHuffmanTables[huffmanTable.getTableIdentifier__()] = huffmanTable;
        } else {
          acHuffmanTables[huffmanTable.getTableIdentifier__()] = huffmanTable;
        }
      }
    }
    precedingDCs = new JavaArray("[I").lengths(4);
    scanHeader = new JPEGScanHeader(new Arguments(org.eclipse.swt.internal.image.JPEGScanHeader.JPEGScanHeader___3B, [new JavaArray("[B").lengths(14)]));
    scanHeader.setSegmentMarker__I(65498);
    scanHeader.setSegmentLength__I(scanLength);
    scanHeader.setNumberOfImageComponents__I(nComponents);
    scanHeader.setStartOfSpectralSelection__I(0);
    scanHeader.setEndOfSpectralSelection__I(63);
    scanHeader.componentParameters = scanParams;
    scanHeader.initializeContents__();
    if (!scanHeader.writeToStream__Lorg_eclipse_swt_internal_image_LEDataOutputStream_2(outputStream)) {
      SWT.error__I(39);
    }
    this.convertImageToYCbCr__Lorg_eclipse_swt_graphics_ImageData_2(image);
    this.resetOutputBuffer__();
    currentByte = 0;
    currentBitCount = 0;
    this.encodeScan__();
    if (!new JPEGEndOfImage(new Arguments(org.eclipse.swt.internal.image.JPEGEndOfImage.JPEGEndOfImage__, [])).writeToStream__Lorg_eclipse_swt_internal_image_LEDataOutputStream_2(outputStream)) {
      SWT.error__I(39);
    }
    return;
  }
}
}
