package org.eclipse.swt.internal.image {
import org.eclipse.swt.*;
import java.lang.System;
import org.eclipse.swt.SWT;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class JPEGFrameHeader extends JPEGVariableSizeSegment {
  internal var maxVFactor: int;
  internal var maxHFactor: int;
  public var componentIdentifiers: JavaArray;
  public var componentParameters: JavaArray;
  public function JPEGFrameHeader___3B(reference: JavaArray): Object {
    return this;
  }
  public function JPEGFrameHeader__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(byteStream: LEDataInputStream): Object {
    this.initializeComponentParameters__();
    return this;
  }
  public function getSamplePrecision__(): int {
    return reference[4] & 0xFF;
  }
  public function getNumberOfLines__(): int {
    return (reference[5] & 0xFF) << 8 | (reference[6] & 0xFF);
  }
  public function getSamplesPerLine__(): int {
    return (reference[7] & 0xFF) << 8 | (reference[8] & 0xFF);
  }
  public function getNumberOfImageComponents__(): int {
    return reference[9] & 0xFF;
  }
  public function setSamplePrecision__I(precision: int): void {
    reference[4] = int((precision & 0xFF));
  }
  public function setNumberOfLines__I(anInteger: int): void {
    reference[5] = int(((anInteger & 0xFF00) >> 8));
    reference[6] = int((anInteger & 0xFF));
  }
  public function setSamplesPerLine__I(samples: int): void {
    reference[7] = int(((samples & 0xFF00) >> 8));
    reference[8] = int((samples & 0xFF));
  }
  public function setNumberOfImageComponents__I(anInteger: int): void {
    reference[9] = int((anInteger & 0xFF));
  }
  public function getMaxHFactor__(): int {
    return maxHFactor;
  }
  public function getMaxVFactor__(): int {
    return maxVFactor;
  }
  public function setMaxHFactor__I(anInteger: int): void {
    maxHFactor = anInteger;
  }
  public function setMaxVFactor__I(anInteger: int): void {
    maxVFactor = anInteger;
  }
  public function initializeComponentParameters__(): void {
    var nf: int = this.getNumberOfImageComponents__();
    componentIdentifiers = new JavaArray("[I").lengths(nf);
    var compSpecParams: JavaArray = new JavaArray("[[I").lengths(0);
    var hmax: int = 1;
    var vmax: int = 1;
    for (var i: int = 0; i < nf; i++) {
      var ofs: int = i * 3 + 10;
      var ci: int = reference[ofs] & 0xFF;
      componentIdentifiers[i] = ci;
      var hi: int = (reference[ofs + 1] & 0xFF) >> 4;
      var vi: int = reference[ofs + 1] & 0xF;
      var tqi: int = reference[ofs + 2] & 0xFF;
      if (hi > hmax) {
        hmax = hi;
      }
      if (vi > vmax) {
        vmax = vi;
      }
      var compParam: JavaArray = new JavaArray("[I").lengths(5);
      compParam[0] = tqi;
      compParam[1] = hi;
      compParam[2] = vi;
      if (compSpecParams.length <= ci) {
        var newParams: JavaArray = new JavaArray("[[I").lengths(ci + 1);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(compSpecParams, 0, newParams, 0, compSpecParams.length);
        compSpecParams = newParams;
      }
      compSpecParams[ci] = compParam;
    }
    var x: int = this.getSamplesPerLine__();
    var y: int = this.getNumberOfLines__();
    var multiples: JavaArray = new JavaArray("[I").values(8, 16, 24, 32);
    for (var i_1: int = 0; i_1 < nf; i_1++) {
      var compParam_1: JavaArray = compSpecParams[componentIdentifiers[i_1]];
      var hi_1: int = compParam_1[1];
      var vi_1: int = compParam_1[2];
      var compWidth: int = int((x * hi_1 + hmax - 1) / hmax);
      var compHeight: int = int((y * vi_1 + vmax - 1) / vmax);
      var dsWidth: int = this.roundUpToMultiple__II(compWidth, multiples[hi_1 - 1]);
      var dsHeight: int = this.roundUpToMultiple__II(compHeight, multiples[vi_1 - 1]);
      compParam_1[3] = dsWidth;
      compParam_1[4] = dsHeight;
    }
    this.setMaxHFactor__I(hmax);
    this.setMaxVFactor__I(vmax);
    componentParameters = compSpecParams;
    return;
  }
  public function initializeContents__(): void {
    var nf: int = this.getNumberOfImageComponents__();
    if (nf == 0 || nf != componentParameters.length) {
      SWT.error__I(40);
    }
    var hmax: int = 0;
    var vmax: int = 0;
    var compSpecParams: JavaArray = componentParameters;
    for (var i: int = 0; i < nf; i++) {
      var ofs: int = i * 3 + 10;
      var compParam: JavaArray = compSpecParams[componentIdentifiers[i]];
      var hi: int = compParam[1];
      var vi: int = compParam[2];
      if (hi * vi > 4) {
        SWT.error__I(40);
      }
      reference[ofs] = int((i + 1));
      reference[ofs + 1] = int((hi * 16 + vi));
      reference[ofs + 2] = int((compParam[0]));
      if (hi > hmax)
        hmax = hi;
      if (vi > vmax)
        vmax = vi;
    }
    var x: int = this.getSamplesPerLine__();
    var y: int = this.getNumberOfLines__();
    var multiples: JavaArray = new JavaArray("[I").values(8, 16, 24, 32);
    for (var i_1: int = 0; i_1 < nf; i_1++) {
      var compParam_1: JavaArray = compSpecParams[componentIdentifiers[i_1]];
      var hi_1: int = compParam_1[1];
      var vi_1: int = compParam_1[2];
      var compWidth: int = int((x * hi_1 + hmax - 1) / hmax);
      var compHeight: int = int((y * vi_1 + vmax - 1) / vmax);
      var dsWidth: int = this.roundUpToMultiple__II(compWidth, multiples[hi_1 - 1]);
      var dsHeight: int = this.roundUpToMultiple__II(compHeight, multiples[vi_1 - 1]);
      compParam_1[3] = dsWidth;
      compParam_1[4] = dsHeight;
    }
    this.setMaxHFactor__I(hmax);
    this.setMaxVFactor__I(vmax);
    return;
  }
  public function roundUpToMultiple__II(anInteger: int, mInteger: int): int {
    var a: int = anInteger + mInteger - 1;
    return a - (a % mInteger);
  }
  public override function verify__(): Boolean {
    var marker: int = this.getSegmentMarker__();
    return (marker >= 65472 && marker <= 65475) || (marker >= 65477 && marker <= 65479) || (marker >= 65481 && marker <= 65483) || (marker >= 65485 && marker <= 65487);
  }
  public function isProgressive__(): Boolean {
    var marker: int = this.getSegmentMarker__();
    return marker == 65474 || marker == 65478 || marker == 65482 || marker == 65486;
  }
  public function isArithmeticCoding__(): Boolean {
    return this.getSegmentMarker__() >= 65481;
  }
  public function JPEGFrameHeader(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is JavaArray) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is LEDataInputStream) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.internal.image.JPEGVariableSizeSegment.JPEGVariableSizeSegment___3B, [args0[0]]);
        break;
      case 1:
        var args1: Array = [args[0]];
        superArgs = new Arguments(org.eclipse.swt.internal.image.JPEGVariableSizeSegment.JPEGVariableSizeSegment__Lorg_eclipse_swt_internal_image_LEDataInputStream_2, [args1[0]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        JPEGFrameHeader___3B(args0[0]);
        break;
      case 1:
        JPEGFrameHeader__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(args1[0]);
        break;
    }
  }
  public static const JPEGFrameHeader___3B : int = 0;
  public static const JPEGFrameHeader__Lorg_eclipse_swt_internal_image_LEDataInputStream_2 : int = 1;
}
}
