package org.eclipse.swt.internal.image {
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class JPEGHuffmanTable extends JPEGVariableSizeSegment {
  internal var allTables: JavaArray;
  internal var tableClass: int;
  internal var tableIdentifier: int;
  internal var dhMaxCodes: JavaArray;
  internal var dhMinCodes: JavaArray;
  internal var dhValPtrs: JavaArray;
  internal var dhValues: JavaArray;
  internal var ehCodes: JavaArray;
  internal var ehCodeLengths: JavaArray;
  public static var DCLuminanceTable: JavaArray = new JavaArray("[B").values(int(255), int(196), 0, 31, 0, 0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11);
  public static var DCChrominanceTable: JavaArray = new JavaArray("[B").values(int(255), int(196), 0, 31, 1, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11);
  public static var ACLuminanceTable: JavaArray = new JavaArray("[B").values(int(255), int(196), 0, int(181), 16, 0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 125, 1, 2, 3, 0, 4, 17, 5, 18, 33, 49, 65, 6, 19, 81, 97, 7, 34, 113, 20, 50, int(129), int(145), int(161), 8, 35, 66, int(177), int(193), 21, 82, int(209), int(240), 36, 51, 98, 114, int(130), 9, 10, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 52, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, int(131), int(132), int(133), int(134), int(135), int(136), int(137), int(138), int(146), int(147), int(148), int(149), int(150), int(151), int(152), int(153), int(154), int(162), int(163), int(164), int(165), int(166), int(167), int(168), int(169), int(170), int(178), int(179), int(180), int(181), int(182), int(183), int(184), int(185), int(186), int(194), int(195), int(196), int(197), int(198), int(199), int(200), int(201), int(202), int(210), int(211), int(212), int(213), int(214), int(215), int(216), int(217), int(218), int(225), int(226), int(227), int(228), int(229), int(230), int(231), int(232), int(233), int(234), int(241), int(242), int(243), int(244), int(245), int(246), int(247), int(248), int(249), int(250));
  public static var ACChrominanceTable: JavaArray = new JavaArray("[B").values(int(255), int(196), 0, int(181), 17, 0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 119, 0, 1, 2, 3, 17, 4, 5, 33, 49, 6, 18, 65, 81, 7, 97, 113, 19, 34, 50, int(129), 8, 20, 66, int(145), int(161), int(177), int(193), 9, 35, 51, 82, int(240), 21, 98, 114, int(209), 10, 22, 36, 52, int(225), 37, int(241), 23, 24, 25, 26, 38, 39, 40, 41, 42, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, int(130), int(131), int(132), int(133), int(134), int(135), int(136), int(137), int(138), int(146), int(147), int(148), int(149), int(150), int(151), int(152), int(153), int(154), int(162), int(163), int(164), int(165), int(166), int(167), int(168), int(169), int(170), int(178), int(179), int(180), int(181), int(182), int(183), int(184), int(185), int(186), int(194), int(195), int(196), int(197), int(198), int(199), int(200), int(201), int(202), int(210), int(211), int(212), int(213), int(214), int(215), int(216), int(217), int(218), int(226), int(227), int(228), int(229), int(230), int(231), int(232), int(233), int(234), int(242), int(243), int(244), int(245), int(246), int(247), int(248), int(249), int(250));
  public function JPEGHuffmanTable___3B(reference: JavaArray): Object {
    return this;
  }
  public function JPEGHuffmanTable__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(byteStream: LEDataInputStream): Object {
    this.initialize__();
    return this;
  }
  public function getAllTables__(): JavaArray {
    return allTables;
  }
  public static function getDefaultACChrominanceTable__(): JPEGHuffmanTable {
    var result: JPEGHuffmanTable = new JPEGHuffmanTable(new Arguments(org.eclipse.swt.internal.image.JPEGHuffmanTable.JPEGHuffmanTable___3B, [ACChrominanceTable]));
    result.initialize__();
    return result;
  }
  public static function getDefaultACLuminanceTable__(): JPEGHuffmanTable {
    var result: JPEGHuffmanTable = new JPEGHuffmanTable(new Arguments(org.eclipse.swt.internal.image.JPEGHuffmanTable.JPEGHuffmanTable___3B, [ACLuminanceTable]));
    result.initialize__();
    return result;
  }
  public static function getDefaultDCChrominanceTable__(): JPEGHuffmanTable {
    var result: JPEGHuffmanTable = new JPEGHuffmanTable(new Arguments(org.eclipse.swt.internal.image.JPEGHuffmanTable.JPEGHuffmanTable___3B, [DCChrominanceTable]));
    result.initialize__();
    return result;
  }
  public static function getDefaultDCLuminanceTable__(): JPEGHuffmanTable {
    var result: JPEGHuffmanTable = new JPEGHuffmanTable(new Arguments(org.eclipse.swt.internal.image.JPEGHuffmanTable.JPEGHuffmanTable___3B, [DCLuminanceTable]));
    result.initialize__();
    return result;
  }
  public function getDhMaxCodes__(): JavaArray {
    return dhMaxCodes;
  }
  public function getDhMinCodes__(): JavaArray {
    return dhMinCodes;
  }
  public function getDhValPtrs__(): JavaArray {
    return dhValPtrs;
  }
  public function getDhValues__(): JavaArray {
    return dhValues;
  }
  public function getTableClass__(): int {
    return tableClass;
  }
  public function getTableIdentifier__(): int {
    return tableIdentifier;
  }
  public function initialize__(): void {
    var totalLength: int = this.getSegmentLength__() - 2;
    var ofs: int = 4;
    var bits: JavaArray = new JavaArray("[I").lengths(16);
    var huffTables: JavaArray = new JavaArray("[Lorg/eclipse/swt/internal/image/JPEGHuffmanTable;").lengths(8);
    var huffTableCount: int = 0;
    while (totalLength > 0) {
      var tc: int = (reference[ofs] & 0xFF) >> 4;
      var tid: int = reference[ofs] & 0xF;
      ofs++;
      var count: int = 0;
      for (var i: int = 0; i < bits.length; i++) {
        var bCount: int = reference[ofs + i] & 0xFF;
        bits[i] = bCount;
        count += bCount;
      }
      ofs += 16;
      totalLength -= 17;
      var huffVals: JavaArray = new JavaArray("[I").lengths(count);
      for (var i_1: int = 0; i_1 < count; i_1++) {
        huffVals[i_1] = reference[ofs + i_1] & 0xFF;
      }
      ofs += count;
      totalLength -= count;
      var huffCodeLengths: JavaArray = new JavaArray("[I").lengths(50);
      var huffCodeLengthsIndex: int = 0;
      for (var i_2: int = 0; i_2 < 16; i_2++) {
        for (var j: int = 0; j < bits[i_2]; j++) {
          if (huffCodeLengthsIndex >= huffCodeLengths.length) {
            var newHuffCodeLengths: JavaArray = new JavaArray("[I").lengths(huffCodeLengths.length + 50);
            System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(huffCodeLengths, 0, newHuffCodeLengths, 0, huffCodeLengths.length);
            huffCodeLengths = newHuffCodeLengths;
          }
          huffCodeLengths[huffCodeLengthsIndex] = i_2 + 1;
          huffCodeLengthsIndex++;
        }
      }
      if (huffCodeLengthsIndex < huffCodeLengths.length) {
        var newHuffCodeLengths_1: JavaArray = new JavaArray("[I").lengths(huffCodeLengthsIndex);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(huffCodeLengths, 0, newHuffCodeLengths_1, 0, huffCodeLengthsIndex);
        huffCodeLengths = newHuffCodeLengths_1;
      }
      var huffCodes: JavaArray = new JavaArray("[I").lengths(50);
      var huffCodesIndex: int = 0;
      var k: int = 1;
      var code: int = 0;
      var si: int = huffCodeLengths[0];
      var p: int = 0;
      while (p < huffCodeLengthsIndex) {
        while ((p < huffCodeLengthsIndex) && (huffCodeLengths[p] == si)) {
          if (huffCodesIndex >= huffCodes.length) {
            var newHuffCodes: JavaArray = new JavaArray("[I").lengths(huffCodes.length + 50);
            System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(huffCodes, 0, newHuffCodes, 0, huffCodes.length);
            huffCodes = newHuffCodes;
          }
          huffCodes[huffCodesIndex] = code;
          huffCodesIndex++;
          code++;
          p++;
        }
        code *= 2;
        si++;
      }
      if (huffCodesIndex < huffCodes.length) {
        var newHuffCodes_1: JavaArray = new JavaArray("[I").lengths(huffCodesIndex);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(huffCodes, 0, newHuffCodes_1, 0, huffCodesIndex);
        huffCodes = newHuffCodes_1;
      }
      k = 0;
      var maxCodes: JavaArray = new JavaArray("[I").lengths(16);
      var minCodes: JavaArray = new JavaArray("[I").lengths(16);
      var valPtrs: JavaArray = new JavaArray("[I").lengths(16);
      for (var i_3: int = 0; i_3 < 16; i_3++) {
        var bSize: int = bits[i_3];
        if (bSize == 0) {
          maxCodes[i_3] = -1;
        } else {
          valPtrs[i_3] = k;
          minCodes[i_3] = huffCodes[k];
          k += bSize;
          maxCodes[i_3] = huffCodes[k - 1];
        }
      }
      var eHuffCodes: JavaArray = new JavaArray("[I").lengths(256);
      var eHuffSize: JavaArray = new JavaArray("[B").lengths(256);
      for (var i_4: int = 0; i_4 < huffCodesIndex; i_4++) {
        eHuffCodes[huffVals[i_4]] = huffCodes[i_4];
        eHuffSize[huffVals[i_4]] = int(huffCodeLengths[i_4]);
      }
      var dhtTable: JPEGHuffmanTable = new JPEGHuffmanTable(new Arguments(org.eclipse.swt.internal.image.JPEGHuffmanTable.JPEGHuffmanTable___3B, [reference]));
      dhtTable.tableClass = tc;
      dhtTable.tableIdentifier = tid;
      dhtTable.dhValues = huffVals;
      dhtTable.dhMinCodes = minCodes;
      dhtTable.dhMaxCodes = maxCodes;
      dhtTable.dhValPtrs = valPtrs;
      dhtTable.ehCodes = eHuffCodes;
      dhtTable.ehCodeLengths = eHuffSize;
      huffTables[huffTableCount] = dhtTable;
      huffTableCount++;
    }
    allTables = new JavaArray("[Lorg/eclipse/swt/internal/image/JPEGHuffmanTable;").lengths(huffTableCount);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(huffTables, 0, allTables, 0, huffTableCount);
    return;
  }
  public override function signature__(): int {
    return 65476;
  }
  public function JPEGHuffmanTable(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is JavaArray) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is LEDataInputStream) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.internal.image.JPEGVariableSizeSegment.JPEGVariableSizeSegment___3B, [args0[0]]);
        break;
      case 1:
        var args1: Array = [args[0]];
        superArgs = new Arguments(org.eclipse.swt.internal.image.JPEGVariableSizeSegment.JPEGVariableSizeSegment__Lorg_eclipse_swt_internal_image_LEDataInputStream_2, [args1[0]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        JPEGHuffmanTable___3B(args0[0]);
        break;
      case 1:
        JPEGHuffmanTable__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(args1[0]);
        break;
    }
  }
  public static const JPEGHuffmanTable___3B : int = 0;
  public static const JPEGHuffmanTable__Lorg_eclipse_swt_internal_image_LEDataInputStream_2 : int = 1;
}
}
