package org.eclipse.swt.internal.image {
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class JPEGQuantizationTable extends JPEGVariableSizeSegment {
  public static var DefaultLuminanceQTable: JavaArray = new JavaArray("[B").values(int(255), int(219), 0, 67, 0, 16, 11, 10, 16, 24, 40, 51, 61, 12, 12, 14, 19, 26, 58, 60, 55, 14, 13, 16, 24, 40, 57, 69, 56, 14, 17, 22, 29, 51, 87, 80, 62, 18, 22, 37, 56, 68, 109, 103, 77, 24, 35, 55, 64, 81, 104, 113, 92, 49, 64, 78, 87, 103, 121, 120, 101, 72, 92, 95, 98, 112, 100, 103, 99);
  public static var DefaultChrominanceQTable: JavaArray = new JavaArray("[B").values(int(255), int(219), 0, 67, 1, 17, 18, 24, 47, 99, 99, 99, 99, 18, 21, 26, 66, 99, 99, 99, 99, 24, 26, 56, 99, 99, 99, 99, 99, 47, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99);
  public function JPEGQuantizationTable___3B(reference: JavaArray): Object {
    return this;
  }
  public function JPEGQuantizationTable__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(byteStream: LEDataInputStream): Object {
    return this;
  }
  public static function defaultChrominanceTable__(): JPEGQuantizationTable {
    var data: JavaArray = new JavaArray("[B").lengths(DefaultChrominanceQTable.length);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(DefaultChrominanceQTable, 0, data, 0, data.length);
    return new JPEGQuantizationTable(new Arguments(org.eclipse.swt.internal.image.JPEGQuantizationTable.JPEGQuantizationTable___3B, [data]));
  }
  public static function defaultLuminanceTable__(): JPEGQuantizationTable {
    var data: JavaArray = new JavaArray("[B").lengths(DefaultLuminanceQTable.length);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(DefaultLuminanceQTable, 0, data, 0, data.length);
    return new JPEGQuantizationTable(new Arguments(org.eclipse.swt.internal.image.JPEGQuantizationTable.JPEGQuantizationTable___3B, [data]));
  }
  public function getQuantizationTablesKeys__(): JavaArray {
    var keys: JavaArray = new JavaArray("[I").lengths(4);
    var keysIndex: int = 0;
    var totalLength: int = this.getSegmentLength__() - 2;
    var ofs: int = 4;
    while (totalLength > 64) {
      var tq: int = reference[ofs] & 0xF;
      var pq: int = (reference[ofs] & 0xFF) >> 4;
      if (pq == 0) {
        ofs += 65;
        totalLength -= 65;
      } else {
        ofs += 129;
        totalLength -= 129;
      }
      if (keysIndex >= keys.length) {
        var newKeys: JavaArray = new JavaArray("[I").lengths(keys.length + 4);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(keys, 0, newKeys, 0, keys.length);
        keys = newKeys;
      }
      keys[keysIndex] = tq;
      keysIndex++;
    }
    var newKeys_1: JavaArray = new JavaArray("[I").lengths(keysIndex);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(keys, 0, newKeys_1, 0, keysIndex);
    return newKeys_1;
  }
  public function getQuantizationTablesValues__(): JavaArray {
    var values: JavaArray = new JavaArray("[[I").lengths(4);
    var valuesIndex: int = 0;
    var totalLength: int = this.getSegmentLength__() - 2;
    var ofs: int = 4;
    while (totalLength > 64) {
      var qk: JavaArray = new JavaArray("[I").lengths(64);
      var pq: int = (reference[ofs] & 0xFF) >> 4;
      if (pq == 0) {
        for (var i: int = 0; i < qk.length; i++) {
          qk[i] = reference[ofs + i + 1] & 0xFF;
        }
        ofs += 65;
        totalLength -= 65;
      } else {
        for (var i_1: int = 0; i_1 < qk.length; i_1++) {
          var idx: int = (i_1 - 1) * 2;
          qk[i_1] = (reference[ofs + idx + 1] & 0xFF) * 256 + (reference[ofs + idx + 2] & 0xFF);
        }
        ofs += 129;
        totalLength -= 129;
      }
      if (valuesIndex >= values.length) {
        var newValues: JavaArray = new JavaArray("[[I").lengths(values.length + 4);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(values, 0, newValues, 0, values.length);
        values = newValues;
      }
      values[valuesIndex] = qk;
      valuesIndex++;
    }
    var newValues_1: JavaArray = new JavaArray("[[I").lengths(valuesIndex);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(values, 0, newValues_1, 0, valuesIndex);
    return newValues_1;
  }
  public function scaleBy__I(qualityFactor: int): void {
    var qFactor: int = qualityFactor;
    if (qFactor <= 0) {
      qFactor = 1;
    }
    if (qFactor > 100) {
      qFactor = 100;
    }
    if (qFactor < 50) {
      qFactor = int(5000 / qFactor);
    } else {
      qFactor = 200 - (qFactor * 2);
    }
    var totalLength: int = this.getSegmentLength__() - 2;
    var ofs: int = 4;
    while (totalLength > 64) {
      var pq: int = (reference[ofs] & 0xFF) >> 4;
      if (pq == 0) {
        for (var i: int = ofs + 1; i <= ofs + 64; i++) {
          var temp: int = int(((reference[i] & 0xFF) * qFactor + 50) / 100);
          if (temp <= 0)
            temp = 1;
          if (temp > 255)
            temp = 255;
          reference[i] = int(temp);
        }
        ofs += 65;
        totalLength -= 65;
      } else {
        for (var i_1: int = ofs + 1; i_1 <= ofs + 128; i_1 += 2) {
          var temp_1: int = int((((reference[i_1] & 0xFF) * 256 + (reference[i_1 + 1] & 0xFF)) * qFactor + 50) / 100);
          if (temp_1 <= 0)
            temp_1 = 1;
          if (temp_1 > 32767)
            temp_1 = 32767;
          reference[i_1] = int((temp_1 >> 8));
          reference[i_1 + 1] = int((temp_1 & 0xFF));
        }
        ofs += 129;
        totalLength -= 129;
      }
    }
    return;
  }
  public override function signature__(): int {
    return 65499;
  }
  public function JPEGQuantizationTable(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is JavaArray) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is LEDataInputStream) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.internal.image.JPEGVariableSizeSegment.JPEGVariableSizeSegment___3B, [args0[0]]);
        break;
      case 1:
        var args1: Array = [args[0]];
        superArgs = new Arguments(org.eclipse.swt.internal.image.JPEGVariableSizeSegment.JPEGVariableSizeSegment__Lorg_eclipse_swt_internal_image_LEDataInputStream_2, [args1[0]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        JPEGQuantizationTable___3B(args0[0]);
        break;
      case 1:
        JPEGQuantizationTable__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(args1[0]);
        break;
    }
  }
  public static const JPEGQuantizationTable___3B : int = 0;
  public static const JPEGQuantizationTable__Lorg_eclipse_swt_internal_image_LEDataInputStream_2 : int = 1;
}
}
