package org.eclipse.swt.internal.image {
import org.eclipse.swt.*;
import java.lang.System;
import org.eclipse.swt.SWT;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class JPEGScanHeader extends JPEGVariableSizeSegment {
  public var componentParameters: JavaArray;
  public function JPEGScanHeader___3B(reference: JavaArray): Object {
    return this;
  }
  public function JPEGScanHeader__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(byteStream: LEDataInputStream): Object {
    this.initializeComponentParameters__();
    return this;
  }
  public function getApproxBitPositionHigh__(): int {
    return reference[(2 * this.getNumberOfImageComponents__()) + 7] >> 4;
  }
  public function getApproxBitPositionLow__(): int {
    return reference[(2 * this.getNumberOfImageComponents__()) + 7] & 0xF;
  }
  public function getEndOfSpectralSelection__(): int {
    return reference[(2 * this.getNumberOfImageComponents__()) + 6];
  }
  public function getNumberOfImageComponents__(): int {
    return reference[4];
  }
  public function getStartOfSpectralSelection__(): int {
    return reference[(2 * this.getNumberOfImageComponents__()) + 5];
  }
  public function initializeComponentParameters__(): void {
    var compCount: int = this.getNumberOfImageComponents__();
    componentParameters = new JavaArray("[[I").lengths(0);
    for (var i: int = 0; i < compCount; i++) {
      var ofs: int = 5 + i * 2;
      var cid: int = reference[ofs] & 0xFF;
      var dc: int = (reference[ofs + 1] & 0xFF) >> 4;
      var ac: int = reference[ofs + 1] & 0xF;
      if (componentParameters.length <= cid) {
        var newParams: JavaArray = new JavaArray("[[I").lengths(cid + 1);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(componentParameters, 0, newParams, 0, componentParameters.length);
        componentParameters = newParams;
      }
      componentParameters[cid] = new JavaArray("[I").values(dc, ac);
    }
    return;
  }
  public function initializeContents__(): void {
    var compCount: int = this.getNumberOfImageComponents__();
    var compSpecParams: JavaArray = componentParameters;
    if (compCount == 0 || compCount != compSpecParams.length) {
      SWT.error__I(40);
    }
    for (var i: int = 0; i < compCount; i++) {
      var ofs: int = i * 2 + 5;
      var compParams: JavaArray = compSpecParams[i];
      reference[ofs] = int((i + 1));
      reference[ofs + 1] = int((compParams[0] * 16 + compParams[1]));
    }
    return;
  }
  public function setEndOfSpectralSelection__I(anInteger: int): void {
    reference[(2 * this.getNumberOfImageComponents__()) + 6] = int(anInteger);
    return;
  }
  public function setNumberOfImageComponents__I(anInteger: int): void {
    reference[4] = int((anInteger & 0xFF));
    return;
  }
  public function setStartOfSpectralSelection__I(anInteger: int): void {
    reference[(2 * this.getNumberOfImageComponents__()) + 5] = int(anInteger);
    return;
  }
  public override function signature__(): int {
    return 65498;
  }
  public function verifyProgressiveScan__(): Boolean {
    var start: int = this.getStartOfSpectralSelection__();
    var end: int = this.getEndOfSpectralSelection__();
    var low: int = this.getApproxBitPositionLow__();
    var high: int = this.getApproxBitPositionHigh__();
    var count: int = this.getNumberOfImageComponents__();
    if ((start == 0 && end == 00) || (start <= end && end <= 63)) {
      if (low <= 13 && high <= 13 && (high == 0 || high == low + 1)) {
        return start == 0 || (start > 0 && count == 1);
      }
    }
    return false;
  }
  public function isACProgressiveScan__(): Boolean {
    return this.getStartOfSpectralSelection__() != 0 && this.getEndOfSpectralSelection__() != 0;
  }
  public function isDCProgressiveScan__(): Boolean {
    return this.getStartOfSpectralSelection__() == 0 && this.getEndOfSpectralSelection__() == 0;
  }
  public function isFirstScan__(): Boolean {
    return this.getApproxBitPositionHigh__() == 0;
  }
  public function JPEGScanHeader(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is JavaArray) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is LEDataInputStream) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.internal.image.JPEGVariableSizeSegment.JPEGVariableSizeSegment___3B, [args0[0]]);
        break;
      case 1:
        var args1: Array = [args[0]];
        superArgs = new Arguments(org.eclipse.swt.internal.image.JPEGVariableSizeSegment.JPEGVariableSizeSegment__Lorg_eclipse_swt_internal_image_LEDataInputStream_2, [args1[0]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        JPEGScanHeader___3B(args0[0]);
        break;
      case 1:
        JPEGScanHeader__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(args1[0]);
        break;
    }
  }
  public static const JPEGScanHeader___3B : int = 0;
  public static const JPEGScanHeader__Lorg_eclipse_swt_internal_image_LEDataInputStream_2 : int = 1;
}
}
