package org.eclipse.swt.internal.image {
import java.lang.Exception;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class JPEGSegment {
  public var reference: JavaArray;
  public function JPEGSegment__(): Object {
    return this;
  }
  public function JPEGSegment___3B(reference: JavaArray): Object {
    this.reference = reference;
    return this;
  }
  public function signature__(): int {
    return 0;
  }
  public function verify__(): Boolean {
    return this.getSegmentMarker__() == this.signature__();
  }
  public function getSegmentMarker__(): int {
    return ((reference[0] & 0xFF) << 8 | (reference[1] & 0xFF));
  }
  public function setSegmentMarker__I(marker: int): void {
    reference[0] = int(((marker & 0xFF00) >> 8));
    reference[1] = int((marker & 0xFF));
  }
  public function getSegmentLength__(): int {
    return ((reference[2] & 0xFF) << 8 | (reference[3] & 0xFF));
  }
  public function setSegmentLength__I(length: int): void {
    reference[2] = int(((length & 0xFF00) >> 8));
    reference[3] = int((length & 0xFF));
  }
  public function writeToStream__Lorg_eclipse_swt_internal_image_LEDataOutputStream_2(byteStream: LEDataOutputStream): Boolean {
    try {
      byteStream.write___3B(reference);
      return true;
    } catch (e : Exception) {
      return false;
    }
    return false;
  }
  public function JPEGSegment(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is JavaArray) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        JPEGSegment__();
        break;
      case 1:
        JPEGSegment___3B(args1[0]);
        break;
    }
  }
  public static const JPEGSegment__ : int = 0;
  public static const JPEGSegment___3B : int = 1;
}
}
