package org.eclipse.swt.internal.image {
import java.io.*;
import java.io.InputStream;
import java.lang.IllegalArgumentException;
import java.io.IOException;
import java.lang.ArrayIndexOutOfBoundsException;
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class LEDataInputStream extends InputStream {
  internal var position: int;
  internal var in_org_eclipse_swt_internal_image_LEDataInputStream: InputStream;
  public var buf: JavaArray;
  public var pos: int;
  public function LEDataInputStream__Ljava_io_InputStream_2(input: InputStream): Object {
    return this;
  }
  public function LEDataInputStream__Ljava_io_InputStream_2I(input: InputStream, bufferSize: int): Object {
    this.in_org_eclipse_swt_internal_image_LEDataInputStream = input;
    if (bufferSize > 0) {
      buf = new JavaArray("[B").lengths(bufferSize);
      pos = bufferSize;
    } else
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__, []));
    return this;
  }
  public override function close__(): void {
    buf = null;
    if (in_org_eclipse_swt_internal_image_LEDataInputStream !== null) {
      in_org_eclipse_swt_internal_image_LEDataInputStream.close__();
      in_org_eclipse_swt_internal_image_LEDataInputStream = null;
    }
    return;
  }
  public function getPosition__(): int {
    return position;
  }
  public override function available__(): int {
    if (buf === null)
      throw new IOException(new Arguments(java.io.IOException.IOException__, []));
    return (buf.length - pos) + in_org_eclipse_swt_internal_image_LEDataInputStream.available__();
  }
  public override function read__(): int {
    if (buf === null)
      throw new IOException(new Arguments(java.io.IOException.IOException__, []));
    if (pos < buf.length) {
      position++;
      return (buf[pos++] & 0xFF);
    }
    var c: int = in_org_eclipse_swt_internal_image_LEDataInputStream.read__();
    if (c != -1)
      position++;
    return c;
  }
  public override function read___3BII(b: JavaArray, off: int, len: int): int {
    var read: int = 0;
    var count: int;
    while (read != len && (count = this.readData___3BII(b, off, len - read)) != -1) {
      off += count;
      read += count;
    }
    position += read;
    if (read == 0 && read != len)
      return -1;
    return read;
  }
  private function readData___3BII(buffer: JavaArray, offset: int, length: int): int {
    if (buf === null)
      throw new IOException(new Arguments(java.io.IOException.IOException__, []));
    if (offset < 0 || offset > buffer.length || length < 0 || (length > buffer.length - offset)) {
      throw new ArrayIndexOutOfBoundsException(new Arguments(java.lang.ArrayIndexOutOfBoundsException.ArrayIndexOutOfBoundsException__, []));
    }
    var cacheCopied: int = 0;
    var newOffset: int = offset;
    var available: int = buf.length - pos;
    if (available > 0) {
      cacheCopied = (available >= length) ? length : available;
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(buf, pos, buffer, newOffset, cacheCopied);
      newOffset += cacheCopied;
      pos += cacheCopied;
    }
    if (cacheCopied == length)
      return length;
    var inCopied: int = in_org_eclipse_swt_internal_image_LEDataInputStream.read___3BII(buffer, newOffset, length - cacheCopied);
    if (inCopied > 0)
      return inCopied + cacheCopied;
    if (cacheCopied == 0)
      return inCopied;
    return cacheCopied;
  }
  public function readInt__(): int {
    var buf_1: JavaArray = new JavaArray("[B").lengths(4);
    this.read___3B(buf_1);
    return ((buf_1[3] & 0xFF) << 24) | ((buf_1[2] & 0xFF) << 16) | ((buf_1[1] & 0xFF) << 8) | (buf_1[0] & 0xFF);
  }
  public function readShort__(): int {
    var buf_1: JavaArray = new JavaArray("[B").lengths(2);
    this.read___3B(buf_1);
    return int((((buf_1[1] & 0xFF) << 8) | (buf_1[0] & 0xFF)));
  }
  public function unread___3B(b: JavaArray): void {
    var length: int = b.length;
    if (length > pos)
      throw new IOException(new Arguments(java.io.IOException.IOException__, []));
    position -= length;
    pos -= length;
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(b, 0, buf, pos, length);
  }
  public function LEDataInputStream(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is InputStream) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is InputStream && vargs[1] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        args1 = [args0[0], 512];
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        break;
    }
    super();
    switch (id) {
      case 0:
        LEDataInputStream__Ljava_io_InputStream_2I(args1[0], args1[1]);
        LEDataInputStream__Ljava_io_InputStream_2(args0[0]);
        break;
      case 1:
        LEDataInputStream__Ljava_io_InputStream_2I(args1[0], args1[1]);
        break;
    }
  }
  public static const LEDataInputStream__Ljava_io_InputStream_2 : int = 0;
  public static const LEDataInputStream__Ljava_io_InputStream_2I : int = 1;
}
}
