package org.eclipse.swt.internal.image {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import java.lang.System;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.SWT;
import java.lang.Exception;
import java.lang.JavaArray;
dynamic public class LZWCodec {
  internal var bitsPerPixel: int;
  internal var blockSize: int;
  internal var blockIndex: int;
  internal var currentByte: int;
  internal var bitsLeft: int;
  internal var codeSize: int;
  internal var clearCode: int;
  internal var endCode: int;
  internal var newCodes: int;
  internal var topSlot: int;
  internal var currentSlot: int;
  internal var imageWidth: int;
  internal var imageHeight: int;
  internal var imageX: int;
  internal var imageY: int;
  internal var pass: int;
  internal var line: int;
  internal var codeMask: int;
  internal var block: JavaArray;
  internal var lineArray: JavaArray;
  internal var stack: JavaArray;
  internal var suffix: JavaArray;
  internal var prefix: JavaArray;
  internal var nodeStack: JavaArray;
  internal var inputStream: LEDataInputStream;
  internal var outputStream: LEDataOutputStream;
  internal var image: ImageData;
  internal var loader: ImageLoader;
  internal var interlaced: Boolean;
  public static var MASK_TABLE: JavaArray = new JavaArray("[I").values(0x1, 0x3, 0x7, 0xF, 0x1F, 0x3F, 0x7F, 0xFF, 0x1FF, 0x3FF, 0x7FF, 0xFFF);
  public function decode__(): void {
    var code: int;
    var oc: int = 0;
    var fc: int = 0;
    var buf: JavaArray = new JavaArray("[B").lengths(imageWidth);
    var stackIndex: int = 0;
    var bufIndex: int = 0;
    var c: int;
    while ((c = this.nextCode__()) != endCode) {
      if (c == clearCode) {
        codeSize = bitsPerPixel + 1;
        codeMask = MASK_TABLE[bitsPerPixel];
        currentSlot = newCodes;
        topSlot = 1 << codeSize;
        while ((c = this.nextCode__()) == clearCode) {
        }
        if (c != endCode) {
          oc = fc = c;
          buf[bufIndex] = int(c);
          bufIndex++;
          if (bufIndex == imageWidth) {
            this.nextPutPixels___3B(buf);
            bufIndex = 0;
          }
        }
      } else {
        code = c;
        if (code >= currentSlot) {
          code = oc;
          stack[stackIndex] = fc;
          stackIndex++;
        }
        while (code >= newCodes) {
          stack[stackIndex] = suffix[code];
          stackIndex++;
          code = prefix[code];
        }
        stack[stackIndex] = code;
        stackIndex++;
        if (currentSlot < topSlot) {
          fc = code;
          suffix[currentSlot] = fc;
          prefix[currentSlot] = oc;
          currentSlot++;
          oc = c;
        }
        if (currentSlot >= topSlot) {
          if (codeSize < 12) {
            codeMask = MASK_TABLE[codeSize];
            codeSize++;
            topSlot = topSlot + topSlot;
          }
        }
        while (stackIndex > 0) {
          stackIndex--;
          buf[bufIndex] = int(stack[stackIndex]);
          bufIndex++;
          if (bufIndex == imageWidth) {
            this.nextPutPixels___3B(buf);
            bufIndex = 0;
          }
        }
      }
    }
    if (bufIndex != 0 && line < imageHeight) {
      this.nextPutPixels___3B(buf);
    }
    return;
  }
  public function decode__Lorg_eclipse_swt_internal_image_LEDataInputStream_2Lorg_eclipse_swt_graphics_ImageLoader_2Lorg_eclipse_swt_graphics_ImageData_2ZI(inputStream_1: LEDataInputStream, loader_1: ImageLoader, image_1: ImageData, interlaced_1: Boolean, depth: int): void {
    this.inputStream = inputStream_1;
    this.loader = loader_1;
    this.image = image_1;
    this.interlaced = interlaced_1;
    this.bitsPerPixel = depth;
    this.initializeForDecoding__();
    this.decode__();
    return;
  }
  public function encode__(): void {
    this.nextPutCode__I(clearCode);
    var lastPrefix: int = this.encodeLoop__();
    this.nextPutCode__I(lastPrefix);
    this.nextPutCode__I(endCode);
    if (bitsLeft == 8) {
      block[0] = int((blockIndex - 1));
    } else {
      block[0] = int((blockIndex));
    }
    this.writeBlock__();
    if (block[0] != 0) {
      block[0] = 0;
      this.writeBlock__();
    }
    return;
  }
  public function encode__Lorg_eclipse_swt_internal_image_LEDataOutputStream_2Lorg_eclipse_swt_graphics_ImageData_2(byteStream: LEDataOutputStream, image_1: ImageData): void {
    this.outputStream = byteStream;
    this.image = image_1;
    this.initializeForEncoding__();
    this.encode__();
    return;
  }
  public function encodeLoop__(): int {
    var pixel: int = this.nextPixel__();
    var found: Boolean;
    var node: LZWNode;
    while (true) {
      var currentPrefix: int = pixel;
      node = nodeStack[currentPrefix];
      found = true;
      pixel = this.nextPixel__();
      if (pixel < 0)
        return currentPrefix;
      while (found && (node.children !== null)) {
        node = node.children;
        while (found && (node.suffix != pixel)) {
          if (pixel < node.suffix) {
            if (node.left === null) {
              node.left = new LZWNode();
              found = false;
            }
            node = node.left;
          } else {
            if (node.right === null) {
              node.right = new LZWNode();
              found = false;
            }
            node = node.right;
          }
        }
        if (found) {
          currentPrefix = node.code;
          pixel = this.nextPixel__();
          if (pixel < 0)
            return currentPrefix;
        }
      }
      if (found) {
        node.children = new LZWNode();
        node = node.children;
      }
      node.children = null;
      node.left = null;
      node.right = null;
      node.code = currentSlot;
      node.prefix = currentPrefix;
      node.suffix = pixel;
      this.nextPutCode__I(currentPrefix);
      currentSlot++;
      if (currentSlot < 4096) {
        if (currentSlot > topSlot) {
          codeSize++;
          codeMask = MASK_TABLE[codeSize - 1];
          topSlot *= 2;
        }
      } else {
        this.nextPutCode__I(clearCode);
        for (var i: int = 0; i < nodeStack.length; i++)
          nodeStack[i].children = null;
        codeSize = bitsPerPixel + 1;
        codeMask = MASK_TABLE[codeSize - 1];
        currentSlot = newCodes;
        topSlot = 1 << codeSize;
      }
    }
    return 0;
  }
  public function initializeForDecoding__(): void {
    pass = 1;
    line = 0;
    codeSize = bitsPerPixel + 1;
    topSlot = 1 << codeSize;
    clearCode = 1 << bitsPerPixel;
    endCode = clearCode + 1;
    newCodes = currentSlot = endCode + 1;
    currentByte = -1;
    blockSize = bitsLeft = 0;
    blockIndex = 0;
    codeMask = MASK_TABLE[codeSize - 1];
    stack = new JavaArray("[I").lengths(4096);
    suffix = new JavaArray("[I").lengths(4096);
    prefix = new JavaArray("[I").lengths(4096);
    block = new JavaArray("[B").lengths(256);
    imageWidth = image.width;
    imageHeight = image.height;
    return;
  }
  public function initializeForEncoding__(): void {
    interlaced = false;
    bitsPerPixel = image.depth;
    codeSize = bitsPerPixel + 1;
    topSlot = 1 << codeSize;
    clearCode = 1 << bitsPerPixel;
    endCode = clearCode + 1;
    newCodes = currentSlot = endCode + 1;
    bitsLeft = 8;
    currentByte = 0;
    blockIndex = 1;
    blockSize = 255;
    block = new JavaArray("[B").lengths(blockSize);
    block[0] = int((blockSize - 1));
    nodeStack = new JavaArray("[Lorg/eclipse/swt/internal/image/LZWNode;").lengths(1 << bitsPerPixel);
    for (var i: int = 0; i < nodeStack.length; i++) {
      var node: LZWNode = new LZWNode();
      node.code = i + 1;
      node.prefix = -1;
      node.suffix = i + 1;
      nodeStack[i] = node;
    }
    imageWidth = image.width;
    imageHeight = image.height;
    imageY = -1;
    lineArray = new JavaArray("[B").lengths(imageWidth);
    imageX = imageWidth + 1;
    return;
  }
  public function nextCode__(): int {
    var code: int;
    if (bitsLeft == 0) {
      if (blockIndex >= blockSize) {
        blockSize = this.readBlock__();
        blockIndex = 0;
        if (blockSize == 0)
          return endCode;
      }
      blockIndex++;
      currentByte = block[blockIndex] & 0xFF;
      bitsLeft = 8;
      code = currentByte;
    } else {
      var shift: int = bitsLeft - 8;
      if (shift < 0)
        code = currentByte >> (0 - shift);
      else
        code = currentByte << shift;
    }
    while (codeSize > bitsLeft) {
      if (blockIndex >= blockSize) {
        blockSize = this.readBlock__();
        blockIndex = 0;
        if (blockSize == 0)
          return endCode;
      }
      blockIndex++;
      currentByte = block[blockIndex] & 0xFF;
      code += currentByte << bitsLeft;
      bitsLeft += 8;
    }
    bitsLeft -= codeSize;
    return code & codeMask;
  }
  public function nextPixel__(): int {
    imageX++;
    if (imageX > imageWidth) {
      imageY++;
      if (imageY >= imageHeight) {
        return -1;
      } else {
        this.nextPixels___3BI(lineArray, imageWidth);
      }
      imageX = 1;
    }
    return this.lineArray[imageX - 1] & 0xFF;
  }
  public function nextPixels___3BI(buf: JavaArray, lineWidth: int): void {
    if (image.depth == 8) {
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(image.data, imageY * image.bytesPerLine, buf, 0, lineWidth);
    } else {
      image.getPixels__III_3BI(0, imageY, lineWidth, buf, 0);
    }
    return;
  }
  public function nextPutCode__I(aCode: int): void {
    var codeToDo: int = aCode;
    var codeBitsToDo: int = codeSize;
    var c: int = codeToDo & MASK_TABLE[bitsLeft - 1];
    currentByte = currentByte | (c << (8 - bitsLeft));
    block[blockIndex] = int(currentByte);
    codeBitsToDo -= bitsLeft;
    if (codeBitsToDo < 1) {
      bitsLeft -= codeSize;
      if (bitsLeft == 0) {
        bitsLeft = 8;
        blockIndex++;
        if (blockIndex >= blockSize) {
          this.writeBlock__();
          blockIndex = 1;
        }
        currentByte = 0;
      }
      return;
    }
    codeToDo = codeToDo >> bitsLeft;
    blockIndex++;
    if (blockIndex >= blockSize) {
      this.writeBlock__();
      blockIndex = 1;
    }
    while (codeBitsToDo >= 8) {
      currentByte = codeToDo & 0xFF;
      block[blockIndex] = int(currentByte);
      codeToDo = codeToDo >> 8;
      codeBitsToDo -= 8;
      blockIndex++;
      if (blockIndex >= blockSize) {
        this.writeBlock__();
        blockIndex = 1;
      }
    }
    bitsLeft = 8 - codeBitsToDo;
    currentByte = codeToDo;
    block[blockIndex] = int(currentByte);
    return;
  }
  public function nextPutPixels___3B(buf: JavaArray): void {
    if (image.depth == 8) {
      var start: int = line * image.bytesPerLine;
      for (var i: int = 0; i < imageWidth; i++)
        image.data[start + i] = buf[i];
    } else {
      image.setPixels__III_3BI(0, line, imageWidth, buf, 0);
    }
    if (interlaced) {
      if (pass == 1) {
        this.copyRow___3BI(buf, 7);
        line += 8;
      } else if (pass == 2) {
        this.copyRow___3BI(buf, 3);
        line += 8;
      } else if (pass == 3) {
        this.copyRow___3BI(buf, 1);
        line += 4;
      } else if (pass == 4) {
        line += 2;
      } else if (pass == 5) {
        line += 0;
      }
      if (line >= imageHeight) {
        pass++;
        if (pass == 2)
          line = 4;
        else if (pass == 3)
          line = 2;
        else if (pass == 4)
          line = 1;
        else if (pass == 5)
          line = 0;
        if (pass < 5) {
          if (loader.hasListeners__()) {
            var imageCopy: ImageData = ImageData(image.clone__());
            loader.notifyListeners__Lorg_eclipse_swt_graphics_ImageLoaderEvent_2(new ImageLoaderEvent(loader, imageCopy, pass - 2, false));
          }
        }
      }
      if (line >= imageHeight)
        line = 0;
    } else {
      line++;
    }
    return;
  }
  public function copyRow___3BI(buf: JavaArray, copies: int): void {
    for (var i: int = 1; i <= copies; i++) {
      if (line + i < imageHeight) {
        image.setPixels__III_3BI(0, line + i, imageWidth, buf, 0);
      }
    }
    return;
  }
  public function readBlock__(): int {
    var size: int = -1;
    try {
      size = inputStream.read__();
      if (size == -1) {
        SWT.error__I(40);
      }
      block[0] = int(size);
      size = inputStream.read___3BII(block, 1, size);
      if (size == -1) {
        SWT.error__I(40);
      }
    } catch (e : Exception) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    return size;
  }
  public function writeBlock__(): void {
    try {
      outputStream.write___3BII(block, 0, (block[0] & 0xFF) + 1);
    } catch (e : Exception) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    return;
  }
}
}
