package org.eclipse.swt.internal.image {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import java.io.*;
import java.lang.Exception;
import org.eclipse.swt.SWT;
import java.io.IOException;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import java.io.OutputStream;
import java.lang.System;
import org.eclipse.swt.graphics.ImageLoader;
import java.io.ByteArrayOutputStream;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class OS2BMPFileFormat extends FileFormat {
  public static const BMPFileHeaderSize: int = 14;
  public static const BMPHeaderFixedSize: int = 12;
  internal var width: int;
  internal var height: int;
  internal var bitCount: int;
  public override function isFileFormat__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(stream: LEDataInputStream): Boolean {
    try {
      var header: JavaArray = new JavaArray("[B").lengths(18);
      stream.read___3B(header);
      stream.unread___3B(header);
      var infoHeaderSize: int = (header[14] & 0xFF) | ((header[15] & 0xFF) << 8) | ((header[16] & 0xFF) << 16) | ((header[17] & 0xFF) << 24);
      return header[0] == 0x42 && header[1] == 0x4D && infoHeaderSize == 12;
    } catch (e : Exception) {
      return false;
    }
    return false;
  }
  public function loadData___3B(infoHeader: JavaArray): JavaArray {
    var stride: int = int((width * bitCount + 7) / 8);
    stride = int((stride + 3) / 4) * 4;
    var data: JavaArray = this.loadData___3BI(infoHeader, stride);
    this.flipScanLines___3BII(data, stride, height);
    return data;
  }
  public function loadData___3BI(infoHeader: JavaArray, stride: int): JavaArray {
    var dataSize: int = height * stride;
    var data: JavaArray = new JavaArray("[B").lengths(dataSize);
    try {
      if (inputStream.read___3B(data) != dataSize)
        SWT.error__I(40);
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    return data;
  }
  public function loadFileHeader__(): JavaArray {
    var header: JavaArray = new JavaArray("[I").lengths(5);
    try {
      header[0] = inputStream.readShort__();
      header[1] = inputStream.readInt__();
      header[2] = inputStream.readShort__();
      header[3] = inputStream.readShort__();
      header[4] = inputStream.readInt__();
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    if (header[0] != 0x4D42)
      SWT.error__I(40);
    return header;
  }
  public override function loadFromByteStream__(): JavaArray {
    var fileHeader: JavaArray = this.loadFileHeader__();
    var infoHeader: JavaArray = new JavaArray("[B").lengths(12);
    try {
      inputStream.read___3B(infoHeader);
    } catch (e : Exception) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    width = (infoHeader[4] & 0xFF) | ((infoHeader[5] & 0xFF) << 8);
    height = (infoHeader[6] & 0xFF) | ((infoHeader[7] & 0xFF) << 8);
    bitCount = (infoHeader[10] & 0xFF) | ((infoHeader[11] & 0xFF) << 8);
    var palette: PaletteData = this.loadPalette___3B(infoHeader);
    if (inputStream.getPosition__() < fileHeader[4]) {
      try {
        inputStream.skip__J(fileHeader[4] - inputStream.getPosition__());
      } catch (e_1 : IOException) {
        SWT.error__ILjava_lang_Throwable_2(39, e_1);
      }
    }
    var data: JavaArray = this.loadData___3B(infoHeader);
    var type: int = 7;
    return new JavaArray("[Lorg/eclipse/swt/graphics/ImageData;").values(ImageData.internal_new__IIILorg_eclipse_swt_graphics_PaletteData_2I_3BI_3B_3BIIIIIII(width, height, bitCount, palette, 4, data, 0, null, null, -1, -1, type, 0, 0, 0, 0));
  }
  public function loadPalette___3B(infoHeader: JavaArray): PaletteData {
    if (bitCount <= 8) {
      var numColors: int = 1 << bitCount;
      var buf: JavaArray = new JavaArray("[B").lengths(numColors * 3);
      try {
        if (inputStream.read___3B(buf) != buf.length)
          SWT.error__I(40);
      } catch (e : IOException) {
        SWT.error__ILjava_lang_Throwable_2(39, e);
      }
      return this.paletteFromBytes___3BI(buf, numColors);
    }
    if (bitCount == 16)
      return new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData__III, [0x7C00, 0x3E0, 0x1F]));
    if (bitCount == 24)
      return new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData__III, [0xFF, 0xFF00, 0xFF0000]));
    return new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData__III, [0xFF00, 0xFF0000, 0xFF000000]));
  }
  public function paletteFromBytes___3BI(bytes: JavaArray, numColors: int): PaletteData {
    var bytesOffset: int = 0;
    var colors: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/RGB;").lengths(numColors);
    for (var i: int = 0; i < numColors; i++) {
      colors[i] = new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [bytes[bytesOffset + 2] & 0xFF, bytes[bytesOffset + 1] & 0xFF, bytes[bytesOffset] & 0xFF]));
      bytesOffset += 3;
    }
    return new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData___3Lorg_eclipse_swt_graphics_RGB_2, [colors]));
  }
  public static function paletteToBytes__Lorg_eclipse_swt_graphics_PaletteData_2(pal: PaletteData): JavaArray {
    var n: int = pal.colors === null ? 0 : (pal.colors.length < 256 ? pal.colors.length : 256);
    var bytes: JavaArray = new JavaArray("[B").lengths(n * 3);
    var offset: int = 0;
    for (var i: int = 0; i < n; i++) {
      var col: RGB = pal.colors[i];
      bytes[offset] = int(col.blue);
      bytes[offset + 1] = int(col.green);
      bytes[offset + 2] = int(col.red);
      offset += 3;
    }
    return bytes;
  }
  public function unloadData__Lorg_eclipse_swt_graphics_ImageData_2Ljava_io_OutputStream_2(image: ImageData, out: OutputStream): int {
    var bmpBpl: int = 0;
    try {
      var bpl: int = int((image.width * image.depth + 7) / 8);
      bmpBpl = int((bpl + 3) / 4) * 4;
      var linesPerBuf: int = int(32678 / bmpBpl);
      var buf: JavaArray = new JavaArray("[B").lengths(linesPerBuf * bmpBpl);
      var data: JavaArray = image.data;
      var imageBpl: int = image.bytesPerLine;
      var dataIndex: int = imageBpl * (image.height - 1);
      if (image.depth == 16) {
        for (var y: int = 0; y < image.height; y += linesPerBuf) {
          var count: int = image.height - y;
          if (linesPerBuf < count)
            count = linesPerBuf;
          var bufOffset: int = 0;
          for (var i: int = 0; i < count; i++) {
            for (var wIndex: int = 0; wIndex < bpl; wIndex += 2) {
              buf[bufOffset + wIndex + 1] = data[dataIndex + wIndex + 1];
              buf[bufOffset + wIndex] = data[dataIndex + wIndex];
            }
            bufOffset += bmpBpl;
            dataIndex -= imageBpl;
          }
          out.write___3BII(buf, 0, bufOffset);
        }
      } else {
        for (var y_1: int = 0; y_1 < image.height; y_1 += linesPerBuf) {
          var tmp: int = image.height - y_1;
          var count_1: int = tmp < linesPerBuf ? tmp : linesPerBuf;
          var bufOffset_1: int = 0;
          for (var i_1: int = 0; i_1 < count_1; i_1++) {
            System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(data, dataIndex, buf, bufOffset_1, bpl);
            bufOffset_1 += bmpBpl;
            dataIndex -= imageBpl;
          }
          out.write___3BII(buf, 0, bufOffset_1);
        }
      }
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    return bmpBpl * image.height;
  }
  public override function unloadIntoByteStream__Lorg_eclipse_swt_graphics_ImageLoader_2(loader_1: ImageLoader): void {
    var image: ImageData = loader_1.data[0];
    var rgbs: JavaArray;
    var numCols: int;
    if (!((image.depth == 1) || (image.depth == 4) || (image.depth == 8) || (image.depth == 16) || (image.depth == 24) || (image.depth == 32)))
      SWT.error__I(38);
    var pal: PaletteData = image.palette;
    if ((image.depth == 16) || (image.depth == 24) || (image.depth == 32)) {
      if (!pal.isDirect)
        SWT.error__I(40);
      numCols = 0;
      rgbs = null;
    } else {
      if (pal.isDirect)
        SWT.error__I(40);
      numCols = pal.colors.length;
      rgbs = OS2BMPFileFormat.paletteToBytes__Lorg_eclipse_swt_graphics_PaletteData_2(pal);
    }
    var headersSize: int = 14 + 12;
    var fileHeader: JavaArray = new JavaArray("[I").lengths(5);
    fileHeader[0] = 0x4D42;
    fileHeader[1] = 0;
    fileHeader[2] = 0;
    fileHeader[3] = 0;
    fileHeader[4] = headersSize;
    if (rgbs !== null) {
      fileHeader[4] += rgbs.length;
    }
    var out: ByteArrayOutputStream = new ByteArrayOutputStream(new Arguments(java.io.ByteArrayOutputStream.ByteArrayOutputStream__, []));
    this.unloadData__Lorg_eclipse_swt_graphics_ImageData_2Ljava_io_OutputStream_2(image, out);
    var data: JavaArray = out.toByteArray__();
    fileHeader[1] = fileHeader[4] + data.length;
    try {
      outputStream.writeShort__I(fileHeader[0]);
      outputStream.writeInt__I(fileHeader[1]);
      outputStream.writeShort__I(fileHeader[2]);
      outputStream.writeShort__I(fileHeader[3]);
      outputStream.writeInt__I(fileHeader[4]);
    } catch (e : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e);
    }
    try {
      outputStream.writeInt__I(12);
      outputStream.writeShort__I(image.width);
      outputStream.writeShort__I(image.height);
      outputStream.writeShort__I(1);
      outputStream.writeShort__I(int(image.depth));
    } catch (e_1 : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e_1);
    }
    if (numCols > 0) {
      try {
        outputStream.write___3B(rgbs);
      } catch (e_2 : IOException) {
        SWT.error__ILjava_lang_Throwable_2(39, e_2);
      }
    }
    try {
      outputStream.write___3B(data);
    } catch (e_3 : IOException) {
      SWT.error__ILjava_lang_Throwable_2(39, e_3);
    }
    return;
  }
  public function flipScanLines___3BII(data: JavaArray, stride: int, height_1: int): void {
    var i1: int = 0;
    var i2: int = (height_1 - 1) * stride;
    for (var i: int = 0; i < int(height_1 / 2); i++) {
      for (var index: int = 0; index < stride; index++) {
        var b: int = data[index + i1];
        data[index + i1] = data[index + i2];
        data[index + i2] = b;
      }
      i1 += stride;
      i2 -= stride;
    }
    return;
  }
}
}
