package org.eclipse.swt.internal.image {
import java.io.*;
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.internal.*;
import org.eclipse.swt.graphics.ImageData;
import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.ImageLoader;
import java.lang.Exception;
import java.io.InputStream;
import java.lang.System;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import java.lang.Math__;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class PNGFileFormat extends FileFormat {
  public static const SIGNATURE_LENGTH: int = 8;
  public static const PRIME: int = 65521;
  internal var headerChunk: PngIhdrChunk;
  internal var paletteChunk: PngPlteChunk;
  internal var imageData: ImageData;
  internal var data: JavaArray;
  internal var alphaPalette: JavaArray;
  internal var headerByte1: int;
  internal var headerByte2: int;
  internal var adler: int;
  public function readSignature__(): void {
    var signature: JavaArray = new JavaArray("[B").lengths(8);
    inputStream.read___3B(signature);
    return;
  }
  public override function loadFromByteStream__(): JavaArray {
    try {
      this.readSignature__();
      var chunkReader: PngChunkReader = new PngChunkReader(inputStream);
      headerChunk = chunkReader.getIhdrChunk__();
      var width: int = headerChunk.getWidth__();
      var height: int = headerChunk.getHeight__();
      if (width <= 0 || height <= 0)
        SWT.error__I(40);
      var imageSize: int = this.getAlignedBytesPerRow__() * height;
      data = new JavaArray("[B").lengths(imageSize);
      imageData = ImageData.internal_new__IIILorg_eclipse_swt_graphics_PaletteData_2I_3BI_3B_3BIIIIIII(width, height, headerChunk.getSwtBitsPerPixel__(), new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData__III, [0, 0, 0])), 4, data, 0, null, null, -1, -1, 5, 0, 0, 0, 0);
      if (headerChunk.usesDirectColor__()) {
        imageData.palette = headerChunk.getPaletteData__();
      }
      while (chunkReader.hasMoreChunks__()) {
        this.readNextChunk__Lorg_eclipse_swt_internal_image_PngChunkReader_2(chunkReader);
      }
      return new JavaArray("[Lorg/eclipse/swt/graphics/ImageData;").values(imageData);
    } catch (e : IOException) {
      SWT.error__I(40);
      return null;
    }
    return null;
  }
  public function readNextChunk__Lorg_eclipse_swt_internal_image_PngChunkReader_2(chunkReader: PngChunkReader): void {
    var chunk: PngChunk = chunkReader.readNextChunk__();
    switch (chunk.getChunkType__()) {
      case 3 :
        break;
      case 1 :
        if (!headerChunk.usesDirectColor__()) {
          paletteChunk = PngPlteChunk(chunk);
          imageData.palette = paletteChunk.getPaletteData__();
        }
        break;
      case 5 :
        var trnsChunk: PngTrnsChunk = PngTrnsChunk(chunk);
        if (trnsChunk.getTransparencyType__Lorg_eclipse_swt_internal_image_PngIhdrChunk_2(headerChunk) == 0) {
          imageData.transparentPixel = trnsChunk.getSwtTransparentPixel__Lorg_eclipse_swt_internal_image_PngIhdrChunk_2(headerChunk);
        } else {
          alphaPalette = trnsChunk.getAlphaValues__Lorg_eclipse_swt_internal_image_PngIhdrChunk_2Lorg_eclipse_swt_internal_image_PngPlteChunk_2(headerChunk, paletteChunk);
          var transparentCount: int = 0;
          var transparentPixel: int = -1;
          for (var i: int = 0; i < alphaPalette.length; i++) {
            if ((alphaPalette[i] & 0xFF) != 255) {
              transparentCount++;
              transparentPixel = i;
            }
          }
          if (transparentCount == 0) {
            alphaPalette = null;
          } else if (transparentCount == 1 && alphaPalette[transparentPixel] == 0) {
            alphaPalette = null;
            imageData.transparentPixel = transparentPixel;
          }
        }
        break;
      case 2 :
        if (chunkReader.readPixelData__()) {
          SWT.error__I(40);
        } else {
          var dataChunk: PngIdatChunk = PngIdatChunk(chunk);
          this.readPixelData__Lorg_eclipse_swt_internal_image_PngIdatChunk_2Lorg_eclipse_swt_internal_image_PngChunkReader_2(dataChunk, chunkReader);
        }
        break;
      default :
        if (chunk.isCritical__()) {
          SWT.error__I(20);
        }
    }
    return;
  }
  public override function unloadIntoByteStream__Lorg_eclipse_swt_graphics_ImageLoader_2(loader_1: ImageLoader): void {
    var encoder: PngEncoder = new PngEncoder(loader_1);
    encoder.encode__Lorg_eclipse_swt_internal_image_LEDataOutputStream_2(outputStream);
    return;
  }
  public override function isFileFormat__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(stream: LEDataInputStream): Boolean {
    try {
      var signature: JavaArray = new JavaArray("[B").lengths(8);
      stream.read___3B(signature);
      stream.unread___3B(signature);
      if ((signature[0] & 0xFF) != 137)
        return false;
      if ((signature[1] & 0xFF) != 80)
        return false;
      if ((signature[2] & 0xFF) != 78)
        return false;
      if ((signature[3] & 0xFF) != 71)
        return false;
      if ((signature[4] & 0xFF) != 13)
        return false;
      if ((signature[5] & 0xFF) != 10)
        return false;
      if ((signature[6] & 0xFF) != 26)
        return false;
      if ((signature[7] & 0xFF) != 10)
        return false;
      return true;
    } catch (e : Exception) {
      return false;
    }
    return false;
  }
  public function validateBitDepth___3B(data_1: JavaArray): JavaArray {
    if (headerChunk.getBitDepth__() > 8) {
      var result: JavaArray = new JavaArray("[B").lengths(int(data_1.length / 2));
      PNGFileFormat.compress16BitDepthTo8BitDepth___3BI_3BII(data_1, 0, result, 0, result.length);
      return result;
    } else {
      return data_1;
    }
    return null;
  }
  public function setPixelData___3BLorg_eclipse_swt_graphics_ImageData_2(data_1: JavaArray, imageData_1: ImageData): void {
    switch (headerChunk.getColorType__()) {
      case 4 :
        {
          var width: int = imageData_1.width;
          var height: int = imageData_1.height;
          var destBytesPerLine: int = imageData_1.bytesPerLine;
          var srcBytesPerLine: int = this.getAlignedBytesPerRow__();
          if (headerChunk.getBitDepth__() > 8)
            srcBytesPerLine /= 2;
          var rgbData: JavaArray = new JavaArray("[B").lengths(destBytesPerLine * height);
          var alphaData: JavaArray = new JavaArray("[B").lengths(width * height);
          for (var y: int = 0; y < height; y++) {
            var srcIndex: int = srcBytesPerLine * y;
            var destIndex: int = destBytesPerLine * y;
            var destAlphaIndex: int = width * y;
            for (var x: int = 0; x < width; x++) {
              var grey: int = data_1[srcIndex];
              var alpha: int = data_1[srcIndex + 1];
              rgbData[destIndex + 0] = grey;
              rgbData[destIndex + 1] = grey;
              rgbData[destIndex + 2] = grey;
              alphaData[destAlphaIndex] = alpha;
              srcIndex += 2;
              destIndex += 3;
              destAlphaIndex++;
            }
          }
          imageData_1.data = rgbData;
          imageData_1.alphaData = alphaData;
          break;
        }
      case 6 :
        {
          var width_1: int = imageData_1.width;
          var height_1: int = imageData_1.height;
          var destBytesPerLine_1: int = imageData_1.bytesPerLine;
          var srcBytesPerLine_1: int = this.getAlignedBytesPerRow__();
          if (headerChunk.getBitDepth__() > 8)
            srcBytesPerLine_1 /= 2;
          var rgbData_1: JavaArray = new JavaArray("[B").lengths(destBytesPerLine_1 * height_1);
          var alphaData_1: JavaArray = new JavaArray("[B").lengths(width_1 * height_1);
          for (var y_1: int = 0; y_1 < height_1; y_1++) {
            var srcIndex_1: int = srcBytesPerLine_1 * y_1;
            var destIndex_1: int = destBytesPerLine_1 * y_1;
            var destAlphaIndex_1: int = width_1 * y_1;
            for (var x_1: int = 0; x_1 < width_1; x_1++) {
              rgbData_1[destIndex_1 + 0] = data_1[srcIndex_1 + 0];
              rgbData_1[destIndex_1 + 1] = data_1[srcIndex_1 + 1];
              rgbData_1[destIndex_1 + 2] = data_1[srcIndex_1 + 2];
              alphaData_1[destAlphaIndex_1] = data_1[srcIndex_1 + 3];
              srcIndex_1 += 4;
              destIndex_1 += 3;
              destAlphaIndex_1++;
            }
          }
          imageData_1.data = rgbData_1;
          imageData_1.alphaData = alphaData_1;
          break;
        }
      case 2 :
        imageData_1.data = data_1;
        break;
      case 3 :
        imageData_1.data = data_1;
        if (alphaPalette !== null) {
          var size: int = imageData_1.width * imageData_1.height;
          var alphaData_2: JavaArray = new JavaArray("[B").lengths(size);
          var pixelData: JavaArray = new JavaArray("[B").lengths(size);
          imageData_1.getPixels__III_3BI(0, 0, size, pixelData, 0);
          for (var i: int = 0; i < pixelData.length; i++) {
            alphaData_2[i] = alphaPalette[pixelData[i] & 0xFF];
          }
          imageData_1.alphaData = alphaData_2;
        }
        break;
      default :
        imageData_1.data = data_1;
        break;
    }
    return;
  }
  public function setImageDataValues___3BLorg_eclipse_swt_graphics_ImageData_2(data_1: JavaArray, imageData_1: ImageData): void {
    var result: JavaArray = this.validateBitDepth___3B(data_1);
    this.setPixelData___3BLorg_eclipse_swt_graphics_ImageData_2(result, imageData_1);
    return;
  }
  public function readPixelData__Lorg_eclipse_swt_internal_image_PngIdatChunk_2Lorg_eclipse_swt_internal_image_PngChunkReader_2(chunk: PngIdatChunk, chunkReader: PngChunkReader): void {
    var stream: InputStream = new PngInputStream(chunk, chunkReader);
    var use3_2: Boolean = System.getProperty__Ljava_lang_String_2("org.eclipse.swt.internal.image.PNGFileFormat_3.2") !== null;
    var inflaterStream: InputStream = use3_2 ? null : Compatibility.newInflaterInputStream__Ljava_io_InputStream_2(stream);
    if (inflaterStream !== null) {
      stream = inflaterStream;
    } else {
      stream = new PngDecodingDataStream(stream);
    }
    var interlaceMethod: int = headerChunk.getInterlaceMethod__();
    if (interlaceMethod == 0) {
      this.readNonInterlacedImage__Ljava_io_InputStream_2(stream);
    } else {
      this.readInterlacedImage__Ljava_io_InputStream_2(stream);
    }
    while (stream.available__() > 0)
      stream.read__();
    stream.close__();
    return;
  }
  public function getAlignedBytesPerRow__(): int {
    return (int((this.getBytesPerRow__I(headerChunk.getWidth__()) + 3) / 4)) * 4;
  }
  public function getBytesPerRow__(): int {
    return this.getBytesPerRow__I(headerChunk.getWidth__());
  }
  public function getBytesPerPixel__(): int {
    var bitsPerPixel: int = headerChunk.getBitsPerPixel__();
    return int((bitsPerPixel + 7) / 8);
  }
  public function getBytesPerRow__I(rowWidthInPixels: int): int {
    var bitsPerPixel: int = headerChunk.getBitsPerPixel__();
    var bitsPerRow: int = bitsPerPixel * rowWidthInPixels;
    var bitsPerByte: int = 8;
    return int((bitsPerRow + (bitsPerByte - 1)) / bitsPerByte);
  }
  public function readInterlaceFrame__Ljava_io_InputStream_2IIIII(inputStream_1: InputStream, rowInterval: int, columnInterval: int, startRow: int, startColumn: int, frameCount: int): void {
    var width: int = headerChunk.getWidth__();
    var alignedBytesPerRow: int = this.getAlignedBytesPerRow__();
    var height: int = headerChunk.getHeight__();
    if (startRow >= height || startColumn >= width)
      return;
    var pixelsPerRow: int = int((width - startColumn + columnInterval - 1) / columnInterval);
    var bytesPerRow: int = this.getBytesPerRow__I(pixelsPerRow);
    var row1: JavaArray = new JavaArray("[B").lengths(bytesPerRow);
    var row2: JavaArray = new JavaArray("[B").lengths(bytesPerRow);
    var currentRow: JavaArray = row1;
    var lastRow: JavaArray = row2;
    for (var row: int = startRow; row < height; row += rowInterval) {
      var filterType: int = int(inputStream_1.read__());
      var read: int = 0;
      while (read != bytesPerRow) {
        read += inputStream_1.read___3BII(currentRow, read, bytesPerRow - read);
      }
      this.filterRow___3B_3BI(currentRow, lastRow, filterType);
      if (headerChunk.getBitDepth__() >= 8) {
        var bytesPerPixel: int = this.getBytesPerPixel__();
        var dataOffset: int = (row * alignedBytesPerRow) + (startColumn * bytesPerPixel);
        for (var rowOffset: int = 0; rowOffset < currentRow.length; rowOffset += bytesPerPixel) {
          for (var byteOffset: int = 0; byteOffset < bytesPerPixel; byteOffset++) {
            data[dataOffset + byteOffset] = currentRow[rowOffset + byteOffset];
          }
          dataOffset += (columnInterval * bytesPerPixel);
        }
      } else {
        var bitsPerPixel: int = headerChunk.getBitDepth__();
        var pixelsPerByte: int = int(8 / bitsPerPixel);
        var column: int = startColumn;
        var rowBase: int = row * alignedBytesPerRow;
        var valueMask: int = 0;
        for (var i: int = 0; i < bitsPerPixel; i++) {
          valueMask <<= 1;
          valueMask |= 1;
        }
        var maxShift: int = 8 - bitsPerPixel;
        for (var byteOffset_1: int = 0; byteOffset_1 < currentRow.length; byteOffset_1++) {
          for (var bitOffset: int = maxShift; bitOffset >= 0; bitOffset -= bitsPerPixel) {
            if (column < width) {
              var dataOffset_1: int = rowBase + (int(column * bitsPerPixel / 8));
              var value: int = (currentRow[byteOffset_1] >> bitOffset) & valueMask;
              var dataShift: int = maxShift - (bitsPerPixel * (column % pixelsPerByte));
              data[dataOffset_1] |= value << dataShift;
            }
            column += columnInterval;
          }
        }
      }
      currentRow = (currentRow === row1) ? row2 : row1;
      lastRow = (lastRow === row1) ? row2 : row1;
    }
    this.setImageDataValues___3BLorg_eclipse_swt_graphics_ImageData_2(data, imageData);
    this.fireInterlacedFrameEvent__I(frameCount);
    return;
  }
  public function readInterlacedImage__Ljava_io_InputStream_2(inputStream_1: InputStream): void {
    this.readInterlaceFrame__Ljava_io_InputStream_2IIIII(inputStream_1, 8, 8, 0, 0, 0);
    this.readInterlaceFrame__Ljava_io_InputStream_2IIIII(inputStream_1, 8, 8, 0, 4, 1);
    this.readInterlaceFrame__Ljava_io_InputStream_2IIIII(inputStream_1, 8, 4, 4, 0, 2);
    this.readInterlaceFrame__Ljava_io_InputStream_2IIIII(inputStream_1, 4, 4, 0, 2, 3);
    this.readInterlaceFrame__Ljava_io_InputStream_2IIIII(inputStream_1, 4, 2, 2, 0, 4);
    this.readInterlaceFrame__Ljava_io_InputStream_2IIIII(inputStream_1, 2, 2, 0, 1, 5);
    this.readInterlaceFrame__Ljava_io_InputStream_2IIIII(inputStream_1, 2, 1, 1, 0, 6);
    return;
  }
  public function fireInterlacedFrameEvent__I(frameCount: int): void {
    if (loader.hasListeners__()) {
      var image: ImageData = ImageData(imageData.clone__());
      var finalFrame: Boolean = frameCount == 6;
      loader.notifyListeners__Lorg_eclipse_swt_graphics_ImageLoaderEvent_2(new ImageLoaderEvent(loader, image, frameCount, finalFrame));
    }
    return;
  }
  public function readNonInterlacedImage__Ljava_io_InputStream_2(inputStream_1: InputStream): void {
    var dataOffset: int = 0;
    var alignedBytesPerRow: int = this.getAlignedBytesPerRow__();
    var bytesPerRow: int = this.getBytesPerRow__();
    var row1: JavaArray = new JavaArray("[B").lengths(bytesPerRow);
    var row2: JavaArray = new JavaArray("[B").lengths(bytesPerRow);
    var currentRow: JavaArray = row1;
    var lastRow: JavaArray = row2;
    var height: int = headerChunk.getHeight__();
    for (var row: int = 0; row < height; row++) {
      var filterType: int = int(inputStream_1.read__());
      var read: int = 0;
      while (read != bytesPerRow) {
        read += inputStream_1.read___3BII(currentRow, read, bytesPerRow - read);
      }
      this.filterRow___3B_3BI(currentRow, lastRow, filterType);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(currentRow, 0, data, dataOffset, bytesPerRow);
      dataOffset += alignedBytesPerRow;
      currentRow = (currentRow === row1) ? row2 : row1;
      lastRow = (lastRow === row1) ? row2 : row1;
    }
    this.setImageDataValues___3BLorg_eclipse_swt_graphics_ImageData_2(data, imageData);
    return;
  }
  public static function compress16BitDepthTo8BitDepth___3BI_3BII(source: JavaArray, sourceOffset: int, destination: JavaArray, destinationOffset: int, numberOfValues: int): void {
    for (var i: int = 0; i < numberOfValues; i++) {
      var sourceIndex: int = sourceOffset + (2 * i);
      var destinationIndex: int = destinationOffset + i;
      var compressedValue: int = source[sourceIndex];
      destination[destinationIndex] = compressedValue;
    }
    return;
  }
  public static function compress16BitDepthTo8BitDepth__I(value: int): int {
    return value >> 8;
  }
  public function filterRow___3B_3BI(row: JavaArray, previousRow: JavaArray, filterType: int): void {
    var byteOffset: int = headerChunk.getFilterByteOffset__();
    switch (filterType) {
      case 0 :
        break;
      case 1 :
        for (var i: int = byteOffset; i < row.length; i++) {
          var current: int = row[i] & 0xFF;
          var left: int = row[i - byteOffset] & 0xFF;
          row[i] = int(((current + left) & 0xFF));
        }
        break;
      case 2 :
        for (var i_1: int = 0; i_1 < row.length; i_1++) {
          var current_1: int = row[i_1] & 0xFF;
          var above: int = previousRow[i_1] & 0xFF;
          row[i_1] = int(((current_1 + above) & 0xFF));
        }
        break;
      case 3 :
        for (var i_2: int = 0; i_2 < row.length; i_2++) {
          var left_1: int = (i_2 < byteOffset) ? 0 : row[i_2 - byteOffset] & 0xFF;
          var above_1: int = previousRow[i_2] & 0xFF;
          var current_2: int = row[i_2] & 0xFF;
          row[i_2] = int(((current_2 + (int((left_1 + above_1) / 2))) & 0xFF));
        }
        break;
      case 4 :
        for (var i_3: int = 0; i_3 < row.length; i_3++) {
          var left_2: int = (i_3 < byteOffset) ? 0 : row[i_3 - byteOffset] & 0xFF;
          var aboveLeft: int = (i_3 < byteOffset) ? 0 : previousRow[i_3 - byteOffset] & 0xFF;
          var above_2: int = previousRow[i_3] & 0xFF;
          var a: int = Math__.abs__I(above_2 - aboveLeft);
          var b: int = Math__.abs__I(left_2 - aboveLeft);
          var c: int = Math__.abs__I(left_2 - aboveLeft + above_2 - aboveLeft);
          var preductor: int = 0;
          if (a <= b && a <= c) {
            preductor = left_2;
          } else if (b <= c) {
            preductor = above_2;
          } else {
            preductor = aboveLeft;
          }
          var currentValue: int = row[i_3] & 0xFF;
          row[i_3] = int(((currentValue + preductor) & 0xFF));
        }
        break;
    }
    return;
  }
}
}
