package org.eclipse.swt.internal.image {
import org.eclipse.swt.*;
import java.io.*;
import org.eclipse.swt.SWT;
import java.lang.System;
import java.io.IOException;
import java.lang.StringBuffer;
import java.lang.Integer;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class PngChunk {
  internal var reference: JavaArray;
  public static const LENGTH_OFFSET: int = 0;
  public static const TYPE_OFFSET: int = 4;
  public static const DATA_OFFSET: int = 8;
  public static const TYPE_FIELD_LENGTH: int = 4;
  public static const LENGTH_FIELD_LENGTH: int = 4;
  public static const MIN_LENGTH: int = 12;
  public static const CHUNK_UNKNOWN: int = -1;
  public static const CHUNK_IHDR: int = 0;
  public static const CHUNK_PLTE: int = 1;
  public static const CHUNK_IDAT: int = 2;
  public static const CHUNK_IEND: int = 3;
  public static const CHUNK_tRNS: int = 5;
  public static var TYPE_IHDR: JavaArray = new JavaArray("[B").values(int(73), int(72), int(68), int(82));
  public static var TYPE_PLTE: JavaArray = new JavaArray("[B").values(int(80), int(76), int(84), int(69));
  public static var TYPE_IDAT: JavaArray = new JavaArray("[B").values(int(73), int(68), int(65), int(84));
  public static var TYPE_IEND: JavaArray = new JavaArray("[B").values(int(73), int(69), int(78), int(68));
  public static var TYPE_tRNS: JavaArray = new JavaArray("[B").values(int(116), int(82), int(78), int(83));
  public static var CRC_TABLE: JavaArray;
  internal var length: int;

  __clinit();

  static private function __clinit(): void {
    {
      CRC_TABLE = new JavaArray("[I").lengths(256);
      for (var i: int = 0; i < 256; i++) {
        CRC_TABLE[i] = i;
        for (var j: int = 0; j < 8; j++) {
          if ((CRC_TABLE[i] & 0x1) == 0) {
            CRC_TABLE[i] = (CRC_TABLE[i] >> 1) & 0x7FFFFFFF;
          } else {
            CRC_TABLE[i] = 0xEDB88320 ^ ((CRC_TABLE[i] >> 1) & 0x7FFFFFFF);
          }
        }
      }
    }
  }
  public function PngChunk___3B(reference: JavaArray): Object {
    this.setReference___3B(reference);
    if (reference.length < 0 + 4)
      SWT.error__I(40);
    length = this.getInt32__I(0);
    return this;
  }
  public function PngChunk__I(dataLength: int): Object {
    this.setLength__I(dataLength);
    return this;
  }
  public function getReference__(): JavaArray {
    return reference;
  }
  public function setReference___3B(reference_1: JavaArray): void {
    this.reference = reference_1;
  }
  public function getInt16__I(offset: int): int {
    var answer: int = 0;
    answer |= (reference[offset] & 0xFF) << 8;
    answer |= (reference[offset + 1] & 0xFF);
    return answer;
  }
  public function setInt16__II(offset: int, value: int): void {
    reference[offset] = int(((value >> 8) & 0xFF));
    reference[offset + 1] = int((value & 0xFF));
  }
  public function getInt32__I(offset: int): int {
    var answer: int = 0;
    answer |= (reference[offset] & 0xFF) << 24;
    answer |= (reference[offset + 1] & 0xFF) << 16;
    answer |= (reference[offset + 2] & 0xFF) << 8;
    answer |= (reference[offset + 3] & 0xFF);
    return answer;
  }
  public function setInt32__II(offset: int, value: int): void {
    reference[offset] = int(((value >> 24) & 0xFF));
    reference[offset + 1] = int(((value >> 16) & 0xFF));
    reference[offset + 2] = int(((value >> 8) & 0xFF));
    reference[offset + 3] = int((value & 0xFF));
  }
  public function getLength__(): int {
    return length;
  }
  public function setLength__I(value: int): void {
    this.setInt32__II(0, value);
    length = value;
  }
  public function getTypeBytes__(): JavaArray {
    var type: JavaArray = new JavaArray("[B").lengths(4);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(reference, 4, type, 0, 4);
    return type;
  }
  public function setType___3B(value: JavaArray): void {
    if (value.length != 4) {
      SWT.error__I(5);
    }
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(value, 0, reference, 4, 4);
    return;
  }
  public function getData__(): JavaArray {
    var dataLength: int = this.getLength__();
    if (reference.length < 12 + dataLength) {
      SWT.error__I(6);
    }
    var data: JavaArray = new JavaArray("[B").lengths(dataLength);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(reference, 8, data, 0, dataLength);
    return data;
  }
  public function setData___3B(data: JavaArray): void {
    this.setLength__I(data.length);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(data, 0, reference, 8, data.length);
    this.setCRC__I(this.computeCRC__());
  }
  public function getCRC__(): int {
    var crcOffset: int = 8 + this.getLength__();
    return this.getInt32__I(crcOffset);
  }
  public function setCRC__I(value: int): void {
    var crcOffset: int = 8 + this.getLength__();
    this.setInt32__II(crcOffset, value);
  }
  public function getSize__(): int {
    return 12 + this.getLength__();
  }
  public function checkCRC__(): Boolean {
    var crc: int = this.computeCRC__();
    var storedCRC: int = this.getCRC__();
    return crc == storedCRC;
  }
  public function computeCRC__(): int {
    var crc: int = 0xFFFFFFFF;
    var start: int = 4;
    var stop: int = 8 + this.getLength__();
    for (var i: int = start; i < stop; i++) {
      var index: int = (crc ^ reference[i]) & 0xFF;
      crc = CRC_TABLE[index] ^ ((crc >> 8) & 0x00FFFFFF);
    }
    return ~crc;
  }
  public function typeMatchesArray___3B(array: JavaArray): Boolean {
    for (var i: int = 0; i < 4; i++) {
      if (reference[4 + i] != array[i]) {
        return false;
      }
    }
    return true;
  }
  public function isCritical__(): Boolean {
    var c: uint = uint(this.getTypeBytes__()[0]);
    return 65 <= c && c <= 90;
  }
  public function getChunkType__(): int {
    if (this.typeMatchesArray___3B(TYPE_IHDR))
      return 0;
    if (this.typeMatchesArray___3B(TYPE_PLTE))
      return 1;
    if (this.typeMatchesArray___3B(TYPE_IDAT))
      return 2;
    if (this.typeMatchesArray___3B(TYPE_IEND))
      return 3;
    if (this.typeMatchesArray___3B(TYPE_tRNS))
      return 5;
    return -1;
  }
  public static function readNextFromStream__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(stream: LEDataInputStream): PngChunk {
    try {
      var headerLength: int = 4 + 4;
      var headerBytes: JavaArray = new JavaArray("[B").lengths(headerLength);
      var result: int = stream.read___3BII(headerBytes, 0, headerLength);
      stream.unread___3B(headerBytes);
      if (result != headerLength)
        return null;
      var tempChunk: PngChunk = new PngChunk(new Arguments(org.eclipse.swt.internal.image.PngChunk.PngChunk___3B, [headerBytes]));
      var chunkLength: int = tempChunk.getSize__();
      var chunk: JavaArray = new JavaArray("[B").lengths(chunkLength);
      result = stream.read___3BII(chunk, 0, chunkLength);
      if (result != chunkLength)
        return null;
      switch (tempChunk.getChunkType__()) {
        case 0 :
          return new PngIhdrChunk(new Arguments(org.eclipse.swt.internal.image.PngIhdrChunk.PngIhdrChunk___3B, [chunk]));
        case 1 :
          return new PngPlteChunk(new Arguments(org.eclipse.swt.internal.image.PngPlteChunk.PngPlteChunk___3B, [chunk]));
        case 2 :
          return new PngIdatChunk(new Arguments(org.eclipse.swt.internal.image.PngIdatChunk.PngIdatChunk___3B, [chunk]));
        case 3 :
          return new PngIendChunk(new Arguments(org.eclipse.swt.internal.image.PngIendChunk.PngIendChunk___3B, [chunk]));
        case 5 :
          return new PngTrnsChunk(new Arguments(org.eclipse.swt.internal.image.PngTrnsChunk.PngTrnsChunk___3B, [chunk]));
        default :
          return new PngChunk(new Arguments(org.eclipse.swt.internal.image.PngChunk.PngChunk___3B, [chunk]));
      }
    } catch (e : IOException) {
      return null;
    }
    return null;
  }
  public function validate__Lorg_eclipse_swt_internal_image_PngFileReadState_2Lorg_eclipse_swt_internal_image_PngIhdrChunk_2(readState: PngFileReadState, headerChunk: PngIhdrChunk): void {
    if (reference.length < 12)
      SWT.error__I(40);
    var type: JavaArray = this.getTypeBytes__();
    var c: uint = uint(type[2]);
    if (!(65 <= c && c <= 90))
      SWT.error__I(40);
    for (var i: int = 0; i < 4; i++) {
      c = uint(type[i]);
      if (!((97 <= c && c <= 122) || (65 <= c && c <= 90))) {
        SWT.error__I(40);
      }
    }
    if (!this.checkCRC__())
      SWT.error__I(40);
    return;
  }
  public function contributeToString__Ljava_lang_StringBuffer_2(buffer: StringBuffer): void {
  }
  public function toString__(): String {
    var buffer: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__, []));
    buffer.append__Ljava_lang_String_2("{");
    buffer.append__Ljava_lang_String_2("\n\tLength: ");
    buffer.append__I(this.getLength__());
    buffer.append__Ljava_lang_String_2("\n\tType: ");
    var type: JavaArray = this.getTypeBytes__();
    for (var i: int = 0; i < type.length; i++) {
      buffer.append__C(uint(type[i]));
    }
    this.contributeToString__Ljava_lang_StringBuffer_2(buffer);
    buffer.append__Ljava_lang_String_2("\n\tCRC: ");
    buffer.append__Ljava_lang_String_2(Integer.toHexString__I(this.getCRC__()));
    buffer.append__Ljava_lang_String_2("\n}");
    return buffer.toString__();
  }
  public function PngChunk(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is JavaArray) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        break;
      case 1:
        var args1: Array = [args[0]];
        args0 = [new JavaArray("[B").lengths(12 + args1[0])];
        break;
    }
    super();
    switch (id) {
      case 0:
        PngChunk___3B(args0[0]);
        break;
      case 1:
        PngChunk___3B(args0[0]);
        PngChunk__I(args1[0]);
        break;
    }
  }
  public static const PngChunk___3B : int = 0;
  public static const PngChunk__I : int = 1;
}
}
