package org.eclipse.swt.internal.image {
import org.eclipse.swt.*;
import org.eclipse.swt.SWT;
import java.lang.ClassCastException;
dynamic public class PngChunkReader {
  internal var inputStream: LEDataInputStream;
  internal var readState: PngFileReadState;
  internal var headerChunk: PngIhdrChunk;
  internal var paletteChunk: PngPlteChunk;
  function PngChunkReader(inputStream: LEDataInputStream) {
    this.inputStream = inputStream;
    readState = new PngFileReadState();
    headerChunk = null;
    return;
  }
  public function getIhdrChunk__(): PngIhdrChunk {
    if (headerChunk === null) {
      try {
        var chunk: PngChunk = PngChunk.readNextFromStream__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(inputStream);
        if (chunk === null)
          SWT.error__I(40);
        headerChunk = PngIhdrChunk(chunk);
        headerChunk.validate__Lorg_eclipse_swt_internal_image_PngFileReadState_2Lorg_eclipse_swt_internal_image_PngIhdrChunk_2(readState, null);
      } catch (e : ClassCastException) {
        SWT.error__I(40);
      }
    }
    return headerChunk;
  }
  public function readNextChunk__(): PngChunk {
    if (headerChunk === null)
      return this.getIhdrChunk__();
    var chunk: PngChunk = PngChunk.readNextFromStream__Lorg_eclipse_swt_internal_image_LEDataInputStream_2(inputStream);
    if (chunk === null)
      SWT.error__I(40);
    switch (chunk.getChunkType__()) {
      case 5 :
        (PngTrnsChunk(chunk)).validate__Lorg_eclipse_swt_internal_image_PngFileReadState_2Lorg_eclipse_swt_internal_image_PngIhdrChunk_2Lorg_eclipse_swt_internal_image_PngPlteChunk_2(readState, headerChunk, paletteChunk);
        break;
      case 1 :
        chunk.validate__Lorg_eclipse_swt_internal_image_PngFileReadState_2Lorg_eclipse_swt_internal_image_PngIhdrChunk_2(readState, headerChunk);
        paletteChunk = PngPlteChunk(chunk);
        break;
      default :
        chunk.validate__Lorg_eclipse_swt_internal_image_PngFileReadState_2Lorg_eclipse_swt_internal_image_PngIhdrChunk_2(readState, headerChunk);
    }
    if (readState.readIDAT && !(chunk.getChunkType__() == 2)) {
      readState.readPixelData = true;
    }
    return chunk;
  }
  public function readPixelData__(): Boolean {
    return readState.readPixelData;
  }
  public function hasMoreChunks__(): Boolean {
    return !readState.readIEND;
  }
}
}
