package org.eclipse.swt.internal.image {
import java.io.*;
import org.eclipse.swt.*;
import java.io.InputStream;
import java.io.IOException;
import org.eclipse.swt.SWT;
import java.lang.JavaArray;
dynamic public class PngDecodingDataStream extends InputStream {
  internal var stream: InputStream;
  internal var currentByte: int;
  internal var nextBitIndex: int;
  internal var lzBlockReader: PngLzBlockReader;
  internal var adlerValue: int;
  public static const PRIME: int = 65521;
  public static const MAX_BIT: int = 7;
  function PngDecodingDataStream(stream: InputStream) {
    this.stream = stream;
    nextBitIndex = 7 + 1;
    adlerValue = 1;
    lzBlockReader = new PngLzBlockReader(this);
    this.readCompressedDataHeader__();
    lzBlockReader.readNextBlockHeader__();
    return;
  }
  public function assertImageDataAtEnd__(): void {
    lzBlockReader.assertCompressedDataAtEnd__();
    return;
  }
  public override function close__(): void {
    this.assertImageDataAtEnd__();
    this.checkAdler__();
    return;
  }
  public function getNextIdatBits__I(length: int): int {
    var value: int = 0;
    for (var i: int = 0; i < length; i++) {
      value |= (this.getNextIdatBit__() << i);
    }
    return value;
  }
  public function getNextIdatBit__(): int {
    if (nextBitIndex > 7) {
      currentByte = this.getNextIdatByte__();
      nextBitIndex = 0;
    }
    return (currentByte & (1 << nextBitIndex)) >> nextBitIndex++;
  }
  public function getNextIdatByte__(): int {
    var nextByte: int = int(stream.read__());
    nextBitIndex = 7 + 1;
    return nextByte;
  }
  public function updateAdler__B(value: int): void {
    var low: int = adlerValue & 0xFFFF;
    var high: int = (adlerValue >> 16) & 0xFFFF;
    var valueInt: int = value & 0xFF;
    low = (low + valueInt) % 65521;
    high = (low + high) % 65521;
    adlerValue = (high << 16) | low;
  }
  public override function read__(): int {
    var nextDecodedByte: int = lzBlockReader.getNextByte__();
    this.updateAdler__B(nextDecodedByte);
    return nextDecodedByte & 0xFF;
  }
  public override function read___3BII(buffer: JavaArray, off: int, len: int): int {
    for (var i: int = 0; i < len; i++) {
      var b: int = this.read__();
      if (b == -1)
        return i;
      buffer[off + i] = int(b);
    }
    return len;
  }
  public function error__(): void {
    SWT.error__I(40);
  }
  private function readCompressedDataHeader__(): void {
    var headerByte1: int = this.getNextIdatByte__();
    var headerByte2: int = this.getNextIdatByte__();
    var number: int = ((headerByte1 & 0xFF) << 8) | (headerByte2 & 0xFF);
    if (number % 31 != 0)
      this.error__();
    var compressionMethod: int = headerByte1 & 0x0F;
    if (compressionMethod != 8)
      this.error__();
    var windowSizeHint: int = (headerByte1 & 0xF0) >> 4;
    if (windowSizeHint > 7)
      this.error__();
    var windowSize: int = (1 << (windowSizeHint + 8));
    lzBlockReader.setWindowSize__I(windowSize);
    var dictionary: int = (headerByte2 & (1 << 5));
    if (dictionary != 0)
      this.error__();
  }
  public function checkAdler__(): void {
    var storedAdler: int = ((this.getNextIdatByte__() & 0xFF) << 24) | ((this.getNextIdatByte__() & 0xFF) << 16) | ((this.getNextIdatByte__() & 0xFF) << 8) | (this.getNextIdatByte__() & 0xFF);
    if (storedAdler != adlerValue)
      this.error__();
  }
}
}
