package org.eclipse.swt.internal.image {
import java.io.ByteArrayOutputStream;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class PngDeflater {
  public static const BASE: int = 65521;
  public static const WINDOW: int = 32768;
  public static const MIN_LENGTH: int = 3;
  public static const MAX_MATCHES: int = 32;
  public static const HASH: int = 8209;
  internal var in_org_eclipse_swt_internal_image_PngDeflater: JavaArray;
  internal var inLength: int;
  internal var bytes: ByteArrayOutputStream = new ByteArrayOutputStream(new Arguments(java.io.ByteArrayOutputStream.ByteArrayOutputStream__I, [1024]));
  internal var adler32: int = 1;
  internal var buffer: int;
  internal var bitCount: int;
  internal var hashtable: JavaArray = new JavaArray("[Lorg/eclipse/swt/internal/image/PngDeflater$Link;").lengths(8209);
  internal var window: JavaArray = new JavaArray("[Lorg/eclipse/swt/internal/image/PngDeflater$Link;").lengths(32768);
  internal var nextWindow: int;
  public static var mirrorBytes: JavaArray = new JavaArray("[S").values(0x00, 0x80, 0x40, 0xc0, 0x20, 0xa0, 0x60, 0xe0, 0x10, 0x90, 0x50, 0xd0, 0x30, 0xb0, 0x70, 0xf0, 0x08, 0x88, 0x48, 0xc8, 0x28, 0xa8, 0x68, 0xe8, 0x18, 0x98, 0x58, 0xd8, 0x38, 0xb8, 0x78, 0xf8, 0x04, 0x84, 0x44, 0xc4, 0x24, 0xa4, 0x64, 0xe4, 0x14, 0x94, 0x54, 0xd4, 0x34, 0xb4, 0x74, 0xf4, 0x0c, 0x8c, 0x4c, 0xcc, 0x2c, 0xac, 0x6c, 0xec, 0x1c, 0x9c, 0x5c, 0xdc, 0x3c, 0xbc, 0x7c, 0xfc, 0x02, 0x82, 0x42, 0xc2, 0x22, 0xa2, 0x62, 0xe2, 0x12, 0x92, 0x52, 0xd2, 0x32, 0xb2, 0x72, 0xf2, 0x0a, 0x8a, 0x4a, 0xca, 0x2a, 0xaa, 0x6a, 0xea, 0x1a, 0x9a, 0x5a, 0xda, 0x3a, 0xba, 0x7a, 0xfa, 0x06, 0x86, 0x46, 0xc6, 0x26, 0xa6, 0x66, 0xe6, 0x16, 0x96, 0x56, 0xd6, 0x36, 0xb6, 0x76, 0xf6, 0x0e, 0x8e, 0x4e, 0xce, 0x2e, 0xae, 0x6e, 0xee, 0x1e, 0x9e, 0x5e, 0xde, 0x3e, 0xbe, 0x7e, 0xfe, 0x01, 0x81, 0x41, 0xc1, 0x21, 0xa1, 0x61, 0xe1, 0x11, 0x91, 0x51, 0xd1, 0x31, 0xb1, 0x71, 0xf1, 0x09, 0x89, 0x49, 0xc9, 0x29, 0xa9, 0x69, 0xe9, 0x19, 0x99, 0x59, 0xd9, 0x39, 0xb9, 0x79, 0xf9, 0x05, 0x85, 0x45, 0xc5, 0x25, 0xa5, 0x65, 0xe5, 0x15, 0x95, 0x55, 0xd5, 0x35, 0xb5, 0x75, 0xf5, 0x0d, 0x8d, 0x4d, 0xcd, 0x2d, 0xad, 0x6d, 0xed, 0x1d, 0x9d, 0x5d, 0xdd, 0x3d, 0xbd, 0x7d, 0xfd, 0x03, 0x83, 0x43, 0xc3, 0x23, 0xa3, 0x63, 0xe3, 0x13, 0x93, 0x53, 0xd3, 0x33, 0xb3, 0x73, 0xf3, 0x0b, 0x8b, 0x4b, 0xcb, 0x2b, 0xab, 0x6b, 0xeb, 0x1b, 0x9b, 0x5b, 0xdb, 0x3b, 0xbb, 0x7b, 0xfb, 0x07, 0x87, 0x47, 0xc7, 0x27, 0xa7, 0x67, 0xe7, 0x17, 0x97, 0x57, 0xd7, 0x37, 0xb7, 0x77, 0xf7, 0x0f, 0x8f, 0x4f, 0xcf, 0x2f, 0xaf, 0x6f, 0xef, 0x1f, 0x9f, 0x5f, 0xdf, 0x3f, 0xbf, 0x7f, 0xff);
  public static var lengthCodes: JavaArray = new JavaArray("[Lorg/eclipse/swt/internal/image/PngDeflater$Code;").values(new PngDeflater$Code(257, 0, 3, 3), new PngDeflater$Code(258, 0, 4, 4), new PngDeflater$Code(259, 0, 5, 5), new PngDeflater$Code(260, 0, 6, 6), new PngDeflater$Code(261, 0, 7, 7), new PngDeflater$Code(262, 0, 8, 8), new PngDeflater$Code(263, 0, 9, 9), new PngDeflater$Code(264, 0, 10, 10), new PngDeflater$Code(265, 1, 11, 12), new PngDeflater$Code(266, 1, 13, 14), new PngDeflater$Code(267, 1, 15, 16), new PngDeflater$Code(268, 1, 17, 18), new PngDeflater$Code(269, 2, 19, 22), new PngDeflater$Code(270, 2, 23, 26), new PngDeflater$Code(271, 2, 27, 30), new PngDeflater$Code(272, 2, 31, 34), new PngDeflater$Code(273, 3, 35, 42), new PngDeflater$Code(274, 3, 43, 50), new PngDeflater$Code(275, 3, 51, 58), new PngDeflater$Code(276, 3, 59, 66), new PngDeflater$Code(277, 4, 67, 82), new PngDeflater$Code(278, 4, 83, 98), new PngDeflater$Code(279, 4, 99, 114), new PngDeflater$Code(280, 4, 115, 130), new PngDeflater$Code(281, 5, 131, 162), new PngDeflater$Code(282, 5, 163, 194), new PngDeflater$Code(283, 5, 195, 226), new PngDeflater$Code(284, 5, 227, 257), new PngDeflater$Code(285, 0, 258, 258));
  public static var distanceCodes: JavaArray = new JavaArray("[Lorg/eclipse/swt/internal/image/PngDeflater$Code;").values(new PngDeflater$Code(0, 0, 1, 1), new PngDeflater$Code(1, 0, 2, 2), new PngDeflater$Code(2, 0, 3, 3), new PngDeflater$Code(3, 0, 4, 4), new PngDeflater$Code(4, 1, 5, 6), new PngDeflater$Code(5, 1, 7, 8), new PngDeflater$Code(6, 2, 9, 12), new PngDeflater$Code(7, 2, 13, 16), new PngDeflater$Code(8, 3, 17, 24), new PngDeflater$Code(9, 3, 25, 32), new PngDeflater$Code(10, 4, 33, 48), new PngDeflater$Code(11, 4, 49, 64), new PngDeflater$Code(12, 5, 65, 96), new PngDeflater$Code(13, 5, 97, 128), new PngDeflater$Code(14, 6, 129, 192), new PngDeflater$Code(15, 6, 193, 256), new PngDeflater$Code(16, 7, 257, 384), new PngDeflater$Code(17, 7, 385, 512), new PngDeflater$Code(18, 8, 513, 768), new PngDeflater$Code(19, 8, 769, 1024), new PngDeflater$Code(20, 9, 1025, 1536), new PngDeflater$Code(21, 9, 1537, 2048), new PngDeflater$Code(22, 10, 2049, 3072), new PngDeflater$Code(23, 10, 3073, 4096), new PngDeflater$Code(24, 11, 4097, 6144), new PngDeflater$Code(25, 11, 6145, 8192), new PngDeflater$Code(26, 12, 8193, 12288), new PngDeflater$Code(27, 12, 12289, 16384), new PngDeflater$Code(28, 13, 16385, 24576), new PngDeflater$Code(29, 13, 24577, 32768));
  public function writeShortLSB__Ljava_io_ByteArrayOutputStream_2I(baos: ByteArrayOutputStream, theShort: int): void {
    var byte1: int = int((theShort & 0xff));
    var byte2: int = int(((theShort >> 8) & 0xff));
    var temp: JavaArray = new JavaArray("[B").values(byte1, byte2);
    baos.write___3BII(temp, 0, 2);
    return;
  }
  public function writeInt__Ljava_io_ByteArrayOutputStream_2I(baos: ByteArrayOutputStream, theInt: int): void {
    var byte1: int = int(((theInt >> 24) & 0xff));
    var byte2: int = int(((theInt >> 16) & 0xff));
    var byte3: int = int(((theInt >> 8) & 0xff));
    var byte4: int = int((theInt & 0xff));
    var temp: JavaArray = new JavaArray("[B").values(byte1, byte2, byte3, byte4);
    baos.write___3BII(temp, 0, 4);
    return;
  }
  public function updateAdler__B(value: int): void {
    var low: int = adler32 & 0xffff;
    var high: int = (adler32 >> 16) & 0xffff;
    var valueInt: int = value & 0xff;
    low = (low + valueInt) % 65521;
    high = (low + high) % 65521;
    adler32 = (high << 16) | low;
    return;
  }
  public function hash___3B(bytes_1: JavaArray): int {
    var hash: int = ((bytes_1[0] & 0xff) << 24 | (bytes_1[1] & 0xff) << 16 | (bytes_1[2] & 0xff) << 8) % 8209;
    if (hash < 0) {
      hash = hash + 8209;
    }
    return hash;
  }
  public function writeBits__II(value: int, count: int): void {
    buffer |= value << bitCount;
    bitCount += count;
    if (bitCount >= 16) {
      bytes.write__I(int(buffer));
      bytes.write__I(int((buffer >>> 8)));
      buffer >>>= 16;
      bitCount -= 16;
    }
    return;
  }
  public function alignToByte__(): void {
    if (bitCount > 0) {
      bytes.write__I(int(buffer));
      if (bitCount > 8)
        bytes.write__I(int((buffer >>> 8)));
    }
    buffer = 0;
    bitCount = 0;
    return;
  }
  public function outputLiteral__B(literal: int): void {
    var i: int = literal & 0xff;
    if (i <= 143) {
      this.writeBits__II(mirrorBytes[0x30 + i], 8);
    } else {
      this.writeBits__II(1 + 2 * mirrorBytes[0x90 - 144 + i], 9);
    }
    return;
  }
  public function findCode__I_3Lorg_eclipse_swt_internal_image_PngDeflater$Code_2(value: int, codes: JavaArray): PngDeflater$Code {
    var i: int;
    var j: int;
    var k: int;
    i = -1;
    j = codes.length;
    while (true) {
      k = int((j + i) / 2);
      if (value < codes[k].min) {
        j = k;
      } else if (value > codes[k].max) {
        i = k;
      } else {
        return codes[k];
      }
    }
    return null;
  }
  public function outputMatch__II(length: int, distance: int): void {
    var d: PngDeflater$Code;
    var l: PngDeflater$Code;
    var thisLength: int;
    while (length > 0) {
      if (length > 260) {
        thisLength = 258;
      } else if (length <= 258) {
        thisLength = length;
      } else {
        thisLength = length - 3;
      }
      length = length - thisLength;
      l = this.findCode__I_3Lorg_eclipse_swt_internal_image_PngDeflater$Code_2(thisLength, lengthCodes);
      if (l.code <= 279) {
        this.writeBits__II(mirrorBytes[(l.code - 256) * 2], 7);
      } else {
        this.writeBits__II(mirrorBytes[0xc0 - 280 + l.code], 8);
      }
      if (l.extraBits != 0) {
        this.writeBits__II(thisLength - l.min, l.extraBits);
      }
      d = this.findCode__I_3Lorg_eclipse_swt_internal_image_PngDeflater$Code_2(distance, distanceCodes);
      this.writeBits__II(mirrorBytes[d.code * 8], 5);
      if (d.extraBits != 0) {
        this.writeBits__II(distance - d.min, d.extraBits);
      }
    }
    return;
  }
  public function findLongestMatch__ILorg_eclipse_swt_internal_image_PngDeflater$Link_2(position: int, firstPosition: PngDeflater$Link): PngDeflater$Match {
    var link: PngDeflater$Link = firstPosition;
    var numberOfMatches: int = 0;
    var bestMatch: PngDeflater$Match = new PngDeflater$Match(-1, -1);
    while (true) {
      var matchPosition: int = link.value;
      if (position - matchPosition < 32768 && matchPosition != 0) {
        var i: int;
        for (i = 1; position + i < inLength; i++) {
          if (in_org_eclipse_swt_internal_image_PngDeflater[position + i] != in_org_eclipse_swt_internal_image_PngDeflater[matchPosition + i]) {
            break;
          }
        }
        if (i >= 3) {
          if (i > bestMatch.length) {
            bestMatch.length = i;
            bestMatch.distance = position - matchPosition;
          }
          numberOfMatches = numberOfMatches + 1;
          if (numberOfMatches == 32) {
            break;
          }
        }
      }
      link = link.next;
      if (link === null) {
        break;
      }
    }
    if (bestMatch.length < 3 || bestMatch.distance < 1 || bestMatch.distance > 32768) {
      return null;
    }
    return bestMatch;
  }
  public function updateHashtable__II(to_1: int, from: int): void {
    var data: JavaArray = new JavaArray("[B").lengths(3);
    var hash: int;
    var temp: PngDeflater$Link;
    for (var i: int = to_1; i < from; i++) {
      if (i + 3 > inLength) {
        break;
      }
      data[0] = in_org_eclipse_swt_internal_image_PngDeflater[i];
      data[1] = in_org_eclipse_swt_internal_image_PngDeflater[i + 1];
      data[2] = in_org_eclipse_swt_internal_image_PngDeflater[i + 2];
      hash = this.hash___3B(data);
      if (window[nextWindow].previous !== null) {
        window[nextWindow].previous.next = null;
      } else if (window[nextWindow].hash != 0) {
        hashtable[window[nextWindow].hash].next = null;
      }
      window[nextWindow].hash = hash;
      window[nextWindow].value = i;
      window[nextWindow].previous = null;
      temp = window[nextWindow].next = hashtable[hash].next;
      hashtable[hash].next = window[nextWindow];
      if (temp !== null) {
        temp.previous = window[nextWindow];
      }
      nextWindow = nextWindow + 1;
      if (nextWindow == 32768) {
        nextWindow = 0;
      }
    }
    return;
  }
  public function compress__(): void {
    var position: int;
    var newPosition: int;
    var data: JavaArray = new JavaArray("[B").lengths(3);
    var hash: int;
    for (var i: int = 0; i < 8209; i++) {
      hashtable[i] = new PngDeflater$Link();
    }
    for (var i_1: int = 0; i_1 < 32768; i_1++) {
      window[i_1] = new PngDeflater$Link();
    }
    nextWindow = 0;
    var firstPosition: PngDeflater$Link;
    var match: PngDeflater$Match;
    var deferredPosition: int = -1;
    var deferredMatch: PngDeflater$Match = null;
    this.writeBits__II(0x01, 1);
    this.writeBits__II(0x01, 2);
    this.outputLiteral__B(in_org_eclipse_swt_internal_image_PngDeflater[0]);
    position = 1;
    while (position < inLength) {
      if (inLength - position < 3) {
        this.outputLiteral__B(in_org_eclipse_swt_internal_image_PngDeflater[position]);
        position = position + 1;
        continue;
      }
      data[0] = in_org_eclipse_swt_internal_image_PngDeflater[position];
      data[1] = in_org_eclipse_swt_internal_image_PngDeflater[position + 1];
      data[2] = in_org_eclipse_swt_internal_image_PngDeflater[position + 2];
      hash = this.hash___3B(data);
      firstPosition = hashtable[hash];
      match = this.findLongestMatch__ILorg_eclipse_swt_internal_image_PngDeflater$Link_2(position, firstPosition);
      this.updateHashtable__II(position, position + 1);
      if (match !== null) {
        if (deferredMatch !== null) {
          if (match.length > deferredMatch.length + 1) {
            this.outputLiteral__B(in_org_eclipse_swt_internal_image_PngDeflater[deferredPosition]);
            deferredPosition = position;
            deferredMatch = match;
            position = position + 1;
          } else {
            this.outputMatch__II(deferredMatch.length, deferredMatch.distance);
            newPosition = deferredPosition + deferredMatch.length;
            deferredPosition = -1;
            deferredMatch = null;
            this.updateHashtable__II(position + 1, newPosition);
            position = newPosition;
          }
        } else {
          deferredPosition = position;
          deferredMatch = match;
          position = position + 1;
        }
      } else {
        if (deferredMatch !== null) {
          this.outputMatch__II(deferredMatch.length, deferredMatch.distance);
          newPosition = deferredPosition + deferredMatch.length;
          deferredPosition = -1;
          deferredMatch = null;
          this.updateHashtable__II(position + 1, newPosition);
          position = newPosition;
        } else {
          this.outputLiteral__B(in_org_eclipse_swt_internal_image_PngDeflater[position]);
          position = position + 1;
        }
      }
    }
    this.writeBits__II(0, 7);
    this.alignToByte__();
    return;
  }
  public function compressHuffmanOnly__(): void {
    var position: int;
    this.writeBits__II(0x01, 1);
    this.writeBits__II(0x01, 2);
    for (position = 0; position < inLength;) {
      this.outputLiteral__B(in_org_eclipse_swt_internal_image_PngDeflater[position]);
      position = position + 1;
    }
    this.writeBits__II(0, 7);
    this.alignToByte__();
    return;
  }
  public function store__(): void {
    var start: int = 0;
    var length: int = inLength;
    var blockLength: int;
    var BFINAL: int = 0x00;
    while (length > 0) {
      if (length < 65535) {
        blockLength = length;
        BFINAL = 0x01;
      } else {
        blockLength = 65535;
        BFINAL = 0x00;
      }
      bytes.write__I(int(BFINAL));
      this.writeShortLSB__Ljava_io_ByteArrayOutputStream_2I(bytes, blockLength);
      this.writeShortLSB__Ljava_io_ByteArrayOutputStream_2I(bytes, blockLength ^ 0xffff);
      bytes.write___3BII(in_org_eclipse_swt_internal_image_PngDeflater, start, blockLength);
      length = length - blockLength;
      start = start + blockLength;
    }
    return;
  }
  public function deflate___3B(input: JavaArray): JavaArray {
    in_org_eclipse_swt_internal_image_PngDeflater = input;
    inLength = input.length;
    bytes.write__I(int(0x78));
    bytes.write__I(int(0x9C));
    for (var i: int = 0; i < inLength; i++) {
      this.updateAdler__B(in_org_eclipse_swt_internal_image_PngDeflater[i]);
    }
    this.compress__();
    this.writeInt__Ljava_io_ByteArrayOutputStream_2I(bytes, adler32);
    return bytes.toByteArray__();
  }
}
}
